/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.thrift;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.plugin.inputformat.thrift.ThriftRecordExtractor;
import org.apache.pinot.plugin.inputformat.thrift.ThriftRecordExtractorConfig;
import org.apache.pinot.plugin.inputformat.thrift.ThriftRecordReaderConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.data.readers.RecordReaderUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransportException;

public class ThriftRecordReader
implements RecordReader {
    private File _dataFile;
    private ThriftRecordExtractor _recordExtractor;
    private Class<?> _thriftClass;
    private Map<String, Integer> _fieldIds = new HashMap<String, Integer>();
    private InputStream _inputStream;
    private TProtocol _tProtocol;
    private boolean _hasNext;

    public void init(File dataFile, @Nullable Set<String> fieldsToRead, @Nullable RecordReaderConfig config) throws IOException {
        TBase tObject;
        ThriftRecordReaderConfig recordReaderConfig = (ThriftRecordReaderConfig)config;
        this._dataFile = dataFile;
        try {
            this._thriftClass = this.getClass().getClassLoader().loadClass(recordReaderConfig.getThriftClass());
            tObject = (TBase)this._thriftClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Map<? extends TFieldIdEnum, FieldMetaData> metaDataMap = FieldMetaData.getStructMetaDataMap(tObject.getClass());
        for (TFieldIdEnum tFieldIdEnum : metaDataMap.keySet()) {
            this._fieldIds.put(tFieldIdEnum.getFieldName(), Short.toUnsignedInt(tFieldIdEnum.getThriftFieldId()));
        }
        ThriftRecordExtractorConfig recordExtractorConfig = new ThriftRecordExtractorConfig();
        recordExtractorConfig.setFieldIds(this._fieldIds);
        this._recordExtractor = new ThriftRecordExtractor();
        this._recordExtractor.init(fieldsToRead, recordExtractorConfig);
        this.init();
    }

    private void init() throws IOException {
        this._inputStream = RecordReaderUtils.getBufferedInputStream((File)this._dataFile);
        try {
            this._tProtocol = new TBinaryProtocol(new TIOStreamTransport(this._inputStream));
        }
        catch (TTransportException e) {
            throw new IOException(e);
        }
        this._hasNext = this.hasMoreToRead();
    }

    private boolean hasMoreToRead() throws IOException {
        this._inputStream.mark(1);
        int nextByte = this._inputStream.read();
        this._inputStream.reset();
        return nextByte != -1;
    }

    public boolean hasNext() {
        return this._hasNext;
    }

    public GenericRow next() throws IOException {
        return this.next(new GenericRow());
    }

    public GenericRow next(GenericRow reuse) throws IOException {
        TBase tObject;
        try {
            tObject = (TBase)this._thriftClass.newInstance();
            tObject.read(this._tProtocol);
        }
        catch (Exception e) {
            throw new IOException("Caught exception while reading thrift object", e);
        }
        this._recordExtractor.extract(tObject, reuse);
        this._hasNext = this.hasMoreToRead();
        return reuse;
    }

    public void rewind() throws IOException {
        this._inputStream.close();
        this.init();
    }

    public void close() throws IOException {
        this._inputStream.close();
    }
}

