/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.thrift;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.plugin.inputformat.thrift.ThriftRecordExtractorConfig;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableSet;
import org.apache.pinot.spi.data.readers.BaseRecordExtractor;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordExtractorConfig;
import org.apache.thrift.TBase;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;

public class ThriftRecordExtractor
extends BaseRecordExtractor<TBase> {
    private Map<String, Integer> _fieldIds;
    private Set<String> _fields;
    private boolean _extractAll = false;

    public void init(@Nullable Set<String> fields, RecordExtractorConfig recordExtractorConfig) {
        this._fieldIds = ((ThriftRecordExtractorConfig)recordExtractorConfig).getFieldIds();
        if (fields == null || fields.isEmpty()) {
            this._extractAll = true;
            this._fields = Collections.emptySet();
        } else {
            this._fields = ImmutableSet.copyOf(fields);
        }
    }

    public GenericRow extract(TBase from, GenericRow to) {
        if (this._extractAll) {
            for (Map.Entry<String, Integer> nameToId : this._fieldIds.entrySet()) {
                Object value = from.getFieldValue(from.fieldForId(nameToId.getValue()));
                if (value != null) {
                    value = this.convert(value);
                }
                to.putValue(nameToId.getKey(), value);
            }
        } else {
            for (String fieldName : this._fields) {
                Object value = null;
                Integer fieldId = this._fieldIds.get(fieldName);
                if (fieldId != null) {
                    value = from.getFieldValue(from.fieldForId(fieldId));
                }
                if (value != null) {
                    value = this.convert(value);
                }
                to.putValue(fieldName, value);
            }
        }
        return to;
    }

    protected boolean isRecord(Object value) {
        return value instanceof TBase;
    }

    protected Object convertRecord(Object value) {
        TBase record = (TBase)value;
        HashMap<String, Object> convertedRecord = new HashMap<String, Object>();
        for (TFieldIdEnum tFieldIdEnum : FieldMetaData.getStructMetaDataMap(record.getClass()).keySet()) {
            Object fieldValue = record.getFieldValue(tFieldIdEnum);
            if (fieldValue != null) {
                fieldValue = this.convert(fieldValue);
            }
            convertedRecord.put(tFieldIdEnum.getFieldName(), fieldValue);
        }
        return convertedRecord;
    }
}

