/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.ingestion.batch.spark3;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.pinot.segment.local.utils.SegmentPushUtils;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.runner.IngestionJobRunner;
import org.apache.pinot.spi.ingestion.batch.spec.PinotFSSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.VoidFunction;

public class SparkSegmentUriPushJobRunner
implements IngestionJobRunner,
Serializable {
    private SegmentGenerationJobSpec _spec;

    public SparkSegmentUriPushJobRunner() {
    }

    public SparkSegmentUriPushJobRunner(SegmentGenerationJobSpec spec) {
        this.init(spec);
    }

    public void init(SegmentGenerationJobSpec spec) {
        this._spec = spec;
        if (this._spec.getPushJobSpec() == null) {
            throw new RuntimeException("Missing PushJobSpec");
        }
    }

    public void run() {
        String[] files;
        URI outputDirURI;
        final List pinotFSSpecs = this._spec.getPinotFSSpecs();
        for (PinotFSSpec pinotFSSpec : pinotFSSpecs) {
            PinotFSFactory.register((String)pinotFSSpec.getScheme(), (String)pinotFSSpec.getClassName(), (PinotConfiguration)new PinotConfiguration(pinotFSSpec));
        }
        try {
            outputDirURI = new URI(this._spec.getOutputDirURI());
            if (outputDirURI.getScheme() == null) {
                outputDirURI = new File(this._spec.getOutputDirURI()).toURI();
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("outputDirURI is not valid - '" + this._spec.getOutputDirURI() + "'");
        }
        PinotFS outputDirFS = PinotFSFactory.create((String)outputDirURI.getScheme());
        try {
            files = outputDirFS.listFiles(outputDirURI, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to list all files under outputDirURI - '" + outputDirURI + "'");
        }
        ArrayList<String> segmentUris = new ArrayList<String>();
        for (String file : files) {
            URI uri = URI.create(file);
            if (!uri.getPath().endsWith(".tar.gz")) continue;
            URI updatedURI = SegmentPushUtils.generateSegmentTarURI((URI)outputDirURI, (URI)uri, (String)this._spec.getPushJobSpec().getSegmentUriPrefix(), (String)this._spec.getPushJobSpec().getSegmentUriSuffix());
            segmentUris.add(updatedURI.toString());
        }
        int pushParallelism = this._spec.getPushJobSpec().getPushParallelism();
        if (pushParallelism < 1) {
            pushParallelism = segmentUris.size();
        }
        if (pushParallelism == 1) {
            try {
                SegmentPushUtils.sendSegmentUris((SegmentGenerationJobSpec)this._spec, segmentUris);
            }
            catch (AttemptsExceededException | RetriableOperationException e) {
                throw new RuntimeException(e);
            }
        } else {
            JavaSparkContext sparkContext = JavaSparkContext.fromSparkContext((SparkContext)SparkContext.getOrCreate());
            JavaRDD pathRDD = sparkContext.parallelize(segmentUris, pushParallelism);
            pathRDD.foreach((VoidFunction)new VoidFunction<String>(){

                public void call(String segmentUri) throws Exception {
                    try {
                        PluginManager.get().init();
                        for (PinotFSSpec pinotFSSpec : pinotFSSpecs) {
                            PinotFSFactory.register((String)pinotFSSpec.getScheme(), (String)pinotFSSpec.getClassName(), (PinotConfiguration)new PinotConfiguration(pinotFSSpec));
                        }
                        SegmentPushUtils.sendSegmentUris((SegmentGenerationJobSpec)SparkSegmentUriPushJobRunner.this._spec, Arrays.asList(segmentUri));
                    }
                    catch (AttemptsExceededException | RetriableOperationException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }
}

