/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.ingestion.batch.common;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.segment.generation.SegmentGenerationUtils;
import org.apache.pinot.segment.local.utils.ConsistentDataPushUtils;
import org.apache.pinot.segment.local.utils.SegmentPushUtils;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.runner.IngestionJobRunner;
import org.apache.pinot.spi.ingestion.batch.spec.PinotFSSpec;
import org.apache.pinot.spi.ingestion.batch.spec.PushJobSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;

public abstract class BaseSegmentPushJobRunner
implements IngestionJobRunner {
    protected SegmentGenerationJobSpec _spec;
    protected String[] _files;
    protected PinotFS _outputDirFS;
    protected URI _outputDirURI;
    protected TableConfig _tableConfig;
    protected boolean _consistentPushEnabled;

    public void init(SegmentGenerationJobSpec spec) {
        this._spec = spec;
        if (this._spec.getPushJobSpec() == null) {
            throw new RuntimeException("Missing PushJobSpec");
        }
        if (this._spec.getTableSpec() == null) {
            throw new RuntimeException("Missing tableSpec");
        }
        if (this._spec.getTableSpec().getTableConfigURI() == null) {
            throw new RuntimeException("Missing property 'tableConfigURI' in 'tableSpec'");
        }
        this._tableConfig = SegmentGenerationUtils.getTableConfig((String)this._spec.getTableSpec().getTableConfigURI(), (String)spec.getAuthToken());
        this._consistentPushEnabled = ConsistentDataPushUtils.consistentDataPushEnabled((TableConfig)this._tableConfig);
    }

    public void initFileSys() {
        List pinotFSSpecs = this._spec.getPinotFSSpecs();
        for (PinotFSSpec pinotFSSpec : pinotFSSpecs) {
            PinotFSFactory.register((String)pinotFSSpec.getScheme(), (String)pinotFSSpec.getClassName(), (PinotConfiguration)new PinotConfiguration(pinotFSSpec));
        }
        try {
            this._outputDirURI = new URI(this._spec.getOutputDirURI());
            if (this._outputDirURI.getScheme() == null) {
                this._outputDirURI = new File(this._spec.getOutputDirURI()).toURI();
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("outputDirURI is not valid - '" + this._spec.getOutputDirURI() + "'");
        }
        this._outputDirFS = PinotFSFactory.create((String)this._outputDirURI.getScheme());
        try {
            this._files = this._outputDirFS.listFiles(this._outputDirURI, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to list all files under outputDirURI - '" + this._outputDirURI + "'");
        }
    }

    public List<String> getSegmentsToReplace(Map<String, String> segmentsUriToTarPathMap) {
        Collection<String> tarFilePaths = segmentsUriToTarPathMap.values();
        ArrayList<String> segmentNames = new ArrayList<String>(tarFilePaths.size());
        for (String tarFilePath : tarFilePaths) {
            File tarFile = new File(tarFilePath);
            String fileName = tarFile.getName();
            Preconditions.checkArgument(fileName.endsWith(".tar.gz"));
            String segmentName = fileName.substring(0, fileName.length() - ".tar.gz".length());
            segmentNames.add(segmentName);
        }
        return segmentNames;
    }

    public abstract void uploadSegments(Map<String, String> var1) throws Exception;

    public void run() throws Exception {
        this.initFileSys();
        Map uriToLineageEntryIdMap = null;
        try {
            Map segmentsUriToTarPathMap = SegmentPushUtils.getSegmentUriToTarPathMap((URI)this._outputDirURI, (PushJobSpec)this._spec.getPushJobSpec(), (String[])this._files);
            if (this._consistentPushEnabled) {
                List<String> segmentsToReplace = this.getSegmentsToReplace(segmentsUriToTarPathMap);
                uriToLineageEntryIdMap = ConsistentDataPushUtils.preUpload((SegmentGenerationJobSpec)this._spec, segmentsToReplace);
            }
            this.uploadSegments(segmentsUriToTarPathMap);
            if (this._consistentPushEnabled) {
                ConsistentDataPushUtils.postUpload((SegmentGenerationJobSpec)this._spec, (Map)uriToLineageEntryIdMap);
            }
        }
        catch (Exception e) {
            if (this._consistentPushEnabled) {
                ConsistentDataPushUtils.handleUploadException((SegmentGenerationJobSpec)this._spec, uriToLineageEntryIdMap, (Exception)e);
            }
            throw e;
        }
    }
}

