/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public interface Command {
    public String getCommand();

    public Map<String, String> getOptions();

    public static final class Builder {
        private final String command;
        private final Map<String, String> options = new HashMap<String, String>();

        public static Builder of(String command) {
            if (command == null) {
                throw new IllegalArgumentException("Command cannot be null.");
            }
            return new Builder(command);
        }

        public Builder addOption(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        public Builder addOptions(Map<String, String> map) {
            this.options.putAll(map);
            return this;
        }

        public Command build() {
            return new SimpleCommand(this.command, Collections.unmodifiableMap(new HashMap<String, String>(this.options)));
        }

        private Builder(String command) {
            this.command = command;
        }

        private static final class SimpleCommand
        implements Command {
            private final String command;
            private final Map<String, String> options;

            SimpleCommand(String command, Map<String, String> options) {
                this.command = command;
                this.options = options;
            }

            @Override
            public String getCommand() {
                return this.command;
            }

            @Override
            public Map<String, String> getOptions() {
                return this.options;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SimpleCommand that = (SimpleCommand)o;
                return this.command.equals(that.command) && this.options.equals(that.options);
            }

            public int hashCode() {
                int result = this.command.hashCode();
                result = 31 * result + this.options.hashCode();
                return result;
            }

            public String toString() {
                return "SimpleCommand{command='" + this.command + '\'' + ", options=" + this.options + '}';
            }
        }
    }
}

