/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class ByteUtil {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final ImmutableBytesPtr EMPTY_BYTE_ARRAY_PTR = new ImmutableBytesPtr(EMPTY_BYTE_ARRAY);
    public static final ImmutableBytesWritable EMPTY_IMMUTABLE_BYTE_ARRAY = new ImmutableBytesWritable(EMPTY_BYTE_ARRAY);
    public static final Comparator<ImmutableBytesPtr> BYTES_PTR_COMPARATOR = new Comparator<ImmutableBytesPtr>(){

        @Override
        public int compare(ImmutableBytesPtr o1, ImmutableBytesPtr o2) {
            return Bytes.compareTo((byte[])o1.get(), (int)o1.getOffset(), (int)o1.getLength(), (byte[])o2.get(), (int)o2.getOffset(), (int)o2.getLength());
        }
    };

    public static byte[] toBytes(byte[][] byteArrays) {
        int size = 0;
        for (byte[] b : byteArrays) {
            if (b == null) {
                ++size;
                continue;
            }
            size += b.length;
            size += WritableUtils.getVIntSize((long)b.length);
        }
        TrustedByteArrayOutputStream bytesOut = new TrustedByteArrayOutputStream(size);
        DataOutputStream out = new DataOutputStream(bytesOut);
        try {
            for (byte[] b : byteArrays) {
                if (b == null) {
                    WritableUtils.writeVInt((DataOutput)out, (int)0);
                    continue;
                }
                WritableUtils.writeVInt((DataOutput)out, (int)b.length);
                out.write(b);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return bytesOut.getBuffer();
    }

    public static byte[][] toByteArrays(byte[] b, int length) {
        return ByteUtil.toByteArrays(b, 0, length);
    }

    public static byte[][] toByteArrays(byte[] b, int offset, int length) {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(b, offset, b.length - offset);
        DataInputStream in = new DataInputStream(bytesIn);
        byte[][] byteArrays = new byte[length][];
        try {
            for (int i = 0; i < length; ++i) {
                int bLength = WritableUtils.readVInt((DataInput)in);
                if (bLength == 0) {
                    byteArrays[i] = null;
                    continue;
                }
                byteArrays[i] = new byte[bLength];
                int rLength = in.read(byteArrays[i], 0, bLength);
                assert (rLength == bLength);
            }
            if (in.read() != -1) {
                throw new IllegalStateException("Expected only " + length + " byte arrays, but found more");
            }
            byte[][] i = byteArrays;
            return i;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static byte[] serializeVIntArray(int[] intArray) {
        return ByteUtil.serializeVIntArray(intArray, intArray.length);
    }

    public static byte[] serializeVIntArray(int[] intArray, int encodedLength) {
        int size = WritableUtils.getVIntSize((long)encodedLength);
        for (int i = 0; i < intArray.length; ++i) {
            size += WritableUtils.getVIntSize((long)intArray[i]);
        }
        int offset = 0;
        byte[] out = new byte[size];
        offset += ByteUtil.vintToBytes(out, offset, size);
        for (int i = 0; i < intArray.length; ++i) {
            offset += ByteUtil.vintToBytes(out, offset, intArray[i]);
        }
        return out;
    }

    public static void serializeVIntArray(DataOutput output, int[] intArray) throws IOException {
        ByteUtil.serializeVIntArray(output, intArray, intArray.length);
    }

    public static void serializeVIntArray(DataOutput output, int[] intArray, int encodedLength) throws IOException {
        WritableUtils.writeVInt((DataOutput)output, (int)encodedLength);
        for (int i = 0; i < intArray.length; ++i) {
            WritableUtils.writeVInt((DataOutput)output, (int)intArray[i]);
        }
    }

    public static long[] readFixedLengthLongArray(DataInput input, int length) throws IOException {
        long[] longArray = new long[length];
        for (int i = 0; i < length; ++i) {
            longArray[i] = input.readLong();
        }
        return longArray;
    }

    public static void writeFixedLengthLongArray(DataOutput output, long[] longArray) throws IOException {
        for (int i = 0; i < longArray.length; ++i) {
            output.writeLong(longArray[i]);
        }
    }

    public static int[] deserializeVIntArray(byte[] b) {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(b);
        DataInputStream in = new DataInputStream(bytesIn);
        try {
            int length = WritableUtils.readVInt((DataInput)in);
            int[] nArray = ByteUtil.deserializeVIntArray(in, length);
            return nArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static int[] deserializeVIntArray(DataInput in) throws IOException {
        return ByteUtil.deserializeVIntArray(in, WritableUtils.readVInt((DataInput)in));
    }

    public static int[] deserializeVIntArray(DataInput in, int length) throws IOException {
        int i = 0;
        int[] intArray = new int[length];
        while (i < length) {
            intArray[i++] = WritableUtils.readVInt((DataInput)in);
        }
        return intArray;
    }

    public static int[] deserializeVIntArray(byte[] b, int length) {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(b);
        DataInputStream in = new DataInputStream(bytesIn);
        try {
            return ByteUtil.deserializeVIntArray(in, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] concat(byte[] first, byte[] ... rest) {
        int totalLength = first.length;
        for (byte[] array : rest) {
            totalLength += array.length;
        }
        byte[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (byte[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static <T> T[] concat(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static byte[] concat(SortOrder sortOrder, ImmutableBytesWritable ... writables) {
        Preconditions.checkNotNull((Object)((Object)sortOrder));
        int totalLength = 0;
        for (ImmutableBytesWritable writable : writables) {
            totalLength += writable.getLength();
        }
        byte[] result = new byte[totalLength];
        int totalOffset = 0;
        for (ImmutableBytesWritable array : writables) {
            byte[] bytes = array.get();
            int offset = array.getOffset();
            if (sortOrder == SortOrder.DESC) {
                bytes = SortOrder.invert(bytes, offset, new byte[array.getLength()], 0, array.getLength());
                offset = 0;
            }
            System.arraycopy(bytes, offset, result, totalOffset, array.getLength());
            totalOffset += array.getLength();
        }
        return result;
    }

    public static int vintFromBytes(byte[] buffer, int offset) {
        try {
            return (int)Bytes.readVLong((byte[])buffer, (int)offset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int vintFromBytes(ImmutableBytesWritable ptr) {
        return (int)ByteUtil.vlongFromBytes(ptr);
    }

    public static long vlongFromBytes(ImmutableBytesWritable ptr) {
        int offset;
        byte[] buffer = ptr.get();
        byte firstByte = buffer[offset = ptr.getOffset()];
        int len = WritableUtils.decodeVIntSize((byte)firstByte);
        if (len == 1) {
            ptr.set(buffer, offset + 1, ptr.getLength());
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = buffer[offset + 1 + idx];
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        ptr.set(buffer, offset + len, ptr.getLength());
        return WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int vintToBytes(byte[] result, int offset, long vint) {
        long i = vint;
        if (i >= -112L && i <= 127L) {
            result[offset] = (byte)i;
            return 1;
        }
        int len = -112;
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        result[offset++] = (byte)len;
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            result[offset++] = (byte)((i & mask) >> shiftbits);
        }
        return len + 1;
    }

    public static byte[] nextKey(byte[] key) {
        byte[] nextStartRow = new byte[key.length];
        System.arraycopy(key, 0, nextStartRow, 0, key.length);
        if (!ByteUtil.nextKey(nextStartRow, nextStartRow.length)) {
            return null;
        }
        return nextStartRow;
    }

    public static boolean nextKey(byte[] key, int length) {
        return ByteUtil.nextKey(key, 0, length);
    }

    public static boolean nextKey(byte[] key, int offset, int length) {
        if (length == 0) {
            return false;
        }
        int i = offset + length - 1;
        while (key[i] == -1) {
            key[i] = 0;
            if (--i >= offset) continue;
            do {
                key[++i] = -1;
            } while (i < offset + length - 1);
            return false;
        }
        key[i] = (byte)(key[i] + 1);
        return true;
    }

    public static byte[] previousKey(byte[] key) {
        byte[] previousKey = new byte[key.length];
        System.arraycopy(key, 0, previousKey, 0, key.length);
        if (!ByteUtil.previousKey(previousKey, previousKey.length)) {
            return null;
        }
        return previousKey;
    }

    public static boolean previousKey(byte[] key, int length) {
        return ByteUtil.previousKey(key, 0, length);
    }

    public static boolean previousKey(byte[] key, int offset, int length) {
        if (length == 0) {
            return false;
        }
        int i = offset + length - 1;
        while (key[i] == 0) {
            key[i] = -1;
            if (--i >= offset) continue;
            do {
                key[++i] = 0;
            } while (i < offset + length - 1);
            return false;
        }
        key[i] = (byte)(key[i] - 1);
        return true;
    }

    public static byte[] fillKey(byte[] key, int length) {
        if (key.length > length) {
            throw new IllegalStateException();
        }
        if (key.length == length) {
            return key;
        }
        byte[] newBound = new byte[length];
        System.arraycopy(key, 0, newBound, 0, key.length);
        return newBound;
    }

    public static void nullPad(ImmutableBytesWritable ptr, int length) {
        if (ptr.getLength() > length) {
            throw new IllegalStateException();
        }
        if (ptr.getLength() == length) {
            return;
        }
        byte[] newBound = new byte[length];
        System.arraycopy(ptr.get(), ptr.getOffset(), newBound, 0, ptr.getLength());
        ptr.set(newBound);
    }

    public static int getSize(CharSequence sequence) {
        int count = 0;
        int len = sequence.length();
        for (int i = 0; i < len; ++i) {
            char ch = sequence.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
                continue;
            }
            count += 3;
        }
        return count;
    }

    public static boolean isInclusive(CompareFilter.CompareOp op) {
        switch (op) {
            case LESS: 
            case GREATER: {
                return false;
            }
            case EQUAL: 
            case NOT_EQUAL: 
            case LESS_OR_EQUAL: 
            case GREATER_OR_EQUAL: {
                return true;
            }
        }
        throw new RuntimeException("Unknown Compare op " + op.name());
    }

    public static boolean compare(CompareFilter.CompareOp op, int compareResult) {
        switch (op) {
            case LESS: {
                return compareResult < 0;
            }
            case LESS_OR_EQUAL: {
                return compareResult <= 0;
            }
            case EQUAL: {
                return compareResult == 0;
            }
            case NOT_EQUAL: {
                return compareResult != 0;
            }
            case GREATER_OR_EQUAL: {
                return compareResult >= 0;
            }
            case GREATER: {
                return compareResult > 0;
            }
        }
        throw new RuntimeException("Unknown Compare op " + op.name());
    }

    public static byte[] copyKeyBytesIfNecessary(ImmutableBytesWritable ptr) {
        if (ptr.getOffset() == 0 && ptr.getLength() == ptr.get().length) {
            return ptr.get();
        }
        return ptr.copyBytes();
    }

    public static KeyRange getKeyRange(byte[] key, CompareFilter.CompareOp op, PDataType type) {
        switch (op) {
            case EQUAL: {
                return type.getKeyRange(key, true, key, true);
            }
            case GREATER: {
                return type.getKeyRange(key, false, KeyRange.UNBOUND, false);
            }
            case GREATER_OR_EQUAL: {
                return type.getKeyRange(key, true, KeyRange.UNBOUND, false);
            }
            case LESS: {
                return type.getKeyRange(KeyRange.UNBOUND, false, key, false);
            }
            case LESS_OR_EQUAL: {
                return type.getKeyRange(KeyRange.UNBOUND, false, key, true);
            }
        }
        throw new IllegalArgumentException("Unknown operator " + op);
    }

    public static boolean contains(Collection<byte[]> keys, byte[] key) {
        for (byte[] k : keys) {
            if (!Arrays.equals(k, key)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(List<ImmutableBytesPtr> keys, ImmutableBytesPtr key) {
        for (ImmutableBytesPtr k : keys) {
            if (key.compareTo(k) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean match(Set<byte[]> keys, Set<byte[]> keys2) {
        if (keys == keys2) {
            return true;
        }
        if (keys == null || keys2 == null) {
            return false;
        }
        int size = keys.size();
        if (keys2.size() != size) {
            return false;
        }
        for (byte[] k : keys) {
            if (ByteUtil.contains(keys2, k)) continue;
            return false;
        }
        return true;
    }

    public static byte[] calculateTheClosestNextRowKeyForPrefix(byte[] rowKeyPrefix) {
        int offset;
        for (offset = rowKeyPrefix.length; offset > 0 && rowKeyPrefix[offset - 1] == -1; --offset) {
        }
        if (offset == 0) {
            return HConstants.EMPTY_END_ROW;
        }
        byte[] newStopRow = Arrays.copyOfRange(rowKeyPrefix, 0, offset);
        int n = newStopRow.length - 1;
        newStopRow[n] = (byte)(newStopRow[n] + 1);
        return newStopRow;
    }

    public static byte[][] splitArrayBySeparator(byte[] src, byte separator) {
        ArrayList<Integer> separatorLocations = new ArrayList<Integer>();
        for (int k = 0; k < src.length; ++k) {
            if (src[k] != separator) continue;
            separatorLocations.add(k);
        }
        byte[][] dst = new byte[separatorLocations.size() + 1][];
        int previousSepartor = -1;
        for (int j = 0; j < separatorLocations.size(); ++j) {
            int separatorLocation = (Integer)separatorLocations.get(j);
            dst[j] = Bytes.copy((byte[])src, (int)(previousSepartor + 1), (int)(separatorLocation - previousSepartor - 1));
            previousSepartor = separatorLocation;
        }
        if (previousSepartor < src.length) {
            dst[separatorLocations.size()] = Bytes.copy((byte[])src, (int)(previousSepartor + 1), (int)(src.length - previousSepartor - 1));
        }
        return dst;
    }
}

