/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import com.google.common.base.Preconditions;
import java.util.Random;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PWholeNumber;

public class PUnsignedSmallint
extends PWholeNumber<Short> {
    public static final PUnsignedSmallint INSTANCE = new PUnsignedSmallint();

    private PUnsignedSmallint() {
        super("UNSIGNED_SMALLINT", 13, Short.class, new UnsignedShortCodec(), 17);
    }

    @Override
    public Integer getScale(Object o) {
        return ZERO;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return PLong.INSTANCE.compareTo(lhs, rhs, rhsType);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return 2;
    }

    @Override
    public Integer getMaxLength(Object o) {
        return SHORT_PRECISION;
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            throw PUnsignedSmallint.newIllegalDataException(this + " may not be null");
        }
        byte[] b = new byte[2];
        this.toBytes(object, b, 0);
        return b;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            throw PUnsignedSmallint.newIllegalDataException(this + " may not be null");
        }
        return this.getCodec().encodeShort(((Number)object).shortValue(), bytes, offset);
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            Short b = Short.parseShort(value);
            if (b < 0) {
                throw PUnsignedSmallint.newIllegalDataException("Value may not be negative(" + b + ")");
            }
            return b;
        }
        catch (NumberFormatException e) {
            throw PUnsignedSmallint.newIllegalDataException(e);
        }
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        Short v = (Short)PSmallint.INSTANCE.toObject(object, actualType);
        PUnsignedSmallint.throwIfNonNegativeNumber(v);
        return v;
    }

    @Override
    public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        Short v = (Short)PSmallint.INSTANCE.toObject(b, o, l, actualType, sortOrder);
        PUnsignedSmallint.throwIfNonNegativeNumber(v);
        return v;
    }

    @Override
    public boolean isComparableTo(PDataType targetType) {
        return PDecimal.INSTANCE.isComparableTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return targetType.equals(this) || PUnsignedInt.INSTANCE.isCoercibleTo(targetType) || PSmallint.INSTANCE.isCoercibleTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        return super.isCoercibleTo(targetType, value) || PSmallint.INSTANCE.isCoercibleTo(targetType, value);
    }

    @Override
    public int getResultSetSqlType() {
        return PSmallint.INSTANCE.getResultSetSqlType();
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return Integer.valueOf(((Random)RANDOM.get()).nextInt(Short.MAX_VALUE)).shortValue();
    }

    static class UnsignedShortCodec
    extends PSmallint.ShortCodec {
        UnsignedShortCodec() {
        }

        @Override
        public short decodeShort(byte[] b, int o, SortOrder sortOrder) {
            short v;
            Preconditions.checkNotNull((Object)((Object)sortOrder));
            PDataType.checkForSufficientLength(b, o, 2);
            if (sortOrder == SortOrder.DESC) {
                b = SortOrder.invert(b, o, new byte[2], 0, 2);
                o = 0;
            }
            if ((v = Bytes.toShort((byte[])b, (int)o)) < 0) {
                throw PDataType.newIllegalDataException();
            }
            return v;
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            PDataType.checkForSufficientLength(b, o, 2);
            if (v < 0) {
                throw PDataType.newIllegalDataException();
            }
            Bytes.putShort((byte[])b, (int)o, (short)v);
            return 2;
        }
    }
}

