/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Random;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PRealNumber;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedSmallint;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PFloat
extends PRealNumber<Float> {
    public static final PFloat INSTANCE = new PFloat();

    private PFloat() {
        super("FLOAT", 6, Float.class, new FloatCodec(), 6);
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return PDouble.INSTANCE.compareTo(lhs, rhs, rhsType);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return 4;
    }

    @Override
    public Integer getScale(Object o) {
        if (o == null) {
            return null;
        }
        Float v = (Float)o;
        BigDecimal bd = BigDecimal.valueOf(v.floatValue());
        return bd.scale() == 0 ? null : Integer.valueOf(bd.scale());
    }

    @Override
    public Integer getMaxLength(Object o) {
        if (o == null) {
            return null;
        }
        Float v = (Float)o;
        BigDecimal bd = BigDecimal.valueOf(v.floatValue());
        return bd.precision();
    }

    @Override
    public byte[] toBytes(Object object) {
        byte[] b = new byte[4];
        this.toBytes(object, b, 0);
        return b;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            throw PFloat.newIllegalDataException(this + " may not be null");
        }
        return this.getCodec().encodeFloat(((Number)object).floatValue(), bytes, offset);
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            throw PFloat.newIllegalDataException(e);
        }
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        if (object == null) {
            return null;
        }
        if (PFloat.equalsAny(actualType, INSTANCE, PUnsignedFloat.INSTANCE)) {
            return object;
        }
        if (PFloat.equalsAny(actualType, PDouble.INSTANCE, PUnsignedDouble.INSTANCE)) {
            double d = (Double)object;
            if (Double.isNaN(d) || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38) {
                return Float.valueOf((float)d);
            }
            throw PFloat.newIllegalDataException(actualType + " value " + d + " cannot be cast to Float without changing its value");
        }
        if (PFloat.equalsAny(actualType, PLong.INSTANCE, PUnsignedLong.INSTANCE)) {
            float f = ((Long)object).longValue();
            return Float.valueOf(f);
        }
        if (PFloat.equalsAny(actualType, PInteger.INSTANCE, PUnsignedInt.INSTANCE)) {
            float f = ((Integer)object).intValue();
            return Float.valueOf(f);
        }
        if (PFloat.equalsAny(actualType, PTinyint.INSTANCE, PUnsignedTinyint.INSTANCE)) {
            float f = ((Byte)object).byteValue();
            return Float.valueOf(f);
        }
        if (PFloat.equalsAny(actualType, PSmallint.INSTANCE, PUnsignedSmallint.INSTANCE)) {
            float f = ((Short)object).shortValue();
            return Float.valueOf(f);
        }
        if (actualType == PDecimal.INSTANCE) {
            BigDecimal dl = (BigDecimal)object;
            return Float.valueOf(dl.floatValue());
        }
        return PFloat.throwConstraintViolationException(actualType, this);
    }

    @Override
    public Float toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        if (l <= 0) {
            return null;
        }
        if (PFloat.equalsAny(actualType, INSTANCE, PUnsignedFloat.INSTANCE, PDouble.INSTANCE, PUnsignedDouble.INSTANCE, PLong.INSTANCE, PUnsignedLong.INSTANCE, PInteger.INSTANCE, PUnsignedInt.INSTANCE, PSmallint.INSTANCE, PUnsignedSmallint.INSTANCE, PTinyint.INSTANCE, PUnsignedTinyint.INSTANCE)) {
            return Float.valueOf(actualType.getCodec().decodeFloat(b, o, sortOrder));
        }
        if (actualType == PDecimal.INSTANCE) {
            BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
            return Float.valueOf(bd.floatValue());
        }
        PFloat.throwConstraintViolationException(actualType, this);
        return null;
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        if (value != null) {
            float f = ((Float)value).floatValue();
            if (targetType.equals(PUnsignedFloat.INSTANCE)) {
                return f >= 0.0f;
            }
            if (targetType.equals(PUnsignedLong.INSTANCE)) {
                return f >= 0.0f && f <= 9.223372E18f;
            }
            if (targetType.equals(PLong.INSTANCE)) {
                return f >= -9.223372E18f && f <= 9.223372E18f;
            }
            if (targetType.equals(PUnsignedInt.INSTANCE)) {
                return f >= 0.0f && f <= 2.1474836E9f;
            }
            if (targetType.equals(PInteger.INSTANCE)) {
                return f >= -2.1474836E9f && f <= 2.1474836E9f;
            }
            if (targetType.equals(PUnsignedSmallint.INSTANCE)) {
                return f >= 0.0f && f <= 32767.0f;
            }
            if (targetType.equals(PSmallint.INSTANCE)) {
                return f >= -32768.0f && f <= 32767.0f;
            }
            if (targetType.equals(PTinyint.INSTANCE)) {
                return f >= -128.0f && f <= 127.0f;
            }
            if (targetType.equals(PUnsignedTinyint.INSTANCE)) {
                return f >= 0.0f && f <= 127.0f;
            }
        }
        return super.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.equals(targetType) || PDouble.INSTANCE.isCoercibleTo(targetType);
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return Float.valueOf(((Random)RANDOM.get()).nextFloat());
    }

    static class FloatCodec
    extends PDataType.BaseCodec {
        FloatCodec() {
        }

        @Override
        public long decodeLong(byte[] b, int o, SortOrder sortOrder) {
            float v = this.decodeFloat(b, o, sortOrder);
            if (v < -9.223372E18f || v > 9.223372E18f) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be cast to Long without changing its value");
            }
            return (long)v;
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            float v = this.decodeFloat(b, o, sortOrder);
            if (v < -2.1474836E9f || v > 2.1474836E9f) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be cast to Integer without changing its value");
            }
            return (int)v;
        }

        @Override
        public byte decodeByte(byte[] b, int o, SortOrder sortOrder) {
            float v = this.decodeFloat(b, o, sortOrder);
            if (v < -128.0f || v > 127.0f) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be cast to Byte without changing its value");
            }
            return (byte)v;
        }

        @Override
        public short decodeShort(byte[] b, int o, SortOrder sortOrder) {
            float v = this.decodeFloat(b, o, sortOrder);
            if (v < -32768.0f || v > 32767.0f) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be cast to Short without changing its value");
            }
            return (short)v;
        }

        @Override
        public double decodeDouble(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeFloat(b, o, sortOrder);
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            int value;
            Preconditions.checkNotNull((Object)((Object)sortOrder));
            PDataType.checkForSufficientLength(b, o, 4);
            if (sortOrder == SortOrder.DESC) {
                value = 0;
                for (int i = o; i < o + 4; ++i) {
                    value <<= 8;
                    value ^= (b[i] ^ 0xFF) & 0xFF;
                }
            } else {
                value = Bytes.toInt((byte[])b, (int)o);
            }
            --value;
            value ^= ~value >> 31 | Integer.MIN_VALUE;
            return Float.intBitsToFloat(value);
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            return this.encodeFloat(v, b, o);
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            return this.encodeFloat(v, b, o);
        }

        @Override
        public int encodeInt(int v, byte[] b, int o) {
            return this.encodeFloat(v, b, o);
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            return this.encodeFloat(v, b, o);
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            if (Double.isNaN(v) || v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY || v >= -3.4028234663852886E38 && v <= 3.4028234663852886E38) {
                return this.encodeFloat((float)v, b, o);
            }
            throw PDataType.newIllegalDataException("Value " + v + " cannot be encoded as an Float without changing its value");
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            PDataType.checkForSufficientLength(b, o, 4);
            int i = Float.floatToIntBits(v);
            i = (i ^ (i >> 31 | Integer.MIN_VALUE)) + 1;
            Bytes.putInt((byte[])b, (int)o, (int)i);
            return 4;
        }

        @Override
        public PDataType.PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PDataType.PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray.PrimitiveFloatPhoenixArray(type, elements);
                }
            };
        }
    }
}

