/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class MultiMutation
extends Mutation {
    private ImmutableBytesPtr rowKey;

    public MultiMutation(ImmutableBytesPtr rowkey) {
        this.rowKey = rowkey;
    }

    public void addAll(Mutation stored) {
        for (Map.Entry kvs : stored.getFamilyCellMap().entrySet()) {
            byte[] family = (byte[])kvs.getKey();
            List<Cell> list = this.getKeyValueList(family, ((List)kvs.getValue()).size());
            list.addAll((Collection)kvs.getValue());
            this.familyMap.put(family, list);
        }
        for (Map.Entry attrib : stored.getAttributesMap().entrySet()) {
            if (this.getAttribute((String)attrib.getKey()) != null) continue;
            this.setAttribute((String)attrib.getKey(), (byte[])attrib.getValue());
        }
    }

    private List<Cell> getKeyValueList(byte[] family, int hint) {
        ArrayList list = (ArrayList)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList(hint);
        }
        return list;
    }

    public byte[] getRow() {
        return this.rowKey.copyBytesIfNecessary();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rowKey == null ? 0 : this.rowKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MultiMutation other = (MultiMutation)((Object)obj);
        return this.rowKey.equals((Object)other.rowKey);
    }
}

