/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.aggregator.BaseAggregator;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.FirstLastNthValueDataContainer;

public class FirstLastValueBaseClientAggregator
extends BaseAggregator {
    protected boolean useOffset = false;
    protected int offset = -1;
    protected BinaryComparator topOrder = new BinaryComparator(ByteUtil.EMPTY_BYTE_ARRAY);
    protected byte[] topValue = null;
    protected TreeMap<byte[], LinkedList<byte[]>> topValues = new TreeMap(new Bytes.ByteArrayComparator());
    protected boolean isAscending;
    protected PDataType dataType;
    protected boolean isArrayReturnType = false;

    public FirstLastValueBaseClientAggregator() {
        super(SortOrder.getDefault());
        this.dataType = PVarbinary.INSTANCE;
    }

    public FirstLastValueBaseClientAggregator(PDataType type) {
        super(SortOrder.getDefault());
        this.dataType = type == null ? PVarbinary.INSTANCE : type;
    }

    @Override
    public void reset() {
        this.topOrder = new BinaryComparator(ByteUtil.EMPTY_BYTE_ARRAY);
        this.topValue = null;
        this.topValues.clear();
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.useOffset) {
            if (this.topValues.size() == 0) {
                return false;
            }
            Set<Map.Entry<Object, LinkedList<Object>>> entrySet = this.isAscending ? this.topValues.entrySet() : this.topValues.descendingMap().entrySet();
            int counter = 0;
            ImmutableBytesWritable arrPtr = new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY);
            block0: for (Map.Entry<Object, LinkedList<Object>> entry : entrySet) {
                ListIterator it = entry.getValue().listIterator();
                while (it.hasNext()) {
                    if (this.isArrayReturnType) {
                        ImmutableBytesWritable newArrPtr = new ImmutableBytesWritable((byte[])it.next());
                        PArrayDataType.appendItemToArray(newArrPtr, arrPtr.getLength(), arrPtr.getOffset(), arrPtr.get(), PDataType.fromTypeId(this.dataType.getSqlType() - 3000), counter, null, this.sortOrder);
                        arrPtr = newArrPtr;
                        if (++counter != this.offset) continue;
                        continue block0;
                    }
                    if (++counter == this.offset) {
                        ptr.set((byte[])it.next());
                        return true;
                    }
                    it.next();
                }
            }
            if (this.isArrayReturnType) {
                ptr.set(arrPtr.get());
                return true;
            }
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        if (this.topValue == null) {
            return false;
        }
        ptr.set(this.topValue);
        return true;
    }

    @Override
    public void aggregate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (tuple instanceof SingleKeyValueTuple) {
            this.topValue = ptr.copyBytes();
            return;
        }
        FirstLastNthValueDataContainer payload = new FirstLastNthValueDataContainer();
        payload.setPayload(ptr.copyBytes());
        this.isAscending = payload.getIsAscending();
        TreeMap<byte[], LinkedList<byte[]>> serverAggregatorResult = payload.getData();
        if (this.useOffset) {
            for (Map.Entry<byte[], LinkedList<byte[]>> entry : serverAggregatorResult.entrySet()) {
                byte[] itemKey = entry.getKey();
                LinkedList<byte[]> itemList = entry.getValue();
                if (this.topValues.containsKey(itemKey)) {
                    this.topValues.get(itemKey).addAll(itemList);
                    continue;
                }
                this.topValues.put(itemKey, itemList);
            }
        } else {
            boolean isBetter;
            Map.Entry<byte[], LinkedList<byte[]>> valueEntry = serverAggregatorResult.firstEntry();
            byte[] currentOrder = valueEntry.getKey();
            if (this.isAscending) {
                isBetter = this.topOrder.compareTo(currentOrder) > 0;
            } else {
                boolean bl = isBetter = this.topOrder.compareTo(currentOrder) < 0;
            }
            if (this.topOrder.getValue().length < 1 || isBetter) {
                this.topOrder = new BinaryComparator(currentOrder);
                this.topValue = valueEntry.getValue().getFirst();
            }
        }
    }

    @Override
    public PDataType getDataType() {
        return this.dataType;
    }

    public void init(int offset, boolean isArrayReturnType) {
        if (offset > 0) {
            this.useOffset = true;
            this.offset = offset;
        }
        this.isArrayReturnType = isArrayReturnType;
    }
}

