/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.hbase.coprocessor;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionCodec;
import org.apache.tephra.TxConstants;
import org.apache.tephra.coprocessor.CacheSupplier;
import org.apache.tephra.coprocessor.TransactionStateCache;
import org.apache.tephra.coprocessor.TransactionStateCacheSupplier;
import org.apache.tephra.hbase.coprocessor.TransactionFilters;
import org.apache.tephra.hbase.txprune.CompactionState;
import org.apache.tephra.persist.TransactionVisibilityState;
import org.apache.tephra.util.TxUtils;

public class TransactionProcessor
extends BaseRegionObserver {
    private static final Log LOG = LogFactory.getLog(TransactionProcessor.class);
    private final TransactionCodec txCodec;
    private TransactionStateCache cache;
    private volatile CompactionState compactionState;
    private CacheSupplier<TransactionStateCache> cacheSupplier;
    protected volatile Boolean pruneEnable;
    protected volatile Long txMaxLifetimeMillis;
    protected Map<byte[], Long> ttlByFamily = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
    protected boolean allowEmptyValues = false;
    protected boolean readNonTxnData = false;

    public TransactionProcessor() {
        this.txCodec = new TransactionCodec();
    }

    public void start(CoprocessorEnvironment e) throws IOException {
        if (e instanceof RegionCoprocessorEnvironment) {
            RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)e;
            this.cacheSupplier = this.getTransactionStateCacheSupplier(env);
            this.cache = this.cacheSupplier.get();
            HTableDescriptor tableDesc = env.getRegion().getTableDesc();
            for (HColumnDescriptor columnDesc : tableDesc.getFamilies()) {
                String columnTTL = columnDesc.getValue("dataset.table.ttl");
                long ttl = 0L;
                if (columnTTL != null) {
                    try {
                        ttl = Long.parseLong(columnTTL);
                        LOG.info((Object)("Family " + columnDesc.getNameAsString() + " has TTL of " + columnTTL));
                    }
                    catch (NumberFormatException nfe) {
                        LOG.warn((Object)("Invalid TTL value configured for column family " + columnDesc.getNameAsString() + ", value = " + columnTTL));
                    }
                }
                this.ttlByFamily.put(columnDesc.getName(), ttl);
            }
            this.allowEmptyValues = this.getAllowEmptyValues(env, tableDesc);
            this.txMaxLifetimeMillis = this.getTxMaxLifetimeMillis(env);
            this.readNonTxnData = Boolean.valueOf(tableDesc.getValue("data.tx.read.pre.existing"));
            if (this.readNonTxnData) {
                LOG.info((Object)("Reading pre-existing data enabled for table " + tableDesc.getNameAsString()));
            }
            this.initializePruneState(env);
        }
    }

    @Nullable
    protected Configuration getConfiguration(CoprocessorEnvironment env) {
        return env.getConfiguration();
    }

    protected CacheSupplier<TransactionStateCache> getTransactionStateCacheSupplier(RegionCoprocessorEnvironment env) {
        return new TransactionStateCacheSupplier(env.getConfiguration());
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
        try {
            this.resetPruneState();
        }
        finally {
            if (this.cacheSupplier != null) {
                this.cacheSupplier.release();
            }
        }
    }

    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
        Transaction tx = this.getFromOperation((OperationWithAttributes)get);
        if (tx != null) {
            this.projectFamilyDeletes(get);
            get.setMaxVersions();
            get.setTimeRange(TxUtils.getOldestVisibleTimestamp(this.ttlByFamily, tx, this.readNonTxnData), TxUtils.getMaxVisibleTimestamp(tx));
            Filter newFilter = this.getTransactionFilter(tx, ScanType.USER_SCAN, get.getFilter());
            get.setFilter(newFilter);
        }
    }

    public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
        Transaction tx = this.getFromOperation((OperationWithAttributes)put);
        this.ensureValidTxLifetime((RegionCoprocessorEnvironment)e.getEnvironment(), (OperationWithAttributes)put, tx);
    }

    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> e, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (this.isRollbackOperation((OperationWithAttributes)delete)) {
            return;
        }
        Transaction tx = this.getFromOperation((OperationWithAttributes)delete);
        this.ensureValidTxLifetime((RegionCoprocessorEnvironment)e.getEnvironment(), (OperationWithAttributes)delete, tx);
        Put deleteMarkers = new Put(delete.getRow(), delete.getTimeStamp());
        for (byte[] byArray : delete.getFamilyCellMap().keySet()) {
            List familyCells = (List)delete.getFamilyCellMap().get(byArray);
            if (this.isFamilyDelete(familyCells)) {
                deleteMarkers.add(byArray, TxConstants.FAMILY_DELETE_QUALIFIER, ((Cell)familyCells.get(0)).getTimestamp(), HConstants.EMPTY_BYTE_ARRAY);
                continue;
            }
            for (Cell cell : familyCells) {
                deleteMarkers.add(byArray, CellUtil.cloneQualifier((Cell)cell), cell.getTimestamp(), HConstants.EMPTY_BYTE_ARRAY);
            }
        }
        for (Map.Entry entry : delete.getAttributesMap().entrySet()) {
            deleteMarkers.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
        ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().put(deleteMarkers);
        e.bypass();
    }

    private boolean getAllowEmptyValues(RegionCoprocessorEnvironment env, HTableDescriptor htd) {
        String allowEmptyValuesFromTableDesc = htd.getValue("data.tx.allow.empty.values");
        Configuration conf = this.getConfiguration((CoprocessorEnvironment)env);
        boolean allowEmptyValuesFromConfig = conf != null ? conf.getBoolean("data.tx.allow.empty.values", false) : false;
        return allowEmptyValuesFromTableDesc != null ? Boolean.valueOf(allowEmptyValuesFromTableDesc) : allowEmptyValuesFromConfig;
    }

    private long getTxMaxLifetimeMillis(RegionCoprocessorEnvironment env) {
        Configuration conf = this.getConfiguration((CoprocessorEnvironment)env);
        if (conf != null) {
            return TimeUnit.SECONDS.toMillis(conf.getInt("data.tx.max.lifetime", TxConstants.Manager.DEFAULT_TX_MAX_LIFETIME));
        }
        return TimeUnit.SECONDS.toMillis(TxConstants.Manager.DEFAULT_TX_MAX_LIFETIME);
    }

    private boolean isFamilyDelete(List<Cell> familyCells) {
        return familyCells.size() == 1 && CellUtil.isDeleteFamily((Cell)familyCells.get(0));
    }

    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
        Transaction tx = this.getFromOperation((OperationWithAttributes)scan);
        if (tx != null) {
            this.projectFamilyDeletes(scan);
            scan.setMaxVersions();
            scan.setTimeRange(TxUtils.getOldestVisibleTimestamp(this.ttlByFamily, tx, this.readNonTxnData), TxUtils.getMaxVisibleTimestamp(tx));
            Filter newFilter = this.getTransactionFilter(tx, ScanType.USER_SCAN, scan.getFilter());
            scan.setFilter(newFilter);
        }
        return s;
    }

    private Scan projectFamilyDeletes(Scan scan) {
        for (Map.Entry entry : scan.getFamilyMap().entrySet()) {
            NavigableSet columns = (NavigableSet)entry.getValue();
            if (columns == null || columns.isEmpty()) continue;
            scan.addColumn((byte[])entry.getKey(), TxConstants.FAMILY_DELETE_QUALIFIER);
        }
        return scan;
    }

    private Get projectFamilyDeletes(Get get) {
        for (Map.Entry entry : get.getFamilyMap().entrySet()) {
            NavigableSet columns = (NavigableSet)entry.getValue();
            if (columns == null || columns.isEmpty()) continue;
            get.addColumn((byte[])entry.getKey(), TxConstants.FAMILY_DELETE_QUALIFIER);
        }
        return get;
    }

    public InternalScanner preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, KeyValueScanner memstoreScanner, InternalScanner scanner) throws IOException {
        InternalScanner temp = scanner;
        Throwable throwable = null;
        if (temp != null) {
            if (throwable != null) {
                try {
                    temp.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                temp.close();
            }
        }
        return this.createStoreScanner((RegionCoprocessorEnvironment)c.getEnvironment(), "flush", this.cache.getLatestState(), store, Collections.singletonList(memstoreScanner), ScanType.COMPACT_RETAIN_DELETES, Long.MIN_VALUE);
    }

    public void postFlush(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        Region region = ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion();
        long numStoreFiles = this.numStoreFilesForRegion(e);
        long memstoreSize = region.getMemstoreSize();
        LOG.debug((Object)String.format("Region %s: memstore size = %s, num store files = %s", region.getRegionInfo().getRegionNameAsString(), memstoreSize, numStoreFiles));
        if (memstoreSize == 0L && numStoreFiles == 0L && this.compactionState != null) {
            this.compactionState.persistRegionEmpty(System.currentTimeMillis());
        }
    }

    public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends KeyValueScanner> scanners, ScanType scanType, long earliestPutTs, InternalScanner s, CompactionRequest request) throws IOException {
        TransactionVisibilityState snapshot = this.cache.getLatestState();
        if (this.compactionState != null) {
            this.compactionState.record(request, snapshot);
        }
        InternalScanner temp = s;
        Throwable throwable = null;
        if (temp != null) {
            if (throwable != null) {
                try {
                    temp.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                temp.close();
            }
        }
        return this.createStoreScanner((RegionCoprocessorEnvironment)c.getEnvironment(), "compaction", snapshot, store, scanners, scanType, earliestPutTs);
    }

    public void postCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, StoreFile resultFile, CompactionRequest request) throws IOException {
        if (this.compactionState != null) {
            this.compactionState.persist();
        }
    }

    protected InternalScanner createStoreScanner(RegionCoprocessorEnvironment env, String action, TransactionVisibilityState snapshot, Store store, List<? extends KeyValueScanner> scanners, ScanType type, long earliestPutTs) throws IOException {
        if (snapshot == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Region " + env.getRegion().getRegionInfo().getRegionNameAsString() + ", no current transaction state found, defaulting to normal " + action + " scanner"));
            }
            return null;
        }
        Transaction dummyTx = TxUtils.createDummyTransaction(snapshot);
        Scan scan = new Scan();
        scan.setMaxVersions();
        scan.setFilter((Filter)new IncludeInProgressFilter(dummyTx.getVisibilityUpperBound(), snapshot.getInvalid(), this.getTransactionFilter(dummyTx, type, null)));
        return new StoreScanner(store, store.getScanInfo(), scan, scanners, type, store.getSmallestReadPoint(), earliestPutTs);
    }

    private Transaction getFromOperation(OperationWithAttributes op) throws IOException {
        byte[] encoded = op.getAttribute("tephra.tx");
        if (encoded == null) {
            encoded = op.getAttribute("cask.tx");
        }
        if (encoded != null) {
            return this.txCodec.decode(encoded);
        }
        return null;
    }

    protected void ensureValidTxLifetime(RegionCoprocessorEnvironment env, OperationWithAttributes op, @Nullable Transaction tx) throws IOException {
        boolean validLifetime;
        if (tx == null) {
            return;
        }
        boolean bl = validLifetime = TxUtils.getTimestamp(tx.getTransactionId()) + this.txMaxLifetimeMillis > System.currentTimeMillis();
        if (!validLifetime) {
            throw new DoNotRetryIOException(String.format("Transaction %s has exceeded max lifetime %s ms", tx.getTransactionId(), this.txMaxLifetimeMillis));
        }
    }

    private boolean isRollbackOperation(OperationWithAttributes op) throws IOException {
        return op.getAttribute("tephra.tx.rollback") != null || op.getAttribute("cask.tx.rollback") != null;
    }

    protected Filter getTransactionFilter(Transaction tx, ScanType type, Filter filter) {
        return TransactionFilters.getVisibilityFilter(tx, this.ttlByFamily, this.allowEmptyValues, type, filter);
    }

    protected void initializePruneState(RegionCoprocessorEnvironment env) {
        Configuration conf = this.getConfiguration((CoprocessorEnvironment)env);
        if (conf != null) {
            this.pruneEnable = conf.getBoolean("data.tx.prune.enable", false);
            if (Boolean.TRUE.equals(this.pruneEnable)) {
                TableName pruneTable = TableName.valueOf((String)conf.get("data.tx.prune.state.table", "tephra.state"));
                long pruneFlushInterval = TimeUnit.SECONDS.toMillis(conf.getLong("data.tx.prune.flush.interval", TxConstants.TransactionPruning.DEFAULT_PRUNE_FLUSH_INTERVAL));
                this.compactionState = new CompactionState(env, pruneTable, pruneFlushInterval);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Automatic invalid list pruning is enabled for table %s. Compaction state will be recorded in table %s", env.getRegionInfo().getTable().getNameWithNamespaceInclAsString(), pruneTable.getNameWithNamespaceInclAsString()));
                }
            }
        }
    }

    protected void resetPruneState() {
        this.pruneEnable = false;
        if (this.compactionState != null) {
            this.compactionState.stop();
            this.compactionState = null;
        }
    }

    private long numStoreFilesForRegion(ObserverContext<RegionCoprocessorEnvironment> c) {
        long numStoreFiles = 0L;
        for (Store store : ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getStores()) {
            numStoreFiles += (long)store.getStorefiles().size();
        }
        return numStoreFiles;
    }

    static class IncludeInProgressFilter
    extends FilterBase {
        private final long visibilityUpperBound;
        private final Set<Long> invalidIds;
        private final Filter txFilter;

        public IncludeInProgressFilter(long upperBound, Collection<Long> invalids, Filter transactionFilter) {
            this.visibilityUpperBound = upperBound;
            this.invalidIds = Sets.newHashSet(invalids);
            this.txFilter = transactionFilter;
        }

        public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
            long ts = cell.getTimestamp();
            if (ts > this.visibilityUpperBound) {
                if (this.invalidIds.contains(ts)) {
                    return Filter.ReturnCode.SKIP;
                }
                return Filter.ReturnCode.INCLUDE;
            }
            return this.txFilter.filterKeyValue(cell);
        }
    }
}

