/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ExplainPlanAttributes;

public class ExplainPlan {
    public static final ExplainPlan EMPTY_PLAN = new ExplainPlan(Collections.emptyList());
    private final List<String> planSteps;
    private final ExplainPlanAttributes planStepsAsAttributes;

    public ExplainPlan(List<String> planSteps) {
        this.planSteps = ImmutableList.copyOf(planSteps);
        this.planStepsAsAttributes = ExplainPlanAttributes.getDefaultExplainPlan();
    }

    public ExplainPlan(List<String> planSteps, ExplainPlanAttributes planStepsAsAttributes) {
        this.planSteps = planSteps;
        this.planStepsAsAttributes = planStepsAsAttributes;
    }

    public List<String> getPlanSteps() {
        return this.planSteps;
    }

    public ExplainPlanAttributes getPlanStepsAsAttributes() {
        return this.planStepsAsAttributes;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (String step : this.planSteps) {
            buf.append(step);
            buf.append('\n');
        }
        return buf.toString();
    }
}

