/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.icuadapter;

import com.ibm.icu.impl.jdkadapter.NumberFormatICU;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.CurrencyAmount;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;

public class NumberFormatJDK
extends com.ibm.icu.text.NumberFormat {
    private static final long serialVersionUID = -1739846528146803964L;
    private NumberFormat fJdkNfmt;

    private NumberFormatJDK(NumberFormat jdkNfmt) {
        this.fJdkNfmt = jdkNfmt;
    }

    public static com.ibm.icu.text.NumberFormat wrap(NumberFormat jdkNfmt) {
        if (jdkNfmt instanceof NumberFormatICU) {
            return ((NumberFormatICU)jdkNfmt).unwrap();
        }
        return new NumberFormatJDK(jdkNfmt);
    }

    public NumberFormat unwrap() {
        return this.fJdkNfmt;
    }

    @Override
    public Object clone() {
        NumberFormatJDK other = (NumberFormatJDK)super.clone();
        other.fJdkNfmt = (NumberFormat)this.fJdkNfmt.clone();
        return other;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NumberFormatJDK) {
            return ((NumberFormatJDK)obj).fJdkNfmt.equals(this.fJdkNfmt);
        }
        return false;
    }

    @Override
    public StringBuffer format(BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.fJdkNfmt.format(number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(com.ibm.icu.math.BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.fJdkNfmt.format(number.toBigDecimal(), toAppendTo, pos);
    }

    @Override
    public StringBuffer format(BigInteger number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.fJdkNfmt.format(number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(CurrencyAmount currAmt, StringBuffer toAppendTo, FieldPosition pos) {
        java.util.Currency save = this.fJdkNfmt.getCurrency();
        String currCode = currAmt.getCurrency().getCurrencyCode();
        boolean same = save.getCurrencyCode().equals(currCode);
        if (!same) {
            this.fJdkNfmt.setCurrency(java.util.Currency.getInstance(currCode));
        }
        this.fJdkNfmt.format(currAmt.getNumber(), toAppendTo, pos);
        if (!same) {
            this.fJdkNfmt.setCurrency(save);
        }
        return toAppendTo;
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.fJdkNfmt.format(number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.fJdkNfmt.format(number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.fJdkNfmt.format(number, toAppendTo, pos);
    }

    @Override
    public Currency getCurrency() {
        java.util.Currency jdkCurrency = this.fJdkNfmt.getCurrency();
        if (jdkCurrency == null) {
            return null;
        }
        return Currency.getInstance(jdkCurrency.getCurrencyCode());
    }

    @Override
    public int getMaximumFractionDigits() {
        return this.fJdkNfmt.getMaximumFractionDigits();
    }

    @Override
    public int getMaximumIntegerDigits() {
        return this.fJdkNfmt.getMaximumIntegerDigits();
    }

    @Override
    public int getMinimumFractionDigits() {
        return this.fJdkNfmt.getMinimumFractionDigits();
    }

    public int getMinumumIntegerDigits() {
        return this.fJdkNfmt.getMinimumIntegerDigits();
    }

    @Override
    public int getRoundingMode() {
        RoundingMode jdkMode = this.fJdkNfmt.getRoundingMode();
        int icuMode = 0;
        if (jdkMode.equals((Object)RoundingMode.CEILING)) {
            icuMode = 2;
        } else if (jdkMode.equals((Object)RoundingMode.DOWN)) {
            icuMode = 1;
        } else if (jdkMode.equals((Object)RoundingMode.FLOOR)) {
            icuMode = 3;
        } else if (jdkMode.equals((Object)RoundingMode.HALF_DOWN)) {
            icuMode = 5;
        } else if (jdkMode.equals((Object)RoundingMode.HALF_EVEN)) {
            icuMode = 6;
        } else if (jdkMode.equals((Object)RoundingMode.HALF_UP)) {
            icuMode = 4;
        } else if (jdkMode.equals((Object)RoundingMode.UNNECESSARY)) {
            icuMode = 7;
        } else if (jdkMode.equals((Object)RoundingMode.UP)) {
            icuMode = 0;
        }
        return icuMode;
    }

    @Override
    public int hashCode() {
        return this.fJdkNfmt.hashCode();
    }

    @Override
    public boolean isGroupingUsed() {
        return this.fJdkNfmt.isGroupingUsed();
    }

    @Override
    public boolean isParseIntegerOnly() {
        return this.fJdkNfmt.isParseIntegerOnly();
    }

    @Override
    public boolean isParseStrict() {
        return false;
    }

    @Override
    public Number parse(String text) throws ParseException {
        return this.fJdkNfmt.parse(text);
    }

    @Override
    public Number parse(String text, ParsePosition parsePosition) {
        return this.fJdkNfmt.parse(text, parsePosition);
    }

    @Override
    public void setCurrency(Currency theCurrency) {
        if (theCurrency == null) {
            this.fJdkNfmt.setCurrency(null);
            return;
        }
        this.fJdkNfmt.setCurrency(java.util.Currency.getInstance(theCurrency.getCurrencyCode()));
    }

    @Override
    public void setGroupingUsed(boolean newValue) {
        this.fJdkNfmt.setGroupingUsed(newValue);
    }

    @Override
    public void setMaximumFractionDigits(int newValue) {
        this.fJdkNfmt.setMaximumFractionDigits(newValue);
    }

    @Override
    public void setMaximumIntegerDigits(int newValue) {
        this.fJdkNfmt.setMaximumIntegerDigits(newValue);
    }

    @Override
    public void setMinimumFractionDigits(int newValue) {
        this.fJdkNfmt.setMinimumFractionDigits(newValue);
    }

    @Override
    public void setMinimumIntegerDigits(int newValue) {
        this.fJdkNfmt.setMinimumIntegerDigits(newValue);
    }

    @Override
    public void setParseIntegerOnly(boolean value) {
        this.fJdkNfmt.setParseIntegerOnly(value);
    }

    @Override
    public void setParseStrict(boolean value) {
    }

    @Override
    public void setRoundingMode(int roundingMode) {
        RoundingMode mode = null;
        switch (roundingMode) {
            case 2: {
                mode = RoundingMode.CEILING;
                break;
            }
            case 1: {
                mode = RoundingMode.DOWN;
                break;
            }
            case 3: {
                mode = RoundingMode.FLOOR;
                break;
            }
            case 5: {
                mode = RoundingMode.HALF_DOWN;
                break;
            }
            case 6: {
                mode = RoundingMode.HALF_EVEN;
                break;
            }
            case 4: {
                mode = RoundingMode.HALF_UP;
                break;
            }
            case 7: {
                mode = RoundingMode.UNNECESSARY;
                break;
            }
            case 0: {
                mode = RoundingMode.UP;
            }
        }
        if (mode == null) {
            throw new IllegalArgumentException("Invalid rounding mode: " + roundingMode);
        }
        this.fJdkNfmt.setRoundingMode(mode);
    }
}

