/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.json;

import ch.qos.logback.classic.pattern.ClassOfCallerConverter;
import ch.qos.logback.classic.pattern.FileOfCallerConverter;
import ch.qos.logback.classic.pattern.LineOfCallerConverter;
import ch.qos.logback.classic.pattern.MethodOfCallerConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.twill.api.logging.LogThrowable;
import org.apache.twill.internal.json.DefaultLogThrowable;

public final class ILoggingEventSerializer
implements JsonSerializer<ILoggingEvent> {
    private final ClassOfCallerConverter classNameConverter = new ClassOfCallerConverter();
    private final MethodOfCallerConverter methodConverter = new MethodOfCallerConverter();
    private final FileOfCallerConverter fileConverter = new FileOfCallerConverter();
    private final LineOfCallerConverter lineConverter = new LineOfCallerConverter();
    private final String hostname;
    private final String runnableName;

    public ILoggingEventSerializer(String hostname, String runnableName) {
        this.hostname = hostname;
        this.runnableName = runnableName;
    }

    @Override
    public JsonElement serialize(ILoggingEvent event, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("name", event.getLoggerName());
        json.addProperty("host", this.hostname);
        json.addProperty("timestamp", Long.toString(event.getTimeStamp()));
        json.addProperty("level", event.getLevel().toString());
        json.addProperty("className", this.classNameConverter.convert(event));
        json.addProperty("method", this.methodConverter.convert(event));
        json.addProperty("file", this.fileConverter.convert(event));
        json.addProperty("line", this.lineConverter.convert(event));
        json.addProperty("thread", event.getThreadName());
        json.addProperty("message", event.getFormattedMessage());
        json.addProperty("runnableName", this.runnableName);
        if (event.getThrowableProxy() == null) {
            json.add("throwable", JsonNull.INSTANCE);
        } else {
            json.add("throwable", context.serialize(new DefaultLogThrowable(event.getThrowableProxy()), (Type)((Object)LogThrowable.class)));
        }
        return json;
    }
}

