/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.filesystem;

import java.io.File;
import java.net.URI;
import org.apache.twill.filesystem.LocalLocation;
import org.apache.twill.filesystem.Location;
import org.apache.twill.filesystem.LocationFactory;

public final class LocalLocationFactory
implements LocationFactory {
    private final File basePath;

    public LocalLocationFactory() {
        this(new File(File.separator));
    }

    public LocalLocationFactory(File basePath) {
        this.basePath = basePath;
    }

    @Override
    public Location create(String path) {
        return this.create(new File(this.basePath, path).toURI());
    }

    @Override
    public Location create(URI uri) {
        if (uri.isAbsolute()) {
            return new LocalLocation(this, new File(uri));
        }
        return new LocalLocation(this, new File(this.basePath, uri.getPath()));
    }

    @Override
    public Location getHomeLocation() {
        return new LocalLocation(this, new File(System.getProperty("user.home")));
    }
}

