/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.transaction;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Provider;
import com.google.inject.util.Providers;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.phoenix.coprocessor.TephraTransactionalProcessor;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.transaction.PhoenixTransactionClient;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.PhoenixTransactionService;
import org.apache.phoenix.transaction.TephraTransactionContext;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.tephra.TransactionManager;
import org.apache.tephra.TransactionSystemClient;
import org.apache.tephra.distributed.PooledClientProvider;
import org.apache.tephra.distributed.TransactionService;
import org.apache.tephra.distributed.TransactionServiceClient;
import org.apache.tephra.inmemory.InMemoryTxSystemClient;
import org.apache.tephra.metrics.TxMetricsCollector;
import org.apache.tephra.persist.HDFSTransactionStateStorage;
import org.apache.tephra.snapshot.SnapshotCodecProvider;
import org.apache.tephra.zookeeper.TephraZKClientService;
import org.apache.twill.discovery.ZKDiscoveryService;
import org.apache.twill.zookeeper.RetryStrategies;
import org.apache.twill.zookeeper.ZKClientService;
import org.apache.twill.zookeeper.ZKClientServices;
import org.apache.twill.zookeeper.ZKClients;

public class TephraTransactionProvider
implements PhoenixTransactionProvider {
    private static final TephraTransactionProvider INSTANCE = new TephraTransactionProvider();

    public static final TephraTransactionProvider getInstance() {
        return INSTANCE;
    }

    private TephraTransactionProvider() {
    }

    public String toString() {
        return this.getProvider().toString();
    }

    @Override
    public PhoenixTransactionContext getTransactionContext(byte[] txnBytes) throws IOException {
        return new TephraTransactionContext(txnBytes);
    }

    @Override
    public PhoenixTransactionContext getTransactionContext(PhoenixConnection connection) throws SQLException {
        return new TephraTransactionContext(connection);
    }

    @Override
    public PhoenixTransactionClient getTransactionClient(Configuration config, PhoenixEmbeddedDriver.ConnectionInfo connectionInfo) {
        if (connectionInfo.isConnectionless()) {
            TransactionManager txnManager = new TransactionManager(config);
            InMemoryTxSystemClient txClient = new InMemoryTxSystemClient(txnManager);
            return new TephraTransactionClient(txClient);
        }
        String zkQuorumServersString = config.get("data.tx.zookeeper.quorum");
        if (zkQuorumServersString == null) {
            zkQuorumServersString = connectionInfo.getZookeeperConnectionString();
        }
        int timeOut = config.getInt("zookeeper.session.timeout", 180000);
        int retryTimeOut = config.getInt("data.tx.client.discovery.timeout", 10);
        ZKClientService zkClientService = ZKClientServices.delegate(ZKClients.reWatchOnExpire(ZKClients.retryOnFailure(new TephraZKClientService(zkQuorumServersString, timeOut, null, (Multimap<String, byte[]>)ArrayListMultimap.create()), RetryStrategies.exponentialDelay(500L, retryTimeOut, TimeUnit.MILLISECONDS))));
        ZKDiscoveryService zkDiscoveryService = new ZKDiscoveryService(zkClientService);
        PooledClientProvider pooledClientProvider = new PooledClientProvider(config, zkDiscoveryService);
        TransactionServiceClient txClient = new TransactionServiceClient(config, pooledClientProvider);
        TephraTransactionClient client = new TephraTransactionClient(zkClientService, txClient);
        client.start();
        return client;
    }

    @Override
    public PhoenixTransactionService getTransactionService(Configuration config, PhoenixEmbeddedDriver.ConnectionInfo connInfo, int port) {
        config.setInt("data.tx.bind.port", port);
        int retryTimeOut = config.getInt("data.tx.client.discovery.timeout", 10);
        ZKClientService zkClient = ZKClientServices.delegate(ZKClients.reWatchOnExpire(ZKClients.retryOnFailure(ZKClientService.Builder.of(connInfo.getZookeeperConnectionString()).setSessionTimeout(config.getInt("zookeeper.session.timeout", 180000)).build(), RetryStrategies.exponentialDelay(500L, retryTimeOut, TimeUnit.MILLISECONDS))));
        ZKDiscoveryService discovery = new ZKDiscoveryService(zkClient);
        TransactionManager txManager = new TransactionManager(config, new HDFSTransactionStateStorage(config, new SnapshotCodecProvider(config), new TxMetricsCollector()), new TxMetricsCollector());
        TransactionService txService = new TransactionService(config, zkClient, discovery, (Provider<TransactionManager>)Providers.of((Object)((Object)txManager)));
        TephraTransactionService service = new TephraTransactionService(zkClient, txService);
        service.start();
        return service;
    }

    @Override
    public Class<? extends RegionObserver> getCoprocessor() {
        return TephraTransactionalProcessor.class;
    }

    @Override
    public Class<? extends RegionObserver> getGCCoprocessor() {
        return null;
    }

    @Override
    public TransactionFactory.Provider getProvider() {
        return TransactionFactory.Provider.TEPHRA;
    }

    @Override
    public boolean isUnsupported(PhoenixTransactionProvider.Feature feature) {
        return false;
    }

    @Override
    public Put markPutAsCommitted(Put put, long timestamp, long commitTimestamp) {
        return put;
    }

    static class TephraTransactionClient
    implements PhoenixTransactionClient {
        private final ZKClientService zkClient;
        private final TransactionSystemClient txClient;

        public TephraTransactionClient(TransactionSystemClient txClient) {
            this(null, txClient);
        }

        public TephraTransactionClient(ZKClientService zkClient, TransactionSystemClient txClient) {
            this.zkClient = zkClient;
            this.txClient = txClient;
        }

        public void start() {
            this.zkClient.startAndWait();
        }

        public TransactionSystemClient getTransactionClient() {
            return this.txClient;
        }

        @Override
        public void close() throws IOException {
            this.zkClient.stopAndWait();
        }
    }

    static class TephraTransactionService
    implements PhoenixTransactionService {
        private final ZKClientService zkClient;
        private final TransactionService txService;

        public TephraTransactionService(ZKClientService zkClient, TransactionService txService) {
            this.zkClient = zkClient;
            this.txService = txService;
        }

        public void start() {
            this.zkClient.startAndWait();
            this.txService.startAndWait();
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.txService != null) {
                    this.txService.stopAndWait();
                }
            }
            finally {
                if (this.zkClient != null) {
                    this.zkClient.stopAndWait();
                }
            }
        }
    }
}

