/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.visitor.StatelessTraverseAllExpressionVisitor;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ServerUtil;

public class MultiEncodedCQKeyValueComparisonFilter
extends BooleanExpressionFilter {
    private int minQualifier;
    private int maxQualifier;
    private PTable.QualifierEncodingScheme encodingScheme;
    private int whereExpressionMinQualifier;
    private int whereExpressionMaxQualifier;
    private FilteredKeyValueHolder filteredKeyValues;
    private BitSet whereExpressionQualifiers;
    private TreeSet<byte[]> cfSet;
    private Boolean matchedColumn;
    private EncodedCQIncrementalResultTuple inputTuple = new EncodedCQIncrementalResultTuple();
    private int expectedCardinality;
    private byte[] essentialCF = ByteUtil.EMPTY_BYTE_ARRAY;
    private boolean allCFs;
    private static final byte[] UNITIALIZED_KEY_BUFFER = new byte[0];

    public MultiEncodedCQKeyValueComparisonFilter() {
    }

    public MultiEncodedCQKeyValueComparisonFilter(Expression expression, PTable.QualifierEncodingScheme scheme, boolean allCFs, byte[] essentialCF) {
        super(expression);
        Preconditions.checkArgument((scheme != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? 1 : 0) != 0, (Object)"Filter can only be used for encoded qualifiers");
        this.encodingScheme = scheme;
        this.allCFs = allCFs;
        this.essentialCF = essentialCF == null ? ByteUtil.EMPTY_BYTE_ARRAY : essentialCF;
        this.initFilter(expression);
    }

    private void initFilter(Expression expression) {
        this.cfSet = new TreeSet(Bytes.BYTES_COMPARATOR);
        final BitSet expressionQualifiers = new BitSet(20);
        final Pair range = new Pair();
        StatelessTraverseAllExpressionVisitor<Void> visitor = new StatelessTraverseAllExpressionVisitor<Void>(){

            @Override
            public Void visit(KeyValueColumnExpression expression) {
                int qualifier = MultiEncodedCQKeyValueComparisonFilter.this.encodingScheme.decode(expression.getColumnQualifier());
                if (range.getFirst() == null) {
                    range.setFirst((Object)qualifier);
                    range.setSecond((Object)qualifier);
                } else if (qualifier < (Integer)range.getFirst()) {
                    range.setFirst((Object)qualifier);
                } else if (qualifier > (Integer)range.getSecond()) {
                    range.setSecond((Object)qualifier);
                }
                MultiEncodedCQKeyValueComparisonFilter.this.cfSet.add(expression.getColumnFamily());
                expressionQualifiers.set(qualifier);
                return null;
            }
        };
        expression.accept(visitor);
        this.whereExpressionMinQualifier = (Integer)range.getFirst();
        this.whereExpressionMaxQualifier = (Integer)range.getSecond();
        int size = this.whereExpressionMaxQualifier - this.whereExpressionMinQualifier + 1;
        this.filteredKeyValues = new FilteredKeyValueHolder(size);
        this.whereExpressionQualifiers = new BitSet(size);
        for (int i = this.whereExpressionMinQualifier; i <= this.whereExpressionMaxQualifier; ++i) {
            if (!expressionQualifiers.get(i)) continue;
            this.whereExpressionQualifiers.set(i - this.whereExpressionMinQualifier);
        }
        this.expectedCardinality = this.whereExpressionQualifiers.cardinality();
    }

    private boolean isQualifierForColumnInWhereExpression(int qualifier) {
        return qualifier >= this.whereExpressionMinQualifier ? this.whereExpressionQualifiers.get(qualifier - this.whereExpressionMinQualifier) : false;
    }

    public Filter.ReturnCode filterKeyValue(Cell cell) {
        if (Boolean.TRUE.equals(this.matchedColumn)) {
            return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
        }
        if (Boolean.FALSE.equals(this.matchedColumn)) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        this.inputTuple.setKey(cell);
        int qualifier = this.encodingScheme.decode(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        if (this.isQualifierForColumnInWhereExpression(qualifier)) {
            this.filteredKeyValues.setCell(qualifier, cell);
            this.matchedColumn = this.evaluate(this.inputTuple);
            if (this.matchedColumn == null) {
                if (this.inputTuple.isImmutable()) {
                    this.matchedColumn = Boolean.FALSE;
                } else {
                    return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                }
            }
            return this.matchedColumn != false ? Filter.ReturnCode.INCLUDE_AND_NEXT_COL : Filter.ReturnCode.NEXT_ROW;
        }
        if (qualifier < this.minQualifier) {
            return Filter.ReturnCode.NEXT_COL;
        }
        return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
    }

    public boolean filterRow() {
        if (this.matchedColumn == null && !this.inputTuple.isImmutable() && this.expression.requiresFinalEvaluation()) {
            this.inputTuple.setImmutable();
            this.matchedColumn = this.evaluate(this.inputTuple);
        }
        return !Boolean.TRUE.equals(this.matchedColumn);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        try {
            this.minQualifier = WritableUtils.readVInt((DataInput)input);
            this.maxQualifier = WritableUtils.readVInt((DataInput)input);
            this.whereExpressionMinQualifier = WritableUtils.readVInt((DataInput)input);
            this.whereExpressionMaxQualifier = WritableUtils.readVInt((DataInput)input);
            this.encodingScheme = PTable.QualifierEncodingScheme.values()[WritableUtils.readVInt((DataInput)input)];
            super.readFields(input);
            try {
                this.allCFs = input.readBoolean();
                if (!this.allCFs) {
                    this.essentialCF = Bytes.readByteArray((DataInput)input);
                }
            }
            catch (EOFException eOFException) {}
        }
        catch (DoNotRetryIOException e) {
            throw e;
        }
        catch (Throwable t) {
            ServerUtil.throwIOException("MultiEncodedCQKeyValueComparisonFilter failed during writing", t);
        }
        this.initFilter(this.expression);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        try {
            WritableUtils.writeVInt((DataOutput)output, (int)this.minQualifier);
            WritableUtils.writeVInt((DataOutput)output, (int)this.maxQualifier);
            WritableUtils.writeVInt((DataOutput)output, (int)this.whereExpressionMinQualifier);
            WritableUtils.writeVInt((DataOutput)output, (int)this.whereExpressionMaxQualifier);
            WritableUtils.writeVInt((DataOutput)output, (int)this.encodingScheme.ordinal());
            super.write(output);
            output.writeBoolean(this.allCFs);
            if (!this.allCFs) {
                Bytes.writeByteArray((DataOutput)output, (byte[])this.essentialCF);
            }
        }
        catch (DoNotRetryIOException e) {
            throw e;
        }
        catch (Throwable t) {
            ServerUtil.throwIOException("MultiEncodedCQKeyValueComparisonFilter failed during writing", t);
        }
    }

    public void setMinMaxQualifierRange(Pair<Integer, Integer> minMaxQualifiers) {
        this.minQualifier = (Integer)minMaxQualifiers.getFirst();
        this.maxQualifier = (Integer)minMaxQualifiers.getSecond();
    }

    public void setMinQualifier(int minQualifier) {
        this.minQualifier = minQualifier;
    }

    public static MultiEncodedCQKeyValueComparisonFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        try {
            return (MultiEncodedCQKeyValueComparisonFilter)Writables.getWritable((byte[])pbBytes, (Writable)new MultiEncodedCQKeyValueComparisonFilter());
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
    }

    @Override
    public void reset() {
        this.filteredKeyValues.clear();
        this.matchedColumn = null;
        this.inputTuple.reset();
        super.reset();
    }

    public boolean isFamilyEssential(byte[] name) {
        return this.allCFs || Bytes.compareTo((byte[])name, (byte[])this.essentialCF) == 0 || this.cfSet.contains(name);
    }

    final class EncodedCQIncrementalResultTuple
    extends BaseTuple {
        private final ImmutableBytesWritable keyPtr = new ImmutableBytesWritable(MultiEncodedCQKeyValueComparisonFilter.access$700());
        private boolean isImmutable;

        EncodedCQIncrementalResultTuple() {
        }

        @Override
        public boolean isImmutable() {
            return this.isImmutable || MultiEncodedCQKeyValueComparisonFilter.this.filteredKeyValues.allColumnsFound();
        }

        public void setImmutable() {
            this.isImmutable = true;
        }

        private void setKey(Cell value) {
            this.keyPtr.set(value.getRowArray(), value.getRowOffset(), (int)value.getRowLength());
        }

        @Override
        public void getKey(ImmutableBytesWritable ptr) {
            ptr.set(this.keyPtr.get(), this.keyPtr.getOffset(), this.keyPtr.getLength());
        }

        @Override
        public Cell getValue(byte[] cf, byte[] cq) {
            int qualifier = MultiEncodedCQKeyValueComparisonFilter.this.encodingScheme.decode(cq);
            return MultiEncodedCQKeyValueComparisonFilter.this.filteredKeyValues.getCell(qualifier);
        }

        public String toString() {
            return MultiEncodedCQKeyValueComparisonFilter.this.filteredKeyValues.toString();
        }

        @Override
        public int size() {
            return MultiEncodedCQKeyValueComparisonFilter.this.filteredKeyValues.numKeyValues();
        }

        @Override
        public Cell getValue(int index) {
            return MultiEncodedCQKeyValueComparisonFilter.this.filteredKeyValues.getCellAtIndex(index);
        }

        @Override
        public boolean getValue(byte[] family, byte[] qualifier, ImmutableBytesWritable ptr) {
            Cell cell = this.getValue(family, qualifier);
            if (cell == null) {
                return false;
            }
            ptr.set(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            return true;
        }

        void reset() {
            this.isImmutable = false;
            this.keyPtr.set(UNITIALIZED_KEY_BUFFER);
        }
    }

    private final class FilteredKeyValueHolder {
        private Cell[] filteredCells;
        private BitSet filteredQualifiers;
        private int numKeyValues;

        private FilteredKeyValueHolder(int size) {
            this.filteredCells = new Cell[size];
            this.filteredQualifiers = new BitSet(size);
        }

        private void setCell(int qualifier, Cell c) {
            int index = qualifier - MultiEncodedCQKeyValueComparisonFilter.this.whereExpressionMinQualifier;
            this.filteredCells[index] = c;
            this.filteredQualifiers.set(index);
            ++this.numKeyValues;
        }

        private Cell getCell(int qualifier) {
            int index = qualifier - MultiEncodedCQKeyValueComparisonFilter.this.whereExpressionMinQualifier;
            return this.filteredQualifiers.get(index) ? this.filteredCells[index] : null;
        }

        private void clear() {
            this.filteredQualifiers.clear();
            this.numKeyValues = 0;
        }

        public Cell getCellAtIndex(int index) {
            int bitIndex = this.filteredQualifiers.nextSetBit(0);
            while (bitIndex >= 0 && index >= 0) {
                --index;
                bitIndex = this.filteredQualifiers.nextSetBit(bitIndex + 1);
            }
            if (bitIndex < 0) {
                throw new NoSuchElementException();
            }
            return this.filteredCells[bitIndex];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(100);
            int length = this.filteredQualifiers.length();
            for (int i = 0; i < length; ++i) {
                sb.append(this.filteredCells[i].toString());
            }
            return sb.toString();
        }

        private boolean allColumnsFound() {
            return this.numKeyValues == MultiEncodedCQKeyValueComparisonFilter.this.expectedCardinality;
        }

        private int numKeyValues() {
            return this.numKeyValues;
        }
    }
}

