/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import java.io.IOException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.aggregator.BaseAggregator;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.ByteUtil;

abstract class HyperLogLogServerAggregator
extends BaseAggregator {
    private HyperLogLogPlus hll = new HyperLogLogPlus(16, 25);
    protected final ImmutableBytesWritable valueByteArray = new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY);

    public HyperLogLogServerAggregator(SortOrder sortOrder) {
        super(sortOrder);
    }

    public HyperLogLogServerAggregator(SortOrder sortOrder, ImmutableBytesWritable ptr) {
        this(sortOrder);
        if (ptr != null) {
            this.hll.offer(ptr);
        }
    }

    @Override
    public void aggregate(Tuple tuple, ImmutableBytesWritable ptr) {
        this.hll.offer(ptr);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        try {
            this.valueByteArray.set(this.hll.getBytes(), 0, this.hll.getBytes().length);
            ptr.set(ByteUtil.copyKeyBytesIfNecessary(this.valueByteArray));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public final PDataType getDataType() {
        return PVarbinary.INSTANCE;
    }

    protected abstract PDataType getInputDataType();
}

