/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.distributed;

import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.distributed.RetryStrategy;
import org.apache.tephra.distributed.RetryStrategyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryWithBackoff
extends RetryStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RetryWithBackoff.class);
    private int backoffFactor;
    private int maxSleep;
    private int sleep;

    private RetryWithBackoff(int initialSleep, int backoff, int limit) {
        this.backoffFactor = backoff;
        this.maxSleep = limit;
        this.sleep = initialSleep;
    }

    @Override
    public boolean failOnce() {
        return this.sleep < this.maxSleep;
    }

    @Override
    public void beforeRetry() {
        LOG.debug("Sleeping " + this.sleep + " ms before retry.");
        long current = System.currentTimeMillis();
        long end = current + (long)this.sleep;
        while (current < end) {
            try {
                Thread.sleep(end - current);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            current = System.currentTimeMillis();
        }
        this.sleep *= this.backoffFactor;
    }

    public static class Provider
    implements RetryStrategyProvider {
        int initialSleep = 100;
        int backoffFactor = 4;
        int maxSleep = 30000;

        @Override
        public void configure(Configuration config) {
            this.initialSleep = config.getInt("data.tx.client.retry.backoff.initial", this.initialSleep);
            this.backoffFactor = config.getInt("data.tx.client.retry.backoff.factor", this.backoffFactor);
            this.maxSleep = config.getInt("data.tx.client.retry.backoff.limit", this.maxSleep);
        }

        @Override
        public RetryStrategy newRetryStrategy() {
            return new RetryWithBackoff(this.initialSleep, this.backoffFactor, this.maxSleep);
        }

        public String toString() {
            return "sleep " + this.initialSleep + " ms with back off factor " + this.backoffFactor + " and limit " + this.maxSleep + " ms";
        }
    }
}

