/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.util;

import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;

public class GenericKeyValueBuilder
extends KeyValueBuilder {
    public static final KeyValueBuilder INSTANCE = new GenericKeyValueBuilder();

    private GenericKeyValueBuilder() {
    }

    @Override
    public KeyValue buildPut(ImmutableBytesWritable row, ImmutableBytesWritable family, ImmutableBytesWritable qualifier, long ts, ImmutableBytesWritable value) {
        return this.build(row, family, qualifier, ts, KeyValue.Type.Put, value);
    }

    @Override
    public KeyValue buildDeleteFamily(ImmutableBytesWritable row, ImmutableBytesWritable family, ImmutableBytesWritable qualifier, long ts) {
        return this.build(row, family, qualifier, ts, KeyValue.Type.DeleteFamily, null);
    }

    @Override
    public KeyValue buildDeleteColumns(ImmutableBytesWritable row, ImmutableBytesWritable family, ImmutableBytesWritable qualifier, long ts) {
        return this.build(row, family, qualifier, ts, KeyValue.Type.DeleteColumn, null);
    }

    @Override
    public KeyValue buildDeleteColumn(ImmutableBytesWritable row, ImmutableBytesWritable family, ImmutableBytesWritable qualifier, long ts) {
        return this.build(row, family, qualifier, ts, KeyValue.Type.Delete, null);
    }

    private KeyValue build(ImmutableBytesWritable row, ImmutableBytesWritable family, ImmutableBytesWritable qualifier, long ts, KeyValue.Type type, ImmutableBytesWritable value) {
        return new KeyValue(ImmutableBytesPtr.copyBytesIfNecessary(row), ImmutableBytesPtr.copyBytesIfNecessary(family), ImmutableBytesPtr.copyBytesIfNecessary(qualifier), ts, type, value == null ? null : ImmutableBytesPtr.copyBytesIfNecessary(value));
    }

    @Override
    public int compareQualifier(Cell kv, byte[] key, int offset, int length) {
        return Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])key, (int)offset, (int)length);
    }

    @Override
    public int compareFamily(Cell kv, byte[] key, int offset, int length) {
        return Bytes.compareTo((byte[])kv.getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength(), (byte[])key, (int)offset, (int)length);
    }

    @Override
    public void getValueAsPtr(Cell kv, ImmutableBytesWritable writable) {
        writable.set(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
    }

    @Override
    public KeyValue.KVComparator getKeyValueComparator() {
        return KeyValue.COMPARATOR;
    }

    @Override
    public int compareRow(Cell kv, byte[] rrow, int roffset, int rlength) {
        return Bytes.compareTo((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])rrow, (int)roffset, (int)rlength);
    }

    @Override
    public List<Mutation> cloneIfNecessary(List<Mutation> mutations) {
        return mutations;
    }
}

