/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import java.io.Closeable;
import java.io.IOException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.test.TestingServer;
import org.apache.curator.utils.CloseableUtils;
import org.apache.omid.TestUtils;
import org.apache.omid.tso.LeaseManagement;
import org.apache.omid.tso.MockPanicker;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.PausableLeaseManager;
import org.apache.omid.tso.TSOChannelHandler;
import org.apache.omid.tso.TSOStateManager;
import org.apache.omid.tso.VoidLeaseManager;
import org.apache.phoenix.thirdparty.com.google.common.base.Charsets;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestLeaseManager {
    private static final long DUMMY_EPOCH_1 = 1L;
    private static final long DUMMY_EPOCH_2 = 2L;
    private static final long DUMMY_EPOCH_3 = 3L;
    private static final long DUMMY_LOW_WATERMARK_1 = 1L;
    private static final long DUMMY_LOW_WATERMARK_2 = 2L;
    private static final long DUMMY_LOW_WATERMARK_3 = 3L;
    private static final String LEASE_MGR_ID_1 = "LM1";
    private static final String LEASE_MGR_ID_2 = "LM2";
    private static final String INSTANCE_ID_1 = "LM1#";
    private static final String INSTANCE_ID_2 = "LM2#";
    private static final Logger LOG = LoggerFactory.getLogger(TestLeaseManager.class);
    private static final long TEST_LEASE_PERIOD_IN_MS = 5000L;
    private CuratorFramework zkClient;
    private TestingServer zkServer;
    @Mock
    private Panicker panicker;
    private PausableLeaseManager leaseManager1;
    private PausableLeaseManager leaseManager2;

    @BeforeClass
    public void beforeClass() throws Exception {
        LOG.info("Starting ZK Server");
        this.zkServer = TestUtils.provideTestingZKServer();
        LOG.info("ZK Server Started @ {}", (Object)this.zkServer.getConnectString());
        this.zkClient = TestUtils.provideConnectedZKClient("localhost:2181");
    }

    @AfterClass
    public void afterClass() throws Exception {
        this.zkClient.close();
        CloseableUtils.closeQuietly((Closeable)this.zkServer);
        this.zkServer = null;
        LOG.info("ZK Server Stopped");
    }

    @Test(timeOut=80000L)
    public void testErrorInitializingTSOStateExitsTheTSO() throws Exception {
        String TEST_TSO_LEASE_PATH = "/test0_tsolease";
        String TEST_CURRENT_TSO_PATH = "/test0_currenttso";
        Panicker panicker = (Panicker)Mockito.spy((Object)new MockPanicker());
        TSOChannelHandler tsoChannelHandler = (TSOChannelHandler)Mockito.mock(TSOChannelHandler.class);
        TSOStateManager stateManager = (TSOStateManager)Mockito.mock(TSOStateManager.class);
        Mockito.when((Object)stateManager.initialize()).thenThrow(new Throwable[]{new IOException()});
        this.leaseManager1 = new PausableLeaseManager(LEASE_MGR_ID_1, tsoChannelHandler, stateManager, 5000L, "/test0_tsolease", "/test0_currenttso", this.zkClient, panicker);
        this.leaseManager1.startService();
        Thread.sleep(10000L);
        ((Panicker)Mockito.verify((Object)panicker, (VerificationMode)Mockito.timeout((int)2000).atLeastOnce())).panic(Matchers.anyString(), (Throwable)Matchers.any(IOException.class));
        this.leaseManager1.stopService();
    }

    @Test(timeOut=80000L)
    public void testLeaseHolderDoesNotChangeWhenPausedForALongTimeAndTheresNoOtherInstance() throws Exception {
        String TEST_TSO_LEASE_PATH = "/test1_tsolease";
        String TEST_CURRENT_TSO_PATH = "/test1_currenttso";
        TSOChannelHandler tsoChannelHandler1 = (TSOChannelHandler)Mockito.mock(TSOChannelHandler.class);
        TSOStateManager stateManager1 = (TSOStateManager)Mockito.mock(TSOStateManager.class);
        Mockito.when((Object)stateManager1.initialize()).thenReturn((Object)new TSOStateManager.TSOState(1L, 1L));
        this.leaseManager1 = new PausableLeaseManager(LEASE_MGR_ID_1, tsoChannelHandler1, stateManager1, 5000L, "/test1_tsolease", "/test1_currenttso", this.zkClient, this.panicker);
        this.leaseManager1.startService();
        Thread.sleep(10000L);
        this.checkLeaseHolder("/test1_tsolease", LEASE_MGR_ID_1);
        this.checkInstanceId("/test1_currenttso", "LM1#1");
        Assert.assertTrue((boolean)this.leaseManager1.stillInLeasePeriod());
        this.leaseManager1.pausedInTryToRenewLeasePeriod();
        Thread.sleep(10000L);
        this.checkLeaseHolder("/test1_tsolease", LEASE_MGR_ID_1);
        this.checkInstanceId("/test1_currenttso", "LM1#1");
        this.leaseManager1.resume();
        Thread.sleep(10000L);
        this.checkLeaseHolder("/test1_tsolease", LEASE_MGR_ID_1);
        this.checkInstanceId("/test1_currenttso", "LM1#1");
        Assert.assertFalse((boolean)this.leaseManager1.stillInLeasePeriod());
    }

    @Test(timeOut=80000L)
    public void testLeaseHolderDoesNotChangeWhenANewLeaseManagerIsUp() throws Exception {
        String TEST_TSO_LEASE_PATH = "/test2_tsolease";
        String TEST_CURRENT_TSO_PATH = "/test2_currenttso";
        TSOChannelHandler tsoChannelHandler1 = (TSOChannelHandler)Mockito.mock(TSOChannelHandler.class);
        TSOStateManager stateManager1 = (TSOStateManager)Mockito.mock(TSOStateManager.class);
        Mockito.when((Object)stateManager1.initialize()).thenReturn((Object)new TSOStateManager.TSOState(1L, 1L));
        this.leaseManager1 = new PausableLeaseManager(LEASE_MGR_ID_1, tsoChannelHandler1, stateManager1, 5000L, "/test2_tsolease", "/test2_currenttso", this.zkClient, this.panicker);
        this.leaseManager1.startService();
        Thread.sleep(10000L);
        this.checkLeaseHolder("/test2_tsolease", LEASE_MGR_ID_1);
        this.checkInstanceId("/test2_currenttso", "LM1#1");
        Assert.assertTrue((boolean)this.leaseManager1.stillInLeasePeriod());
        TSOChannelHandler tsoChannelHandler2 = (TSOChannelHandler)Mockito.mock(TSOChannelHandler.class);
        TSOStateManager stateManager2 = (TSOStateManager)Mockito.mock(TSOStateManager.class);
        Mockito.when((Object)stateManager2.initialize()).thenReturn((Object)new TSOStateManager.TSOState(2L, 2L));
        this.leaseManager2 = new PausableLeaseManager(LEASE_MGR_ID_2, tsoChannelHandler2, stateManager2, 5000L, "/test2_tsolease", "/test2_currenttso", this.zkClient, this.panicker);
        this.leaseManager2.startService();
        Thread.sleep(10000L);
        this.checkLeaseHolder("/test2_tsolease", LEASE_MGR_ID_1);
        this.checkInstanceId("/test2_currenttso", "LM1#1");
        Assert.assertTrue((boolean)this.leaseManager1.stillInLeasePeriod());
        Assert.assertFalse((boolean)this.leaseManager2.stillInLeasePeriod());
    }

    @Test(timeOut=80000L)
    public void testLeaseHolderChangesWhenActiveLeaseManagerIsPaused() throws Exception {
        String TEST_TSO_LEASE_PATH = "/test3_tsolease";
        String TEST_CURRENT_TSO_PATH = "/test3_currenttso";
        TSOChannelHandler tsoChannelHandler1 = (TSOChannelHandler)Mockito.mock(TSOChannelHandler.class);
        TSOStateManager stateManager1 = (TSOStateManager)Mockito.mock(TSOStateManager.class);
        Mockito.when((Object)stateManager1.initialize()).thenReturn((Object)new TSOStateManager.TSOState(1L, 1L));
        this.leaseManager1 = new PausableLeaseManager(LEASE_MGR_ID_1, tsoChannelHandler1, stateManager1, 5000L, "/test3_tsolease", "/test3_currenttso", this.zkClient, this.panicker);
        this.leaseManager1.startService();
        Thread.sleep(10000L);
        this.checkLeaseHolder("/test3_tsolease", LEASE_MGR_ID_1);
        this.checkInstanceId("/test3_currenttso", "LM1#1");
        Assert.assertTrue((boolean)this.leaseManager1.stillInLeasePeriod());
        TSOChannelHandler tsoChannelHandler2 = (TSOChannelHandler)Mockito.mock(TSOChannelHandler.class);
        TSOStateManager stateManager2 = (TSOStateManager)Mockito.mock(TSOStateManager.class);
        Mockito.when((Object)stateManager2.initialize()).thenReturn((Object)new TSOStateManager.TSOState(2L, 2L));
        this.leaseManager2 = new PausableLeaseManager(LEASE_MGR_ID_2, tsoChannelHandler2, stateManager2, 5000L, "/test3_tsolease", "/test3_currenttso", this.zkClient, this.panicker);
        this.leaseManager2.startService();
        this.leaseManager1.pausedInStillInLeasePeriod();
        Thread.sleep(10000L);
        this.checkLeaseHolder("/test3_tsolease", LEASE_MGR_ID_2);
        this.checkInstanceId("/test3_currenttso", "LM2#2");
        Assert.assertTrue((boolean)this.leaseManager2.stillInLeasePeriod());
        Mockito.when((Object)stateManager1.initialize()).thenReturn((Object)new TSOStateManager.TSOState(3L, 3L));
        this.leaseManager1.resume();
        Thread.sleep(10000L);
        this.checkLeaseHolder("/test3_tsolease", LEASE_MGR_ID_2);
        this.checkInstanceId("/test3_currenttso", "LM2#2");
        Assert.assertFalse((boolean)this.leaseManager1.stillInLeasePeriod());
        Assert.assertTrue((boolean)this.leaseManager2.stillInLeasePeriod());
        this.leaseManager2.pausedInTryToRenewLeasePeriod();
        Thread.sleep(10000L);
        this.checkLeaseHolder("/test3_tsolease", LEASE_MGR_ID_1);
        this.checkInstanceId("/test3_currenttso", "LM1#3");
        Assert.assertFalse((boolean)this.leaseManager2.stillInLeasePeriod());
        Assert.assertTrue((boolean)this.leaseManager1.stillInLeasePeriod());
        this.leaseManager2.resume();
        Thread.sleep(10000L);
        this.checkLeaseHolder("/test3_tsolease", LEASE_MGR_ID_1);
        this.checkInstanceId("/test3_currenttso", "LM1#3");
        Assert.assertFalse((boolean)this.leaseManager2.stillInLeasePeriod());
        Assert.assertTrue((boolean)this.leaseManager1.stillInLeasePeriod());
    }

    @Test(timeOut=80000L)
    public void testLeaseManagerPanicsWhenUnexpectedInfoIsFoundInCurrentTSOZnode() throws Exception {
        String TEST_TSO_LEASE_PATH = "/test_wronginfo_tsolease";
        String TEST_CURRENT_TSO_PATH = "/test_wronginfo_currenttso";
        Panicker panicker = (Panicker)Mockito.spy((Object)new MockPanicker());
        TSOStateManager stateManager1 = (TSOStateManager)Mockito.mock(TSOStateManager.class);
        Mockito.when((Object)stateManager1.initialize()).thenReturn((Object)new TSOStateManager.TSOState(1L, 1L));
        PausableLeaseManager leaseManager = new PausableLeaseManager(LEASE_MGR_ID_1, (TSOChannelHandler)Mockito.mock(TSOChannelHandler.class), stateManager1, 5000L, "/test_wronginfo_tsolease", "/test_wronginfo_currenttso", this.zkClient, panicker);
        leaseManager.startService();
        Thread.sleep(10000L);
        leaseManager.pausedInTryToRenewLeasePeriod();
        this.zkClient.setData().forPath("/test_wronginfo_currenttso", "CorruptedData!!!".getBytes());
        Thread.sleep(10000L);
        leaseManager.resume();
        Thread.sleep(10000L);
        ArgumentCaptor trowableIAE = ArgumentCaptor.forClass(IllegalArgumentException.class);
        ((Panicker)Mockito.verify((Object)panicker, (VerificationMode)Mockito.times((int)2))).panic(Matchers.anyString(), (Throwable)trowableIAE.capture());
        Assert.assertTrue((trowableIAE.getValue() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((IllegalArgumentException)trowableIAE.getValue()).getMessage().contains("Incorrect TSO Info found"));
        Mockito.reset((Object[])new Panicker[]{panicker});
        this.zkClient.setData().forPath("/test_wronginfo_currenttso", "newTSO:12345#10000".getBytes());
        leaseManager.pausedInTryToRenewLeasePeriod();
        Thread.sleep(10000L);
        leaseManager.resume();
        Thread.sleep(10000L);
        ArgumentCaptor trowableLME = ArgumentCaptor.forClass(LeaseManagement.LeaseManagementException.class);
        ((Panicker)Mockito.verify((Object)panicker, (VerificationMode)Mockito.times((int)2))).panic(Matchers.anyString(), (Throwable)trowableLME.capture());
        Assert.assertTrue((trowableLME.getValue() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((LeaseManagement.LeaseManagementException)trowableLME.getValue()).getMessage().contains("Another TSO replica was found"));
    }

    @Test(timeOut=1000L)
    public void testNonHALeaseManager() throws Exception {
        VoidLeaseManager leaseManager = new VoidLeaseManager((TSOChannelHandler)Mockito.mock(TSOChannelHandler.class), (TSOStateManager)Mockito.mock(TSOStateManager.class));
        leaseManager.startService();
        Assert.assertTrue((boolean)leaseManager.stillInLeasePeriod());
        leaseManager.stopService();
    }

    private void checkLeaseHolder(String tsoLeasePath, String expectedLeaseHolder) throws Exception {
        byte[] leaseHolderInBytes = (byte[])this.zkClient.getData().forPath(tsoLeasePath);
        String leaseHolder = new String(leaseHolderInBytes, Charsets.UTF_8);
        Assert.assertEquals((String)leaseHolder, (String)expectedLeaseHolder);
    }

    private void checkInstanceId(String currentTSOPath, String expectedInstanceId) throws Exception {
        byte[] expectedInstanceIdInBytes = (byte[])this.zkClient.getData().forPath(currentTSOPath);
        String instanceId = new String(expectedInstanceIdInBytes, Charsets.UTF_8);
        Assert.assertEquals((String)instanceId, (String)expectedInstanceId);
    }
}

