/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.MutableStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.schema.PTableType;

public class CreateTableStatement
extends MutableStatement {
    private final TableName tableName;
    private final PTableType tableType;
    private final List<ColumnDef> columns;
    private final PrimaryKeyConstraint pkConstraint;
    private final List<ParseNode> splitNodes;
    private final int bindCount;
    private final ListMultimap<String, Pair<String, Object>> props;
    private final boolean ifNotExists;
    private final TableName baseTableName;
    private final ParseNode whereClause;
    private final Boolean immutableRows;

    public CreateTableStatement(CreateTableStatement createTable, List<ColumnDef> columns) {
        this.tableName = createTable.tableName;
        this.tableType = createTable.tableType;
        this.columns = ImmutableList.copyOf(columns);
        this.pkConstraint = createTable.pkConstraint;
        this.splitNodes = createTable.splitNodes;
        this.bindCount = createTable.bindCount;
        this.props = createTable.props;
        this.ifNotExists = createTable.ifNotExists;
        this.baseTableName = createTable.baseTableName;
        this.whereClause = createTable.whereClause;
        this.immutableRows = createTable.immutableRows;
    }

    protected CreateTableStatement(TableName tableName, ListMultimap<String, Pair<String, Object>> props, List<ColumnDef> columns, PrimaryKeyConstraint pkConstraint, List<ParseNode> splitNodes, PTableType tableType, boolean ifNotExists, TableName baseTableName, ParseNode whereClause, int bindCount, Boolean immutableRows) {
        this.tableName = tableName;
        this.props = props == null ? ImmutableListMultimap.of() : props;
        this.tableType = "SYSTEM".equals(tableName.getSchemaName()) ? PTableType.SYSTEM : tableType;
        this.columns = columns == null ? ImmutableList.of() : ImmutableList.copyOf(columns);
        this.pkConstraint = pkConstraint == null ? PrimaryKeyConstraint.EMPTY : pkConstraint;
        this.splitNodes = splitNodes == null ? Collections.emptyList() : ImmutableList.copyOf(splitNodes);
        this.bindCount = bindCount;
        this.ifNotExists = ifNotExists;
        this.baseTableName = baseTableName;
        this.whereClause = whereClause;
        this.immutableRows = immutableRows;
    }

    public ParseNode getWhereClause() {
        return this.whereClause;
    }

    @Override
    public int getBindCount() {
        return this.bindCount;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public TableName getBaseTableName() {
        return this.baseTableName;
    }

    public List<ColumnDef> getColumnDefs() {
        return this.columns;
    }

    public List<ParseNode> getSplitNodes() {
        return this.splitNodes;
    }

    public PTableType getTableType() {
        return this.tableType;
    }

    public ListMultimap<String, Pair<String, Object>> getProps() {
        return this.props;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    public PrimaryKeyConstraint getPrimaryKeyConstraint() {
        return this.pkConstraint;
    }

    public Boolean immutableRows() {
        return this.immutableRows;
    }
}

