/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.phoenix.jdbc.DelegateConnection;
import org.apache.phoenix.jdbc.LoggingPhoenixPreparedStatement;
import org.apache.phoenix.jdbc.LoggingPhoenixStatement;
import org.apache.phoenix.jdbc.PhoenixMetricsLog;
import org.apache.phoenix.util.PhoenixRuntime;

public class LoggingPhoenixConnection
extends DelegateConnection {
    private PhoenixMetricsLog phoenixMetricsLog;

    public LoggingPhoenixConnection(Connection conn, PhoenixMetricsLog phoenixMetricsLog) {
        super(conn);
        this.phoenixMetricsLog = phoenixMetricsLog;
    }

    public PhoenixMetricsLog getPhoenixMetricsLog() {
        return this.phoenixMetricsLog;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new LoggingPhoenixStatement(super.createStatement(), this.phoenixMetricsLog, this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new LoggingPhoenixStatement(super.createStatement(resultSetType, resultSetConcurrency), this.phoenixMetricsLog, this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new LoggingPhoenixStatement(super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this.phoenixMetricsLog, this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new LoggingPhoenixPreparedStatement(super.prepareStatement(sql), this.phoenixMetricsLog, sql, this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new LoggingPhoenixPreparedStatement(super.prepareStatement(sql, resultSetType, resultSetConcurrency), this.phoenixMetricsLog, sql, this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new LoggingPhoenixPreparedStatement(super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this.phoenixMetricsLog, sql, this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new LoggingPhoenixPreparedStatement(super.prepareStatement(sql, autoGeneratedKeys), this.phoenixMetricsLog, sql, this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new LoggingPhoenixPreparedStatement(super.prepareStatement(sql, columnIndexes), this.phoenixMetricsLog, sql, this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new LoggingPhoenixPreparedStatement(super.prepareStatement(sql, columnNames), this.phoenixMetricsLog, sql, this);
    }

    @Override
    public void commit() throws SQLException {
        super.commit();
        this.loggingMetricsHelper();
    }

    @Override
    public void close() throws SQLException {
        try {
            this.loggingMetricsHelper();
        }
        finally {
            super.close();
        }
    }

    public void loggingMetricsHelper() throws SQLException {
        this.phoenixMetricsLog.logWriteMetricsfoForMutationsSinceLastReset(PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset(this.conn));
        this.phoenixMetricsLog.logReadMetricInfoForMutationsSinceLastReset(PhoenixRuntime.getReadMetricInfoForMutationsSinceLastReset(this.conn));
        PhoenixRuntime.resetMetrics(this.conn);
    }
}

