/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso.client;

import java.util.concurrent.ExecutionException;
import org.apache.omid.proto.TSOProto;
import org.apache.omid.tso.client.TSOClientRaw;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSOClientOneShot {
    private static final Logger LOG = LoggerFactory.getLogger(TSOClientOneShot.class);
    private final String host;
    private final int port;

    public TSOClientOneShot(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public TSOProto.Response makeRequest(TSOProto.Request request) throws InterruptedException, ExecutionException {
        TSOClientRaw raw = new TSOClientRaw(this.host, this.port);
        TSOProto.HandshakeRequest.Builder handshake = TSOProto.HandshakeRequest.newBuilder();
        handshake.setClientCapabilities(TSOProto.Capabilities.newBuilder().build());
        raw.write(TSOProto.Request.newBuilder().setHandshakeRequest(handshake.build()).build());
        TSOProto.Response response = raw.getResponse().get();
        assert (response.getHandshakeResponse().getClientCompatible());
        raw.write(request);
        response = raw.getResponse().get();
        raw.close();
        return response;
    }
}

