/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tools.hbase;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.omid.tools.hbase.SecureHBaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBaseLogin {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseLogin.class);
    private static volatile UserGroupInformation ugi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static UserGroupInformation loginIfNeeded(SecureHBaseConfig config) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            LOG.info("Security enabled when connecting to HBase");
            if (ugi == null) {
                Class<HBaseLogin> clazz = HBaseLogin.class;
                synchronized (HBaseLogin.class) {
                    if (ugi == null) {
                        LOG.info("Login with Kerberos. User={}, keytab={}", (Object)config.getPrincipal(), (Object)config.getKeytab());
                        UserGroupInformation.loginUserFromKeytab((String)config.getPrincipal(), (String)config.getKeytab());
                        ugi = UserGroupInformation.getCurrentUser();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            } else {
                LOG.info("User {}, already trusted (Kerberos). Avoiding 2nd login as it causes problems", (Object)ugi.toString());
            }
        } else {
            LOG.warn("Security NOT enabled when connecting to HBase. Act at your own risk. NULL UGI returned");
        }
        return ugi;
    }
}

