/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.jdkadapter;

import com.ibm.icu.impl.icuadapter.NumberFormatJDK;
import com.ibm.icu.impl.icuadapter.TimeZoneJDK;
import com.ibm.icu.impl.jdkadapter.CalendarICU;
import com.ibm.icu.impl.jdkadapter.DateFormatSymbolsICU;
import com.ibm.icu.impl.jdkadapter.DecimalFormatICU;
import com.ibm.icu.impl.jdkadapter.NumberFormatICU;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.BuddhistCalendar;
import com.ibm.icu.util.JapaneseCalendar;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class SimpleDateFormatICU
extends java.text.SimpleDateFormat {
    private static final long serialVersionUID = -2060890659010258983L;
    private SimpleDateFormat fIcuSdf;
    private static final long SAMPLE_TIME = 962409600000L;
    private static final int JAPANESE_YEAR = 12;
    private static final int THAI_YEAR = 2543;

    private SimpleDateFormatICU(SimpleDateFormat icuSdf) {
        this.fIcuSdf = icuSdf;
    }

    public static java.text.SimpleDateFormat wrap(SimpleDateFormat icuSdf) {
        return new SimpleDateFormatICU(icuSdf);
    }

    @Override
    public void applyLocalizedPattern(String pattern) {
        this.fIcuSdf.applyLocalizedPattern(pattern);
    }

    @Override
    public void applyPattern(String pattern) {
        this.fIcuSdf.applyPattern(pattern);
    }

    @Override
    public Object clone() {
        SimpleDateFormatICU other = (SimpleDateFormatICU)super.clone();
        other.fIcuSdf = (SimpleDateFormat)this.fIcuSdf.clone();
        return other;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SimpleDateFormatICU) {
            return ((SimpleDateFormatICU)obj).fIcuSdf.equals(this.fIcuSdf);
        }
        return false;
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        return this.fIcuSdf.format(date, toAppendTo, pos);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        AttributedCharacterIterator aci = this.fIcuSdf.formatToCharacterIterator(obj);
        StringBuilder sb = new StringBuilder(aci.getEndIndex() - aci.getBeginIndex());
        char c = aci.first();
        do {
            sb.append(c);
        } while ((c = aci.next()) != '\uffff');
        AttributedString resstr = new AttributedString(sb.toString());
        Map<AttributedCharacterIterator.Attribute, Object> attributes = null;
        int index = aci.getBeginIndex();
        int residx = 0;
        while (aci.setIndex(index) != '\uffff') {
            attributes = aci.getAttributes();
            if (attributes == null) continue;
            int end = aci.getRunLimit();
            HashMap<AttributedCharacterIterator.Attribute, Object> jdkAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
            for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : attributes.entrySet()) {
                AttributedCharacterIterator.Attribute key = entry.getKey();
                AttributedCharacterIterator.Attribute jdkKey = SimpleDateFormatICU.mapAttribute(key);
                Object jdkVal = entry.getValue();
                if (jdkVal instanceof AttributedCharacterIterator.Attribute) {
                    jdkVal = SimpleDateFormatICU.mapAttribute((AttributedCharacterIterator.Attribute)jdkVal);
                }
                jdkAttributes.put(jdkKey, jdkVal);
            }
            int resend = residx + (end - index);
            resstr.addAttributes(jdkAttributes, residx, resend);
            index = end;
            residx = resend;
        }
        return resstr.getIterator();
    }

    @Override
    public Date get2DigitYearStart() {
        return this.fIcuSdf.get2DigitYearStart();
    }

    @Override
    public DateFormatSymbols getDateFormatSymbols() {
        return DateFormatSymbolsICU.wrap(this.fIcuSdf.getDateFormatSymbols());
    }

    @Override
    public int hashCode() {
        return this.fIcuSdf.hashCode();
    }

    @Override
    public Date parse(String text, ParsePosition pos) {
        return this.fIcuSdf.parse(text, pos);
    }

    @Override
    public void set2DigitYearStart(Date startDate) {
        this.fIcuSdf.set2DigitYearStart(startDate);
    }

    @Override
    public void setDateFormatSymbols(DateFormatSymbols newFormatSymbols) {
        com.ibm.icu.text.DateFormatSymbols icuDfs = null;
        if (newFormatSymbols instanceof DateFormatSymbolsICU) {
            icuDfs = ((DateFormatSymbolsICU)newFormatSymbols).unwrap();
        } else if (this.fIcuSdf.getCalendar() instanceof com.ibm.icu.util.GregorianCalendar) {
            icuDfs = this.fIcuSdf.getDateFormatSymbols();
            String[] newJDK = newFormatSymbols.getEras();
            String[] curICU = icuDfs.getEras();
            String[] newICU = this.copySymbols(newJDK, curICU, true);
            newJDK = newFormatSymbols.getMonths();
            curICU = icuDfs.getMonths();
            newICU = this.copySymbols(newJDK, curICU, false);
            icuDfs.setMonths(newICU);
            newJDK = newFormatSymbols.getShortMonths();
            curICU = icuDfs.getShortMonths();
            newICU = this.copySymbols(newJDK, curICU, false);
            icuDfs.setShortMonths(newICU);
            newJDK = newFormatSymbols.getWeekdays();
            curICU = icuDfs.getWeekdays();
            newICU = this.copySymbols(newJDK, curICU, false);
            icuDfs.setWeekdays(newICU);
            newJDK = newFormatSymbols.getShortWeekdays();
            curICU = icuDfs.getShortWeekdays();
            newICU = this.copySymbols(newJDK, curICU, false);
            icuDfs.setShortWeekdays(newICU);
            newJDK = newFormatSymbols.getAmPmStrings();
            curICU = icuDfs.getAmPmStrings();
            newICU = this.copySymbols(newJDK, curICU, false);
            icuDfs.setAmPmStrings(newICU);
        } else {
            throw new UnsupportedOperationException("JDK DateFormatSymbols cannot be used for the calendar type.");
        }
        this.fIcuSdf.setDateFormatSymbols(icuDfs);
    }

    @Override
    public String toLocalizedPattern() {
        return this.fIcuSdf.toLocalizedPattern();
    }

    @Override
    public String toPattern() {
        return this.fIcuSdf.toLocalizedPattern();
    }

    @Override
    public Calendar getCalendar() {
        return CalendarICU.wrap(this.fIcuSdf.getCalendar());
    }

    @Override
    public NumberFormat getNumberFormat() {
        com.ibm.icu.text.NumberFormat nfmt = this.fIcuSdf.getNumberFormat();
        if (nfmt instanceof NumberFormatJDK) {
            return ((NumberFormatJDK)nfmt).unwrap();
        }
        if (nfmt instanceof DecimalFormat) {
            return DecimalFormatICU.wrap((DecimalFormat)nfmt);
        }
        return NumberFormatICU.wrap(nfmt);
    }

    @Override
    public TimeZone getTimeZone() {
        return this.getCalendar().getTimeZone();
    }

    @Override
    public boolean isLenient() {
        return this.fIcuSdf.isLenient();
    }

    @Override
    public void setCalendar(Calendar newCalendar) {
        com.ibm.icu.util.Calendar icuCal = null;
        if (newCalendar instanceof CalendarICU) {
            icuCal = ((CalendarICU)newCalendar).unwrap();
        } else {
            com.ibm.icu.util.TimeZone icuTz = TimeZoneJDK.wrap(newCalendar.getTimeZone());
            if (newCalendar instanceof GregorianCalendar) {
                icuCal = new com.ibm.icu.util.GregorianCalendar(icuTz);
            } else {
                newCalendar.setTimeInMillis(962409600000L);
                int year = newCalendar.get(1);
                if (year == 12) {
                    icuCal = new JapaneseCalendar(icuTz);
                } else if (year == 2543) {
                    icuCal = new BuddhistCalendar(icuTz);
                } else {
                    throw new UnsupportedOperationException("Unsupported calendar type by ICU Calendar adapter.");
                }
            }
            icuCal.setFirstDayOfWeek(newCalendar.getFirstDayOfWeek());
            icuCal.setLenient(newCalendar.isLenient());
            icuCal.setMinimalDaysInFirstWeek(newCalendar.getMinimalDaysInFirstWeek());
        }
        this.fIcuSdf.setCalendar(icuCal);
    }

    @Override
    public void setLenient(boolean lenient) {
        this.fIcuSdf.setLenient(lenient);
    }

    @Override
    public void setNumberFormat(NumberFormat newNumberFormat) {
        if (newNumberFormat instanceof DecimalFormatICU) {
            this.fIcuSdf.setNumberFormat(((DecimalFormatICU)newNumberFormat).unwrap());
        } else if (newNumberFormat instanceof NumberFormatICU) {
            this.fIcuSdf.setNumberFormat(((NumberFormatICU)newNumberFormat).unwrap());
        } else {
            this.fIcuSdf.setNumberFormat(NumberFormatJDK.wrap(newNumberFormat));
        }
    }

    @Override
    public void setTimeZone(TimeZone zone) {
        this.fIcuSdf.setTimeZone(TimeZoneJDK.wrap(zone));
    }

    private String[] copySymbols(String[] newData, String[] curData, boolean alignEnd) {
        if (newData.length >= curData.length) {
            return newData;
        }
        int startOffset = alignEnd ? curData.length - newData.length : 0;
        System.arraycopy(newData, 0, curData, startOffset, newData.length);
        return curData;
    }

    private static AttributedCharacterIterator.Attribute mapAttribute(AttributedCharacterIterator.Attribute icuAttribute) {
        AttributedCharacterIterator.Attribute jdkAttribute = icuAttribute;
        if (icuAttribute == DateFormat.Field.AM_PM) {
            jdkAttribute = DateFormat.Field.AM_PM;
        } else if (icuAttribute == DateFormat.Field.DAY_OF_MONTH) {
            jdkAttribute = DateFormat.Field.DAY_OF_MONTH;
        } else if (icuAttribute == DateFormat.Field.DAY_OF_WEEK) {
            jdkAttribute = DateFormat.Field.DAY_OF_WEEK;
        } else if (icuAttribute == DateFormat.Field.DAY_OF_WEEK_IN_MONTH) {
            jdkAttribute = DateFormat.Field.DAY_OF_WEEK_IN_MONTH;
        } else if (icuAttribute == DateFormat.Field.DAY_OF_YEAR) {
            jdkAttribute = DateFormat.Field.DAY_OF_YEAR;
        } else if (icuAttribute == DateFormat.Field.ERA) {
            jdkAttribute = DateFormat.Field.ERA;
        } else if (icuAttribute == DateFormat.Field.HOUR_OF_DAY0) {
            jdkAttribute = DateFormat.Field.HOUR_OF_DAY0;
        } else if (icuAttribute == DateFormat.Field.HOUR_OF_DAY1) {
            jdkAttribute = DateFormat.Field.HOUR_OF_DAY1;
        } else if (icuAttribute == DateFormat.Field.HOUR0) {
            jdkAttribute = DateFormat.Field.HOUR0;
        } else if (icuAttribute == DateFormat.Field.HOUR1) {
            jdkAttribute = DateFormat.Field.HOUR1;
        } else if (icuAttribute == DateFormat.Field.MILLISECOND) {
            jdkAttribute = DateFormat.Field.MILLISECOND;
        } else if (icuAttribute == DateFormat.Field.MINUTE) {
            jdkAttribute = DateFormat.Field.MINUTE;
        } else if (icuAttribute == DateFormat.Field.MONTH) {
            jdkAttribute = DateFormat.Field.MONTH;
        } else if (icuAttribute == DateFormat.Field.SECOND) {
            jdkAttribute = DateFormat.Field.SECOND;
        } else if (icuAttribute == DateFormat.Field.TIME_ZONE) {
            jdkAttribute = DateFormat.Field.TIME_ZONE;
        } else if (icuAttribute == DateFormat.Field.WEEK_OF_MONTH) {
            jdkAttribute = DateFormat.Field.WEEK_OF_MONTH;
        } else if (icuAttribute == DateFormat.Field.WEEK_OF_YEAR) {
            jdkAttribute = DateFormat.Field.WEEK_OF_YEAR;
        } else if (icuAttribute == DateFormat.Field.YEAR) {
            jdkAttribute = DateFormat.Field.YEAR;
        }
        return jdkAttribute;
    }
}

