/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.zookeeper;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.twill.common.Cancellable;
import org.apache.twill.common.Threads;
import org.apache.twill.internal.zookeeper.BasicACLData;
import org.apache.twill.internal.zookeeper.BasicNodeChildren;
import org.apache.twill.internal.zookeeper.BasicNodeData;
import org.apache.twill.internal.zookeeper.SettableOperationFuture;
import org.apache.twill.zookeeper.ACLData;
import org.apache.twill.zookeeper.AbstractZKClient;
import org.apache.twill.zookeeper.NodeChildren;
import org.apache.twill.zookeeper.NodeData;
import org.apache.twill.zookeeper.OperationFuture;
import org.apache.twill.zookeeper.ZKClientService;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultZKClientService
extends AbstractZKClient
implements ZKClientService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultZKClientService.class);
    private final String zkStr;
    private final int sessionTimeout;
    private final List<Watcher> connectionWatchers;
    private final Multimap<String, byte[]> authInfos;
    private final AtomicReference<ZooKeeper> zooKeeper;
    private final Service serviceDelegate;
    private ExecutorService eventExecutor;

    @Deprecated
    public DefaultZKClientService(String zkStr, int sessionTimeout, Watcher connectionWatcher) {
        this(zkStr, sessionTimeout, connectionWatcher, (Multimap<String, byte[]>)ImmutableMultimap.of());
    }

    public DefaultZKClientService(String zkStr, int sessionTimeout, Watcher connectionWatcher, Multimap<String, byte[]> authInfos) {
        this.zkStr = zkStr;
        this.sessionTimeout = sessionTimeout;
        this.connectionWatchers = new CopyOnWriteArrayList<Watcher>();
        this.authInfos = this.copyAuthInfo(authInfos);
        this.addConnectionWatcher(connectionWatcher);
        this.zooKeeper = new AtomicReference();
        this.serviceDelegate = new ServiceDelegate();
    }

    @Override
    public Long getSessionId() {
        ZooKeeper zk = this.zooKeeper.get();
        return zk == null ? null : Long.valueOf(zk.getSessionId());
    }

    @Override
    public String getConnectString() {
        return this.zkStr;
    }

    @Override
    public Cancellable addConnectionWatcher(final Watcher watcher) {
        if (watcher == null) {
            return new Cancellable(){

                @Override
                public void cancel() {
                }
            };
        }
        this.connectionWatchers.add(watcher);
        return new Cancellable(){

            @Override
            public void cancel() {
                DefaultZKClientService.this.connectionWatchers.remove(watcher);
            }
        };
    }

    @Override
    public OperationFuture<String> create(String path, @Nullable byte[] data, CreateMode createMode, boolean createParent, Iterable<ACL> acl) {
        return this.doCreate(path, data, createMode, createParent, (List<ACL>)ImmutableList.copyOf(acl), false);
    }

    private OperationFuture<String> doCreate(final String path, final @Nullable byte[] data, final CreateMode createMode, boolean createParent, final List<ACL> acl, final boolean ignoreNodeExists) {
        SettableOperationFuture<String> createFuture = SettableOperationFuture.create(path, this.eventExecutor);
        this.getZooKeeper().create(path, data, acl, createMode, Callbacks.STRING, createFuture);
        if (!createParent) {
            return createFuture;
        }
        final SettableOperationFuture<String> result = SettableOperationFuture.create(path, this.eventExecutor);
        Futures.addCallback(createFuture, (FutureCallback)new FutureCallback<String>(){

            public void onSuccess(String path2) {
                result.set(path2);
            }

            public void onFailure(Throwable t) {
                if (this.updateFailureResult(t, result, path, ignoreNodeExists)) {
                    return;
                }
                String parentPath = this.getParent(path);
                if (parentPath.isEmpty()) {
                    result.setException(t);
                    return;
                }
                Futures.addCallback((ListenableFuture)DefaultZKClientService.this.doCreate(parentPath, null, CreateMode.PERSISTENT, true, ZooDefs.Ids.OPEN_ACL_UNSAFE, true), (FutureCallback)new FutureCallback<String>(){

                    public void onSuccess(String parentPath) {
                        Futures.addCallback((ListenableFuture)DefaultZKClientService.this.doCreate(path, data, createMode, false, acl, ignoreNodeExists), (FutureCallback)new FutureCallback<String>(){

                            public void onSuccess(String pathResult) {
                                result.set(pathResult);
                            }

                            public void onFailure(Throwable t) {
                                this.updateFailureResult(t, result, path, ignoreNodeExists);
                            }
                        });
                    }

                    public void onFailure(Throwable t) {
                        result.setException(t);
                    }
                });
            }

            private boolean updateFailureResult(Throwable t, SettableOperationFuture<String> result2, String path2, boolean ignoreNodeExists2) {
                if (!(t instanceof KeeperException)) {
                    result2.setException(t);
                    return true;
                }
                KeeperException.Code code = ((KeeperException)t).code();
                if (ignoreNodeExists2 && code == KeeperException.Code.NODEEXISTS) {
                    result2.set(path2);
                    return false;
                }
                if (code != KeeperException.Code.NONODE) {
                    result2.setException(t);
                    return true;
                }
                return false;
            }

            private String getParent(String path2) {
                String parentPath = path2.substring(0, path2.lastIndexOf(47));
                return parentPath.isEmpty() && !"/".equals(path2) ? "/" : parentPath;
            }
        });
        return result;
    }

    @Override
    public OperationFuture<Stat> exists(String path, Watcher watcher) {
        SettableOperationFuture<Stat> result = SettableOperationFuture.create(path, this.eventExecutor);
        this.getZooKeeper().exists(path, this.wrapWatcher(watcher), Callbacks.STAT_NONODE, result);
        return result;
    }

    @Override
    public OperationFuture<NodeChildren> getChildren(String path, Watcher watcher) {
        SettableOperationFuture<NodeChildren> result = SettableOperationFuture.create(path, this.eventExecutor);
        this.getZooKeeper().getChildren(path, this.wrapWatcher(watcher), Callbacks.CHILDREN, result);
        return result;
    }

    @Override
    public OperationFuture<NodeData> getData(String path, Watcher watcher) {
        SettableOperationFuture<NodeData> result = SettableOperationFuture.create(path, this.eventExecutor);
        this.getZooKeeper().getData(path, this.wrapWatcher(watcher), Callbacks.DATA, result);
        return result;
    }

    @Override
    public OperationFuture<Stat> setData(String dataPath, byte[] data, int version) {
        SettableOperationFuture<Stat> result = SettableOperationFuture.create(dataPath, this.eventExecutor);
        this.getZooKeeper().setData(dataPath, data, version, Callbacks.STAT, result);
        return result;
    }

    @Override
    public OperationFuture<String> delete(String deletePath, int version) {
        SettableOperationFuture<String> result = SettableOperationFuture.create(deletePath, this.eventExecutor);
        this.getZooKeeper().delete(deletePath, version, Callbacks.VOID, result);
        return result;
    }

    @Override
    public OperationFuture<ACLData> getACL(String path) {
        SettableOperationFuture<ACLData> result = SettableOperationFuture.create(path, this.eventExecutor);
        this.getZooKeeper().getACL(path, new Stat(), Callbacks.ACL, result);
        return result;
    }

    @Override
    public OperationFuture<Stat> setACL(String path, Iterable<ACL> acl, int version) {
        SettableOperationFuture<Stat> result = SettableOperationFuture.create(path, this.eventExecutor);
        this.getZooKeeper().setACL(path, (List)ImmutableList.copyOf(acl), version, Callbacks.STAT, result);
        return result;
    }

    @Override
    public Supplier<ZooKeeper> getZooKeeperSupplier() {
        return new Supplier<ZooKeeper>(){

            public ZooKeeper get() {
                return DefaultZKClientService.this.getZooKeeper();
            }
        };
    }

    public ListenableFuture<Service.State> start() {
        return this.serviceDelegate.start();
    }

    public Service.State startAndWait() {
        return this.serviceDelegate.startAndWait();
    }

    public boolean isRunning() {
        return this.serviceDelegate.isRunning();
    }

    public Service.State state() {
        return this.serviceDelegate.state();
    }

    public ListenableFuture<Service.State> stop() {
        return this.serviceDelegate.stop();
    }

    public Service.State stopAndWait() {
        return this.serviceDelegate.stopAndWait();
    }

    public void addListener(Service.Listener listener, Executor executor) {
        this.serviceDelegate.addListener(listener, executor);
    }

    private ZooKeeper getZooKeeper() {
        ZooKeeper zk = this.zooKeeper.get();
        Preconditions.checkArgument((zk != null ? 1 : 0) != 0, (Object)"Not connected to zooKeeper.");
        return zk;
    }

    private Watcher wrapWatcher(final Watcher watcher) {
        if (watcher == null) {
            return null;
        }
        return new Watcher(){

            public void process(final WatchedEvent event) {
                if (DefaultZKClientService.this.eventExecutor.isShutdown()) {
                    LOG.debug("Already shutdown. Discarding event: {}", (Object)event);
                    return;
                }
                DefaultZKClientService.this.eventExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            watcher.process(event);
                        }
                        catch (Throwable t) {
                            LOG.error("Watcher throws exception.", t);
                        }
                    }
                });
            }
        };
    }

    private Multimap<String, byte[]> copyAuthInfo(Multimap<String, byte[]> authInfos) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (Map.Entry entry : authInfos.entries()) {
            byte[] info = (byte[])entry.getValue();
            result.put(entry.getKey(), info == null ? null : Arrays.copyOf(info, info.length));
        }
        return result;
    }

    private static final class Callbacks {
        static final AsyncCallback.StringCallback STRING = new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
                SettableOperationFuture result = (SettableOperationFuture)ctx;
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                if (code == KeeperException.Code.OK) {
                    result.set(name == null || name.isEmpty() ? path : name);
                    return;
                }
                result.setException((Throwable)KeeperException.create((KeeperException.Code)code, (String)result.getRequestPath()));
            }
        };
        static final AsyncCallback.StatCallback STAT = new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                SettableOperationFuture result = (SettableOperationFuture)ctx;
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                if (code == KeeperException.Code.OK) {
                    result.set(stat);
                    return;
                }
                result.setException((Throwable)KeeperException.create((KeeperException.Code)code, (String)result.getRequestPath()));
            }
        };
        static final AsyncCallback.StatCallback STAT_NONODE = new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                SettableOperationFuture result = (SettableOperationFuture)ctx;
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                if (code == KeeperException.Code.OK || code == KeeperException.Code.NONODE) {
                    result.set(stat);
                    return;
                }
                result.setException((Throwable)KeeperException.create((KeeperException.Code)code, (String)result.getRequestPath()));
            }
        };
        static final AsyncCallback.Children2Callback CHILDREN = new AsyncCallback.Children2Callback(){

            public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                SettableOperationFuture result = (SettableOperationFuture)ctx;
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                if (code == KeeperException.Code.OK) {
                    result.set(new BasicNodeChildren(children, stat));
                    return;
                }
                result.setException((Throwable)KeeperException.create((KeeperException.Code)code, (String)result.getRequestPath()));
            }
        };
        static final AsyncCallback.DataCallback DATA = new AsyncCallback.DataCallback(){

            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                SettableOperationFuture result = (SettableOperationFuture)ctx;
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                if (code == KeeperException.Code.OK) {
                    result.set(new BasicNodeData(data, stat));
                    return;
                }
                result.setException((Throwable)KeeperException.create((KeeperException.Code)code, (String)result.getRequestPath()));
            }
        };
        static final AsyncCallback.VoidCallback VOID = new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                SettableOperationFuture result = (SettableOperationFuture)ctx;
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                if (code == KeeperException.Code.OK) {
                    result.set(result.getRequestPath());
                    return;
                }
                result.setException((Throwable)KeeperException.create((KeeperException.Code)code, (String)result.getRequestPath()));
            }
        };
        static final AsyncCallback.ACLCallback ACL = new AsyncCallback.ACLCallback(){

            public void processResult(int rc, String path, Object ctx, List<ACL> acl, Stat stat) {
                SettableOperationFuture result = (SettableOperationFuture)ctx;
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                if (code == KeeperException.Code.OK) {
                    result.set(new BasicACLData(acl, stat));
                    return;
                }
                result.setException((Throwable)KeeperException.create((KeeperException.Code)code, (String)result.getRequestPath()));
            }
        };

        private Callbacks() {
        }
    }

    private final class ServiceDelegate
    extends AbstractService
    implements Watcher {
        private final Runnable stopTask = this.createStopTask();

        private ServiceDelegate() {
            this.addListener(new Service.Listener(){

                public void starting() {
                }

                public void running() {
                }

                public void stopping(Service.State from) {
                    if (from == Service.State.STARTING) {
                        ServiceDelegate.this.notifyStarted();
                    }
                }

                public void terminated(Service.State from) {
                }

                public void failed(Service.State from, Throwable failure) {
                    DefaultZKClientService.this.eventExecutor.shutdownNow();
                    ServiceDelegate.this.closeZooKeeper(DefaultZKClientService.this.zooKeeper.getAndSet(null));
                }
            }, Threads.SAME_THREAD_EXECUTOR);
        }

        protected void doStart() {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), Threads.createDaemonThreadFactory("zk-client-EventThread"));
            executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
            DefaultZKClientService.this.eventExecutor = executor;
            try {
                DefaultZKClientService.this.zooKeeper.set(this.createZooKeeper());
            }
            catch (IOException e) {
                this.notifyFailed(e);
            }
        }

        protected void doStop() {
            DefaultZKClientService.this.eventExecutor.submit(this.stopTask);
            DefaultZKClientService.this.eventExecutor.shutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            Service.State state2 = this.state();
            if (state2 == Service.State.TERMINATED || state2 == Service.State.FAILED) {
                return;
            }
            try {
                if (event.getState() == Watcher.Event.KeeperState.SyncConnected && state2 == Service.State.STARTING) {
                    LOG.debug("Connected to ZooKeeper: {}", (Object)DefaultZKClientService.this.zkStr);
                    this.notifyStarted();
                    return;
                }
                if (event.getState() == Watcher.Event.KeeperState.Expired) {
                    LOG.info("ZooKeeper session expired: {}", (Object)DefaultZKClientService.this.zkStr);
                    if (state2 != Service.State.RUNNING) {
                        return;
                    }
                    DefaultZKClientService.this.eventExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (ServiceDelegate.this.state() != Service.State.RUNNING) {
                                return;
                            }
                            try {
                                LOG.info("Reconnect to ZooKeeper due to expiration: {}", (Object)DefaultZKClientService.this.zkStr);
                                ServiceDelegate.this.closeZooKeeper(DefaultZKClientService.this.zooKeeper.getAndSet(ServiceDelegate.this.createZooKeeper()));
                            }
                            catch (IOException e) {
                                ServiceDelegate.this.notifyFailed(e);
                            }
                        }
                    });
                }
            }
            finally {
                if (event.getType() == Watcher.Event.EventType.None) {
                    for (Watcher connectionWatcher : DefaultZKClientService.this.connectionWatchers) {
                        connectionWatcher.process(event);
                    }
                }
            }
        }

        private Runnable createStopTask() {
            return new Runnable(){

                @Override
                public void run() {
                    try {
                        ServiceDelegate.this.closeZooKeeper(DefaultZKClientService.this.zooKeeper.getAndSet(null));
                        ServiceDelegate.this.notifyStopped();
                    }
                    catch (Exception e) {
                        ServiceDelegate.this.notifyFailed(e);
                    }
                }
            };
        }

        private ZooKeeper createZooKeeper() throws IOException {
            ZooKeeper zk = new ZooKeeper(DefaultZKClientService.this.zkStr, DefaultZKClientService.this.sessionTimeout, DefaultZKClientService.this.wrapWatcher(this));
            for (Map.Entry authInfo : DefaultZKClientService.this.authInfos.entries()) {
                zk.addAuthInfo((String)authInfo.getKey(), (byte[])authInfo.getValue());
            }
            return zk;
        }

        private void closeZooKeeper(@Nullable ZooKeeper zk) {
            try {
                if (zk != null) {
                    zk.close();
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted when closing ZooKeeper", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

