/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositeService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeService.class);
    private final Deque<Service> services = new ArrayDeque<Service>();

    public CompositeService(Service ... services) {
        this((Iterable<? extends Service>)ImmutableList.copyOf((Object[])services));
    }

    public CompositeService(Iterable<? extends Service> services) {
        Iterables.addAll(this.services, services);
    }

    protected void startUp() throws Exception {
        Throwable failureCause = null;
        for (Service service : this.services) {
            try {
                service.startAndWait();
            }
            catch (UncheckedExecutionException e) {
                failureCause = e.getCause();
                break;
            }
        }
        if (failureCause != null) {
            try {
                this.stopAll();
            }
            catch (Throwable t) {
                LOG.warn("Failed when stopping all services on start failure", t);
            }
            Throwables.propagateIfPossible(failureCause, Exception.class);
            throw new RuntimeException(failureCause);
        }
    }

    protected void shutDown() throws Exception {
        this.stopAll();
    }

    private void stopAll() throws Exception {
        Throwable failureCause = null;
        Iterator<Service> itor = this.services.descendingIterator();
        while (itor.hasNext()) {
            Service service = itor.next();
            try {
                if (!service.isRunning() && service.state() != Service.State.STARTING) continue;
                service.stopAndWait();
            }
            catch (UncheckedExecutionException e) {
                if (failureCause == null) {
                    failureCause = e.getCause();
                    continue;
                }
                LOG.warn("Failed to stop service {}", (Object)service, (Object)e);
            }
        }
        if (failureCause != null) {
            Throwables.propagateIfPossible(failureCause, Exception.class);
            throw new RuntimeException(failureCause);
        }
    }
}

