/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.phoenix.mapreduce.PhoenixMultiViewInputSplit;
import org.apache.phoenix.mapreduce.util.ViewInfoWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixMultiViewReader<T extends Writable>
extends RecordReader<NullWritable, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixMultiViewReader.class);
    private Configuration configuration;
    private Class<T> inputClass;
    Iterator<ViewInfoWritable> it;

    public PhoenixMultiViewReader() {
    }

    public PhoenixMultiViewReader(Class<T> inputClass, Configuration configuration) {
        this.configuration = configuration;
        this.inputClass = inputClass;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        if (!(split instanceof PhoenixMultiViewInputSplit)) {
            LOGGER.error("InputSplit class cannot cast to PhoenixMultiViewInputSplit.");
            throw new IOException("InputSplit class cannot cast to PhoenixMultiViewInputSplit");
        }
        PhoenixMultiViewInputSplit pSplit = (PhoenixMultiViewInputSplit)split;
        List<ViewInfoWritable> viewInfoTracker = pSplit.getViewInfoTrackerList();
        this.it = viewInfoTracker.iterator();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.it.hasNext();
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        ViewInfoWritable currentValue = null;
        if (this.it.hasNext()) {
            currentValue = this.it.next();
        }
        return (T)currentValue;
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.0f;
    }

    public void close() throws IOException {
    }
}

