/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.coprocessor.DelegateRegionCoprocessorEnvironment;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.execute.PhoenixTxIndexMutationGenerator;
import org.apache.phoenix.hbase.index.write.IndexWriter;
import org.apache.phoenix.hbase.index.write.LeaveIndexActiveFailurePolicy;
import org.apache.phoenix.hbase.index.write.ParallelWriterIndexCommitter;
import org.apache.phoenix.index.PhoenixIndexCodec;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.index.PhoenixIndexMetaDataBuilder;
import org.apache.phoenix.trace.TracingUtils;
import org.apache.phoenix.trace.util.NullSpan;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixTransactionalIndexer
extends BaseRegionObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixTransactionalIndexer.class);
    private ThreadLocal<BatchMutateContext> batchMutateContext = new ThreadLocal();
    private PhoenixIndexCodec codec;
    private IndexWriter writer;
    private boolean stopped;

    public void start(CoprocessorEnvironment e) throws IOException {
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)e;
        Configuration conf = e.getConfiguration();
        String serverName = env.getRegionServerServices().getServerName().getServerName();
        this.codec = new PhoenixIndexCodec(conf, env.getRegionInfo().getTable().getName());
        DelegateRegionCoprocessorEnvironment indexWriterEnv = new DelegateRegionCoprocessorEnvironment(env, ServerUtil.ConnectionType.INDEX_WRITER_CONNECTION);
        this.writer = new IndexWriter(IndexWriter.getCommitter(indexWriterEnv, ParallelWriterIndexCommitter.class), new LeaveIndexActiveFailurePolicy(), indexWriterEnv, serverName + "-tx-index-writer");
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        String msg = "TxIndexer is being stopped";
        this.writer.stop(msg);
    }

    private static Iterator<Mutation> getMutationIterator(final MiniBatchOperationInProgress<Mutation> miniBatchOp) {
        return new Iterator<Mutation>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < miniBatchOp.size();
            }

            @Override
            public Mutation next() {
                return (Mutation)miniBatchOp.getOperation(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        Mutation m = (Mutation)miniBatchOp.getOperation(0);
        if (!this.codec.isEnabled(m)) {
            super.preBatchMutate(c, miniBatchOp);
            return;
        }
        PhoenixIndexMetaData indexMetaData = new PhoenixIndexMetaDataBuilder((RegionCoprocessorEnvironment)c.getEnvironment()).getIndexMetaData(miniBatchOp);
        if (indexMetaData.getClientVersion() >= MetaDataProtocol.MIN_TX_CLIENT_SIDE_MAINTENANCE && !indexMetaData.hasLocalIndexes()) {
            super.preBatchMutate(c, miniBatchOp);
            return;
        }
        BatchMutateContext context = new BatchMutateContext(indexMetaData.getClientVersion());
        this.setBatchMutateContext(c, context);
        Collection<Pair<Mutation, byte[]>> indexUpdates = null;
        try (TraceScope scope = Trace.startSpan((String)"Starting to build index updates");){
            Span current = scope.getSpan();
            if (current == null) {
                current = NullSpan.INSTANCE;
            }
            RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)c.getEnvironment();
            PhoenixTransactionContext txnContext = indexMetaData.getTransactionContext();
            if (txnContext == null) {
                throw new NullPointerException("Expected to find transaction in metadata for " + env.getRegionInfo().getTable().getNameAsString());
            }
            PhoenixTxIndexMutationGenerator generator = new PhoenixTxIndexMutationGenerator(env.getConfiguration(), indexMetaData, env.getRegionInfo().getTable().getName(), env.getRegionInfo().getStartKey(), env.getRegionInfo().getEndKey());
            try (HTableInterface htable = env.getTable(env.getRegionInfo().getTable());){
                indexUpdates = generator.getIndexUpdates((Table)htable, PhoenixTransactionalIndexer.getMutationIterator(miniBatchOp));
            }
            byte[] tableName = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getTableDesc().getTableName().getName();
            Iterator<Pair<Mutation, byte[]>> indexUpdatesItr = indexUpdates.iterator();
            ArrayList<Mutation> localUpdates = new ArrayList<Mutation>(indexUpdates.size());
            while (indexUpdatesItr.hasNext()) {
                Pair<Mutation, byte[]> next = indexUpdatesItr.next();
                if (Bytes.compareTo((byte[])((byte[])next.getSecond()), (byte[])tableName) != 0) continue;
                Mutation mutation = TransactionUtil.convertIfDelete((Mutation)next.getFirst());
                localUpdates.add(mutation);
                indexUpdatesItr.remove();
            }
            if (!localUpdates.isEmpty()) {
                miniBatchOp.addOperationsFromCP(0, localUpdates.toArray(new Mutation[localUpdates.size()]));
            }
            if (!indexUpdates.isEmpty()) {
                context.indexUpdates = indexUpdates;
            }
            current.addTimelineAnnotation("Built index updates, doing preStep");
            TracingUtils.addAnnotation(current, "index update count", context.indexUpdates.size());
        }
        catch (Throwable t) {
            String msg = "Failed to update index with entries:" + indexUpdates;
            LOGGER.error(msg, t);
            ServerUtil.throwIOException(msg, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBatchMutateIndispensably(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp, boolean success) throws IOException {
        BatchMutateContext context = this.getBatchMutateContext(c);
        if (context == null || context.indexUpdates == null) {
            return;
        }
        try (TraceScope scope = Trace.startSpan((String)"Starting to write index updates");){
            Span current = scope.getSpan();
            if (current == null) {
                current = NullSpan.INSTANCE;
            }
            if (success) {
                if (!context.indexUpdates.isEmpty()) {
                    this.writer.write(context.indexUpdates, false, context.clientVersion);
                }
                current.addTimelineAnnotation("Wrote index updates");
            }
        }
        catch (Throwable t) {
            String msg = "Failed to write index updates:" + context.indexUpdates;
            LOGGER.error(msg, t);
            ServerUtil.throwIOException(msg, t);
        }
        finally {
            this.removeBatchMutateContext(c);
        }
    }

    private void setBatchMutateContext(ObserverContext<RegionCoprocessorEnvironment> c, BatchMutateContext context) {
        this.batchMutateContext.set(context);
    }

    private BatchMutateContext getBatchMutateContext(ObserverContext<RegionCoprocessorEnvironment> c) {
        return this.batchMutateContext.get();
    }

    private void removeBatchMutateContext(ObserverContext<RegionCoprocessorEnvironment> c) {
        this.batchMutateContext.remove();
    }

    private static class BatchMutateContext {
        public Collection<Pair<Mutation, byte[]>> indexUpdates = Collections.emptyList();
        public final int clientVersion;

        public BatchMutateContext(int clientVersion) {
            this.clientVersion = clientVersion;
        }
    }
}

