/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.ipc.controller.InterRegionServerIndexRpcControllerFactory;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfoUtil;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.DelegateRegionCoprocessorEnvironment;
import org.apache.phoenix.coprocessor.GlobalIndexRegionScanner;
import org.apache.phoenix.coprocessor.HashJoinRegionScanner;
import org.apache.phoenix.coprocessor.IndexRebuildRegionScanner;
import org.apache.phoenix.coprocessor.IndexRepairRegionScanner;
import org.apache.phoenix.coprocessor.IndexerRegionScanner;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionScanner;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.hbase.index.Indexer;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.exception.IndexWriteException;
import org.apache.phoenix.index.GlobalIndexChecker;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexFailurePolicy;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.stats.NoOpStatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsCollectionRunTracker;
import org.apache.phoenix.schema.stats.StatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsCollectorFactory;
import org.apache.phoenix.schema.stats.StatsCollectionDisabledOnServerException;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UngroupedAggregateRegionObserver
extends BaseScannerRegionObserver {
    public static final String UNGROUPED_AGG = "UngroupedAgg";
    public static final String DELETE_AGG = "DeleteAgg";
    public static final String DELETE_CQ = "DeleteCQ";
    public static final String DELETE_CF = "DeleteCF";
    public static final String EMPTY_CF = "EmptyCF";
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private int scansReferenceCount = 0;
    @GuardedBy(value="lock")
    private boolean isRegionClosingOrSplitting = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(UngroupedAggregateRegionObserver.class);
    private Configuration upsertSelectConfig;
    private Configuration compactionConfig;
    private Configuration indexWriteConfig;
    private ReadOnlyProps indexWriteProps;

    @Override
    public void start(CoprocessorEnvironment e) throws IOException {
        super.start(e);
        this.upsertSelectConfig = PropertiesUtil.cloneConfig(e.getConfiguration());
        this.upsertSelectConfig.setClass("hbase.rpc.controllerfactory.class", InterRegionServerIndexRpcControllerFactory.class, RpcControllerFactory.class);
        this.compactionConfig = ServerUtil.getCompactionConfig(e.getConfiguration());
        this.indexWriteConfig = PropertiesUtil.cloneConfig(e.getConfiguration());
        this.indexWriteConfig.setInt("hbase.client.retries.number", e.getConfiguration().getInt("phoenix.index.rebuild.rpc.retries.counter", 5));
        this.indexWriteProps = new ReadOnlyProps(this.indexWriteConfig.iterator());
    }

    Configuration getUpsertSelectConfig() {
        return this.upsertSelectConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementScansReferenceCount() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRegionClosingOrSplitting) {
                throw new IOException("Temporarily unable to write from scan because region is closing or splitting");
            }
            ++this.scansReferenceCount;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementScansReferenceCount() {
        Object object = this.lock;
        synchronized (object) {
            --this.scansReferenceCount;
            if (this.scansReferenceCount < 0) {
                LOGGER.warn("Scan reference count went below zero. Something isn't correct. Resetting it back to zero");
                this.scansReferenceCount = 0;
            }
            this.lock.notifyAll();
        }
    }

    void commitBatchWithRetries(final Region region, final List<Mutation> localRegionMutations, final long blockingMemstoreSize) throws IOException {
        try {
            this.commitBatch(region, localRegionMutations, blockingMemstoreSize);
        }
        catch (IOException e) {
            this.handleIndexWriteException(localRegionMutations, e, new PhoenixIndexFailurePolicy.MutateCommand(){

                @Override
                public void doMutation() throws IOException {
                    UngroupedAggregateRegionObserver.this.commitBatch(region, localRegionMutations, blockingMemstoreSize);
                }

                @Override
                public List<Mutation> getMutationList() {
                    return localRegionMutations;
                }
            });
        }
    }

    void commitBatch(Region region, List<Mutation> mutations, long blockingMemstoreSize) throws IOException {
        if (mutations.isEmpty()) {
            return;
        }
        Mutation[] mutationArray = new Mutation[mutations.size()];
        for (int i = 0; blockingMemstoreSize > 0L && region.getMemstoreSize() > blockingMemstoreSize && i < 30; ++i) {
            try {
                this.checkForRegionClosing();
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        LOGGER.debug("Committing batch of " + mutations.size() + " mutations for " + region.getRegionInfo().getTable().getNameAsString());
        region.batchMutate(mutations.toArray(mutationArray), 0L, 0L);
    }

    static void setIndexAndTransactionProperties(List<Mutation> mutations, byte[] indexUUID, byte[] indexMaintainersPtr, byte[] txState, byte[] clientVersionBytes, boolean useIndexProto) {
        for (Mutation m : mutations) {
            if (indexMaintainersPtr != null) {
                m.setAttribute(useIndexProto ? "IdxProtoMD" : "IdxMD", indexMaintainersPtr);
            }
            if (indexUUID != null) {
                m.setAttribute("IdxUUID", indexUUID);
            }
            if (txState != null) {
                m.setAttribute("_TxState", txState);
            }
            if (clientVersionBytes == null) continue;
            m.setAttribute("_ClientVersion", clientVersionBytes);
        }
    }

    private void commitBatchWithHTable(HTable table, List<Mutation> mutations) throws IOException {
        if (mutations.isEmpty()) {
            return;
        }
        LOGGER.debug("Committing batch of " + mutations.size() + " mutations for " + table);
        try {
            table.batch(mutations);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForRegionClosing() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRegionClosingOrSplitting) {
                this.lock.notifyAll();
                throw new IOException("Region is getting closed. Not allowing to write to avoid possible deadlock.");
            }
        }
    }

    public static void serializeIntoScan(Scan scan) {
        scan.setAttribute("_UngroupedAgg", QueryConstants.TRUE);
    }

    @Override
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
        s = super.preScannerOpen(e, scan, s);
        if (ScanUtil.isAnalyzeTable(scan)) {
            scan.setStartRow(HConstants.EMPTY_START_ROW);
            scan.setStopRow(HConstants.EMPTY_END_ROW);
            scan.setFilter(null);
        }
        return s;
    }

    static long getBlockingMemstoreSize(Region region, Configuration conf) {
        long flushSize = region.getTableDesc().getMemStoreFlushSize();
        if (flushSize <= 0L) {
            flushSize = conf.getLong("hbase.hregion.memstore.flush.size", 0x8000000L);
        }
        return flushSize * (conf.getLong("hbase.hregion.memstore.block.multiplier", 4L) - 1L);
    }

    @Override
    protected RegionScanner doPostScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, final Scan scan, final RegionScanner s) throws IOException, SQLException {
        final RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)c.getEnvironment();
        final Region region = env.getRegion();
        long ts = scan.getTimeRange().getMax();
        boolean localIndexScan = ScanUtil.isLocalIndex(scan);
        if (ScanUtil.isAnalyzeTable(scan)) {
            byte[] gp_width_bytes = scan.getAttribute("_GUIDEPOST_WIDTH_BYTES");
            byte[] gp_per_region_bytes = scan.getAttribute("_GUIDEPOST_PER_REGION");
            StatisticsCollector statsCollector = StatisticsCollectorFactory.createStatisticsCollector(env, region.getRegionInfo().getTable().getNameAsString(), ts, gp_width_bytes, gp_per_region_bytes);
            if (statsCollector instanceof NoOpStatisticsCollector) {
                throw new StatsCollectionDisabledOnServerException();
            }
            return this.collectStats(s, statsCollector, region, scan, env.getConfiguration());
        }
        if (ScanUtil.isIndexRebuild(scan)) {
            return (RegionScanner)User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<RegionScanner>(){

                @Override
                public RegionScanner run() throws Exception {
                    return UngroupedAggregateRegionObserver.this.rebuildIndices(s, region, scan, env);
                }
            });
        }
        boolean useNewValueColumnQualifier = EncodedColumnsUtil.useNewValueColumnQualifier(scan);
        int offsetToBe = 0;
        if (localIndexScan) {
            offsetToBe = region.getRegionInfo().getStartKey().length != 0 ? region.getRegionInfo().getStartKey().length : region.getRegionInfo().getEndKey().length;
        }
        int offset = offsetToBe;
        byte[] descRowKeyTableBytes = scan.getAttribute("_UPGRADE_DESC_ROW_KEY");
        boolean isDescRowKeyOrderUpgrade = descRowKeyTableBytes != null;
        boolean useProto = false;
        byte[] localIndexBytes = scan.getAttribute("_LocalIndexBuild");
        boolean bl = useProto = localIndexBytes != null;
        if (localIndexBytes == null) {
            localIndexBytes = scan.getAttribute("_LocalIndexBuild");
        }
        List<IndexMaintainer> indexMaintainers = localIndexBytes == null ? null : IndexMaintainer.deserialize(localIndexBytes, useProto);
        RegionScanner theScanner = s;
        byte[] upsertSelectTable = scan.getAttribute("_UpsertSelectTable");
        boolean isDelete = false;
        if (upsertSelectTable == null) {
            byte[] isDeleteAgg = scan.getAttribute("_DeleteAgg");
            isDelete = isDeleteAgg != null && Bytes.compareTo((byte[])PDataType.TRUE_BYTES, (byte[])isDeleteAgg) == 0;
        }
        TupleProjector tupleProjector = null;
        byte[][] viewConstants = null;
        ColumnReference[] dataColumns = IndexUtil.deserializeDataTableColumnsToJoin(scan);
        TupleProjector p = TupleProjector.deserializeProjectorFromScan(scan);
        HashJoinInfo j = HashJoinInfo.deserializeHashJoinFromScan(scan);
        boolean useQualifierAsIndex = EncodedColumnsUtil.useQualifierAsIndex(EncodedColumnsUtil.getMinMaxQualifiersFromScan(scan));
        if (localIndexScan && !isDelete && !isDescRowKeyOrderUpgrade || j == null && p != null) {
            if (dataColumns != null) {
                tupleProjector = IndexUtil.getTupleProjector(scan, dataColumns);
                viewConstants = IndexUtil.deserializeViewConstantsFromScan(scan);
            }
            ImmutableBytesWritable tempPtr = new ImmutableBytesWritable();
            theScanner = this.getWrappedScanner(c, theScanner, offset, scan, dataColumns, tupleProjector, region, indexMaintainers == null ? null : indexMaintainers.get(0), viewConstants, p, tempPtr, useQualifierAsIndex);
        }
        if (j != null) {
            theScanner = new HashJoinRegionScanner(theScanner, scan, p, j, ScanUtil.getTenantId(scan), env, useQualifierAsIndex, useNewValueColumnQualifier);
        }
        return new UngroupedAggregateRegionScanner(c, theScanner, region, scan, env, this);
    }

    static void checkForLocalIndexColumnFamilies(Region region, List<IndexMaintainer> indexMaintainers) throws IOException {
        HTableDescriptor tableDesc = region.getTableDesc();
        String schemaName = tableDesc.getTableName().getNamespaceAsString().equals(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR) ? SchemaUtil.getSchemaNameFromFullName(tableDesc.getTableName().getNameAsString()) : tableDesc.getTableName().getNamespaceAsString();
        String tableName = SchemaUtil.getTableNameFromFullName(tableDesc.getTableName().getNameAsString());
        for (IndexMaintainer indexMaintainer : indexMaintainers) {
            byte[] localIndexCf;
            Set<ColumnReference> coveredColumns = indexMaintainer.getCoveredColumns();
            if (coveredColumns.isEmpty() && tableDesc.getFamily(localIndexCf = indexMaintainer.getEmptyKeyValueFamily().get()) == null) {
                ServerUtil.throwIOException("Column Family Not Found", new ColumnFamilyNotFoundException(schemaName, tableName, Bytes.toString((byte[])localIndexCf)));
            }
            for (ColumnReference reference : coveredColumns) {
                byte[] cf = IndexUtil.getLocalIndexColumnFamily(reference.getFamily());
                HColumnDescriptor family = region.getTableDesc().getFamily(cf);
                if (family != null) continue;
                ServerUtil.throwIOException("Column Family Not Found", new ColumnFamilyNotFoundException(schemaName, tableName, Bytes.toString((byte[])cf)));
            }
        }
    }

    void commit(Region region, List<Mutation> mutations, byte[] indexUUID, long blockingMemStoreSize, byte[] indexMaintainersPtr, byte[] txState, final HTable targetHTable, boolean useIndexProto, boolean isPKChanging, byte[] clientVersionBytes) throws IOException {
        ArrayList localRegionMutations = Lists.newArrayList();
        final ArrayList remoteRegionMutations = Lists.newArrayList();
        UngroupedAggregateRegionObserver.setIndexAndTransactionProperties(mutations, indexUUID, indexMaintainersPtr, txState, clientVersionBytes, useIndexProto);
        this.separateLocalAndRemoteMutations(targetHTable, region, mutations, localRegionMutations, remoteRegionMutations, isPKChanging);
        this.commitBatchWithRetries(region, localRegionMutations, blockingMemStoreSize);
        try {
            this.commitBatchWithHTable(targetHTable, remoteRegionMutations);
        }
        catch (IOException e) {
            this.handleIndexWriteException(remoteRegionMutations, e, new PhoenixIndexFailurePolicy.MutateCommand(){

                @Override
                public void doMutation() throws IOException {
                    UngroupedAggregateRegionObserver.this.commitBatchWithHTable(targetHTable, remoteRegionMutations);
                }

                @Override
                public List<Mutation> getMutationList() {
                    return remoteRegionMutations;
                }
            });
        }
        localRegionMutations.clear();
        remoteRegionMutations.clear();
    }

    private void handleIndexWriteException(List<Mutation> localRegionMutations, IOException origIOE, PhoenixIndexFailurePolicy.MutateCommand mutateCommand) throws IOException {
        block18: {
            long serverTimestamp = ServerUtil.parseTimestampFromRemoteException(origIOE);
            SQLException inferredE = ServerUtil.parseLocalOrRemoteServerException(origIOE);
            if (inferredE != null && inferredE.getErrorCode() == SQLExceptionCode.INDEX_WRITE_FAILURE.getErrorCode()) {
                for (Mutation mutation : localRegionMutations) {
                    if (PhoenixIndexMetaData.isIndexRebuild(mutation.getAttributesMap())) {
                        mutation.setAttribute("_IGNORE_NEWER_MUTATIONS", BaseScannerRegionObserver.REPLAY_INDEX_REBUILD_WRITES);
                    } else {
                        mutation.setAttribute("_IGNORE_NEWER_MUTATIONS", BaseScannerRegionObserver.REPLAY_ONLY_INDEX_WRITES);
                    }
                    KeyValueUtil.setTimestamp(mutation, serverTimestamp);
                }
                IndexWriteException iwe = PhoenixIndexFailurePolicy.getIndexWriteException(inferredE);
                try (PhoenixConnection conn = QueryUtil.getConnectionOnServer(this.indexWriteConfig).unwrap(PhoenixConnection.class);){
                    PhoenixIndexFailurePolicy.doBatchWithRetries(mutateCommand, iwe, conn, this.indexWriteProps);
                    break block18;
                }
                catch (Exception e) {
                    throw new DoNotRetryIOException((Throwable)e);
                }
            }
            throw origIOE;
        }
    }

    private void separateLocalAndRemoteMutations(HTable targetHTable, Region region, List<Mutation> mutations, List<Mutation> localRegionMutations, List<Mutation> remoteRegionMutations, boolean isPKChanging) {
        boolean areMutationsInSameTable = this.areMutationsInSameTable(targetHTable, region);
        if (areMutationsInSameTable && isPKChanging) {
            HRegionInfo regionInfo = region.getRegionInfo();
            for (Mutation mutation : mutations) {
                if (regionInfo.containsRow(mutation.getRow())) {
                    localRegionMutations.add(mutation);
                    continue;
                }
                remoteRegionMutations.add(mutation);
            }
        } else if (areMutationsInSameTable && !isPKChanging) {
            localRegionMutations.addAll(mutations);
        } else {
            remoteRegionMutations.addAll(mutations);
        }
    }

    private boolean areMutationsInSameTable(HTable targetHTable, Region region) {
        return targetHTable == null || Bytes.compareTo((byte[])targetHTable.getTableName(), (byte[])region.getTableDesc().getTableName().getName()) == 0;
    }

    public InternalScanner preCompact(final ObserverContext<RegionCoprocessorEnvironment> c, final Store store, final InternalScanner scanner, ScanType scanType) throws IOException {
        if (scanType.equals((Object)ScanType.COMPACT_DROP_DELETES)) {
            final TableName table = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable();
            return (InternalScanner)User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<InternalScanner>(){

                @Override
                public InternalScanner run() throws Exception {
                    InternalScanner internalScanner;
                    block2: {
                        internalScanner = scanner;
                        try {
                            long clientTimeStamp = EnvironmentEdgeManager.currentTimeMillis();
                            DelegateRegionCoprocessorEnvironment compactionConfEnv = new DelegateRegionCoprocessorEnvironment((RegionCoprocessorEnvironment)c.getEnvironment(), ServerUtil.ConnectionType.COMPACTION_CONNECTION);
                            StatisticsCollector statisticsCollector = StatisticsCollectorFactory.createStatisticsCollector(compactionConfEnv, table.getNameAsString(), clientTimeStamp, store.getFamily().getName());
                            statisticsCollector.init();
                            internalScanner = statisticsCollector.createCompactionScanner(compactionConfEnv, store, internalScanner);
                        }
                        catch (Exception e) {
                            if (!LOGGER.isWarnEnabled()) break block2;
                            LOGGER.warn("Unable to collect stats for " + table, (Throwable)e);
                        }
                    }
                    return internalScanner;
                }
            });
        }
        return scanner;
    }

    static PTable deserializeTable(byte[] b) {
        try {
            PTableProtos.PTable ptableProto = PTableProtos.PTable.parseFrom(b);
            return PTableImpl.createFromProto(ptableProto);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RegionScanner getRegionScanner(RegionScanner innerScanner, Region region, Scan scan, RegionCoprocessorEnvironment env, boolean oldCoproc) throws IOException {
        if (oldCoproc) {
            return new IndexerRegionScanner(innerScanner, region, scan, env, this);
        }
        if (region.getTableDesc().hasCoprocessor(GlobalIndexChecker.class.getCanonicalName())) {
            return new IndexRepairRegionScanner(innerScanner, region, scan, env, this);
        }
        return new IndexRebuildRegionScanner(innerScanner, region, scan, env, this);
    }

    private RegionScanner rebuildIndices(RegionScanner innerScanner, Region region, Scan scan, RegionCoprocessorEnvironment env) throws IOException {
        RegionScanner scanner;
        IndexTool.IndexVerifyType verifyType;
        boolean oldCoproc = region.getTableDesc().hasCoprocessor(Indexer.class.getCanonicalName());
        byte[] valueBytes = scan.getAttribute("_IndexRebuildVerifyType");
        IndexTool.IndexVerifyType indexVerifyType = verifyType = valueBytes != null ? IndexTool.IndexVerifyType.fromValue(valueBytes) : IndexTool.IndexVerifyType.NONE;
        if (oldCoproc && verifyType == IndexTool.IndexVerifyType.ONLY) {
            return new IndexerRegionScanner(innerScanner, region, scan, env, this);
        }
        if (!scan.isRaw()) {
            Scan rawScan = new Scan(scan);
            rawScan.setRaw(true);
            rawScan.setMaxVersions();
            rawScan.getFamilyMap().clear();
            GlobalIndexRegionScanner.adjustScanFilter(rawScan);
            rawScan.setCacheBlocks(false);
            for (byte[] family : scan.getFamilyMap().keySet()) {
                rawScan.addFamily(family);
            }
            scanner = ((BaseRegionScanner)innerScanner).getNewRegionScanner(rawScan);
            innerScanner.close();
        } else if (GlobalIndexRegionScanner.adjustScanFilter(scan)) {
            scanner = ((BaseRegionScanner)innerScanner).getNewRegionScanner(scan);
            innerScanner.close();
        } else {
            scanner = innerScanner;
        }
        return this.getRegionScanner(scanner, region, scan, env, oldCoproc);
    }

    private RegionScanner collectStats(RegionScanner innerScanner, StatisticsCollector stats, final Region region, final Scan scan, Configuration config) throws IOException {
        StatsCollectionCallable callable = new StatsCollectionCallable(stats, region, innerScanner, config, scan);
        byte[] asyncBytes = scan.getAttribute("_RunUpdateStatsAsync");
        boolean async = false;
        if (asyncBytes != null) {
            async = Bytes.toBoolean((byte[])asyncBytes);
        }
        long rowCount = 0L;
        StatisticsCollectionRunTracker statsRunTracker = StatisticsCollectionRunTracker.getInstance(config);
        final boolean runUpdateStats = statsRunTracker.addUpdateStatsCommandRegion(region.getRegionInfo(), scan.getFamilyMap().keySet());
        if (runUpdateStats) {
            if (!async) {
                rowCount = callable.call();
            } else {
                statsRunTracker.runTask(callable);
            }
        } else {
            rowCount = -100L;
            LOGGER.info("UPDATE STATISTICS didn't run because another UPDATE STATISTICS command was already running on the region " + region.getRegionInfo().getRegionNameAsString());
        }
        byte[] rowCountBytes = PLong.INSTANCE.toBytes(rowCount);
        final KeyValue aggKeyValue = KeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, rowCountBytes, 0, rowCountBytes.length);
        BaseRegionScanner scanner = new BaseRegionScanner(innerScanner){

            @Override
            public HRegionInfo getRegionInfo() {
                return region.getRegionInfo();
            }

            @Override
            public boolean isFilterDone() {
                return true;
            }

            @Override
            public void close() throws IOException {
                if (!runUpdateStats) {
                    super.close();
                }
            }

            @Override
            public boolean next(List<Cell> results) throws IOException {
                results.add((Cell)aggKeyValue);
                return false;
            }

            @Override
            public long getMaxResultSize() {
                return scan.getMaxResultSize();
            }
        };
        return scanner;
    }

    static List<Expression> deserializeExpressions(byte[] b) {
        ByteArrayInputStream stream = new ByteArrayInputStream(b);
        try {
            DataInputStream input = new DataInputStream(stream);
            int size = WritableUtils.readVInt((DataInput)input);
            ArrayList selectExpressions = Lists.newArrayListWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                ExpressionType type = ExpressionType.values()[WritableUtils.readVInt((DataInput)input)];
                Expression selectExpression = type.newInstance();
                selectExpression.readFields(input);
                selectExpressions.add(selectExpression);
            }
            ArrayList arrayList = selectExpressions;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static byte[] serialize(PTable projectedTable) {
        PTableProtos.PTable ptableProto = PTableImpl.toProto(projectedTable);
        return ptableProto.toByteArray();
    }

    public static byte[] serialize(List<Expression> selectExpressions) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(stream);
            WritableUtils.writeVInt((DataOutput)output, (int)selectExpressions.size());
            for (int i = 0; i < selectExpressions.size(); ++i) {
                Expression expression = selectExpressions.get(i);
                WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(expression).ordinal());
                expression.write(output);
            }
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> c, byte[] splitRow) throws IOException {
        this.waitForScansToFinish(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForScansToFinish(ObserverContext<RegionCoprocessorEnvironment> c) throws IOException {
        int maxWaitTime = ((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration().getInt("hbase.client.operation.timeout", 1200000);
        long start = EnvironmentEdgeManager.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            this.isRegionClosingOrSplitting = true;
            while (this.scansReferenceCount > 0) {
                try {
                    this.lock.wait(1000L);
                    if (EnvironmentEdgeManager.currentTimeMillis() - start < (long)maxWaitTime) continue;
                    this.isRegionClosingOrSplitting = false;
                    throw new IOException(String.format("Operations like local index building/delete/upsert select might be going on so not allowing to split/close. scansReferenceCount=%s region=%s", this.scansReferenceCount, ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegionInfo().getRegionNameAsString()));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> c, List<Pair<byte[], String>> familyPaths) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.scansReferenceCount > 0) {
                throw new DoNotRetryIOException("Operations like local index building/delete/upsert select might be going on so not allowing to bulkload.");
            }
        }
    }

    public void preClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) throws IOException {
        this.waitForScansToFinish(c);
    }

    @Override
    protected boolean isRegionObserverFor(Scan scan) {
        return scan.getAttribute("_UngroupedAgg") != null;
    }

    public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, final Store store, final List<? extends KeyValueScanner> scanners, ScanType scanType, long earliestPutTs, final InternalScanner s, CompactionRequest request) throws IOException {
        final String fullTableName = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable().getNameAsString();
        if (request.isMajor() && !ScanInfoUtil.isMaxLookbackTimeEnabled(this.compactionConfig) && !PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME.equals(fullTableName)) {
            return (InternalScanner)User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<InternalScanner>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public InternalScanner run() throws Exception {
                    try (PhoenixConnection conn = QueryUtil.getConnectionOnServer(UngroupedAggregateRegionObserver.this.compactionConfig).unwrap(PhoenixConnection.class);){
                        PTable index;
                        PTable table = PhoenixRuntime.getTableNoCache(conn, fullTableName);
                        ArrayList indexes = PTableType.INDEX.equals((Object)table.getType()) ? Lists.newArrayList((Object[])new PTable[]{table}) : table.getIndexes();
                        Iterator<PTable> iterator = indexes.iterator();
                        do {
                            if (!iterator.hasNext()) return s;
                        } while ((index = iterator.next()).getIndexDisableTimestamp() == 0L);
                        LOGGER.info("Modifying major compaction scanner to retain deleted cells for a table with disabled index: " + fullTableName);
                        Scan scan = new Scan();
                        scan.setMaxVersions();
                        try {
                            if (s != null) {
                                s.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        StoreScanner storeScanner = new StoreScanner(store, store.getScanInfo(), scan, scanners, ScanType.COMPACT_RETAIN_DELETES, store.getSmallestReadPoint(), Long.MIN_VALUE);
                        return storeScanner;
                    }
                    catch (Exception e) {
                        if (e instanceof TableNotFoundException) {
                            LOGGER.debug("Ignoring HBase table that is not a Phoenix table: " + fullTableName);
                            return s;
                        }
                        LOGGER.error("Unable to modify compaction scanner to retain deleted cells for a table with disabled Index; " + fullTableName, (Throwable)e);
                    }
                    return s;
                }
            });
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRollBackSplit(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.isRegionClosingOrSplitting = false;
        }
    }

    static class StatsCollectionCallable
    implements Callable<Long> {
        private final StatisticsCollector statsCollector;
        private final Region region;
        private final RegionScanner innerScanner;
        private final Configuration config;
        private final Scan scan;

        StatsCollectionCallable(StatisticsCollector s, Region r, RegionScanner rs, Configuration config, Scan scan) {
            this.statsCollector = s;
            this.region = r;
            this.innerScanner = rs;
            this.config = config;
            this.scan = scan;
        }

        @Override
        public Long call() throws IOException {
            return this.collectStatsInternal();
        }

        private boolean areStatsBeingCollectedViaCompaction() {
            return StatisticsCollectionRunTracker.getInstance(this.config).areStatsBeingCollectedOnCompaction(this.region.getRegionInfo());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long collectStatsInternal() throws IOException {
            long startTime = EnvironmentEdgeManager.currentTimeMillis();
            this.region.startRegionOperation();
            boolean hasMore = false;
            boolean noErrors = false;
            boolean compactionRunning = this.areStatsBeingCollectedViaCompaction();
            long rowCount = 0L;
            try {
                if (!compactionRunning) {
                    this.statsCollector.init();
                    RegionScanner regionScanner = this.innerScanner;
                    synchronized (regionScanner) {
                        do {
                            ArrayList<Cell> results = new ArrayList<Cell>();
                            hasMore = this.innerScanner.nextRaw(results);
                            this.statsCollector.collectStatistics(results);
                            ++rowCount;
                            compactionRunning = this.areStatsBeingCollectedViaCompaction();
                        } while (hasMore && !compactionRunning);
                        noErrors = true;
                    }
                }
                long l = compactionRunning ? -200L : rowCount;
                return l;
            }
            catch (IOException e) {
                LOGGER.error("IOException in update stats: " + Throwables.getStackTraceAsString((Throwable)e));
                throw e;
            }
            finally {
                try {
                    if (noErrors && !compactionRunning) {
                        this.statsCollector.updateStatistics(this.region, this.scan);
                        LOGGER.info("UPDATE STATISTICS finished successfully for scanner: " + this.innerScanner + ". Number of rows scanned: " + rowCount + ". Time: " + (EnvironmentEdgeManager.currentTimeMillis() - startTime));
                    }
                    if (compactionRunning) {
                        LOGGER.info("UPDATE STATISTICS stopped in between because major compaction was running for region " + this.region.getRegionInfo().getRegionNameAsString());
                    }
                }
                finally {
                    try {
                        StatisticsCollectionRunTracker.getInstance(this.config).removeUpdateStatsCommandRegion(this.region.getRegionInfo(), this.scan.getFamilyMap().keySet());
                        this.statsCollector.close();
                    }
                    finally {
                        try {
                            this.innerScanner.close();
                        }
                        finally {
                            this.region.closeRegionOperation();
                        }
                    }
                }
            }
        }
    }

    public static class MutationList
    extends ArrayList<Mutation> {
        private long byteSize = 0L;

        public MutationList() {
        }

        public MutationList(int size) {
            super(size);
        }

        @Override
        public boolean add(Mutation e) {
            boolean r = super.add(e);
            if (r) {
                this.byteSize += KeyValueUtil.calculateMutationDiskSize(e);
            }
            return r;
        }

        public long byteSize() {
            return this.byteSize;
        }

        @Override
        public void clear() {
            this.byteSize = 0L;
            super.clear();
        }
    }
}

