/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.mapreduce.index.IndexVerificationResultRepository;

public class IndexToolVerificationResult {
    private long scannedDataRowCount = 0L;
    private long rebuiltIndexRowCount = 0L;
    private byte[] startRow;
    private byte[] stopRow;
    private long scanMaxTs;
    private byte[] region;
    private PhaseResult before = new PhaseResult();
    private PhaseResult after = new PhaseResult();

    public void setScannedDataRowCount(long scannedDataRowCount) {
        this.scannedDataRowCount = scannedDataRowCount;
    }

    public void setRebuiltIndexRowCount(long rebuiltIndexRowCount) {
        this.rebuiltIndexRowCount = rebuiltIndexRowCount;
    }

    public PhaseResult getBefore() {
        return this.before;
    }

    public void setBefore(PhaseResult before) {
        this.before = before;
    }

    public PhaseResult getAfter() {
        return this.after;
    }

    public void setAfter(PhaseResult after) {
        this.after = after;
    }

    public byte[] getStartRow() {
        return this.startRow;
    }

    public byte[] getStopRow() {
        return this.stopRow;
    }

    public long getScanMaxTs() {
        return this.scanMaxTs;
    }

    public IndexToolVerificationResult(long scanMaxTs) {
        this.scanMaxTs = scanMaxTs;
    }

    public IndexToolVerificationResult(byte[] startRow, byte[] stopRow, long scanMaxTs) {
        this.setStartRow(startRow);
        this.setStopRow(stopRow);
        this.scanMaxTs = scanMaxTs;
    }

    public IndexToolVerificationResult(Scan scan) {
        this.setStartRow(scan.getStartRow());
        this.setStopRow(scan.getStopRow());
        this.scanMaxTs = scan.getTimeRange().getMax();
    }

    public byte[] getRegion() {
        return this.region;
    }

    public void setStartRow(byte[] startRow) {
        this.startRow = startRow;
    }

    public void setStopRow(byte[] stopRow) {
        this.stopRow = stopRow;
    }

    public String toString() {
        return "VerificationResult{scannedDataRowCount=" + this.getScannedDataRowCount() + ", rebuiltIndexRowCount=" + this.getRebuiltIndexRowCount() + ", before=" + this.getBefore() + ", after=" + this.getAfter() + '}';
    }

    public long getScannedDataRowCount() {
        return this.scannedDataRowCount;
    }

    public long getRebuiltIndexRowCount() {
        return this.rebuiltIndexRowCount;
    }

    public long getBeforeRebuildValidIndexRowCount() {
        return this.getBefore().getValidIndexRowCount();
    }

    public long getBeforeRebuildExpiredIndexRowCount() {
        return this.getBefore().getExpiredIndexRowCount();
    }

    public long getBeforeRebuildInvalidIndexRowCount() {
        return this.getBefore().getInvalidIndexRowCount();
    }

    public long getBeforeRebuildUnverifiedIndexRowCount() {
        return this.getBefore().getUnverifiedIndexRowCount();
    }

    public long getBeforeRebuildOldIndexRowCount() {
        return this.getBefore().getOldIndexRowCount();
    }

    public long getBeforeRebuildUnknownIndexRowCount() {
        return this.getBefore().getUnknownIndexRowCount();
    }

    public long getBeforeRebuildBeyondMaxLookBackMissingIndexRowCount() {
        return this.before.getBeyondMaxLookBackMissingIndexRowCount();
    }

    public long getBeforeRebuildBeyondMaxLookBackInvalidIndexRowCount() {
        return this.before.getBeyondMaxLookBackInvalidIndexRowCount();
    }

    public long getBeforeRebuildMissingIndexRowCount() {
        return this.getBefore().getMissingIndexRowCount();
    }

    public long getBeforeIndexHasMissingCellsCount() {
        return this.getBefore().getIndexHasMissingCellsCount();
    }

    public long getBeforeIndexHasExtraCellsCount() {
        return this.getBefore().getIndexHasExtraCellsCount();
    }

    public long getBeforeRepairExtraVerifiedIndexRowCount() {
        return this.getBefore().getExtraVerifiedIndexRowCount();
    }

    public long getBeforeRepairExtraUnverifiedIndexRowCount() {
        return this.getBefore().getExtraUnverifiedIndexRowCount();
    }

    public long getAfterRebuildValidIndexRowCount() {
        return this.getAfter().getValidIndexRowCount();
    }

    public long getAfterRebuildExpiredIndexRowCount() {
        return this.getAfter().getExpiredIndexRowCount();
    }

    public long getAfterRebuildInvalidIndexRowCount() {
        return this.getAfter().getInvalidIndexRowCount();
    }

    public long getAfterRebuildMissingIndexRowCount() {
        return this.getAfter().getMissingIndexRowCount();
    }

    public long getAfterRebuildBeyondMaxLookBackMissingIndexRowCount() {
        return this.after.getBeyondMaxLookBackMissingIndexRowCount();
    }

    public long getAfterRebuildBeyondMaxLookBackInvalidIndexRowCount() {
        return this.after.getBeyondMaxLookBackInvalidIndexRowCount();
    }

    public long getAfterIndexHasMissingCellsCount() {
        return this.getAfter().getIndexHasMissingCellsCount();
    }

    public long getAfterIndexHasExtraCellsCount() {
        return this.getAfter().getIndexHasExtraCellsCount();
    }

    public long getAfterRepairExtraVerifiedIndexRowCount() {
        return this.getAfter().getExtraVerifiedIndexRowCount();
    }

    public long getAfterRepairExtraUnverifiedIndexRowCount() {
        return this.getAfter().getExtraUnverifiedIndexRowCount();
    }

    private void addScannedDataRowCount(long count) {
        this.setScannedDataRowCount(this.getScannedDataRowCount() + count);
    }

    private void addRebuiltIndexRowCount(long count) {
        this.setRebuiltIndexRowCount(this.getRebuiltIndexRowCount() + count);
    }

    private void addBeforeRebuildValidIndexRowCount(long count) {
        this.getBefore().setValidIndexRowCount(this.getBefore().getValidIndexRowCount() + count);
    }

    private void addBeforeRebuildExpiredIndexRowCount(long count) {
        this.getBefore().setExpiredIndexRowCount(this.getBefore().getExpiredIndexRowCount() + count);
    }

    private void addBeforeRebuildMissingIndexRowCount(long count) {
        this.getBefore().setMissingIndexRowCount(this.getBefore().getMissingIndexRowCount() + count);
    }

    private void addBeforeRebuildInvalidIndexRowCount(long count) {
        this.getBefore().setInvalidIndexRowCount(this.getBefore().getInvalidIndexRowCount() + count);
    }

    private void addBeforeRebuildBeyondMaxLookBackMissingIndexRowCount(long count) {
        this.before.setBeyondMaxLookBackMissingIndexRowCount(this.before.getBeyondMaxLookBackMissingIndexRowCount() + count);
    }

    private void addBeforeRebuildBeyondMaxLookBackInvalidIndexRowCount(long count) {
        this.before.setBeyondMaxLookBackInvalidIndexRowCount(this.before.getBeyondMaxLookBackInvalidIndexRowCount() + count);
    }

    public void addBeforeIndexHasMissingCellsCount(long count) {
        this.getBefore().setIndexHasMissingCellsCount(this.getBefore().getIndexHasMissingCellsCount() + count);
    }

    public void addBeforeIndexHasExtraCellsCount(long count) {
        this.getBefore().setIndexHasExtraCellsCount(this.getBefore().getIndexHasExtraCellsCount() + count);
    }

    public void addBeforeUnverifiedIndexRowCount(long count) {
        this.getBefore().setUnverifiedIndexRowCount(this.getBefore().getUnverifiedIndexRowCount() + count);
    }

    public void addBeforeOldIndexRowCount(long count) {
        this.getBefore().setOldIndexRowCount(this.getBefore().getOldIndexRowCount() + count);
    }

    public void addBeforeUnknownIndexRowCount(long count) {
        this.getBefore().setUnknownIndexRowCount(this.getBefore().getUnknownIndexRowCount() + count);
    }

    public void addBeforeRepairExtraVerifiedIndexRowCount(long count) {
        this.getBefore().setExtraVerifiedIndexRowCount(this.getBefore().getExtraVerifiedIndexRowCount() + count);
    }

    public void addBeforeRepairExtraUnverifiedIndexRowCount(long count) {
        this.getBefore().setExtraUnverifiedIndexRowCount(this.getBefore().getExtraUnverifiedIndexRowCount() + count);
    }

    private void addAfterRebuildValidIndexRowCount(long count) {
        this.getAfter().setValidIndexRowCount(this.getAfter().getValidIndexRowCount() + count);
    }

    private void addAfterRebuildExpiredIndexRowCount(long count) {
        this.getAfter().setExpiredIndexRowCount(this.getAfter().getExpiredIndexRowCount() + count);
    }

    private void addAfterRebuildMissingIndexRowCount(long count) {
        this.getAfter().setMissingIndexRowCount(this.getAfter().getMissingIndexRowCount() + count);
    }

    private void addAfterRebuildInvalidIndexRowCount(long count) {
        this.getAfter().setInvalidIndexRowCount(this.getAfter().getInvalidIndexRowCount() + count);
    }

    private void addAfterRebuildBeyondMaxLookBackMissingIndexRowCount(long count) {
        this.after.setBeyondMaxLookBackMissingIndexRowCount(this.after.getBeyondMaxLookBackMissingIndexRowCount() + count);
    }

    private void addAfterRebuildBeyondMaxLookBackInvalidIndexRowCount(long count) {
        this.after.setBeyondMaxLookBackInvalidIndexRowCount(this.after.getBeyondMaxLookBackInvalidIndexRowCount() + count);
    }

    public void addAfterIndexHasMissingCellsCount(long count) {
        this.getAfter().setIndexHasMissingCellsCount(this.getAfter().getIndexHasMissingCellsCount() + count);
    }

    public void addAfterIndexHasExtraCellsCount(long count) {
        this.getAfter().setIndexHasExtraCellsCount(this.getAfter().getIndexHasExtraCellsCount() + count);
    }

    public void addAfterRepairExtraVerifiedIndexRowCount(long count) {
        this.getAfter().setExtraVerifiedIndexRowCount(this.getAfter().getExtraVerifiedIndexRowCount() + count);
    }

    public void addAfterRepairExtraUnverifiedIndexRowCount(long count) {
        this.getAfter().setExtraUnverifiedIndexRowCount(this.getAfter().getExtraUnverifiedIndexRowCount() + count);
    }

    private static boolean isAfterRebuildInvalidIndexRowCount(Cell cell) {
        return Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])IndexVerificationResultRepository.AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_BYTES, (int)0, (int)IndexVerificationResultRepository.AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_BYTES.length) == 0;
    }

    private long getValue(Cell cell) {
        return Long.parseLong(Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
    }

    public void update(Cell cell) {
        if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.SCANNED_DATA_ROW_COUNT_BYTES)) {
            this.addScannedDataRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.REBUILT_INDEX_ROW_COUNT_BYTES)) {
            this.addRebuiltIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT_BYTES)) {
            this.addBeforeRebuildValidIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT_BYTES)) {
            this.addBeforeRebuildExpiredIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT_BYTES)) {
            this.addBeforeRebuildMissingIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_BYTES)) {
            this.addBeforeRebuildInvalidIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT_BYTES)) {
            this.addBeforeRebuildBeyondMaxLookBackMissingIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT_BYTES)) {
            this.addBeforeRebuildBeyondMaxLookBackInvalidIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_EXTRA_CELLS_BYTES)) {
            this.addBeforeIndexHasExtraCellsCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_MISSING_CELLS_BYTES)) {
            this.addBeforeIndexHasMissingCellsCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT_BYTES)) {
            this.addBeforeUnverifiedIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.BEFORE_REBUILD_OLD_INDEX_ROW_COUNT_BYTES)) {
            this.addBeforeOldIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.BEFORE_REBUILD_UNKNOWN_INDEX_ROW_COUNT_BYTES)) {
            this.addBeforeUnknownIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.BEFORE_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT_BYTES)) {
            this.addBeforeRepairExtraVerifiedIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT_BYTES)) {
            this.addBeforeRepairExtraUnverifiedIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.AFTER_REBUILD_VALID_INDEX_ROW_COUNT_BYTES)) {
            this.addAfterRebuildValidIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.AFTER_REBUILD_EXPIRED_INDEX_ROW_COUNT_BYTES)) {
            this.addAfterRebuildExpiredIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.AFTER_REBUILD_MISSING_INDEX_ROW_COUNT_BYTES)) {
            this.addAfterRebuildMissingIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_BYTES)) {
            this.addAfterRebuildInvalidIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.AFTER_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT_BYTES)) {
            this.addAfterRebuildBeyondMaxLookBackMissingIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.AFTER_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT_BYTES)) {
            this.addAfterRebuildBeyondMaxLookBackInvalidIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_EXTRA_CELLS_BYTES)) {
            this.addAfterIndexHasExtraCellsCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.AFTER_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_MISSING_CELLS_BYTES)) {
            this.addAfterIndexHasMissingCellsCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.AFTER_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT_BYTES)) {
            this.addAfterRepairExtraVerifiedIndexRowCount(this.getValue(cell));
        } else if (CellUtil.matchingColumn((Cell)cell, (byte[])IndexVerificationResultRepository.RESULT_TABLE_COLUMN_FAMILY, (byte[])IndexVerificationResultRepository.AFTER_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT_BYTES)) {
            this.addAfterRepairExtraUnverifiedIndexRowCount(this.getValue(cell));
        }
    }

    public boolean isVerificationFailed() {
        return this.getAfter().getInvalidIndexRowCount() + this.getAfter().getMissingIndexRowCount() + this.getAfter().getExtraVerifiedIndexRowCount() > 0L;
    }

    public void add(IndexToolVerificationResult verificationResult) {
        this.setScannedDataRowCount(this.getScannedDataRowCount() + verificationResult.getScannedDataRowCount());
        this.setRebuiltIndexRowCount(this.getRebuiltIndexRowCount() + verificationResult.getRebuiltIndexRowCount());
        this.getBefore().add(verificationResult.getBefore());
        this.getAfter().add(verificationResult.getAfter());
    }

    public static class PhaseResult {
        private long validIndexRowCount = 0L;
        private long expiredIndexRowCount = 0L;
        private long missingIndexRowCount = 0L;
        private long invalidIndexRowCount = 0L;
        private long beyondMaxLookBackMissingIndexRowCount = 0L;
        private long beyondMaxLookBackInvalidIndexRowCount = 0L;
        private long indexHasExtraCellsCount = 0L;
        private long indexHasMissingCellsCount = 0L;
        private long unverifiedIndexRowCount = 0L;
        private long oldIndexRowCount = 0L;
        private long unknownIndexRowCount = 0L;
        private long extraVerifiedIndexRowCount = 0L;
        private long extraUnverifiedIndexRowCount = 0L;

        public void add(PhaseResult phaseResult) {
            this.setBeyondMaxLookBackMissingIndexRowCount(this.getBeyondMaxLookBackMissingIndexRowCount() + phaseResult.getBeyondMaxLookBackMissingIndexRowCount());
            this.setBeyondMaxLookBackInvalidIndexRowCount(this.getBeyondMaxLookBackInvalidIndexRowCount() + phaseResult.getBeyondMaxLookBackInvalidIndexRowCount());
            this.setValidIndexRowCount(this.getValidIndexRowCount() + phaseResult.getValidIndexRowCount());
            this.setExpiredIndexRowCount(this.getExpiredIndexRowCount() + phaseResult.getExpiredIndexRowCount());
            this.setMissingIndexRowCount(this.getMissingIndexRowCount() + phaseResult.getMissingIndexRowCount());
            this.setInvalidIndexRowCount(this.getInvalidIndexRowCount() + phaseResult.getInvalidIndexRowCount());
            this.setIndexHasExtraCellsCount(this.getIndexHasExtraCellsCount() + phaseResult.getIndexHasExtraCellsCount());
            this.setIndexHasMissingCellsCount(this.getIndexHasMissingCellsCount() + phaseResult.getIndexHasMissingCellsCount());
            this.setUnverifiedIndexRowCount(this.getUnverifiedIndexRowCount() + phaseResult.getUnverifiedIndexRowCount());
            this.setUnknownIndexRowCount(this.getUnknownIndexRowCount() + phaseResult.getUnknownIndexRowCount());
            this.setOldIndexRowCount(this.getOldIndexRowCount() + phaseResult.getOldIndexRowCount());
            this.setExtraVerifiedIndexRowCount(this.getExtraVerifiedIndexRowCount() + phaseResult.getExtraVerifiedIndexRowCount());
            this.setExtraUnverifiedIndexRowCount(this.getExtraUnverifiedIndexRowCount() + phaseResult.getExtraUnverifiedIndexRowCount());
        }

        public PhaseResult() {
        }

        public PhaseResult(long validIndexRowCount, long expiredIndexRowCount, long missingIndexRowCount, long invalidIndexRowCount, long beyondMaxLookBackMissingIndexRowCount, long beyondMaxLookBackInvalidIndexRowCount, long indexHasExtraCellsCount, long indexHasMissingCellsCount, long extraVerifiedIndexRowCount, long extraUnverifiedIndexRowCount) {
            this.setValidIndexRowCount(validIndexRowCount);
            this.setExpiredIndexRowCount(expiredIndexRowCount);
            this.setMissingIndexRowCount(missingIndexRowCount);
            this.setInvalidIndexRowCount(invalidIndexRowCount);
            this.setBeyondMaxLookBackInvalidIndexRowCount(beyondMaxLookBackInvalidIndexRowCount);
            this.setBeyondMaxLookBackMissingIndexRowCount(beyondMaxLookBackMissingIndexRowCount);
            this.setIndexHasExtraCellsCount(indexHasExtraCellsCount);
            this.setIndexHasMissingCellsCount(indexHasMissingCellsCount);
            this.setExtraVerifiedIndexRowCount(extraVerifiedIndexRowCount);
            this.setExtraUnverifiedIndexRowCount(extraUnverifiedIndexRowCount);
        }

        public long getTotalCount() {
            return this.getValidIndexRowCount() + this.getExpiredIndexRowCount() + this.getMissingIndexRowCount() + this.getInvalidIndexRowCount() + this.getBeyondMaxLookBackMissingIndexRowCount() + this.getBeyondMaxLookBackInvalidIndexRowCount();
        }

        public long getIndexHasExtraCellsCount() {
            return this.indexHasExtraCellsCount;
        }

        public long getIndexHasMissingCellsCount() {
            return this.indexHasMissingCellsCount;
        }

        public long getTotalExtraIndexRowsCount() {
            return this.getExtraVerifiedIndexRowCount() + this.getExtraUnverifiedIndexRowCount();
        }

        public String toString() {
            return "PhaseResult{validIndexRowCount=" + this.validIndexRowCount + ", expiredIndexRowCount=" + this.expiredIndexRowCount + ", missingIndexRowCount=" + this.missingIndexRowCount + ", invalidIndexRowCount=" + this.invalidIndexRowCount + ", beyondMaxLookBackMissingIndexRowCount=" + this.getBeyondMaxLookBackMissingIndexRowCount() + ", beyondMaxLookBackInvalidIndexRowCount=" + this.getBeyondMaxLookBackInvalidIndexRowCount() + ", extraCellsOnIndexCount=" + this.indexHasExtraCellsCount + ", missingCellsOnIndexCount=" + this.indexHasMissingCellsCount + ", unverifiedIndexRowCount=" + this.unverifiedIndexRowCount + ", oldIndexRowCount=" + this.oldIndexRowCount + ", unknownIndexRowCount=" + this.unknownIndexRowCount + ", extraVerifiedIndexRowCount=" + this.extraVerifiedIndexRowCount + ", extraUnverifiedIndexRowCount=" + this.extraUnverifiedIndexRowCount + '}';
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof PhaseResult)) {
                return false;
            }
            PhaseResult pr = (PhaseResult)o;
            return this.expiredIndexRowCount == pr.expiredIndexRowCount && this.validIndexRowCount == pr.validIndexRowCount && this.invalidIndexRowCount == pr.invalidIndexRowCount && this.missingIndexRowCount == pr.missingIndexRowCount && this.beyondMaxLookBackInvalidIndexRowCount == pr.beyondMaxLookBackInvalidIndexRowCount && this.beyondMaxLookBackMissingIndexRowCount == pr.beyondMaxLookBackMissingIndexRowCount && this.indexHasMissingCellsCount == pr.indexHasMissingCellsCount && this.indexHasExtraCellsCount == pr.indexHasExtraCellsCount && this.oldIndexRowCount == pr.oldIndexRowCount && this.unknownIndexRowCount == pr.unknownIndexRowCount && this.extraVerifiedIndexRowCount == pr.extraVerifiedIndexRowCount && this.extraUnverifiedIndexRowCount == pr.extraUnverifiedIndexRowCount;
        }

        public int hashCode() {
            long result = 17L;
            result = 31L * result + this.getExpiredIndexRowCount();
            result = 31L * result + this.getValidIndexRowCount();
            result = 31L * result + this.getMissingIndexRowCount();
            result = 31L * result + this.getInvalidIndexRowCount();
            result = 31L * result + this.getBeyondMaxLookBackMissingIndexRowCount();
            result = 31L * result + this.getBeyondMaxLookBackInvalidIndexRowCount();
            result = 31L * result + this.getIndexHasMissingCellsCount();
            result = 31L * result + this.getIndexHasExtraCellsCount();
            result = 31L * result + this.getUnverifiedIndexRowCount();
            result = 31L * result + this.getOldIndexRowCount();
            result = 31L * result + this.getUnknownIndexRowCount();
            result = 31L * result + this.getExtraVerifiedIndexRowCount();
            result = 31L * result + this.getExtraUnverifiedIndexRowCount();
            return (int)result;
        }

        public long getValidIndexRowCount() {
            return this.validIndexRowCount;
        }

        public void setValidIndexRowCount(long validIndexRowCount) {
            this.validIndexRowCount = validIndexRowCount;
        }

        public long getExpiredIndexRowCount() {
            return this.expiredIndexRowCount;
        }

        public void setExpiredIndexRowCount(long expiredIndexRowCount) {
            this.expiredIndexRowCount = expiredIndexRowCount;
        }

        public long getMissingIndexRowCount() {
            return this.missingIndexRowCount;
        }

        public void setMissingIndexRowCount(long missingIndexRowCount) {
            this.missingIndexRowCount = missingIndexRowCount;
        }

        public long getInvalidIndexRowCount() {
            return this.invalidIndexRowCount;
        }

        public void setInvalidIndexRowCount(long invalidIndexRowCount) {
            this.invalidIndexRowCount = invalidIndexRowCount;
        }

        public long getBeyondMaxLookBackMissingIndexRowCount() {
            return this.beyondMaxLookBackMissingIndexRowCount;
        }

        public void setBeyondMaxLookBackMissingIndexRowCount(long beyondMaxLookBackMissingIndexRowCount) {
            this.beyondMaxLookBackMissingIndexRowCount = beyondMaxLookBackMissingIndexRowCount;
        }

        public long getBeyondMaxLookBackInvalidIndexRowCount() {
            return this.beyondMaxLookBackInvalidIndexRowCount;
        }

        public void setBeyondMaxLookBackInvalidIndexRowCount(long beyondMaxLookBackInvalidIndexRowCount) {
            this.beyondMaxLookBackInvalidIndexRowCount = beyondMaxLookBackInvalidIndexRowCount;
        }

        public void setIndexHasMissingCellsCount(long indexHasMissingCellsCount) {
            this.indexHasMissingCellsCount = indexHasMissingCellsCount;
        }

        public void setIndexHasExtraCellsCount(long indexHasExtraCellsCount) {
            this.indexHasExtraCellsCount = indexHasExtraCellsCount;
        }

        public long getUnverifiedIndexRowCount() {
            return this.unverifiedIndexRowCount;
        }

        public void setUnverifiedIndexRowCount(long unverifiedIndexRowCount) {
            this.unverifiedIndexRowCount = unverifiedIndexRowCount;
        }

        public long getOldIndexRowCount() {
            return this.oldIndexRowCount;
        }

        public void setOldIndexRowCount(long oldIndexRowCount) {
            this.oldIndexRowCount = oldIndexRowCount;
        }

        public long getUnknownIndexRowCount() {
            return this.unknownIndexRowCount;
        }

        public void setUnknownIndexRowCount(long unknownIndexRowCount) {
            this.unknownIndexRowCount = unknownIndexRowCount;
        }

        public long getExtraVerifiedIndexRowCount() {
            return this.extraVerifiedIndexRowCount;
        }

        public void setExtraVerifiedIndexRowCount(long extraVerifiedIndexRowCount) {
            this.extraVerifiedIndexRowCount = extraVerifiedIndexRowCount;
        }

        public long getExtraUnverifiedIndexRowCount() {
            return this.extraUnverifiedIndexRowCount;
        }

        public void setExtraUnverifiedIndexRowCount(long extraUnverifiedIndexRowCount) {
            this.extraUnverifiedIndexRowCount = extraUnverifiedIndexRowCount;
        }
    }
}

