/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.committable.hbase.HBaseCommitTable;
import org.apache.omid.committable.hbase.HBaseCommitTableConfig;
import org.apache.omid.tools.hbase.HBaseLogin;
import org.apache.omid.transaction.AbstractTransaction;
import org.apache.omid.transaction.AbstractTransactionManager;
import org.apache.omid.transaction.CellUtils;
import org.apache.omid.transaction.CommitTimestampLocator;
import org.apache.omid.transaction.HBaseAsyncPostCommitter;
import org.apache.omid.transaction.HBaseCellId;
import org.apache.omid.transaction.HBaseOmidClientConfiguration;
import org.apache.omid.transaction.HBaseSyncPostCommitter;
import org.apache.omid.transaction.HBaseTransaction;
import org.apache.omid.transaction.HBaseTransactionClient;
import org.apache.omid.transaction.HTableAccessWrapper;
import org.apache.omid.transaction.PostCommitActions;
import org.apache.omid.transaction.TableAccessWrapper;
import org.apache.omid.transaction.TransactionException;
import org.apache.omid.transaction.TransactionManager;
import org.apache.omid.transaction.TransactionManagerException;
import org.apache.omid.tso.client.CellId;
import org.apache.omid.tso.client.OmidClientConfiguration;
import org.apache.omid.tso.client.TSOClient;
import org.apache.omid.tso.client.TSOProtocol;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.MoreExecutors;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseTransactionManager
extends AbstractTransactionManager
implements HBaseTransactionClient {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseTransactionManager.class);
    private final Connection connection;

    public static TransactionManager newInstance() throws IOException, InterruptedException {
        return HBaseTransactionManager.newInstance(new HBaseOmidClientConfiguration());
    }

    public static TransactionManager newInstance(HBaseOmidClientConfiguration configuration) throws IOException, InterruptedException {
        HBaseLogin.loginIfNeeded(configuration);
        return HBaseTransactionManager.builder(configuration).build();
    }

    public static Builder builder(HBaseOmidClientConfiguration hbaseOmidClientConf) {
        return new Builder(hbaseOmidClientConf);
    }

    private HBaseTransactionManager(HBaseOmidClientConfiguration hBaseOmidClientConfiguration, PostCommitActions postCommitter, TSOProtocol tsoClient, CommitTable.Client commitTableClient, CommitTable.Writer commitTableWriter, HBaseTransactionFactory hBaseTransactionFactory, Connection connection) {
        super(hBaseOmidClientConfiguration.getMetrics(), postCommitter, tsoClient, commitTableClient, commitTableWriter, hBaseTransactionFactory);
        this.connection = connection;
    }

    @Override
    public void closeResources() throws IOException {
        this.connection.close();
    }

    @Override
    public void preCommit(AbstractTransaction<? extends CellId> transaction) throws TransactionManagerException {
        try {
            HBaseTransaction hBaseTx = HBaseTransactionManager.enforceHBaseTransactionAsParam(transaction);
            hBaseTx.flushTables();
        }
        catch (IOException e) {
            throw new TransactionManagerException("Exception while flushing writes", e);
        }
    }

    @Override
    public void preRollback(AbstractTransaction<? extends CellId> transaction) throws TransactionManagerException {
        try {
            HBaseTransaction hBaseTx = HBaseTransactionManager.enforceHBaseTransactionAsParam(transaction);
            hBaseTx.flushTables();
        }
        catch (IOException e) {
            throw new TransactionManagerException("Exception while flushing writes", e);
        }
    }

    @Override
    public long getHashForTable(byte[] tableName) {
        return HBaseCellId.getHasher().putBytes(tableName).hash().asLong();
    }

    @Override
    public long getLowWatermark() throws TransactionException {
        try {
            return (Long)this.commitTableClient.readLowWatermark().get();
        }
        catch (ExecutionException ee) {
            throw new TransactionException("Error reading low watermark", ee.getCause());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new TransactionException("Interrupted reading low watermark", ie);
        }
    }

    static HBaseTransaction enforceHBaseTransactionAsParam(AbstractTransaction<? extends CellId> tx) {
        if (tx instanceof HBaseTransaction) {
            return (HBaseTransaction)tx;
        }
        throw new IllegalArgumentException("The transaction object passed is not an instance of HBaseTransaction");
    }

    public void setConflictDetectionLevel(OmidClientConfiguration.ConflictDetectionLevel conflictDetectionLevel) {
        this.tsoClient.setConflictDetectionLevel(conflictDetectionLevel);
    }

    public OmidClientConfiguration.ConflictDetectionLevel getConflictDetectionLevel() {
        return this.tsoClient.getConflictDetectionLevel();
    }

    static class CommitTimestampLocatorImpl
    implements CommitTimestampLocator {
        private HBaseCellId hBaseCellId;
        private final Map<Long, Long> commitCache;
        private TableAccessWrapper tableAccessWrapper;

        CommitTimestampLocatorImpl(HBaseCellId hBaseCellId, Map<Long, Long> commitCache, TableAccessWrapper tableAccessWrapper) {
            this.hBaseCellId = hBaseCellId;
            this.commitCache = commitCache;
            this.tableAccessWrapper = tableAccessWrapper;
        }

        CommitTimestampLocatorImpl(HBaseCellId hBaseCellId, Map<Long, Long> commitCache) {
            this.hBaseCellId = hBaseCellId;
            this.commitCache = commitCache;
            this.tableAccessWrapper = null;
            this.tableAccessWrapper = new HTableAccessWrapper(hBaseCellId.getTable().getHTable(), hBaseCellId.getTable().getHTable());
        }

        @Override
        public Optional<Long> readCommitTimestampFromCache(long startTimestamp) {
            if (this.commitCache.containsKey(startTimestamp)) {
                return Optional.of((Object)this.commitCache.get(startTimestamp));
            }
            return Optional.absent();
        }

        @Override
        public Optional<Long> readCommitTimestampFromShadowCell(long startTimestamp) throws IOException {
            Get get = new Get(this.hBaseCellId.getRow());
            byte[] family = this.hBaseCellId.getFamily();
            byte[] shadowCellQualifier = CellUtils.addShadowCellSuffixPrefix(this.hBaseCellId.getQualifier());
            get.addColumn(family, shadowCellQualifier);
            get.setMaxVersions(1);
            get.setTimeStamp(startTimestamp);
            Result result = this.tableAccessWrapper.get(get);
            if (result.containsColumn(family, shadowCellQualifier)) {
                return Optional.of((Object)Bytes.toLong((byte[])result.getValue(family, shadowCellQualifier)));
            }
            return Optional.absent();
        }
    }

    public static class Builder {
        private final HBaseOmidClientConfiguration hbaseOmidClientConf;
        private Optional<TSOProtocol> tsoClient = Optional.absent();
        private Optional<CommitTable.Client> commitTableClient = Optional.absent();
        private Optional<CommitTable.Writer> commitTableWriter = Optional.absent();
        private Optional<PostCommitActions> postCommitter = Optional.absent();

        public Builder(HBaseOmidClientConfiguration hbaseOmidClientConf) {
            this.hbaseOmidClientConf = hbaseOmidClientConf;
        }

        public Builder tsoClient(TSOProtocol tsoClient) {
            this.tsoClient = Optional.of((Object)tsoClient);
            return this;
        }

        public Builder commitTableClient(CommitTable.Client client) {
            this.commitTableClient = Optional.of((Object)client);
            return this;
        }

        public Builder commitTableWriter(CommitTable.Writer writer) {
            this.commitTableWriter = Optional.of((Object)writer);
            return this;
        }

        Builder postCommitter(PostCommitActions postCommitter) {
            this.postCommitter = Optional.of((Object)postCommitter);
            return this;
        }

        public HBaseTransactionManager build() throws IOException, InterruptedException {
            Connection connection = ConnectionFactory.createConnection((Configuration)this.hbaseOmidClientConf.getHBaseConfiguration());
            CommitTable.Client commitTableClient = (CommitTable.Client)this.commitTableClient.or(this.buildCommitTableClient(connection)).get();
            CommitTable.Writer commitTableWriter = (CommitTable.Writer)this.commitTableWriter.or(this.buildCommitTableWriter(connection)).get();
            PostCommitActions postCommitter = (PostCommitActions)this.postCommitter.or(this.buildPostCommitter(commitTableClient, connection)).get();
            TSOProtocol tsoClient = (TSOProtocol)this.tsoClient.or(this.buildTSOClient()).get();
            return new HBaseTransactionManager(this.hbaseOmidClientConf, postCommitter, tsoClient, commitTableClient, commitTableWriter, new HBaseTransactionFactory(), connection);
        }

        private Optional<TSOProtocol> buildTSOClient() throws IOException, InterruptedException {
            return Optional.of((Object)TSOClient.newInstance(this.hbaseOmidClientConf.getOmidClientConfiguration()));
        }

        private Optional<CommitTable.Client> buildCommitTableClient(Connection connection) throws IOException {
            HBaseCommitTableConfig commitTableConf = new HBaseCommitTableConfig();
            commitTableConf.setTableName(this.hbaseOmidClientConf.getCommitTableName());
            HBaseCommitTable commitTable = new HBaseCommitTable(connection, commitTableConf);
            return Optional.of((Object)commitTable.getClient());
        }

        private Optional<CommitTable.Writer> buildCommitTableWriter(Connection connection) throws IOException {
            HBaseCommitTableConfig commitTableConf = new HBaseCommitTableConfig();
            commitTableConf.setTableName(this.hbaseOmidClientConf.getCommitTableName());
            HBaseCommitTable commitTable = new HBaseCommitTable(connection, commitTableConf);
            return Optional.of((Object)commitTable.getWriter());
        }

        private Optional<PostCommitActions> buildPostCommitter(CommitTable.Client commitTableClient, Connection connection) {
            PostCommitActions postCommitter;
            HBaseSyncPostCommitter syncPostCommitter = new HBaseSyncPostCommitter(this.hbaseOmidClientConf.getMetrics(), commitTableClient, connection);
            switch (this.hbaseOmidClientConf.getPostCommitMode()) {
                case ASYNC: {
                    ListeningExecutorService postCommitExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("postCommit-%d").build()));
                    postCommitter = new HBaseAsyncPostCommitter(syncPostCommitter, postCommitExecutor);
                    break;
                }
                default: {
                    postCommitter = syncPostCommitter;
                }
            }
            return Optional.of((Object)postCommitter);
        }
    }

    private static class HBaseTransactionFactory
    implements AbstractTransactionManager.TransactionFactory<HBaseCellId> {
        private HBaseTransactionFactory() {
        }

        public HBaseTransaction createTransaction(long transactionId, long epoch, AbstractTransactionManager tm) {
            return new HBaseTransaction(transactionId, epoch, (Set<HBaseCellId>)new HashSet<HBaseCellId>(), (Set<HBaseCellId>)new HashSet<HBaseCellId>(), tm, tm.isLowLatency());
        }
    }
}

