/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.phoenix.flume.serializer;

import java.sql.SQLException;
import java.util.List;

import org.apache.flume.Context;
import org.apache.flume.Event;

public class CustomSerializer extends BaseEventSerializer {
    @Override
    public void doConfigure(Context context) {

    }

    @Override
    public void doInitialize() throws SQLException {

    }

    @Override
    public void upsertEvents(List<Event> events) throws SQLException {
        // Just execute a sample UPSERT
        connection.createStatement().execute("UPSERT INTO FLUME_TEST_EXTENDED(ID, COUNTS) VALUES(1, 1)");
        connection.commit();
    }
}
