/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

import org.apache.phoenix.expression.OrderByExpression;
import org.junit.Test;

/**
 * Test class for {@link OrderedResultIterator}.
 */
public class OrderedResultIteratorTest {

  @Test
  public void testNullIteratorOnClose() throws SQLException {
      ResultIterator delegate =  ResultIterator.EMPTY_ITERATOR;
      List<OrderByExpression> orderByExpressions = Collections.singletonList(null);
      int thresholdBytes = Integer.MAX_VALUE;
      OrderedResultIterator iterator = new OrderedResultIterator(delegate, orderByExpressions, thresholdBytes);
      // Should not throw an exception
      iterator.close();
  }

}
