/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.hbase.regionserver;


import java.util.List;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;

/**
 * @ScannerContext has all methods package visible. To properly update the context progress for our scanners we
 * need this helper
 */
public class ScannerContextUtil {
    public static void incrementSizeProgress(ScannerContext sc, List<Cell> cells) {
        for (Cell cell : cells) {
            sc.incrementSizeProgress(CellUtil.estimatedSerializedSizeOf(cell),
                    CellUtil.estimatedHeapSizeOf(cell));
        }
    }

    public static void updateTimeProgress(ScannerContext sc) {
        sc.updateTimeProgress();
    }
}
