/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * license agreements; and to You under the Apache License, version 2.0:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * This file is part of the Apache Pekko project, which was derived from Akka.
 */

/*
 * Copyright (C) 2019-2022 Lightbend Inc. <https://www.lightbend.com>
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ReplicatedDataMessages.proto

// Protobuf Java Version: 3.25.6
package org.apache.pekko.cluster.ddata.protobuf.msg;

public final class ReplicatedDataMessages {
  private ReplicatedDataMessages() {}
  public static void registerAllExtensions(
      org.apache.pekko.protobufv3.internal.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      org.apache.pekko.protobufv3.internal.ExtensionRegistry registry) {
    registerAllExtensions(
        (org.apache.pekko.protobufv3.internal.ExtensionRegistryLite) registry);
  }
  /**
   * Protobuf enum {@code org.apache.pekko.cluster.ddata.ORSetDeltaOp}
   */
  public enum ORSetDeltaOp
      implements org.apache.pekko.protobufv3.internal.ProtocolMessageEnum {
    /**
     * <code>Add = 0;</code>
     */
    Add(0),
    /**
     * <code>Remove = 1;</code>
     */
    Remove(1),
    /**
     * <code>Full = 2;</code>
     */
    Full(2),
    ;

    /**
     * <code>Add = 0;</code>
     */
    public static final int Add_VALUE = 0;
    /**
     * <code>Remove = 1;</code>
     */
    public static final int Remove_VALUE = 1;
    /**
     * <code>Full = 2;</code>
     */
    public static final int Full_VALUE = 2;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ORSetDeltaOp valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ORSetDeltaOp forNumber(int value) {
      switch (value) {
        case 0: return Add;
        case 1: return Remove;
        case 2: return Full;
        default: return null;
      }
    }

    public static org.apache.pekko.protobufv3.internal.Internal.EnumLiteMap<ORSetDeltaOp>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final org.apache.pekko.protobufv3.internal.Internal.EnumLiteMap<
        ORSetDeltaOp> internalValueMap =
          new org.apache.pekko.protobufv3.internal.Internal.EnumLiteMap<ORSetDeltaOp>() {
            public ORSetDeltaOp findValueByNumber(int number) {
              return ORSetDeltaOp.forNumber(number);
            }
          };

    public final org.apache.pekko.protobufv3.internal.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final org.apache.pekko.protobufv3.internal.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final org.apache.pekko.protobufv3.internal.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.getDescriptor().getEnumTypes().get(0);
    }

    private static final ORSetDeltaOp[] VALUES = values();

    public static ORSetDeltaOp valueOf(
        org.apache.pekko.protobufv3.internal.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ORSetDeltaOp(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:org.apache.pekko.cluster.ddata.ORSetDeltaOp)
  }

  /**
   * Protobuf enum {@code org.apache.pekko.cluster.ddata.ORMapDeltaOp}
   */
  public enum ORMapDeltaOp
      implements org.apache.pekko.protobufv3.internal.ProtocolMessageEnum {
    /**
     * <code>ORMapPut = 0;</code>
     */
    ORMapPut(0),
    /**
     * <code>ORMapRemove = 1;</code>
     */
    ORMapRemove(1),
    /**
     * <code>ORMapRemoveKey = 2;</code>
     */
    ORMapRemoveKey(2),
    /**
     * <code>ORMapUpdate = 3;</code>
     */
    ORMapUpdate(3),
    ;

    /**
     * <code>ORMapPut = 0;</code>
     */
    public static final int ORMapPut_VALUE = 0;
    /**
     * <code>ORMapRemove = 1;</code>
     */
    public static final int ORMapRemove_VALUE = 1;
    /**
     * <code>ORMapRemoveKey = 2;</code>
     */
    public static final int ORMapRemoveKey_VALUE = 2;
    /**
     * <code>ORMapUpdate = 3;</code>
     */
    public static final int ORMapUpdate_VALUE = 3;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ORMapDeltaOp valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ORMapDeltaOp forNumber(int value) {
      switch (value) {
        case 0: return ORMapPut;
        case 1: return ORMapRemove;
        case 2: return ORMapRemoveKey;
        case 3: return ORMapUpdate;
        default: return null;
      }
    }

    public static org.apache.pekko.protobufv3.internal.Internal.EnumLiteMap<ORMapDeltaOp>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final org.apache.pekko.protobufv3.internal.Internal.EnumLiteMap<
        ORMapDeltaOp> internalValueMap =
          new org.apache.pekko.protobufv3.internal.Internal.EnumLiteMap<ORMapDeltaOp>() {
            public ORMapDeltaOp findValueByNumber(int number) {
              return ORMapDeltaOp.forNumber(number);
            }
          };

    public final org.apache.pekko.protobufv3.internal.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final org.apache.pekko.protobufv3.internal.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final org.apache.pekko.protobufv3.internal.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.getDescriptor().getEnumTypes().get(1);
    }

    private static final ORMapDeltaOp[] VALUES = values();

    public static ORMapDeltaOp valueOf(
        org.apache.pekko.protobufv3.internal.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ORMapDeltaOp(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:org.apache.pekko.cluster.ddata.ORMapDeltaOp)
  }

  public interface GSetOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.GSet)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>repeated string stringElements = 1;</code>
     * @return A list containing the stringElements.
     */
    java.util.List<java.lang.String>
        getStringElementsList();
    /**
     * <code>repeated string stringElements = 1;</code>
     * @return The count of stringElements.
     */
    int getStringElementsCount();
    /**
     * <code>repeated string stringElements = 1;</code>
     * @param index The index of the element to return.
     * @return The stringElements at the given index.
     */
    java.lang.String getStringElements(int index);
    /**
     * <code>repeated string stringElements = 1;</code>
     * @param index The index of the value to return.
     * @return The bytes of the stringElements at the given index.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getStringElementsBytes(int index);

    /**
     * <code>repeated sint32 intElements = 2 [packed = true];</code>
     * @return A list containing the intElements.
     */
    java.util.List<java.lang.Integer> getIntElementsList();
    /**
     * <code>repeated sint32 intElements = 2 [packed = true];</code>
     * @return The count of intElements.
     */
    int getIntElementsCount();
    /**
     * <code>repeated sint32 intElements = 2 [packed = true];</code>
     * @param index The index of the element to return.
     * @return The intElements at the given index.
     */
    int getIntElements(int index);

    /**
     * <code>repeated sint64 longElements = 3 [packed = true];</code>
     * @return A list containing the longElements.
     */
    java.util.List<java.lang.Long> getLongElementsList();
    /**
     * <code>repeated sint64 longElements = 3 [packed = true];</code>
     * @return The count of longElements.
     */
    int getLongElementsCount();
    /**
     * <code>repeated sint64 longElements = 3 [packed = true];</code>
     * @param index The index of the element to return.
     * @return The longElements at the given index.
     */
    long getLongElements(int index);

    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
     */
    java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage> 
        getOtherElementsList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherElements(int index);
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
     */
    int getOtherElementsCount();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
     */
    java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
        getOtherElementsOrBuilderList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherElementsOrBuilder(
        int index);

    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 5;</code>
     * @return A list containing the actorRefElements.
     */
    java.util.List<java.lang.String>
        getActorRefElementsList();
    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 5;</code>
     * @return The count of actorRefElements.
     */
    int getActorRefElementsCount();
    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 5;</code>
     * @param index The index of the element to return.
     * @return The actorRefElements at the given index.
     */
    java.lang.String getActorRefElements(int index);
    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 5;</code>
     * @param index The index of the value to return.
     * @return The bytes of the actorRefElements at the given index.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getActorRefElementsBytes(int index);
  }
  /**
   * Protobuf type {@code org.apache.pekko.cluster.ddata.GSet}
   */
  public static final class GSet extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.GSet)
      GSetOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GSet.newBuilder() to construct.
    private GSet(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GSet() {
      stringElements_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
      intElements_ = emptyIntList();
      longElements_ = emptyLongList();
      otherElements_ = java.util.Collections.emptyList();
      actorRefElements_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new GSet();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_GSet_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_GSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet.Builder.class);
    }

    public static final int STRINGELEMENTS_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private org.apache.pekko.protobufv3.internal.LazyStringArrayList stringElements_ =
        org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
    /**
     * <code>repeated string stringElements = 1;</code>
     * @return A list containing the stringElements.
     */
    public org.apache.pekko.protobufv3.internal.ProtocolStringList
        getStringElementsList() {
      return stringElements_;
    }
    /**
     * <code>repeated string stringElements = 1;</code>
     * @return The count of stringElements.
     */
    public int getStringElementsCount() {
      return stringElements_.size();
    }
    /**
     * <code>repeated string stringElements = 1;</code>
     * @param index The index of the element to return.
     * @return The stringElements at the given index.
     */
    public java.lang.String getStringElements(int index) {
      return stringElements_.get(index);
    }
    /**
     * <code>repeated string stringElements = 1;</code>
     * @param index The index of the value to return.
     * @return The bytes of the stringElements at the given index.
     */
    public org.apache.pekko.protobufv3.internal.ByteString
        getStringElementsBytes(int index) {
      return stringElements_.getByteString(index);
    }

    public static final int INTELEMENTS_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private org.apache.pekko.protobufv3.internal.Internal.IntList intElements_ =
        emptyIntList();
    /**
     * <code>repeated sint32 intElements = 2 [packed = true];</code>
     * @return A list containing the intElements.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer>
        getIntElementsList() {
      return intElements_;
    }
    /**
     * <code>repeated sint32 intElements = 2 [packed = true];</code>
     * @return The count of intElements.
     */
    public int getIntElementsCount() {
      return intElements_.size();
    }
    /**
     * <code>repeated sint32 intElements = 2 [packed = true];</code>
     * @param index The index of the element to return.
     * @return The intElements at the given index.
     */
    public int getIntElements(int index) {
      return intElements_.getInt(index);
    }
    private int intElementsMemoizedSerializedSize = -1;

    public static final int LONGELEMENTS_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private org.apache.pekko.protobufv3.internal.Internal.LongList longElements_ =
        emptyLongList();
    /**
     * <code>repeated sint64 longElements = 3 [packed = true];</code>
     * @return A list containing the longElements.
     */
    @java.lang.Override
    public java.util.List<java.lang.Long>
        getLongElementsList() {
      return longElements_;
    }
    /**
     * <code>repeated sint64 longElements = 3 [packed = true];</code>
     * @return The count of longElements.
     */
    public int getLongElementsCount() {
      return longElements_.size();
    }
    /**
     * <code>repeated sint64 longElements = 3 [packed = true];</code>
     * @param index The index of the element to return.
     * @return The longElements at the given index.
     */
    public long getLongElements(int index) {
      return longElements_.getLong(index);
    }
    private int longElementsMemoizedSerializedSize = -1;

    public static final int OTHERELEMENTS_FIELD_NUMBER = 4;
    @SuppressWarnings("serial")
    private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage> otherElements_;
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage> getOtherElementsList() {
      return otherElements_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
        getOtherElementsOrBuilderList() {
      return otherElements_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
     */
    @java.lang.Override
    public int getOtherElementsCount() {
      return otherElements_.size();
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherElements(int index) {
      return otherElements_.get(index);
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherElementsOrBuilder(
        int index) {
      return otherElements_.get(index);
    }

    public static final int ACTORREFELEMENTS_FIELD_NUMBER = 5;
    @SuppressWarnings("serial")
    private org.apache.pekko.protobufv3.internal.LazyStringArrayList actorRefElements_ =
        org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 5;</code>
     * @return A list containing the actorRefElements.
     */
    public org.apache.pekko.protobufv3.internal.ProtocolStringList
        getActorRefElementsList() {
      return actorRefElements_;
    }
    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 5;</code>
     * @return The count of actorRefElements.
     */
    public int getActorRefElementsCount() {
      return actorRefElements_.size();
    }
    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 5;</code>
     * @param index The index of the element to return.
     * @return The actorRefElements at the given index.
     */
    public java.lang.String getActorRefElements(int index) {
      return actorRefElements_.get(index);
    }
    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 5;</code>
     * @param index The index of the value to return.
     * @return The bytes of the actorRefElements at the given index.
     */
    public org.apache.pekko.protobufv3.internal.ByteString
        getActorRefElementsBytes(int index) {
      return actorRefElements_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getOtherElementsCount(); i++) {
        if (!getOtherElements(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < stringElements_.size(); i++) {
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 1, stringElements_.getRaw(i));
      }
      if (getIntElementsList().size() > 0) {
        output.writeUInt32NoTag(18);
        output.writeUInt32NoTag(intElementsMemoizedSerializedSize);
      }
      for (int i = 0; i < intElements_.size(); i++) {
        output.writeSInt32NoTag(intElements_.getInt(i));
      }
      if (getLongElementsList().size() > 0) {
        output.writeUInt32NoTag(26);
        output.writeUInt32NoTag(longElementsMemoizedSerializedSize);
      }
      for (int i = 0; i < longElements_.size(); i++) {
        output.writeSInt64NoTag(longElements_.getLong(i));
      }
      for (int i = 0; i < otherElements_.size(); i++) {
        output.writeMessage(4, otherElements_.get(i));
      }
      for (int i = 0; i < actorRefElements_.size(); i++) {
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 5, actorRefElements_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < stringElements_.size(); i++) {
          dataSize += computeStringSizeNoTag(stringElements_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getStringElementsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < intElements_.size(); i++) {
          dataSize += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeSInt32SizeNoTag(intElements_.getInt(i));
        }
        size += dataSize;
        if (!getIntElementsList().isEmpty()) {
          size += 1;
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
              .computeInt32SizeNoTag(dataSize);
        }
        intElementsMemoizedSerializedSize = dataSize;
      }
      {
        int dataSize = 0;
        for (int i = 0; i < longElements_.size(); i++) {
          dataSize += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeSInt64SizeNoTag(longElements_.getLong(i));
        }
        size += dataSize;
        if (!getLongElementsList().isEmpty()) {
          size += 1;
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
              .computeInt32SizeNoTag(dataSize);
        }
        longElementsMemoizedSerializedSize = dataSize;
      }
      for (int i = 0; i < otherElements_.size(); i++) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(4, otherElements_.get(i));
      }
      {
        int dataSize = 0;
        for (int i = 0; i < actorRefElements_.size(); i++) {
          dataSize += computeStringSizeNoTag(actorRefElements_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getActorRefElementsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet)) {
        return super.equals(obj);
      }
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet) obj;

      if (!getStringElementsList()
          .equals(other.getStringElementsList())) return false;
      if (!getIntElementsList()
          .equals(other.getIntElementsList())) return false;
      if (!getLongElementsList()
          .equals(other.getLongElementsList())) return false;
      if (!getOtherElementsList()
          .equals(other.getOtherElementsList())) return false;
      if (!getActorRefElementsList()
          .equals(other.getActorRefElementsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getStringElementsCount() > 0) {
        hash = (37 * hash) + STRINGELEMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getStringElementsList().hashCode();
      }
      if (getIntElementsCount() > 0) {
        hash = (37 * hash) + INTELEMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getIntElementsList().hashCode();
      }
      if (getLongElementsCount() > 0) {
        hash = (37 * hash) + LONGELEMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getLongElementsList().hashCode();
      }
      if (getOtherElementsCount() > 0) {
        hash = (37 * hash) + OTHERELEMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getOtherElementsList().hashCode();
      }
      if (getActorRefElementsCount() > 0) {
        hash = (37 * hash) + ACTORREFELEMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getActorRefElementsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.GSet}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.GSet)
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSetOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_GSet_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_GSet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet.Builder.class);
      }

      // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet.newBuilder()
      private Builder() {

      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        stringElements_ =
            org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
        intElements_ = emptyIntList();
        longElements_ = emptyLongList();
        if (otherElementsBuilder_ == null) {
          otherElements_ = java.util.Collections.emptyList();
        } else {
          otherElements_ = null;
          otherElementsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        actorRefElements_ =
            org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_GSet_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet getDefaultInstanceForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet build() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet buildPartial() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet result) {
        if (otherElementsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            otherElements_ = java.util.Collections.unmodifiableList(otherElements_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.otherElements_ = otherElements_;
        } else {
          result.otherElements_ = otherElementsBuilder_.build();
        }
      }

      private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          stringElements_.makeImmutable();
          result.stringElements_ = stringElements_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          intElements_.makeImmutable();
          result.intElements_ = intElements_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          longElements_.makeImmutable();
          result.longElements_ = longElements_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          actorRefElements_.makeImmutable();
          result.actorRefElements_ = actorRefElements_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet) {
          return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet other) {
        if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet.getDefaultInstance()) return this;
        if (!other.stringElements_.isEmpty()) {
          if (stringElements_.isEmpty()) {
            stringElements_ = other.stringElements_;
            bitField0_ |= 0x00000001;
          } else {
            ensureStringElementsIsMutable();
            stringElements_.addAll(other.stringElements_);
          }
          onChanged();
        }
        if (!other.intElements_.isEmpty()) {
          if (intElements_.isEmpty()) {
            intElements_ = other.intElements_;
            intElements_.makeImmutable();
            bitField0_ |= 0x00000002;
          } else {
            ensureIntElementsIsMutable();
            intElements_.addAll(other.intElements_);
          }
          onChanged();
        }
        if (!other.longElements_.isEmpty()) {
          if (longElements_.isEmpty()) {
            longElements_ = other.longElements_;
            longElements_.makeImmutable();
            bitField0_ |= 0x00000004;
          } else {
            ensureLongElementsIsMutable();
            longElements_.addAll(other.longElements_);
          }
          onChanged();
        }
        if (otherElementsBuilder_ == null) {
          if (!other.otherElements_.isEmpty()) {
            if (otherElements_.isEmpty()) {
              otherElements_ = other.otherElements_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureOtherElementsIsMutable();
              otherElements_.addAll(other.otherElements_);
            }
            onChanged();
          }
        } else {
          if (!other.otherElements_.isEmpty()) {
            if (otherElementsBuilder_.isEmpty()) {
              otherElementsBuilder_.dispose();
              otherElementsBuilder_ = null;
              otherElements_ = other.otherElements_;
              bitField0_ = (bitField0_ & ~0x00000008);
              otherElementsBuilder_ = 
                org.apache.pekko.protobufv3.internal.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getOtherElementsFieldBuilder() : null;
            } else {
              otherElementsBuilder_.addAllMessages(other.otherElements_);
            }
          }
        }
        if (!other.actorRefElements_.isEmpty()) {
          if (actorRefElements_.isEmpty()) {
            actorRefElements_ = other.actorRefElements_;
            bitField0_ |= 0x00000010;
          } else {
            ensureActorRefElementsIsMutable();
            actorRefElements_.addAll(other.actorRefElements_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        for (int i = 0; i < getOtherElementsCount(); i++) {
          if (!getOtherElements(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                org.apache.pekko.protobufv3.internal.ByteString bs = input.readBytes();
                ensureStringElementsIsMutable();
                stringElements_.add(bs);
                break;
              } // case 10
              case 16: {
                int v = input.readSInt32();
                ensureIntElementsIsMutable();
                intElements_.addInt(v);
                break;
              } // case 16
              case 18: {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureIntElementsIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  intElements_.addInt(input.readSInt32());
                }
                input.popLimit(limit);
                break;
              } // case 18
              case 24: {
                long v = input.readSInt64();
                ensureLongElementsIsMutable();
                longElements_.addLong(v);
                break;
              } // case 24
              case 26: {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureLongElementsIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  longElements_.addLong(input.readSInt64());
                }
                input.popLimit(limit);
                break;
              } // case 26
              case 34: {
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage m =
                    input.readMessage(
                        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.PARSER,
                        extensionRegistry);
                if (otherElementsBuilder_ == null) {
                  ensureOtherElementsIsMutable();
                  otherElements_.add(m);
                } else {
                  otherElementsBuilder_.addMessage(m);
                }
                break;
              } // case 34
              case 42: {
                org.apache.pekko.protobufv3.internal.ByteString bs = input.readBytes();
                ensureActorRefElementsIsMutable();
                actorRefElements_.add(bs);
                break;
              } // case 42
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.protobufv3.internal.LazyStringArrayList stringElements_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
      private void ensureStringElementsIsMutable() {
        if (!stringElements_.isModifiable()) {
          stringElements_ = new org.apache.pekko.protobufv3.internal.LazyStringArrayList(stringElements_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       * <code>repeated string stringElements = 1;</code>
       * @return A list containing the stringElements.
       */
      public org.apache.pekko.protobufv3.internal.ProtocolStringList
          getStringElementsList() {
        stringElements_.makeImmutable();
        return stringElements_;
      }
      /**
       * <code>repeated string stringElements = 1;</code>
       * @return The count of stringElements.
       */
      public int getStringElementsCount() {
        return stringElements_.size();
      }
      /**
       * <code>repeated string stringElements = 1;</code>
       * @param index The index of the element to return.
       * @return The stringElements at the given index.
       */
      public java.lang.String getStringElements(int index) {
        return stringElements_.get(index);
      }
      /**
       * <code>repeated string stringElements = 1;</code>
       * @param index The index of the value to return.
       * @return The bytes of the stringElements at the given index.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getStringElementsBytes(int index) {
        return stringElements_.getByteString(index);
      }
      /**
       * <code>repeated string stringElements = 1;</code>
       * @param index The index to set the value at.
       * @param value The stringElements to set.
       * @return This builder for chaining.
       */
      public Builder setStringElements(
          int index, java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureStringElementsIsMutable();
        stringElements_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>repeated string stringElements = 1;</code>
       * @param value The stringElements to add.
       * @return This builder for chaining.
       */
      public Builder addStringElements(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureStringElementsIsMutable();
        stringElements_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>repeated string stringElements = 1;</code>
       * @param values The stringElements to add.
       * @return This builder for chaining.
       */
      public Builder addAllStringElements(
          java.lang.Iterable<java.lang.String> values) {
        ensureStringElementsIsMutable();
        org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
            values, stringElements_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>repeated string stringElements = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStringElements() {
        stringElements_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);;
        onChanged();
        return this;
      }
      /**
       * <code>repeated string stringElements = 1;</code>
       * @param value The bytes of the stringElements to add.
       * @return This builder for chaining.
       */
      public Builder addStringElementsBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        ensureStringElementsIsMutable();
        stringElements_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.Internal.IntList intElements_ = emptyIntList();
      private void ensureIntElementsIsMutable() {
        if (!intElements_.isModifiable()) {
          intElements_ = makeMutableCopy(intElements_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       * <code>repeated sint32 intElements = 2 [packed = true];</code>
       * @return A list containing the intElements.
       */
      public java.util.List<java.lang.Integer>
          getIntElementsList() {
        intElements_.makeImmutable();
        return intElements_;
      }
      /**
       * <code>repeated sint32 intElements = 2 [packed = true];</code>
       * @return The count of intElements.
       */
      public int getIntElementsCount() {
        return intElements_.size();
      }
      /**
       * <code>repeated sint32 intElements = 2 [packed = true];</code>
       * @param index The index of the element to return.
       * @return The intElements at the given index.
       */
      public int getIntElements(int index) {
        return intElements_.getInt(index);
      }
      /**
       * <code>repeated sint32 intElements = 2 [packed = true];</code>
       * @param index The index to set the value at.
       * @param value The intElements to set.
       * @return This builder for chaining.
       */
      public Builder setIntElements(
          int index, int value) {

        ensureIntElementsIsMutable();
        intElements_.setInt(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>repeated sint32 intElements = 2 [packed = true];</code>
       * @param value The intElements to add.
       * @return This builder for chaining.
       */
      public Builder addIntElements(int value) {

        ensureIntElementsIsMutable();
        intElements_.addInt(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>repeated sint32 intElements = 2 [packed = true];</code>
       * @param values The intElements to add.
       * @return This builder for chaining.
       */
      public Builder addAllIntElements(
          java.lang.Iterable<? extends java.lang.Integer> values) {
        ensureIntElementsIsMutable();
        org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
            values, intElements_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>repeated sint32 intElements = 2 [packed = true];</code>
       * @return This builder for chaining.
       */
      public Builder clearIntElements() {
        intElements_ = emptyIntList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.Internal.LongList longElements_ = emptyLongList();
      private void ensureLongElementsIsMutable() {
        if (!longElements_.isModifiable()) {
          longElements_ = makeMutableCopy(longElements_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       * <code>repeated sint64 longElements = 3 [packed = true];</code>
       * @return A list containing the longElements.
       */
      public java.util.List<java.lang.Long>
          getLongElementsList() {
        longElements_.makeImmutable();
        return longElements_;
      }
      /**
       * <code>repeated sint64 longElements = 3 [packed = true];</code>
       * @return The count of longElements.
       */
      public int getLongElementsCount() {
        return longElements_.size();
      }
      /**
       * <code>repeated sint64 longElements = 3 [packed = true];</code>
       * @param index The index of the element to return.
       * @return The longElements at the given index.
       */
      public long getLongElements(int index) {
        return longElements_.getLong(index);
      }
      /**
       * <code>repeated sint64 longElements = 3 [packed = true];</code>
       * @param index The index to set the value at.
       * @param value The longElements to set.
       * @return This builder for chaining.
       */
      public Builder setLongElements(
          int index, long value) {

        ensureLongElementsIsMutable();
        longElements_.setLong(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>repeated sint64 longElements = 3 [packed = true];</code>
       * @param value The longElements to add.
       * @return This builder for chaining.
       */
      public Builder addLongElements(long value) {

        ensureLongElementsIsMutable();
        longElements_.addLong(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>repeated sint64 longElements = 3 [packed = true];</code>
       * @param values The longElements to add.
       * @return This builder for chaining.
       */
      public Builder addAllLongElements(
          java.lang.Iterable<? extends java.lang.Long> values) {
        ensureLongElementsIsMutable();
        org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
            values, longElements_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>repeated sint64 longElements = 3 [packed = true];</code>
       * @return This builder for chaining.
       */
      public Builder clearLongElements() {
        longElements_ = emptyLongList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage> otherElements_ =
        java.util.Collections.emptyList();
      private void ensureOtherElementsIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          otherElements_ = new java.util.ArrayList<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage>(otherElements_);
          bitField0_ |= 0x00000008;
         }
      }

      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> otherElementsBuilder_;

      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage> getOtherElementsList() {
        if (otherElementsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(otherElements_);
        } else {
          return otherElementsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public int getOtherElementsCount() {
        if (otherElementsBuilder_ == null) {
          return otherElements_.size();
        } else {
          return otherElementsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherElements(int index) {
        if (otherElementsBuilder_ == null) {
          return otherElements_.get(index);
        } else {
          return otherElementsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public Builder setOtherElements(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
        if (otherElementsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOtherElementsIsMutable();
          otherElements_.set(index, value);
          onChanged();
        } else {
          otherElementsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public Builder setOtherElements(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder builderForValue) {
        if (otherElementsBuilder_ == null) {
          ensureOtherElementsIsMutable();
          otherElements_.set(index, builderForValue.build());
          onChanged();
        } else {
          otherElementsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public Builder addOtherElements(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
        if (otherElementsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOtherElementsIsMutable();
          otherElements_.add(value);
          onChanged();
        } else {
          otherElementsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public Builder addOtherElements(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
        if (otherElementsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOtherElementsIsMutable();
          otherElements_.add(index, value);
          onChanged();
        } else {
          otherElementsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public Builder addOtherElements(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder builderForValue) {
        if (otherElementsBuilder_ == null) {
          ensureOtherElementsIsMutable();
          otherElements_.add(builderForValue.build());
          onChanged();
        } else {
          otherElementsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public Builder addOtherElements(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder builderForValue) {
        if (otherElementsBuilder_ == null) {
          ensureOtherElementsIsMutable();
          otherElements_.add(index, builderForValue.build());
          onChanged();
        } else {
          otherElementsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public Builder addAllOtherElements(
          java.lang.Iterable<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage> values) {
        if (otherElementsBuilder_ == null) {
          ensureOtherElementsIsMutable();
          org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
              values, otherElements_);
          onChanged();
        } else {
          otherElementsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public Builder clearOtherElements() {
        if (otherElementsBuilder_ == null) {
          otherElements_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          otherElementsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public Builder removeOtherElements(int index) {
        if (otherElementsBuilder_ == null) {
          ensureOtherElementsIsMutable();
          otherElements_.remove(index);
          onChanged();
        } else {
          otherElementsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder getOtherElementsBuilder(
          int index) {
        return getOtherElementsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherElementsOrBuilder(
          int index) {
        if (otherElementsBuilder_ == null) {
          return otherElements_.get(index);  } else {
          return otherElementsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
           getOtherElementsOrBuilderList() {
        if (otherElementsBuilder_ != null) {
          return otherElementsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(otherElements_);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder addOtherElementsBuilder() {
        return getOtherElementsFieldBuilder().addBuilder(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder addOtherElementsBuilder(
          int index) {
        return getOtherElementsFieldBuilder().addBuilder(
            index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 4;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder> 
           getOtherElementsBuilderList() {
        return getOtherElementsFieldBuilder().getBuilderList();
      }
      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
          getOtherElementsFieldBuilder() {
        if (otherElementsBuilder_ == null) {
          otherElementsBuilder_ = new org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder>(
                  otherElements_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          otherElements_ = null;
        }
        return otherElementsBuilder_;
      }

      private org.apache.pekko.protobufv3.internal.LazyStringArrayList actorRefElements_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
      private void ensureActorRefElementsIsMutable() {
        if (!actorRefElements_.isModifiable()) {
          actorRefElements_ = new org.apache.pekko.protobufv3.internal.LazyStringArrayList(actorRefElements_);
        }
        bitField0_ |= 0x00000010;
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 5;</code>
       * @return A list containing the actorRefElements.
       */
      public org.apache.pekko.protobufv3.internal.ProtocolStringList
          getActorRefElementsList() {
        actorRefElements_.makeImmutable();
        return actorRefElements_;
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 5;</code>
       * @return The count of actorRefElements.
       */
      public int getActorRefElementsCount() {
        return actorRefElements_.size();
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 5;</code>
       * @param index The index of the element to return.
       * @return The actorRefElements at the given index.
       */
      public java.lang.String getActorRefElements(int index) {
        return actorRefElements_.get(index);
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 5;</code>
       * @param index The index of the value to return.
       * @return The bytes of the actorRefElements at the given index.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getActorRefElementsBytes(int index) {
        return actorRefElements_.getByteString(index);
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 5;</code>
       * @param index The index to set the value at.
       * @param value The actorRefElements to set.
       * @return This builder for chaining.
       */
      public Builder setActorRefElements(
          int index, java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureActorRefElementsIsMutable();
        actorRefElements_.set(index, value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 5;</code>
       * @param value The actorRefElements to add.
       * @return This builder for chaining.
       */
      public Builder addActorRefElements(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureActorRefElementsIsMutable();
        actorRefElements_.add(value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 5;</code>
       * @param values The actorRefElements to add.
       * @return This builder for chaining.
       */
      public Builder addAllActorRefElements(
          java.lang.Iterable<java.lang.String> values) {
        ensureActorRefElementsIsMutable();
        org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
            values, actorRefElements_);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearActorRefElements() {
        actorRefElements_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 5;</code>
       * @param value The bytes of the actorRefElements to add.
       * @return This builder for chaining.
       */
      public Builder addActorRefElementsBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        ensureActorRefElementsIsMutable();
        actorRefElements_.add(value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.GSet)
    }

    // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.GSet)
    private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet();
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<GSet>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<GSet>() {
      @java.lang.Override
      public GSet parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<GSet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<GSet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GSet getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ORSetOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.ORSet)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required .org.apache.pekko.cluster.ddata.VersionVector vvector = 1;</code>
     * @return Whether the vvector field is set.
     */
    boolean hasVvector();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.VersionVector vvector = 1;</code>
     * @return The vvector.
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector getVvector();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.VersionVector vvector = 1;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVectorOrBuilder getVvectorOrBuilder();

    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
     */
    java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector> 
        getDotsList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector getDots(int index);
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
     */
    int getDotsCount();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
     */
    java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVectorOrBuilder> 
        getDotsOrBuilderList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVectorOrBuilder getDotsOrBuilder(
        int index);

    /**
     * <code>repeated string stringElements = 3;</code>
     * @return A list containing the stringElements.
     */
    java.util.List<java.lang.String>
        getStringElementsList();
    /**
     * <code>repeated string stringElements = 3;</code>
     * @return The count of stringElements.
     */
    int getStringElementsCount();
    /**
     * <code>repeated string stringElements = 3;</code>
     * @param index The index of the element to return.
     * @return The stringElements at the given index.
     */
    java.lang.String getStringElements(int index);
    /**
     * <code>repeated string stringElements = 3;</code>
     * @param index The index of the value to return.
     * @return The bytes of the stringElements at the given index.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getStringElementsBytes(int index);

    /**
     * <code>repeated sint32 intElements = 4 [packed = true];</code>
     * @return A list containing the intElements.
     */
    java.util.List<java.lang.Integer> getIntElementsList();
    /**
     * <code>repeated sint32 intElements = 4 [packed = true];</code>
     * @return The count of intElements.
     */
    int getIntElementsCount();
    /**
     * <code>repeated sint32 intElements = 4 [packed = true];</code>
     * @param index The index of the element to return.
     * @return The intElements at the given index.
     */
    int getIntElements(int index);

    /**
     * <code>repeated sint64 longElements = 5 [packed = true];</code>
     * @return A list containing the longElements.
     */
    java.util.List<java.lang.Long> getLongElementsList();
    /**
     * <code>repeated sint64 longElements = 5 [packed = true];</code>
     * @return The count of longElements.
     */
    int getLongElementsCount();
    /**
     * <code>repeated sint64 longElements = 5 [packed = true];</code>
     * @param index The index of the element to return.
     * @return The longElements at the given index.
     */
    long getLongElements(int index);

    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
     */
    java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage> 
        getOtherElementsList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherElements(int index);
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
     */
    int getOtherElementsCount();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
     */
    java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
        getOtherElementsOrBuilderList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherElementsOrBuilder(
        int index);

    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 7;</code>
     * @return A list containing the actorRefElements.
     */
    java.util.List<java.lang.String>
        getActorRefElementsList();
    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 7;</code>
     * @return The count of actorRefElements.
     */
    int getActorRefElementsCount();
    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 7;</code>
     * @param index The index of the element to return.
     * @return The actorRefElements at the given index.
     */
    java.lang.String getActorRefElements(int index);
    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 7;</code>
     * @param index The index of the value to return.
     * @return The bytes of the actorRefElements at the given index.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getActorRefElementsBytes(int index);
  }
  /**
   * Protobuf type {@code org.apache.pekko.cluster.ddata.ORSet}
   */
  public static final class ORSet extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.ORSet)
      ORSetOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ORSet.newBuilder() to construct.
    private ORSet(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ORSet() {
      dots_ = java.util.Collections.emptyList();
      stringElements_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
      intElements_ = emptyIntList();
      longElements_ = emptyLongList();
      otherElements_ = java.util.Collections.emptyList();
      actorRefElements_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new ORSet();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORSet_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder.class);
    }

    private int bitField0_;
    public static final int VVECTOR_FIELD_NUMBER = 1;
    private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector vvector_;
    /**
     * <code>required .org.apache.pekko.cluster.ddata.VersionVector vvector = 1;</code>
     * @return Whether the vvector field is set.
     */
    @java.lang.Override
    public boolean hasVvector() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.VersionVector vvector = 1;</code>
     * @return The vvector.
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector getVvector() {
      return vvector_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.getDefaultInstance() : vvector_;
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.VersionVector vvector = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVectorOrBuilder getVvectorOrBuilder() {
      return vvector_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.getDefaultInstance() : vvector_;
    }

    public static final int DOTS_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector> dots_;
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector> getDotsList() {
      return dots_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVectorOrBuilder> 
        getDotsOrBuilderList() {
      return dots_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
     */
    @java.lang.Override
    public int getDotsCount() {
      return dots_.size();
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector getDots(int index) {
      return dots_.get(index);
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVectorOrBuilder getDotsOrBuilder(
        int index) {
      return dots_.get(index);
    }

    public static final int STRINGELEMENTS_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private org.apache.pekko.protobufv3.internal.LazyStringArrayList stringElements_ =
        org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
    /**
     * <code>repeated string stringElements = 3;</code>
     * @return A list containing the stringElements.
     */
    public org.apache.pekko.protobufv3.internal.ProtocolStringList
        getStringElementsList() {
      return stringElements_;
    }
    /**
     * <code>repeated string stringElements = 3;</code>
     * @return The count of stringElements.
     */
    public int getStringElementsCount() {
      return stringElements_.size();
    }
    /**
     * <code>repeated string stringElements = 3;</code>
     * @param index The index of the element to return.
     * @return The stringElements at the given index.
     */
    public java.lang.String getStringElements(int index) {
      return stringElements_.get(index);
    }
    /**
     * <code>repeated string stringElements = 3;</code>
     * @param index The index of the value to return.
     * @return The bytes of the stringElements at the given index.
     */
    public org.apache.pekko.protobufv3.internal.ByteString
        getStringElementsBytes(int index) {
      return stringElements_.getByteString(index);
    }

    public static final int INTELEMENTS_FIELD_NUMBER = 4;
    @SuppressWarnings("serial")
    private org.apache.pekko.protobufv3.internal.Internal.IntList intElements_ =
        emptyIntList();
    /**
     * <code>repeated sint32 intElements = 4 [packed = true];</code>
     * @return A list containing the intElements.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer>
        getIntElementsList() {
      return intElements_;
    }
    /**
     * <code>repeated sint32 intElements = 4 [packed = true];</code>
     * @return The count of intElements.
     */
    public int getIntElementsCount() {
      return intElements_.size();
    }
    /**
     * <code>repeated sint32 intElements = 4 [packed = true];</code>
     * @param index The index of the element to return.
     * @return The intElements at the given index.
     */
    public int getIntElements(int index) {
      return intElements_.getInt(index);
    }
    private int intElementsMemoizedSerializedSize = -1;

    public static final int LONGELEMENTS_FIELD_NUMBER = 5;
    @SuppressWarnings("serial")
    private org.apache.pekko.protobufv3.internal.Internal.LongList longElements_ =
        emptyLongList();
    /**
     * <code>repeated sint64 longElements = 5 [packed = true];</code>
     * @return A list containing the longElements.
     */
    @java.lang.Override
    public java.util.List<java.lang.Long>
        getLongElementsList() {
      return longElements_;
    }
    /**
     * <code>repeated sint64 longElements = 5 [packed = true];</code>
     * @return The count of longElements.
     */
    public int getLongElementsCount() {
      return longElements_.size();
    }
    /**
     * <code>repeated sint64 longElements = 5 [packed = true];</code>
     * @param index The index of the element to return.
     * @return The longElements at the given index.
     */
    public long getLongElements(int index) {
      return longElements_.getLong(index);
    }
    private int longElementsMemoizedSerializedSize = -1;

    public static final int OTHERELEMENTS_FIELD_NUMBER = 6;
    @SuppressWarnings("serial")
    private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage> otherElements_;
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage> getOtherElementsList() {
      return otherElements_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
        getOtherElementsOrBuilderList() {
      return otherElements_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
     */
    @java.lang.Override
    public int getOtherElementsCount() {
      return otherElements_.size();
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherElements(int index) {
      return otherElements_.get(index);
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherElementsOrBuilder(
        int index) {
      return otherElements_.get(index);
    }

    public static final int ACTORREFELEMENTS_FIELD_NUMBER = 7;
    @SuppressWarnings("serial")
    private org.apache.pekko.protobufv3.internal.LazyStringArrayList actorRefElements_ =
        org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 7;</code>
     * @return A list containing the actorRefElements.
     */
    public org.apache.pekko.protobufv3.internal.ProtocolStringList
        getActorRefElementsList() {
      return actorRefElements_;
    }
    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 7;</code>
     * @return The count of actorRefElements.
     */
    public int getActorRefElementsCount() {
      return actorRefElements_.size();
    }
    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 7;</code>
     * @param index The index of the element to return.
     * @return The actorRefElements at the given index.
     */
    public java.lang.String getActorRefElements(int index) {
      return actorRefElements_.get(index);
    }
    /**
     * <pre>
     * added in Akka 2.5.14
     * </pre>
     *
     * <code>repeated string actorRefElements = 7;</code>
     * @param index The index of the value to return.
     * @return The bytes of the actorRefElements at the given index.
     */
    public org.apache.pekko.protobufv3.internal.ByteString
        getActorRefElementsBytes(int index) {
      return actorRefElements_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasVvector()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getVvector().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getDotsCount(); i++) {
        if (!getDots(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getOtherElementsCount(); i++) {
        if (!getOtherElements(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getVvector());
      }
      for (int i = 0; i < dots_.size(); i++) {
        output.writeMessage(2, dots_.get(i));
      }
      for (int i = 0; i < stringElements_.size(); i++) {
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 3, stringElements_.getRaw(i));
      }
      if (getIntElementsList().size() > 0) {
        output.writeUInt32NoTag(34);
        output.writeUInt32NoTag(intElementsMemoizedSerializedSize);
      }
      for (int i = 0; i < intElements_.size(); i++) {
        output.writeSInt32NoTag(intElements_.getInt(i));
      }
      if (getLongElementsList().size() > 0) {
        output.writeUInt32NoTag(42);
        output.writeUInt32NoTag(longElementsMemoizedSerializedSize);
      }
      for (int i = 0; i < longElements_.size(); i++) {
        output.writeSInt64NoTag(longElements_.getLong(i));
      }
      for (int i = 0; i < otherElements_.size(); i++) {
        output.writeMessage(6, otherElements_.get(i));
      }
      for (int i = 0; i < actorRefElements_.size(); i++) {
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 7, actorRefElements_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getVvector());
      }
      for (int i = 0; i < dots_.size(); i++) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, dots_.get(i));
      }
      {
        int dataSize = 0;
        for (int i = 0; i < stringElements_.size(); i++) {
          dataSize += computeStringSizeNoTag(stringElements_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getStringElementsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < intElements_.size(); i++) {
          dataSize += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeSInt32SizeNoTag(intElements_.getInt(i));
        }
        size += dataSize;
        if (!getIntElementsList().isEmpty()) {
          size += 1;
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
              .computeInt32SizeNoTag(dataSize);
        }
        intElementsMemoizedSerializedSize = dataSize;
      }
      {
        int dataSize = 0;
        for (int i = 0; i < longElements_.size(); i++) {
          dataSize += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeSInt64SizeNoTag(longElements_.getLong(i));
        }
        size += dataSize;
        if (!getLongElementsList().isEmpty()) {
          size += 1;
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
              .computeInt32SizeNoTag(dataSize);
        }
        longElementsMemoizedSerializedSize = dataSize;
      }
      for (int i = 0; i < otherElements_.size(); i++) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(6, otherElements_.get(i));
      }
      {
        int dataSize = 0;
        for (int i = 0; i < actorRefElements_.size(); i++) {
          dataSize += computeStringSizeNoTag(actorRefElements_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getActorRefElementsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet)) {
        return super.equals(obj);
      }
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet) obj;

      if (hasVvector() != other.hasVvector()) return false;
      if (hasVvector()) {
        if (!getVvector()
            .equals(other.getVvector())) return false;
      }
      if (!getDotsList()
          .equals(other.getDotsList())) return false;
      if (!getStringElementsList()
          .equals(other.getStringElementsList())) return false;
      if (!getIntElementsList()
          .equals(other.getIntElementsList())) return false;
      if (!getLongElementsList()
          .equals(other.getLongElementsList())) return false;
      if (!getOtherElementsList()
          .equals(other.getOtherElementsList())) return false;
      if (!getActorRefElementsList()
          .equals(other.getActorRefElementsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasVvector()) {
        hash = (37 * hash) + VVECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getVvector().hashCode();
      }
      if (getDotsCount() > 0) {
        hash = (37 * hash) + DOTS_FIELD_NUMBER;
        hash = (53 * hash) + getDotsList().hashCode();
      }
      if (getStringElementsCount() > 0) {
        hash = (37 * hash) + STRINGELEMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getStringElementsList().hashCode();
      }
      if (getIntElementsCount() > 0) {
        hash = (37 * hash) + INTELEMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getIntElementsList().hashCode();
      }
      if (getLongElementsCount() > 0) {
        hash = (37 * hash) + LONGELEMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getLongElementsList().hashCode();
      }
      if (getOtherElementsCount() > 0) {
        hash = (37 * hash) + OTHERELEMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getOtherElementsList().hashCode();
      }
      if (getActorRefElementsCount() > 0) {
        hash = (37 * hash) + ACTORREFELEMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getActorRefElementsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.ORSet}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.ORSet)
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORSet_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORSet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder.class);
      }

      // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getVvectorFieldBuilder();
          getDotsFieldBuilder();
          getOtherElementsFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        vvector_ = null;
        if (vvectorBuilder_ != null) {
          vvectorBuilder_.dispose();
          vvectorBuilder_ = null;
        }
        if (dotsBuilder_ == null) {
          dots_ = java.util.Collections.emptyList();
        } else {
          dots_ = null;
          dotsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        stringElements_ =
            org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
        intElements_ = emptyIntList();
        longElements_ = emptyLongList();
        if (otherElementsBuilder_ == null) {
          otherElements_ = java.util.Collections.emptyList();
        } else {
          otherElements_ = null;
          otherElementsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        actorRefElements_ =
            org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORSet_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getDefaultInstanceForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet build() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet buildPartial() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet result) {
        if (dotsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            dots_ = java.util.Collections.unmodifiableList(dots_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.dots_ = dots_;
        } else {
          result.dots_ = dotsBuilder_.build();
        }
        if (otherElementsBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)) {
            otherElements_ = java.util.Collections.unmodifiableList(otherElements_);
            bitField0_ = (bitField0_ & ~0x00000020);
          }
          result.otherElements_ = otherElements_;
        } else {
          result.otherElements_ = otherElementsBuilder_.build();
        }
      }

      private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.vvector_ = vvectorBuilder_ == null
              ? vvector_
              : vvectorBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          stringElements_.makeImmutable();
          result.stringElements_ = stringElements_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          intElements_.makeImmutable();
          result.intElements_ = intElements_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          longElements_.makeImmutable();
          result.longElements_ = longElements_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          actorRefElements_.makeImmutable();
          result.actorRefElements_ = actorRefElements_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet) {
          return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet other) {
        if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance()) return this;
        if (other.hasVvector()) {
          mergeVvector(other.getVvector());
        }
        if (dotsBuilder_ == null) {
          if (!other.dots_.isEmpty()) {
            if (dots_.isEmpty()) {
              dots_ = other.dots_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureDotsIsMutable();
              dots_.addAll(other.dots_);
            }
            onChanged();
          }
        } else {
          if (!other.dots_.isEmpty()) {
            if (dotsBuilder_.isEmpty()) {
              dotsBuilder_.dispose();
              dotsBuilder_ = null;
              dots_ = other.dots_;
              bitField0_ = (bitField0_ & ~0x00000002);
              dotsBuilder_ = 
                org.apache.pekko.protobufv3.internal.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getDotsFieldBuilder() : null;
            } else {
              dotsBuilder_.addAllMessages(other.dots_);
            }
          }
        }
        if (!other.stringElements_.isEmpty()) {
          if (stringElements_.isEmpty()) {
            stringElements_ = other.stringElements_;
            bitField0_ |= 0x00000004;
          } else {
            ensureStringElementsIsMutable();
            stringElements_.addAll(other.stringElements_);
          }
          onChanged();
        }
        if (!other.intElements_.isEmpty()) {
          if (intElements_.isEmpty()) {
            intElements_ = other.intElements_;
            intElements_.makeImmutable();
            bitField0_ |= 0x00000008;
          } else {
            ensureIntElementsIsMutable();
            intElements_.addAll(other.intElements_);
          }
          onChanged();
        }
        if (!other.longElements_.isEmpty()) {
          if (longElements_.isEmpty()) {
            longElements_ = other.longElements_;
            longElements_.makeImmutable();
            bitField0_ |= 0x00000010;
          } else {
            ensureLongElementsIsMutable();
            longElements_.addAll(other.longElements_);
          }
          onChanged();
        }
        if (otherElementsBuilder_ == null) {
          if (!other.otherElements_.isEmpty()) {
            if (otherElements_.isEmpty()) {
              otherElements_ = other.otherElements_;
              bitField0_ = (bitField0_ & ~0x00000020);
            } else {
              ensureOtherElementsIsMutable();
              otherElements_.addAll(other.otherElements_);
            }
            onChanged();
          }
        } else {
          if (!other.otherElements_.isEmpty()) {
            if (otherElementsBuilder_.isEmpty()) {
              otherElementsBuilder_.dispose();
              otherElementsBuilder_ = null;
              otherElements_ = other.otherElements_;
              bitField0_ = (bitField0_ & ~0x00000020);
              otherElementsBuilder_ = 
                org.apache.pekko.protobufv3.internal.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getOtherElementsFieldBuilder() : null;
            } else {
              otherElementsBuilder_.addAllMessages(other.otherElements_);
            }
          }
        }
        if (!other.actorRefElements_.isEmpty()) {
          if (actorRefElements_.isEmpty()) {
            actorRefElements_ = other.actorRefElements_;
            bitField0_ |= 0x00000040;
          } else {
            ensureActorRefElementsIsMutable();
            actorRefElements_.addAll(other.actorRefElements_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasVvector()) {
          return false;
        }
        if (!getVvector().isInitialized()) {
          return false;
        }
        for (int i = 0; i < getDotsCount(); i++) {
          if (!getDots(i).isInitialized()) {
            return false;
          }
        }
        for (int i = 0; i < getOtherElementsCount(); i++) {
          if (!getOtherElements(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getVvectorFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector m =
                    input.readMessage(
                        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.PARSER,
                        extensionRegistry);
                if (dotsBuilder_ == null) {
                  ensureDotsIsMutable();
                  dots_.add(m);
                } else {
                  dotsBuilder_.addMessage(m);
                }
                break;
              } // case 18
              case 26: {
                org.apache.pekko.protobufv3.internal.ByteString bs = input.readBytes();
                ensureStringElementsIsMutable();
                stringElements_.add(bs);
                break;
              } // case 26
              case 32: {
                int v = input.readSInt32();
                ensureIntElementsIsMutable();
                intElements_.addInt(v);
                break;
              } // case 32
              case 34: {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureIntElementsIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  intElements_.addInt(input.readSInt32());
                }
                input.popLimit(limit);
                break;
              } // case 34
              case 40: {
                long v = input.readSInt64();
                ensureLongElementsIsMutable();
                longElements_.addLong(v);
                break;
              } // case 40
              case 42: {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureLongElementsIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  longElements_.addLong(input.readSInt64());
                }
                input.popLimit(limit);
                break;
              } // case 42
              case 50: {
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage m =
                    input.readMessage(
                        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.PARSER,
                        extensionRegistry);
                if (otherElementsBuilder_ == null) {
                  ensureOtherElementsIsMutable();
                  otherElements_.add(m);
                } else {
                  otherElementsBuilder_.addMessage(m);
                }
                break;
              } // case 50
              case 58: {
                org.apache.pekko.protobufv3.internal.ByteString bs = input.readBytes();
                ensureActorRefElementsIsMutable();
                actorRefElements_.add(bs);
                break;
              } // case 58
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector vvector_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVectorOrBuilder> vvectorBuilder_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.VersionVector vvector = 1;</code>
       * @return Whether the vvector field is set.
       */
      public boolean hasVvector() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.VersionVector vvector = 1;</code>
       * @return The vvector.
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector getVvector() {
        if (vvectorBuilder_ == null) {
          return vvector_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.getDefaultInstance() : vvector_;
        } else {
          return vvectorBuilder_.getMessage();
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.VersionVector vvector = 1;</code>
       */
      public Builder setVvector(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector value) {
        if (vvectorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          vvector_ = value;
        } else {
          vvectorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.VersionVector vvector = 1;</code>
       */
      public Builder setVvector(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.Builder builderForValue) {
        if (vvectorBuilder_ == null) {
          vvector_ = builderForValue.build();
        } else {
          vvectorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.VersionVector vvector = 1;</code>
       */
      public Builder mergeVvector(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector value) {
        if (vvectorBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            vvector_ != null &&
            vvector_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.getDefaultInstance()) {
            getVvectorBuilder().mergeFrom(value);
          } else {
            vvector_ = value;
          }
        } else {
          vvectorBuilder_.mergeFrom(value);
        }
        if (vvector_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.VersionVector vvector = 1;</code>
       */
      public Builder clearVvector() {
        bitField0_ = (bitField0_ & ~0x00000001);
        vvector_ = null;
        if (vvectorBuilder_ != null) {
          vvectorBuilder_.dispose();
          vvectorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.VersionVector vvector = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.Builder getVvectorBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getVvectorFieldBuilder().getBuilder();
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.VersionVector vvector = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVectorOrBuilder getVvectorOrBuilder() {
        if (vvectorBuilder_ != null) {
          return vvectorBuilder_.getMessageOrBuilder();
        } else {
          return vvector_ == null ?
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.getDefaultInstance() : vvector_;
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.VersionVector vvector = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVectorOrBuilder> 
          getVvectorFieldBuilder() {
        if (vvectorBuilder_ == null) {
          vvectorBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVectorOrBuilder>(
                  getVvector(),
                  getParentForChildren(),
                  isClean());
          vvector_ = null;
        }
        return vvectorBuilder_;
      }

      private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector> dots_ =
        java.util.Collections.emptyList();
      private void ensureDotsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          dots_ = new java.util.ArrayList<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector>(dots_);
          bitField0_ |= 0x00000002;
         }
      }

      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVectorOrBuilder> dotsBuilder_;

      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector> getDotsList() {
        if (dotsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(dots_);
        } else {
          return dotsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public int getDotsCount() {
        if (dotsBuilder_ == null) {
          return dots_.size();
        } else {
          return dotsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector getDots(int index) {
        if (dotsBuilder_ == null) {
          return dots_.get(index);
        } else {
          return dotsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public Builder setDots(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector value) {
        if (dotsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDotsIsMutable();
          dots_.set(index, value);
          onChanged();
        } else {
          dotsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public Builder setDots(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.Builder builderForValue) {
        if (dotsBuilder_ == null) {
          ensureDotsIsMutable();
          dots_.set(index, builderForValue.build());
          onChanged();
        } else {
          dotsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public Builder addDots(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector value) {
        if (dotsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDotsIsMutable();
          dots_.add(value);
          onChanged();
        } else {
          dotsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public Builder addDots(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector value) {
        if (dotsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDotsIsMutable();
          dots_.add(index, value);
          onChanged();
        } else {
          dotsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public Builder addDots(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.Builder builderForValue) {
        if (dotsBuilder_ == null) {
          ensureDotsIsMutable();
          dots_.add(builderForValue.build());
          onChanged();
        } else {
          dotsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public Builder addDots(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.Builder builderForValue) {
        if (dotsBuilder_ == null) {
          ensureDotsIsMutable();
          dots_.add(index, builderForValue.build());
          onChanged();
        } else {
          dotsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public Builder addAllDots(
          java.lang.Iterable<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector> values) {
        if (dotsBuilder_ == null) {
          ensureDotsIsMutable();
          org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
              values, dots_);
          onChanged();
        } else {
          dotsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public Builder clearDots() {
        if (dotsBuilder_ == null) {
          dots_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          dotsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public Builder removeDots(int index) {
        if (dotsBuilder_ == null) {
          ensureDotsIsMutable();
          dots_.remove(index);
          onChanged();
        } else {
          dotsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.Builder getDotsBuilder(
          int index) {
        return getDotsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVectorOrBuilder getDotsOrBuilder(
          int index) {
        if (dotsBuilder_ == null) {
          return dots_.get(index);  } else {
          return dotsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVectorOrBuilder> 
           getDotsOrBuilderList() {
        if (dotsBuilder_ != null) {
          return dotsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(dots_);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.Builder addDotsBuilder() {
        return getDotsFieldBuilder().addBuilder(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.Builder addDotsBuilder(
          int index) {
        return getDotsFieldBuilder().addBuilder(
            index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.VersionVector dots = 2;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.Builder> 
           getDotsBuilderList() {
        return getDotsFieldBuilder().getBuilderList();
      }
      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVectorOrBuilder> 
          getDotsFieldBuilder() {
        if (dotsBuilder_ == null) {
          dotsBuilder_ = new org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVector.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.VersionVectorOrBuilder>(
                  dots_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          dots_ = null;
        }
        return dotsBuilder_;
      }

      private org.apache.pekko.protobufv3.internal.LazyStringArrayList stringElements_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
      private void ensureStringElementsIsMutable() {
        if (!stringElements_.isModifiable()) {
          stringElements_ = new org.apache.pekko.protobufv3.internal.LazyStringArrayList(stringElements_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       * <code>repeated string stringElements = 3;</code>
       * @return A list containing the stringElements.
       */
      public org.apache.pekko.protobufv3.internal.ProtocolStringList
          getStringElementsList() {
        stringElements_.makeImmutable();
        return stringElements_;
      }
      /**
       * <code>repeated string stringElements = 3;</code>
       * @return The count of stringElements.
       */
      public int getStringElementsCount() {
        return stringElements_.size();
      }
      /**
       * <code>repeated string stringElements = 3;</code>
       * @param index The index of the element to return.
       * @return The stringElements at the given index.
       */
      public java.lang.String getStringElements(int index) {
        return stringElements_.get(index);
      }
      /**
       * <code>repeated string stringElements = 3;</code>
       * @param index The index of the value to return.
       * @return The bytes of the stringElements at the given index.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getStringElementsBytes(int index) {
        return stringElements_.getByteString(index);
      }
      /**
       * <code>repeated string stringElements = 3;</code>
       * @param index The index to set the value at.
       * @param value The stringElements to set.
       * @return This builder for chaining.
       */
      public Builder setStringElements(
          int index, java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureStringElementsIsMutable();
        stringElements_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>repeated string stringElements = 3;</code>
       * @param value The stringElements to add.
       * @return This builder for chaining.
       */
      public Builder addStringElements(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureStringElementsIsMutable();
        stringElements_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>repeated string stringElements = 3;</code>
       * @param values The stringElements to add.
       * @return This builder for chaining.
       */
      public Builder addAllStringElements(
          java.lang.Iterable<java.lang.String> values) {
        ensureStringElementsIsMutable();
        org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
            values, stringElements_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>repeated string stringElements = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearStringElements() {
        stringElements_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);;
        onChanged();
        return this;
      }
      /**
       * <code>repeated string stringElements = 3;</code>
       * @param value The bytes of the stringElements to add.
       * @return This builder for chaining.
       */
      public Builder addStringElementsBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        ensureStringElementsIsMutable();
        stringElements_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.Internal.IntList intElements_ = emptyIntList();
      private void ensureIntElementsIsMutable() {
        if (!intElements_.isModifiable()) {
          intElements_ = makeMutableCopy(intElements_);
        }
        bitField0_ |= 0x00000008;
      }
      /**
       * <code>repeated sint32 intElements = 4 [packed = true];</code>
       * @return A list containing the intElements.
       */
      public java.util.List<java.lang.Integer>
          getIntElementsList() {
        intElements_.makeImmutable();
        return intElements_;
      }
      /**
       * <code>repeated sint32 intElements = 4 [packed = true];</code>
       * @return The count of intElements.
       */
      public int getIntElementsCount() {
        return intElements_.size();
      }
      /**
       * <code>repeated sint32 intElements = 4 [packed = true];</code>
       * @param index The index of the element to return.
       * @return The intElements at the given index.
       */
      public int getIntElements(int index) {
        return intElements_.getInt(index);
      }
      /**
       * <code>repeated sint32 intElements = 4 [packed = true];</code>
       * @param index The index to set the value at.
       * @param value The intElements to set.
       * @return This builder for chaining.
       */
      public Builder setIntElements(
          int index, int value) {

        ensureIntElementsIsMutable();
        intElements_.setInt(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <code>repeated sint32 intElements = 4 [packed = true];</code>
       * @param value The intElements to add.
       * @return This builder for chaining.
       */
      public Builder addIntElements(int value) {

        ensureIntElementsIsMutable();
        intElements_.addInt(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <code>repeated sint32 intElements = 4 [packed = true];</code>
       * @param values The intElements to add.
       * @return This builder for chaining.
       */
      public Builder addAllIntElements(
          java.lang.Iterable<? extends java.lang.Integer> values) {
        ensureIntElementsIsMutable();
        org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
            values, intElements_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <code>repeated sint32 intElements = 4 [packed = true];</code>
       * @return This builder for chaining.
       */
      public Builder clearIntElements() {
        intElements_ = emptyIntList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.Internal.LongList longElements_ = emptyLongList();
      private void ensureLongElementsIsMutable() {
        if (!longElements_.isModifiable()) {
          longElements_ = makeMutableCopy(longElements_);
        }
        bitField0_ |= 0x00000010;
      }
      /**
       * <code>repeated sint64 longElements = 5 [packed = true];</code>
       * @return A list containing the longElements.
       */
      public java.util.List<java.lang.Long>
          getLongElementsList() {
        longElements_.makeImmutable();
        return longElements_;
      }
      /**
       * <code>repeated sint64 longElements = 5 [packed = true];</code>
       * @return The count of longElements.
       */
      public int getLongElementsCount() {
        return longElements_.size();
      }
      /**
       * <code>repeated sint64 longElements = 5 [packed = true];</code>
       * @param index The index of the element to return.
       * @return The longElements at the given index.
       */
      public long getLongElements(int index) {
        return longElements_.getLong(index);
      }
      /**
       * <code>repeated sint64 longElements = 5 [packed = true];</code>
       * @param index The index to set the value at.
       * @param value The longElements to set.
       * @return This builder for chaining.
       */
      public Builder setLongElements(
          int index, long value) {

        ensureLongElementsIsMutable();
        longElements_.setLong(index, value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <code>repeated sint64 longElements = 5 [packed = true];</code>
       * @param value The longElements to add.
       * @return This builder for chaining.
       */
      public Builder addLongElements(long value) {

        ensureLongElementsIsMutable();
        longElements_.addLong(value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <code>repeated sint64 longElements = 5 [packed = true];</code>
       * @param values The longElements to add.
       * @return This builder for chaining.
       */
      public Builder addAllLongElements(
          java.lang.Iterable<? extends java.lang.Long> values) {
        ensureLongElementsIsMutable();
        org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
            values, longElements_);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <code>repeated sint64 longElements = 5 [packed = true];</code>
       * @return This builder for chaining.
       */
      public Builder clearLongElements() {
        longElements_ = emptyLongList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage> otherElements_ =
        java.util.Collections.emptyList();
      private void ensureOtherElementsIsMutable() {
        if (!((bitField0_ & 0x00000020) != 0)) {
          otherElements_ = new java.util.ArrayList<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage>(otherElements_);
          bitField0_ |= 0x00000020;
         }
      }

      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> otherElementsBuilder_;

      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage> getOtherElementsList() {
        if (otherElementsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(otherElements_);
        } else {
          return otherElementsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public int getOtherElementsCount() {
        if (otherElementsBuilder_ == null) {
          return otherElements_.size();
        } else {
          return otherElementsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherElements(int index) {
        if (otherElementsBuilder_ == null) {
          return otherElements_.get(index);
        } else {
          return otherElementsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public Builder setOtherElements(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
        if (otherElementsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOtherElementsIsMutable();
          otherElements_.set(index, value);
          onChanged();
        } else {
          otherElementsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public Builder setOtherElements(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder builderForValue) {
        if (otherElementsBuilder_ == null) {
          ensureOtherElementsIsMutable();
          otherElements_.set(index, builderForValue.build());
          onChanged();
        } else {
          otherElementsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public Builder addOtherElements(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
        if (otherElementsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOtherElementsIsMutable();
          otherElements_.add(value);
          onChanged();
        } else {
          otherElementsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public Builder addOtherElements(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
        if (otherElementsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOtherElementsIsMutable();
          otherElements_.add(index, value);
          onChanged();
        } else {
          otherElementsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public Builder addOtherElements(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder builderForValue) {
        if (otherElementsBuilder_ == null) {
          ensureOtherElementsIsMutable();
          otherElements_.add(builderForValue.build());
          onChanged();
        } else {
          otherElementsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public Builder addOtherElements(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder builderForValue) {
        if (otherElementsBuilder_ == null) {
          ensureOtherElementsIsMutable();
          otherElements_.add(index, builderForValue.build());
          onChanged();
        } else {
          otherElementsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public Builder addAllOtherElements(
          java.lang.Iterable<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage> values) {
        if (otherElementsBuilder_ == null) {
          ensureOtherElementsIsMutable();
          org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
              values, otherElements_);
          onChanged();
        } else {
          otherElementsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public Builder clearOtherElements() {
        if (otherElementsBuilder_ == null) {
          otherElements_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
        } else {
          otherElementsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public Builder removeOtherElements(int index) {
        if (otherElementsBuilder_ == null) {
          ensureOtherElementsIsMutable();
          otherElements_.remove(index);
          onChanged();
        } else {
          otherElementsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder getOtherElementsBuilder(
          int index) {
        return getOtherElementsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherElementsOrBuilder(
          int index) {
        if (otherElementsBuilder_ == null) {
          return otherElements_.get(index);  } else {
          return otherElementsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
           getOtherElementsOrBuilderList() {
        if (otherElementsBuilder_ != null) {
          return otherElementsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(otherElements_);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder addOtherElementsBuilder() {
        return getOtherElementsFieldBuilder().addBuilder(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder addOtherElementsBuilder(
          int index) {
        return getOtherElementsFieldBuilder().addBuilder(
            index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.OtherMessage otherElements = 6;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder> 
           getOtherElementsBuilderList() {
        return getOtherElementsFieldBuilder().getBuilderList();
      }
      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
          getOtherElementsFieldBuilder() {
        if (otherElementsBuilder_ == null) {
          otherElementsBuilder_ = new org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder>(
                  otherElements_,
                  ((bitField0_ & 0x00000020) != 0),
                  getParentForChildren(),
                  isClean());
          otherElements_ = null;
        }
        return otherElementsBuilder_;
      }

      private org.apache.pekko.protobufv3.internal.LazyStringArrayList actorRefElements_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
      private void ensureActorRefElementsIsMutable() {
        if (!actorRefElements_.isModifiable()) {
          actorRefElements_ = new org.apache.pekko.protobufv3.internal.LazyStringArrayList(actorRefElements_);
        }
        bitField0_ |= 0x00000040;
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 7;</code>
       * @return A list containing the actorRefElements.
       */
      public org.apache.pekko.protobufv3.internal.ProtocolStringList
          getActorRefElementsList() {
        actorRefElements_.makeImmutable();
        return actorRefElements_;
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 7;</code>
       * @return The count of actorRefElements.
       */
      public int getActorRefElementsCount() {
        return actorRefElements_.size();
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 7;</code>
       * @param index The index of the element to return.
       * @return The actorRefElements at the given index.
       */
      public java.lang.String getActorRefElements(int index) {
        return actorRefElements_.get(index);
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 7;</code>
       * @param index The index of the value to return.
       * @return The bytes of the actorRefElements at the given index.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getActorRefElementsBytes(int index) {
        return actorRefElements_.getByteString(index);
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 7;</code>
       * @param index The index to set the value at.
       * @param value The actorRefElements to set.
       * @return This builder for chaining.
       */
      public Builder setActorRefElements(
          int index, java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureActorRefElementsIsMutable();
        actorRefElements_.set(index, value);
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 7;</code>
       * @param value The actorRefElements to add.
       * @return This builder for chaining.
       */
      public Builder addActorRefElements(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureActorRefElementsIsMutable();
        actorRefElements_.add(value);
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 7;</code>
       * @param values The actorRefElements to add.
       * @return This builder for chaining.
       */
      public Builder addAllActorRefElements(
          java.lang.Iterable<java.lang.String> values) {
        ensureActorRefElementsIsMutable();
        org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
            values, actorRefElements_);
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 7;</code>
       * @return This builder for chaining.
       */
      public Builder clearActorRefElements() {
        actorRefElements_ =
          org.apache.pekko.protobufv3.internal.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * added in Akka 2.5.14
       * </pre>
       *
       * <code>repeated string actorRefElements = 7;</code>
       * @param value The bytes of the actorRefElements to add.
       * @return This builder for chaining.
       */
      public Builder addActorRefElementsBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        ensureActorRefElementsIsMutable();
        actorRefElements_.add(value);
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.ORSet)
    }

    // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.ORSet)
    private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet();
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<ORSet>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<ORSet>() {
      @java.lang.Override
      public ORSet parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<ORSet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<ORSet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ORSetDeltaGroupOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.ORSetDeltaGroup)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
     */
    java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry> 
        getEntriesList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry getEntries(int index);
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
     */
    int getEntriesCount();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
     */
    java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.EntryOrBuilder> 
        getEntriesOrBuilderList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.EntryOrBuilder getEntriesOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code org.apache.pekko.cluster.ddata.ORSetDeltaGroup}
   */
  public static final class ORSetDeltaGroup extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.ORSetDeltaGroup)
      ORSetDeltaGroupOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ORSetDeltaGroup.newBuilder() to construct.
    private ORSetDeltaGroup(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ORSetDeltaGroup() {
      entries_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new ORSetDeltaGroup();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Builder.class);
    }

    public interface EntryOrBuilder extends
        // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry)
        org.apache.pekko.protobufv3.internal.MessageOrBuilder {

      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSetDeltaOp operation = 1;</code>
       * @return Whether the operation field is set.
       */
      boolean hasOperation();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSetDeltaOp operation = 1;</code>
       * @return The operation.
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaOp getOperation();

      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
       * @return Whether the underlying field is set.
       */
      boolean hasUnderlying();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
       * @return The underlying.
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getUnderlying();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getUnderlyingOrBuilder();
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry}
     */
    public static final class Entry extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry)
        EntryOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Entry.newBuilder() to construct.
      private Entry(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Entry() {
        operation_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Entry();
      }

      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_Entry_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_Entry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.Builder.class);
      }

      private int bitField0_;
      public static final int OPERATION_FIELD_NUMBER = 1;
      private int operation_ = 0;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSetDeltaOp operation = 1;</code>
       * @return Whether the operation field is set.
       */
      @java.lang.Override public boolean hasOperation() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSetDeltaOp operation = 1;</code>
       * @return The operation.
       */
      @java.lang.Override public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaOp getOperation() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaOp result = org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaOp.forNumber(operation_);
        return result == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaOp.Add : result;
      }

      public static final int UNDERLYING_FIELD_NUMBER = 2;
      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet underlying_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
       * @return Whether the underlying field is set.
       */
      @java.lang.Override
      public boolean hasUnderlying() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
       * @return The underlying.
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getUnderlying() {
        return underlying_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : underlying_;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getUnderlyingOrBuilder() {
        return underlying_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : underlying_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasOperation()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!hasUnderlying()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!getUnderlying().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeEnum(1, operation_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getUnderlying());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeEnumSize(1, operation_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeMessageSize(2, getUnderlying());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry)) {
          return super.equals(obj);
        }
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry) obj;

        if (hasOperation() != other.hasOperation()) return false;
        if (hasOperation()) {
          if (operation_ != other.operation_) return false;
        }
        if (hasUnderlying() != other.hasUnderlying()) return false;
        if (hasUnderlying()) {
          if (!getUnderlying()
              .equals(other.getUnderlying())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasOperation()) {
          hash = (37 * hash) + OPERATION_FIELD_NUMBER;
          hash = (53 * hash) + operation_;
        }
        if (hasUnderlying()) {
          hash = (37 * hash) + UNDERLYING_FIELD_NUMBER;
          hash = (53 * hash) + getUnderlying().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry parseFrom(
          java.nio.ByteBuffer data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry parseFrom(
          java.nio.ByteBuffer data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry parseFrom(byte[] data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry parseFrom(
          byte[] data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry parseFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry parseDelimitedFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry}
       */
      public static final class Builder extends
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry)
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.EntryOrBuilder {
        public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_Entry_descriptor;
        }

        @java.lang.Override
        protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_Entry_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.Builder.class);
        }

        // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getUnderlyingFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          operation_ = 0;
          underlying_ = null;
          if (underlyingBuilder_ != null) {
            underlyingBuilder_.dispose();
            underlyingBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_Entry_descriptor;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry getDefaultInstanceForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry build() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry buildPartial() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry(this);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.operation_ = operation_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.underlying_ = underlyingBuilder_ == null
                ? underlying_
                : underlyingBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
          if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry) {
            return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry other) {
          if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.getDefaultInstance()) return this;
          if (other.hasOperation()) {
            setOperation(other.getOperation());
          }
          if (other.hasUnderlying()) {
            mergeUnderlying(other.getUnderlying());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!hasOperation()) {
            return false;
          }
          if (!hasUnderlying()) {
            return false;
          }
          if (!getUnderlying().isInitialized()) {
            return false;
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8: {
                  int tmpRaw = input.readEnum();
                  org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaOp tmpValue =
                      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaOp.forNumber(tmpRaw);
                  if (tmpValue == null) {
                    mergeUnknownVarintField(1, tmpRaw);
                  } else {
                    operation_ = tmpRaw;
                    bitField0_ |= 0x00000001;
                  }
                  break;
                } // case 8
                case 18: {
                  input.readMessage(
                      getUnderlyingFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private int operation_ = 0;
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSetDeltaOp operation = 1;</code>
         * @return Whether the operation field is set.
         */
        @java.lang.Override public boolean hasOperation() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSetDeltaOp operation = 1;</code>
         * @return The operation.
         */
        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaOp getOperation() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaOp result = org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaOp.forNumber(operation_);
          return result == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaOp.Add : result;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSetDeltaOp operation = 1;</code>
         * @param value The operation to set.
         * @return This builder for chaining.
         */
        public Builder setOperation(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaOp value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000001;
          operation_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSetDeltaOp operation = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearOperation() {
          bitField0_ = (bitField0_ & ~0x00000001);
          operation_ = 0;
          onChanged();
          return this;
        }

        private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet underlying_;
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder> underlyingBuilder_;
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         * @return Whether the underlying field is set.
         */
        public boolean hasUnderlying() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         * @return The underlying.
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getUnderlying() {
          if (underlyingBuilder_ == null) {
            return underlying_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : underlying_;
          } else {
            return underlyingBuilder_.getMessage();
          }
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         */
        public Builder setUnderlying(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value) {
          if (underlyingBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            underlying_ = value;
          } else {
            underlyingBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         */
        public Builder setUnderlying(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder builderForValue) {
          if (underlyingBuilder_ == null) {
            underlying_ = builderForValue.build();
          } else {
            underlyingBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         */
        public Builder mergeUnderlying(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value) {
          if (underlyingBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0) &&
              underlying_ != null &&
              underlying_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance()) {
              getUnderlyingBuilder().mergeFrom(value);
            } else {
              underlying_ = value;
            }
          } else {
            underlyingBuilder_.mergeFrom(value);
          }
          if (underlying_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         */
        public Builder clearUnderlying() {
          bitField0_ = (bitField0_ & ~0x00000002);
          underlying_ = null;
          if (underlyingBuilder_ != null) {
            underlyingBuilder_.dispose();
            underlyingBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder getUnderlyingBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getUnderlyingFieldBuilder().getBuilder();
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getUnderlyingOrBuilder() {
          if (underlyingBuilder_ != null) {
            return underlyingBuilder_.getMessageOrBuilder();
          } else {
            return underlying_ == null ?
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : underlying_;
          }
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         */
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder> 
            getUnderlyingFieldBuilder() {
          if (underlyingBuilder_ == null) {
            underlyingBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder>(
                    getUnderlying(),
                    getParentForChildren(),
                    isClean());
            underlying_ = null;
          }
          return underlyingBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry)
      }

      // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry)
      private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry();
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<Entry>
          PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<Entry>() {
        @java.lang.Override
        public Entry parsePartialFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static org.apache.pekko.protobufv3.internal.Parser<Entry> parser() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Parser<Entry> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public static final int ENTRIES_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry> entries_;
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry> getEntriesList() {
      return entries_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.EntryOrBuilder> 
        getEntriesOrBuilderList() {
      return entries_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
     */
    @java.lang.Override
    public int getEntriesCount() {
      return entries_.size();
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry getEntries(int index) {
      return entries_.get(index);
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.EntryOrBuilder getEntriesOrBuilder(
        int index) {
      return entries_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getEntriesCount(); i++) {
        if (!getEntries(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < entries_.size(); i++) {
        output.writeMessage(1, entries_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < entries_.size(); i++) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, entries_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup)) {
        return super.equals(obj);
      }
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup) obj;

      if (!getEntriesList()
          .equals(other.getEntriesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getEntriesCount() > 0) {
        hash = (37 * hash) + ENTRIES_FIELD_NUMBER;
        hash = (53 * hash) + getEntriesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.ORSetDeltaGroup}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.ORSetDeltaGroup)
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroupOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Builder.class);
      }

      // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.newBuilder()
      private Builder() {

      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
        } else {
          entries_ = null;
          entriesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup getDefaultInstanceForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup build() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup buildPartial() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup result) {
        if (entriesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            entries_ = java.util.Collections.unmodifiableList(entries_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.entries_ = entries_;
        } else {
          result.entries_ = entriesBuilder_.build();
        }
      }

      private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup) {
          return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup other) {
        if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.getDefaultInstance()) return this;
        if (entriesBuilder_ == null) {
          if (!other.entries_.isEmpty()) {
            if (entries_.isEmpty()) {
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureEntriesIsMutable();
              entries_.addAll(other.entries_);
            }
            onChanged();
          }
        } else {
          if (!other.entries_.isEmpty()) {
            if (entriesBuilder_.isEmpty()) {
              entriesBuilder_.dispose();
              entriesBuilder_ = null;
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000001);
              entriesBuilder_ = 
                org.apache.pekko.protobufv3.internal.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getEntriesFieldBuilder() : null;
            } else {
              entriesBuilder_.addAllMessages(other.entries_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        for (int i = 0; i < getEntriesCount(); i++) {
          if (!getEntries(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry m =
                    input.readMessage(
                        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.PARSER,
                        extensionRegistry);
                if (entriesBuilder_ == null) {
                  ensureEntriesIsMutable();
                  entries_.add(m);
                } else {
                  entriesBuilder_.addMessage(m);
                }
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry> entries_ =
        java.util.Collections.emptyList();
      private void ensureEntriesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          entries_ = new java.util.ArrayList<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry>(entries_);
          bitField0_ |= 0x00000001;
         }
      }

      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.EntryOrBuilder> entriesBuilder_;

      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry> getEntriesList() {
        if (entriesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(entries_);
        } else {
          return entriesBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public int getEntriesCount() {
        if (entriesBuilder_ == null) {
          return entries_.size();
        } else {
          return entriesBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry getEntries(int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);
        } else {
          return entriesBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public Builder setEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.set(index, value);
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public Builder setEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.set(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public Builder addEntries(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public Builder addEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(index, value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public Builder addEntries(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public Builder addEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public Builder addAllEntries(
          java.lang.Iterable<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry> values) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
              values, entries_);
          onChanged();
        } else {
          entriesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public Builder clearEntries() {
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          entriesBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public Builder removeEntries(int index) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.remove(index);
          onChanged();
        } else {
          entriesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.Builder getEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.EntryOrBuilder getEntriesOrBuilder(
          int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);  } else {
          return entriesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.EntryOrBuilder> 
           getEntriesOrBuilderList() {
        if (entriesBuilder_ != null) {
          return entriesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(entries_);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.Builder addEntriesBuilder() {
        return getEntriesFieldBuilder().addBuilder(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.Builder addEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder().addBuilder(
            index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORSetDeltaGroup.Entry entries = 1;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.Builder> 
           getEntriesBuilderList() {
        return getEntriesFieldBuilder().getBuilderList();
      }
      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.EntryOrBuilder> 
          getEntriesFieldBuilder() {
        if (entriesBuilder_ == null) {
          entriesBuilder_ = new org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup.EntryOrBuilder>(
                  entries_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          entries_ = null;
        }
        return entriesBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.ORSetDeltaGroup)
    }

    // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.ORSetDeltaGroup)
    private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup();
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<ORSetDeltaGroup>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<ORSetDeltaGroup>() {
      @java.lang.Override
      public ORSetDeltaGroup parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<ORSetDeltaGroup> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<ORSetDeltaGroup> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetDeltaGroup getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface FlagOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.Flag)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required bool enabled = 1;</code>
     * @return Whether the enabled field is set.
     */
    boolean hasEnabled();
    /**
     * <code>required bool enabled = 1;</code>
     * @return The enabled.
     */
    boolean getEnabled();
  }
  /**
   * Protobuf type {@code org.apache.pekko.cluster.ddata.Flag}
   */
  public static final class Flag extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.Flag)
      FlagOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Flag.newBuilder() to construct.
    private Flag(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Flag() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new Flag();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_Flag_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_Flag_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag.Builder.class);
    }

    private int bitField0_;
    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;
    /**
     * <code>required bool enabled = 1;</code>
     * @return Whether the enabled field is set.
     */
    @java.lang.Override
    public boolean hasEnabled() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required bool enabled = 1;</code>
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasEnabled()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeBool(1, enabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeBoolSize(1, enabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag)) {
        return super.equals(obj);
      }
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag) obj;

      if (hasEnabled() != other.hasEnabled()) return false;
      if (hasEnabled()) {
        if (getEnabled()
            != other.getEnabled()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasEnabled()) {
        hash = (37 * hash) + ENABLED_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashBoolean(
            getEnabled());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.Flag}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.Flag)
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.FlagOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_Flag_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_Flag_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag.Builder.class);
      }

      // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag.newBuilder()
      private Builder() {

      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_Flag_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag getDefaultInstanceForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag build() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag buildPartial() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag) {
          return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag other) {
        if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag.getDefaultInstance()) return this;
        if (other.hasEnabled()) {
          setEnabled(other.getEnabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasEnabled()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                enabled_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private boolean enabled_ ;
      /**
       * <code>required bool enabled = 1;</code>
       * @return Whether the enabled field is set.
       */
      @java.lang.Override
      public boolean hasEnabled() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required bool enabled = 1;</code>
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       * <code>required bool enabled = 1;</code>
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required bool enabled = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.Flag)
    }

    // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.Flag)
    private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag();
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<Flag>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<Flag>() {
      @java.lang.Override
      public Flag parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<Flag> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<Flag> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.Flag getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface LWWRegisterOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.LWWRegister)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required sint64 timestamp = 1;</code>
     * @return Whether the timestamp field is set.
     */
    boolean hasTimestamp();
    /**
     * <code>required sint64 timestamp = 1;</code>
     * @return The timestamp.
     */
    long getTimestamp();

    /**
     * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 2;</code>
     * @return Whether the node field is set.
     */
    boolean hasNode();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 2;</code>
     * @return The node.
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress getNode();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 2;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddressOrBuilder getNodeOrBuilder();

    /**
     * <code>required .org.apache.pekko.cluster.ddata.OtherMessage state = 3;</code>
     * @return Whether the state field is set.
     */
    boolean hasState();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.OtherMessage state = 3;</code>
     * @return The state.
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getState();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.OtherMessage state = 3;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getStateOrBuilder();
  }
  /**
   * Protobuf type {@code org.apache.pekko.cluster.ddata.LWWRegister}
   */
  public static final class LWWRegister extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.LWWRegister)
      LWWRegisterOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use LWWRegister.newBuilder() to construct.
    private LWWRegister(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private LWWRegister() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new LWWRegister();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_LWWRegister_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_LWWRegister_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.Builder.class);
    }

    private int bitField0_;
    public static final int TIMESTAMP_FIELD_NUMBER = 1;
    private long timestamp_ = 0L;
    /**
     * <code>required sint64 timestamp = 1;</code>
     * @return Whether the timestamp field is set.
     */
    @java.lang.Override
    public boolean hasTimestamp() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required sint64 timestamp = 1;</code>
     * @return The timestamp.
     */
    @java.lang.Override
    public long getTimestamp() {
      return timestamp_;
    }

    public static final int NODE_FIELD_NUMBER = 2;
    private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress node_;
    /**
     * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 2;</code>
     * @return Whether the node field is set.
     */
    @java.lang.Override
    public boolean hasNode() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 2;</code>
     * @return The node.
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress getNode() {
      return node_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.getDefaultInstance() : node_;
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddressOrBuilder getNodeOrBuilder() {
      return node_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.getDefaultInstance() : node_;
    }

    public static final int STATE_FIELD_NUMBER = 3;
    private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage state_;
    /**
     * <code>required .org.apache.pekko.cluster.ddata.OtherMessage state = 3;</code>
     * @return Whether the state field is set.
     */
    @java.lang.Override
    public boolean hasState() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.OtherMessage state = 3;</code>
     * @return The state.
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getState() {
      return state_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : state_;
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.OtherMessage state = 3;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getStateOrBuilder() {
      return state_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : state_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasTimestamp()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasNode()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasState()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getNode().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getState().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeSInt64(1, timestamp_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getNode());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(3, getState());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeSInt64Size(1, timestamp_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, getNode());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(3, getState());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister)) {
        return super.equals(obj);
      }
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister) obj;

      if (hasTimestamp() != other.hasTimestamp()) return false;
      if (hasTimestamp()) {
        if (getTimestamp()
            != other.getTimestamp()) return false;
      }
      if (hasNode() != other.hasNode()) return false;
      if (hasNode()) {
        if (!getNode()
            .equals(other.getNode())) return false;
      }
      if (hasState() != other.hasState()) return false;
      if (hasState()) {
        if (!getState()
            .equals(other.getState())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTimestamp()) {
        hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
            getTimestamp());
      }
      if (hasNode()) {
        hash = (37 * hash) + NODE_FIELD_NUMBER;
        hash = (53 * hash) + getNode().hashCode();
      }
      if (hasState()) {
        hash = (37 * hash) + STATE_FIELD_NUMBER;
        hash = (53 * hash) + getState().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.LWWRegister}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.LWWRegister)
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegisterOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_LWWRegister_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_LWWRegister_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.Builder.class);
      }

      // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getNodeFieldBuilder();
          getStateFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        timestamp_ = 0L;
        node_ = null;
        if (nodeBuilder_ != null) {
          nodeBuilder_.dispose();
          nodeBuilder_ = null;
        }
        state_ = null;
        if (stateBuilder_ != null) {
          stateBuilder_.dispose();
          stateBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_LWWRegister_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister getDefaultInstanceForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister build() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister buildPartial() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.timestamp_ = timestamp_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.node_ = nodeBuilder_ == null
              ? node_
              : nodeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.state_ = stateBuilder_ == null
              ? state_
              : stateBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister) {
          return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister other) {
        if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.getDefaultInstance()) return this;
        if (other.hasTimestamp()) {
          setTimestamp(other.getTimestamp());
        }
        if (other.hasNode()) {
          mergeNode(other.getNode());
        }
        if (other.hasState()) {
          mergeState(other.getState());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasTimestamp()) {
          return false;
        }
        if (!hasNode()) {
          return false;
        }
        if (!hasState()) {
          return false;
        }
        if (!getNode().isInitialized()) {
          return false;
        }
        if (!getState().isInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                timestamp_ = input.readSInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 18: {
                input.readMessage(
                    getNodeFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getStateFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private long timestamp_ ;
      /**
       * <code>required sint64 timestamp = 1;</code>
       * @return Whether the timestamp field is set.
       */
      @java.lang.Override
      public boolean hasTimestamp() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required sint64 timestamp = 1;</code>
       * @return The timestamp.
       */
      @java.lang.Override
      public long getTimestamp() {
        return timestamp_;
      }
      /**
       * <code>required sint64 timestamp = 1;</code>
       * @param value The timestamp to set.
       * @return This builder for chaining.
       */
      public Builder setTimestamp(long value) {

        timestamp_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required sint64 timestamp = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000001);
        timestamp_ = 0L;
        onChanged();
        return this;
      }

      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress node_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddressOrBuilder> nodeBuilder_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 2;</code>
       * @return Whether the node field is set.
       */
      public boolean hasNode() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 2;</code>
       * @return The node.
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress getNode() {
        if (nodeBuilder_ == null) {
          return node_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.getDefaultInstance() : node_;
        } else {
          return nodeBuilder_.getMessage();
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 2;</code>
       */
      public Builder setNode(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress value) {
        if (nodeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          node_ = value;
        } else {
          nodeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 2;</code>
       */
      public Builder setNode(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.Builder builderForValue) {
        if (nodeBuilder_ == null) {
          node_ = builderForValue.build();
        } else {
          nodeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 2;</code>
       */
      public Builder mergeNode(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress value) {
        if (nodeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            node_ != null &&
            node_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.getDefaultInstance()) {
            getNodeBuilder().mergeFrom(value);
          } else {
            node_ = value;
          }
        } else {
          nodeBuilder_.mergeFrom(value);
        }
        if (node_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 2;</code>
       */
      public Builder clearNode() {
        bitField0_ = (bitField0_ & ~0x00000002);
        node_ = null;
        if (nodeBuilder_ != null) {
          nodeBuilder_.dispose();
          nodeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.Builder getNodeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getNodeFieldBuilder().getBuilder();
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddressOrBuilder getNodeOrBuilder() {
        if (nodeBuilder_ != null) {
          return nodeBuilder_.getMessageOrBuilder();
        } else {
          return node_ == null ?
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.getDefaultInstance() : node_;
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 2;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddressOrBuilder> 
          getNodeFieldBuilder() {
        if (nodeBuilder_ == null) {
          nodeBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddressOrBuilder>(
                  getNode(),
                  getParentForChildren(),
                  isClean());
          node_ = null;
        }
        return nodeBuilder_;
      }

      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage state_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> stateBuilder_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.OtherMessage state = 3;</code>
       * @return Whether the state field is set.
       */
      public boolean hasState() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.OtherMessage state = 3;</code>
       * @return The state.
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getState() {
        if (stateBuilder_ == null) {
          return state_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : state_;
        } else {
          return stateBuilder_.getMessage();
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.OtherMessage state = 3;</code>
       */
      public Builder setState(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
        if (stateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          state_ = value;
        } else {
          stateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.OtherMessage state = 3;</code>
       */
      public Builder setState(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder builderForValue) {
        if (stateBuilder_ == null) {
          state_ = builderForValue.build();
        } else {
          stateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.OtherMessage state = 3;</code>
       */
      public Builder mergeState(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
        if (stateBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
            state_ != null &&
            state_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance()) {
            getStateBuilder().mergeFrom(value);
          } else {
            state_ = value;
          }
        } else {
          stateBuilder_.mergeFrom(value);
        }
        if (state_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.OtherMessage state = 3;</code>
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000004);
        state_ = null;
        if (stateBuilder_ != null) {
          stateBuilder_.dispose();
          stateBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.OtherMessage state = 3;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder getStateBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getStateFieldBuilder().getBuilder();
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.OtherMessage state = 3;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getStateOrBuilder() {
        if (stateBuilder_ != null) {
          return stateBuilder_.getMessageOrBuilder();
        } else {
          return state_ == null ?
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : state_;
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.OtherMessage state = 3;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
          getStateFieldBuilder() {
        if (stateBuilder_ == null) {
          stateBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder>(
                  getState(),
                  getParentForChildren(),
                  isClean());
          state_ = null;
        }
        return stateBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.LWWRegister)
    }

    // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.LWWRegister)
    private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister();
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<LWWRegister>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<LWWRegister>() {
      @java.lang.Override
      public LWWRegister parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<LWWRegister> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<LWWRegister> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GCounterOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.GCounter)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
     */
    java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry> 
        getEntriesList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry getEntries(int index);
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
     */
    int getEntriesCount();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
     */
    java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.EntryOrBuilder> 
        getEntriesOrBuilderList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.EntryOrBuilder getEntriesOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code org.apache.pekko.cluster.ddata.GCounter}
   */
  public static final class GCounter extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.GCounter)
      GCounterOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GCounter.newBuilder() to construct.
    private GCounter(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GCounter() {
      entries_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new GCounter();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_GCounter_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_GCounter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Builder.class);
    }

    public interface EntryOrBuilder extends
        // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.GCounter.Entry)
        org.apache.pekko.protobufv3.internal.MessageOrBuilder {

      /**
       * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 1;</code>
       * @return Whether the node field is set.
       */
      boolean hasNode();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 1;</code>
       * @return The node.
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress getNode();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 1;</code>
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddressOrBuilder getNodeOrBuilder();

      /**
       * <code>required bytes value = 2;</code>
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       * <code>required bytes value = 2;</code>
       * @return The value.
       */
      org.apache.pekko.protobufv3.internal.ByteString getValue();
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.GCounter.Entry}
     */
    public static final class Entry extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.GCounter.Entry)
        EntryOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Entry.newBuilder() to construct.
      private Entry(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Entry() {
        value_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Entry();
      }

      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_GCounter_Entry_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_GCounter_Entry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.Builder.class);
      }

      private int bitField0_;
      public static final int NODE_FIELD_NUMBER = 1;
      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress node_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 1;</code>
       * @return Whether the node field is set.
       */
      @java.lang.Override
      public boolean hasNode() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 1;</code>
       * @return The node.
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress getNode() {
        return node_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.getDefaultInstance() : node_;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 1;</code>
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddressOrBuilder getNodeOrBuilder() {
        return node_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.getDefaultInstance() : node_;
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      private org.apache.pekko.protobufv3.internal.ByteString value_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
      /**
       * <code>required bytes value = 2;</code>
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required bytes value = 2;</code>
       * @return The value.
       */
      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.ByteString getValue() {
        return value_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasNode()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!hasValue()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!getNode().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getNode());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeBytes(2, value_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeMessageSize(1, getNode());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeBytesSize(2, value_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry)) {
          return super.equals(obj);
        }
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry) obj;

        if (hasNode() != other.hasNode()) return false;
        if (hasNode()) {
          if (!getNode()
              .equals(other.getNode())) return false;
        }
        if (hasValue() != other.hasValue()) return false;
        if (hasValue()) {
          if (!getValue()
              .equals(other.getValue())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasNode()) {
          hash = (37 * hash) + NODE_FIELD_NUMBER;
          hash = (53 * hash) + getNode().hashCode();
        }
        if (hasValue()) {
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getValue().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry parseFrom(
          java.nio.ByteBuffer data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry parseFrom(
          java.nio.ByteBuffer data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry parseFrom(byte[] data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry parseFrom(
          byte[] data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry parseFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry parseDelimitedFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code org.apache.pekko.cluster.ddata.GCounter.Entry}
       */
      public static final class Builder extends
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.GCounter.Entry)
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.EntryOrBuilder {
        public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_GCounter_Entry_descriptor;
        }

        @java.lang.Override
        protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_GCounter_Entry_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.Builder.class);
        }

        // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getNodeFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          node_ = null;
          if (nodeBuilder_ != null) {
            nodeBuilder_.dispose();
            nodeBuilder_ = null;
          }
          value_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
          return this;
        }

        @java.lang.Override
        public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_GCounter_Entry_descriptor;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry getDefaultInstanceForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry build() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry buildPartial() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry(this);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.node_ = nodeBuilder_ == null
                ? node_
                : nodeBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.value_ = value_;
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
          if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry) {
            return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry other) {
          if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.getDefaultInstance()) return this;
          if (other.hasNode()) {
            mergeNode(other.getNode());
          }
          if (other.hasValue()) {
            setValue(other.getValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!hasNode()) {
            return false;
          }
          if (!hasValue()) {
            return false;
          }
          if (!getNode().isInitialized()) {
            return false;
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  input.readMessage(
                      getNodeFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
                case 18: {
                  value_ = input.readBytes();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress node_;
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddressOrBuilder> nodeBuilder_;
        /**
         * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 1;</code>
         * @return Whether the node field is set.
         */
        public boolean hasNode() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 1;</code>
         * @return The node.
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress getNode() {
          if (nodeBuilder_ == null) {
            return node_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.getDefaultInstance() : node_;
          } else {
            return nodeBuilder_.getMessage();
          }
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 1;</code>
         */
        public Builder setNode(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress value) {
          if (nodeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            node_ = value;
          } else {
            nodeBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 1;</code>
         */
        public Builder setNode(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.Builder builderForValue) {
          if (nodeBuilder_ == null) {
            node_ = builderForValue.build();
          } else {
            nodeBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 1;</code>
         */
        public Builder mergeNode(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress value) {
          if (nodeBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0) &&
              node_ != null &&
              node_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.getDefaultInstance()) {
              getNodeBuilder().mergeFrom(value);
            } else {
              node_ = value;
            }
          } else {
            nodeBuilder_.mergeFrom(value);
          }
          if (node_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 1;</code>
         */
        public Builder clearNode() {
          bitField0_ = (bitField0_ & ~0x00000001);
          node_ = null;
          if (nodeBuilder_ != null) {
            nodeBuilder_.dispose();
            nodeBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 1;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.Builder getNodeBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getNodeFieldBuilder().getBuilder();
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 1;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddressOrBuilder getNodeOrBuilder() {
          if (nodeBuilder_ != null) {
            return nodeBuilder_.getMessageOrBuilder();
          } else {
            return node_ == null ?
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.getDefaultInstance() : node_;
          }
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.UniqueAddress node = 1;</code>
         */
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddressOrBuilder> 
            getNodeFieldBuilder() {
          if (nodeBuilder_ == null) {
            nodeBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddress.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.UniqueAddressOrBuilder>(
                    getNode(),
                    getParentForChildren(),
                    isClean());
            node_ = null;
          }
          return nodeBuilder_;
        }

        private org.apache.pekko.protobufv3.internal.ByteString value_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
        /**
         * <code>required bytes value = 2;</code>
         * @return Whether the value field is set.
         */
        @java.lang.Override
        public boolean hasValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>required bytes value = 2;</code>
         * @return The value.
         */
        @java.lang.Override
        public org.apache.pekko.protobufv3.internal.ByteString getValue() {
          return value_;
        }
        /**
         * <code>required bytes value = 2;</code>
         * @param value The value to set.
         * @return This builder for chaining.
         */
        public Builder setValue(org.apache.pekko.protobufv3.internal.ByteString value) {
          if (value == null) { throw new NullPointerException(); }
          value_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>required bytes value = 2;</code>
         * @return This builder for chaining.
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          value_ = getDefaultInstance().getValue();
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.GCounter.Entry)
      }

      // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.GCounter.Entry)
      private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry();
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<Entry>
          PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<Entry>() {
        @java.lang.Override
        public Entry parsePartialFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static org.apache.pekko.protobufv3.internal.Parser<Entry> parser() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Parser<Entry> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public static final int ENTRIES_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry> entries_;
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry> getEntriesList() {
      return entries_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.EntryOrBuilder> 
        getEntriesOrBuilderList() {
      return entries_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
     */
    @java.lang.Override
    public int getEntriesCount() {
      return entries_.size();
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry getEntries(int index) {
      return entries_.get(index);
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.EntryOrBuilder getEntriesOrBuilder(
        int index) {
      return entries_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getEntriesCount(); i++) {
        if (!getEntries(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < entries_.size(); i++) {
        output.writeMessage(1, entries_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < entries_.size(); i++) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, entries_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter)) {
        return super.equals(obj);
      }
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter) obj;

      if (!getEntriesList()
          .equals(other.getEntriesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getEntriesCount() > 0) {
        hash = (37 * hash) + ENTRIES_FIELD_NUMBER;
        hash = (53 * hash) + getEntriesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.GCounter}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.GCounter)
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounterOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_GCounter_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_GCounter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Builder.class);
      }

      // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.newBuilder()
      private Builder() {

      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
        } else {
          entries_ = null;
          entriesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_GCounter_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter getDefaultInstanceForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter build() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter buildPartial() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter result) {
        if (entriesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            entries_ = java.util.Collections.unmodifiableList(entries_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.entries_ = entries_;
        } else {
          result.entries_ = entriesBuilder_.build();
        }
      }

      private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter) {
          return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter other) {
        if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.getDefaultInstance()) return this;
        if (entriesBuilder_ == null) {
          if (!other.entries_.isEmpty()) {
            if (entries_.isEmpty()) {
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureEntriesIsMutable();
              entries_.addAll(other.entries_);
            }
            onChanged();
          }
        } else {
          if (!other.entries_.isEmpty()) {
            if (entriesBuilder_.isEmpty()) {
              entriesBuilder_.dispose();
              entriesBuilder_ = null;
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000001);
              entriesBuilder_ = 
                org.apache.pekko.protobufv3.internal.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getEntriesFieldBuilder() : null;
            } else {
              entriesBuilder_.addAllMessages(other.entries_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        for (int i = 0; i < getEntriesCount(); i++) {
          if (!getEntries(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry m =
                    input.readMessage(
                        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.PARSER,
                        extensionRegistry);
                if (entriesBuilder_ == null) {
                  ensureEntriesIsMutable();
                  entries_.add(m);
                } else {
                  entriesBuilder_.addMessage(m);
                }
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry> entries_ =
        java.util.Collections.emptyList();
      private void ensureEntriesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          entries_ = new java.util.ArrayList<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry>(entries_);
          bitField0_ |= 0x00000001;
         }
      }

      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.EntryOrBuilder> entriesBuilder_;

      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry> getEntriesList() {
        if (entriesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(entries_);
        } else {
          return entriesBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public int getEntriesCount() {
        if (entriesBuilder_ == null) {
          return entries_.size();
        } else {
          return entriesBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry getEntries(int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);
        } else {
          return entriesBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public Builder setEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.set(index, value);
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public Builder setEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.set(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public Builder addEntries(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public Builder addEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(index, value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public Builder addEntries(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public Builder addEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public Builder addAllEntries(
          java.lang.Iterable<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry> values) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
              values, entries_);
          onChanged();
        } else {
          entriesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public Builder clearEntries() {
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          entriesBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public Builder removeEntries(int index) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.remove(index);
          onChanged();
        } else {
          entriesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.Builder getEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.EntryOrBuilder getEntriesOrBuilder(
          int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);  } else {
          return entriesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.EntryOrBuilder> 
           getEntriesOrBuilderList() {
        if (entriesBuilder_ != null) {
          return entriesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(entries_);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.Builder addEntriesBuilder() {
        return getEntriesFieldBuilder().addBuilder(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.Builder addEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder().addBuilder(
            index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.GCounter.Entry entries = 1;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.Builder> 
           getEntriesBuilderList() {
        return getEntriesFieldBuilder().getBuilderList();
      }
      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.EntryOrBuilder> 
          getEntriesFieldBuilder() {
        if (entriesBuilder_ == null) {
          entriesBuilder_ = new org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.EntryOrBuilder>(
                  entries_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          entries_ = null;
        }
        return entriesBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.GCounter)
    }

    // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.GCounter)
    private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter();
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<GCounter>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<GCounter>() {
      @java.lang.Override
      public GCounter parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<GCounter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<GCounter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PNCounterOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.PNCounter)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required .org.apache.pekko.cluster.ddata.GCounter increments = 1;</code>
     * @return Whether the increments field is set.
     */
    boolean hasIncrements();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.GCounter increments = 1;</code>
     * @return The increments.
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter getIncrements();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.GCounter increments = 1;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounterOrBuilder getIncrementsOrBuilder();

    /**
     * <code>required .org.apache.pekko.cluster.ddata.GCounter decrements = 2;</code>
     * @return Whether the decrements field is set.
     */
    boolean hasDecrements();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.GCounter decrements = 2;</code>
     * @return The decrements.
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter getDecrements();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.GCounter decrements = 2;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounterOrBuilder getDecrementsOrBuilder();
  }
  /**
   * Protobuf type {@code org.apache.pekko.cluster.ddata.PNCounter}
   */
  public static final class PNCounter extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.PNCounter)
      PNCounterOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use PNCounter.newBuilder() to construct.
    private PNCounter(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private PNCounter() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new PNCounter();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_PNCounter_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_PNCounter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.Builder.class);
    }

    private int bitField0_;
    public static final int INCREMENTS_FIELD_NUMBER = 1;
    private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter increments_;
    /**
     * <code>required .org.apache.pekko.cluster.ddata.GCounter increments = 1;</code>
     * @return Whether the increments field is set.
     */
    @java.lang.Override
    public boolean hasIncrements() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.GCounter increments = 1;</code>
     * @return The increments.
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter getIncrements() {
      return increments_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.getDefaultInstance() : increments_;
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.GCounter increments = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounterOrBuilder getIncrementsOrBuilder() {
      return increments_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.getDefaultInstance() : increments_;
    }

    public static final int DECREMENTS_FIELD_NUMBER = 2;
    private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter decrements_;
    /**
     * <code>required .org.apache.pekko.cluster.ddata.GCounter decrements = 2;</code>
     * @return Whether the decrements field is set.
     */
    @java.lang.Override
    public boolean hasDecrements() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.GCounter decrements = 2;</code>
     * @return The decrements.
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter getDecrements() {
      return decrements_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.getDefaultInstance() : decrements_;
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.GCounter decrements = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounterOrBuilder getDecrementsOrBuilder() {
      return decrements_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.getDefaultInstance() : decrements_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasIncrements()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasDecrements()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getIncrements().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getDecrements().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getIncrements());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getDecrements());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getIncrements());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, getDecrements());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter)) {
        return super.equals(obj);
      }
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter) obj;

      if (hasIncrements() != other.hasIncrements()) return false;
      if (hasIncrements()) {
        if (!getIncrements()
            .equals(other.getIncrements())) return false;
      }
      if (hasDecrements() != other.hasDecrements()) return false;
      if (hasDecrements()) {
        if (!getDecrements()
            .equals(other.getDecrements())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasIncrements()) {
        hash = (37 * hash) + INCREMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getIncrements().hashCode();
      }
      if (hasDecrements()) {
        hash = (37 * hash) + DECREMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getDecrements().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.PNCounter}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.PNCounter)
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_PNCounter_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_PNCounter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.Builder.class);
      }

      // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getIncrementsFieldBuilder();
          getDecrementsFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        increments_ = null;
        if (incrementsBuilder_ != null) {
          incrementsBuilder_.dispose();
          incrementsBuilder_ = null;
        }
        decrements_ = null;
        if (decrementsBuilder_ != null) {
          decrementsBuilder_.dispose();
          decrementsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_PNCounter_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter getDefaultInstanceForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter build() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter buildPartial() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.increments_ = incrementsBuilder_ == null
              ? increments_
              : incrementsBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.decrements_ = decrementsBuilder_ == null
              ? decrements_
              : decrementsBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter) {
          return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter other) {
        if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.getDefaultInstance()) return this;
        if (other.hasIncrements()) {
          mergeIncrements(other.getIncrements());
        }
        if (other.hasDecrements()) {
          mergeDecrements(other.getDecrements());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasIncrements()) {
          return false;
        }
        if (!hasDecrements()) {
          return false;
        }
        if (!getIncrements().isInitialized()) {
          return false;
        }
        if (!getDecrements().isInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getIncrementsFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    getDecrementsFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter increments_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounterOrBuilder> incrementsBuilder_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter increments = 1;</code>
       * @return Whether the increments field is set.
       */
      public boolean hasIncrements() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter increments = 1;</code>
       * @return The increments.
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter getIncrements() {
        if (incrementsBuilder_ == null) {
          return increments_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.getDefaultInstance() : increments_;
        } else {
          return incrementsBuilder_.getMessage();
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter increments = 1;</code>
       */
      public Builder setIncrements(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter value) {
        if (incrementsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          increments_ = value;
        } else {
          incrementsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter increments = 1;</code>
       */
      public Builder setIncrements(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Builder builderForValue) {
        if (incrementsBuilder_ == null) {
          increments_ = builderForValue.build();
        } else {
          incrementsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter increments = 1;</code>
       */
      public Builder mergeIncrements(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter value) {
        if (incrementsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            increments_ != null &&
            increments_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.getDefaultInstance()) {
            getIncrementsBuilder().mergeFrom(value);
          } else {
            increments_ = value;
          }
        } else {
          incrementsBuilder_.mergeFrom(value);
        }
        if (increments_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter increments = 1;</code>
       */
      public Builder clearIncrements() {
        bitField0_ = (bitField0_ & ~0x00000001);
        increments_ = null;
        if (incrementsBuilder_ != null) {
          incrementsBuilder_.dispose();
          incrementsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter increments = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Builder getIncrementsBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getIncrementsFieldBuilder().getBuilder();
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter increments = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounterOrBuilder getIncrementsOrBuilder() {
        if (incrementsBuilder_ != null) {
          return incrementsBuilder_.getMessageOrBuilder();
        } else {
          return increments_ == null ?
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.getDefaultInstance() : increments_;
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter increments = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounterOrBuilder> 
          getIncrementsFieldBuilder() {
        if (incrementsBuilder_ == null) {
          incrementsBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounterOrBuilder>(
                  getIncrements(),
                  getParentForChildren(),
                  isClean());
          increments_ = null;
        }
        return incrementsBuilder_;
      }

      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter decrements_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounterOrBuilder> decrementsBuilder_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter decrements = 2;</code>
       * @return Whether the decrements field is set.
       */
      public boolean hasDecrements() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter decrements = 2;</code>
       * @return The decrements.
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter getDecrements() {
        if (decrementsBuilder_ == null) {
          return decrements_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.getDefaultInstance() : decrements_;
        } else {
          return decrementsBuilder_.getMessage();
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter decrements = 2;</code>
       */
      public Builder setDecrements(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter value) {
        if (decrementsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          decrements_ = value;
        } else {
          decrementsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter decrements = 2;</code>
       */
      public Builder setDecrements(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Builder builderForValue) {
        if (decrementsBuilder_ == null) {
          decrements_ = builderForValue.build();
        } else {
          decrementsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter decrements = 2;</code>
       */
      public Builder mergeDecrements(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter value) {
        if (decrementsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            decrements_ != null &&
            decrements_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.getDefaultInstance()) {
            getDecrementsBuilder().mergeFrom(value);
          } else {
            decrements_ = value;
          }
        } else {
          decrementsBuilder_.mergeFrom(value);
        }
        if (decrements_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter decrements = 2;</code>
       */
      public Builder clearDecrements() {
        bitField0_ = (bitField0_ & ~0x00000002);
        decrements_ = null;
        if (decrementsBuilder_ != null) {
          decrementsBuilder_.dispose();
          decrementsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter decrements = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Builder getDecrementsBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getDecrementsFieldBuilder().getBuilder();
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter decrements = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounterOrBuilder getDecrementsOrBuilder() {
        if (decrementsBuilder_ != null) {
          return decrementsBuilder_.getMessageOrBuilder();
        } else {
          return decrements_ == null ?
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.getDefaultInstance() : decrements_;
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.GCounter decrements = 2;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounterOrBuilder> 
          getDecrementsFieldBuilder() {
        if (decrementsBuilder_ == null) {
          decrementsBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounter.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.GCounterOrBuilder>(
                  getDecrements(),
                  getParentForChildren(),
                  isClean());
          decrements_ = null;
        }
        return decrementsBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.PNCounter)
    }

    // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.PNCounter)
    private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter();
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<PNCounter>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<PNCounter>() {
      @java.lang.Override
      public PNCounter parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<PNCounter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<PNCounter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ORMapOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.ORMap)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return Whether the keys field is set.
     */
    boolean hasKeys();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return The keys.
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getKeys();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getKeysOrBuilder();

    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
     */
    java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry> 
        getEntriesList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry getEntries(int index);
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
     */
    int getEntriesCount();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
     */
    java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.EntryOrBuilder> 
        getEntriesOrBuilderList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.EntryOrBuilder getEntriesOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code org.apache.pekko.cluster.ddata.ORMap}
   */
  public static final class ORMap extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.ORMap)
      ORMapOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ORMap.newBuilder() to construct.
    private ORMap(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ORMap() {
      entries_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new ORMap();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMap_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMap_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Builder.class);
    }

    public interface EntryOrBuilder extends
        // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.ORMap.Entry)
        org.apache.pekko.protobufv3.internal.MessageOrBuilder {

      /**
       * <code>optional string stringKey = 1;</code>
       * @return Whether the stringKey field is set.
       */
      boolean hasStringKey();
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The stringKey.
       */
      java.lang.String getStringKey();
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The bytes for stringKey.
       */
      org.apache.pekko.protobufv3.internal.ByteString
          getStringKeyBytes();

      /**
       * <code>required .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
       * @return The value.
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getValue();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getValueOrBuilder();

      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return Whether the intKey field is set.
       */
      boolean hasIntKey();
      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return The intKey.
       */
      int getIntKey();

      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return Whether the longKey field is set.
       */
      boolean hasLongKey();
      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return The longKey.
       */
      long getLongKey();

      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return Whether the otherKey field is set.
       */
      boolean hasOtherKey();
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return The otherKey.
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherKey();
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherKeyOrBuilder();
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.ORMap.Entry}
     */
    public static final class Entry extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.ORMap.Entry)
        EntryOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Entry.newBuilder() to construct.
      private Entry(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Entry() {
        stringKey_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Entry();
      }

      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMap_Entry_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMap_Entry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.Builder.class);
      }

      private int bitField0_;
      public static final int STRINGKEY_FIELD_NUMBER = 1;
      @SuppressWarnings("serial")
      private volatile java.lang.Object stringKey_ = "";
      /**
       * <code>optional string stringKey = 1;</code>
       * @return Whether the stringKey field is set.
       */
      @java.lang.Override
      public boolean hasStringKey() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The stringKey.
       */
      @java.lang.Override
      public java.lang.String getStringKey() {
        java.lang.Object ref = stringKey_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          org.apache.pekko.protobufv3.internal.ByteString bs = 
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            stringKey_ = s;
          }
          return s;
        }
      }
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The bytes for stringKey.
       */
      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.ByteString
          getStringKeyBytes() {
        java.lang.Object ref = stringKey_;
        if (ref instanceof java.lang.String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          stringKey_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
       * @return The value.
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getValue() {
        return value_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : value_;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getValueOrBuilder() {
        return value_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : value_;
      }

      public static final int INTKEY_FIELD_NUMBER = 3;
      private int intKey_ = 0;
      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return Whether the intKey field is set.
       */
      @java.lang.Override
      public boolean hasIntKey() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return The intKey.
       */
      @java.lang.Override
      public int getIntKey() {
        return intKey_;
      }

      public static final int LONGKEY_FIELD_NUMBER = 4;
      private long longKey_ = 0L;
      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return Whether the longKey field is set.
       */
      @java.lang.Override
      public boolean hasLongKey() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return The longKey.
       */
      @java.lang.Override
      public long getLongKey() {
        return longKey_;
      }

      public static final int OTHERKEY_FIELD_NUMBER = 5;
      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage otherKey_;
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return Whether the otherKey field is set.
       */
      @java.lang.Override
      public boolean hasOtherKey() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return The otherKey.
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherKey() {
        return otherKey_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
      }
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherKeyOrBuilder() {
        return otherKey_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasValue()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!getValue().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (hasOtherKey()) {
          if (!getOtherKey().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 1, stringKey_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getValue());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeSInt32(3, intKey_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          output.writeSInt64(4, longKey_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          output.writeMessage(5, getOtherKey());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += org.apache.pekko.protobufv3.internal.GeneratedMessageV3.computeStringSize(1, stringKey_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeMessageSize(2, getValue());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeSInt32Size(3, intKey_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeSInt64Size(4, longKey_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeMessageSize(5, getOtherKey());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry)) {
          return super.equals(obj);
        }
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry) obj;

        if (hasStringKey() != other.hasStringKey()) return false;
        if (hasStringKey()) {
          if (!getStringKey()
              .equals(other.getStringKey())) return false;
        }
        if (hasValue() != other.hasValue()) return false;
        if (hasValue()) {
          if (!getValue()
              .equals(other.getValue())) return false;
        }
        if (hasIntKey() != other.hasIntKey()) return false;
        if (hasIntKey()) {
          if (getIntKey()
              != other.getIntKey()) return false;
        }
        if (hasLongKey() != other.hasLongKey()) return false;
        if (hasLongKey()) {
          if (getLongKey()
              != other.getLongKey()) return false;
        }
        if (hasOtherKey() != other.hasOtherKey()) return false;
        if (hasOtherKey()) {
          if (!getOtherKey()
              .equals(other.getOtherKey())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasStringKey()) {
          hash = (37 * hash) + STRINGKEY_FIELD_NUMBER;
          hash = (53 * hash) + getStringKey().hashCode();
        }
        if (hasValue()) {
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getValue().hashCode();
        }
        if (hasIntKey()) {
          hash = (37 * hash) + INTKEY_FIELD_NUMBER;
          hash = (53 * hash) + getIntKey();
        }
        if (hasLongKey()) {
          hash = (37 * hash) + LONGKEY_FIELD_NUMBER;
          hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
              getLongKey());
        }
        if (hasOtherKey()) {
          hash = (37 * hash) + OTHERKEY_FIELD_NUMBER;
          hash = (53 * hash) + getOtherKey().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry parseFrom(
          java.nio.ByteBuffer data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry parseFrom(
          java.nio.ByteBuffer data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry parseFrom(byte[] data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry parseFrom(
          byte[] data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry parseFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry parseDelimitedFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code org.apache.pekko.cluster.ddata.ORMap.Entry}
       */
      public static final class Builder extends
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.ORMap.Entry)
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.EntryOrBuilder {
        public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMap_Entry_descriptor;
        }

        @java.lang.Override
        protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMap_Entry_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.Builder.class);
        }

        // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getValueFieldBuilder();
            getOtherKeyFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          stringKey_ = "";
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          intKey_ = 0;
          longKey_ = 0L;
          otherKey_ = null;
          if (otherKeyBuilder_ != null) {
            otherKeyBuilder_.dispose();
            otherKeyBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMap_Entry_descriptor;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry getDefaultInstanceForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry build() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry buildPartial() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry(this);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.stringKey_ = stringKey_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.value_ = valueBuilder_ == null
                ? value_
                : valueBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.intKey_ = intKey_;
            to_bitField0_ |= 0x00000004;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.longKey_ = longKey_;
            to_bitField0_ |= 0x00000008;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.otherKey_ = otherKeyBuilder_ == null
                ? otherKey_
                : otherKeyBuilder_.build();
            to_bitField0_ |= 0x00000010;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
          if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry) {
            return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry other) {
          if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.getDefaultInstance()) return this;
          if (other.hasStringKey()) {
            stringKey_ = other.stringKey_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasValue()) {
            mergeValue(other.getValue());
          }
          if (other.hasIntKey()) {
            setIntKey(other.getIntKey());
          }
          if (other.hasLongKey()) {
            setLongKey(other.getLongKey());
          }
          if (other.hasOtherKey()) {
            mergeOtherKey(other.getOtherKey());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!hasValue()) {
            return false;
          }
          if (!getValue().isInitialized()) {
            return false;
          }
          if (hasOtherKey()) {
            if (!getOtherKey().isInitialized()) {
              return false;
            }
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  stringKey_ = input.readBytes();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
                case 18: {
                  input.readMessage(
                      getValueFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
                case 24: {
                  intKey_ = input.readSInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
                case 32: {
                  longKey_ = input.readSInt64();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
                case 42: {
                  input.readMessage(
                      getOtherKeyFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private java.lang.Object stringKey_ = "";
        /**
         * <code>optional string stringKey = 1;</code>
         * @return Whether the stringKey field is set.
         */
        public boolean hasStringKey() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @return The stringKey.
         */
        public java.lang.String getStringKey() {
          java.lang.Object ref = stringKey_;
          if (!(ref instanceof java.lang.String)) {
            org.apache.pekko.protobufv3.internal.ByteString bs =
                (org.apache.pekko.protobufv3.internal.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              stringKey_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @return The bytes for stringKey.
         */
        public org.apache.pekko.protobufv3.internal.ByteString
            getStringKeyBytes() {
          java.lang.Object ref = stringKey_;
          if (ref instanceof String) {
            org.apache.pekko.protobufv3.internal.ByteString b = 
                org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            stringKey_ = b;
            return b;
          } else {
            return (org.apache.pekko.protobufv3.internal.ByteString) ref;
          }
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @param value The stringKey to set.
         * @return This builder for chaining.
         */
        public Builder setStringKey(
            java.lang.String value) {
          if (value == null) { throw new NullPointerException(); }
          stringKey_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearStringKey() {
          stringKey_ = getDefaultInstance().getStringKey();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @param value The bytes for stringKey to set.
         * @return This builder for chaining.
         */
        public Builder setStringKeyBytes(
            org.apache.pekko.protobufv3.internal.ByteString value) {
          if (value == null) { throw new NullPointerException(); }
          stringKey_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value_;
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> valueBuilder_;
        /**
         * <code>required .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         * @return Whether the value field is set.
         */
        public boolean hasValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         * @return The value.
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getValue() {
          if (valueBuilder_ == null) {
            return value_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : value_;
          } else {
            return valueBuilder_.getMessage();
          }
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         */
        public Builder setValue(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
          if (valueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            value_ = value;
          } else {
            valueBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         */
        public Builder setValue(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder builderForValue) {
          if (valueBuilder_ == null) {
            value_ = builderForValue.build();
          } else {
            valueBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         */
        public Builder mergeValue(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
          if (valueBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0) &&
              value_ != null &&
              value_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance()) {
              getValueBuilder().mergeFrom(value);
            } else {
              value_ = value;
            }
          } else {
            valueBuilder_.mergeFrom(value);
          }
          if (value_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder getValueBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getValueFieldBuilder().getBuilder();
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getValueOrBuilder() {
          if (valueBuilder_ != null) {
            return valueBuilder_.getMessageOrBuilder();
          } else {
            return value_ == null ?
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : value_;
          }
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         */
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
            getValueFieldBuilder() {
          if (valueBuilder_ == null) {
            valueBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder>(
                    getValue(),
                    getParentForChildren(),
                    isClean());
            value_ = null;
          }
          return valueBuilder_;
        }

        private int intKey_ ;
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @return Whether the intKey field is set.
         */
        @java.lang.Override
        public boolean hasIntKey() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @return The intKey.
         */
        @java.lang.Override
        public int getIntKey() {
          return intKey_;
        }
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @param value The intKey to set.
         * @return This builder for chaining.
         */
        public Builder setIntKey(int value) {

          intKey_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @return This builder for chaining.
         */
        public Builder clearIntKey() {
          bitField0_ = (bitField0_ & ~0x00000004);
          intKey_ = 0;
          onChanged();
          return this;
        }

        private long longKey_ ;
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @return Whether the longKey field is set.
         */
        @java.lang.Override
        public boolean hasLongKey() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @return The longKey.
         */
        @java.lang.Override
        public long getLongKey() {
          return longKey_;
        }
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @param value The longKey to set.
         * @return This builder for chaining.
         */
        public Builder setLongKey(long value) {

          longKey_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @return This builder for chaining.
         */
        public Builder clearLongKey() {
          bitField0_ = (bitField0_ & ~0x00000008);
          longKey_ = 0L;
          onChanged();
          return this;
        }

        private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage otherKey_;
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> otherKeyBuilder_;
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         * @return Whether the otherKey field is set.
         */
        public boolean hasOtherKey() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         * @return The otherKey.
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherKey() {
          if (otherKeyBuilder_ == null) {
            return otherKey_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
          } else {
            return otherKeyBuilder_.getMessage();
          }
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder setOtherKey(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
          if (otherKeyBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            otherKey_ = value;
          } else {
            otherKeyBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder setOtherKey(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder builderForValue) {
          if (otherKeyBuilder_ == null) {
            otherKey_ = builderForValue.build();
          } else {
            otherKeyBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder mergeOtherKey(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
          if (otherKeyBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0) &&
              otherKey_ != null &&
              otherKey_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance()) {
              getOtherKeyBuilder().mergeFrom(value);
            } else {
              otherKey_ = value;
            }
          } else {
            otherKeyBuilder_.mergeFrom(value);
          }
          if (otherKey_ != null) {
            bitField0_ |= 0x00000010;
            onChanged();
          }
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder clearOtherKey() {
          bitField0_ = (bitField0_ & ~0x00000010);
          otherKey_ = null;
          if (otherKeyBuilder_ != null) {
            otherKeyBuilder_.dispose();
            otherKeyBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder getOtherKeyBuilder() {
          bitField0_ |= 0x00000010;
          onChanged();
          return getOtherKeyFieldBuilder().getBuilder();
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherKeyOrBuilder() {
          if (otherKeyBuilder_ != null) {
            return otherKeyBuilder_.getMessageOrBuilder();
          } else {
            return otherKey_ == null ?
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
          }
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
            getOtherKeyFieldBuilder() {
          if (otherKeyBuilder_ == null) {
            otherKeyBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder>(
                    getOtherKey(),
                    getParentForChildren(),
                    isClean());
            otherKey_ = null;
          }
          return otherKeyBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.ORMap.Entry)
      }

      // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.ORMap.Entry)
      private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry();
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<Entry>
          PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<Entry>() {
        @java.lang.Override
        public Entry parsePartialFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static org.apache.pekko.protobufv3.internal.Parser<Entry> parser() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Parser<Entry> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int KEYS_FIELD_NUMBER = 1;
    private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet keys_;
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return Whether the keys field is set.
     */
    @java.lang.Override
    public boolean hasKeys() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return The keys.
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getKeys() {
      return keys_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getKeysOrBuilder() {
      return keys_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
    }

    public static final int ENTRIES_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry> entries_;
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry> getEntriesList() {
      return entries_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.EntryOrBuilder> 
        getEntriesOrBuilderList() {
      return entries_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public int getEntriesCount() {
      return entries_.size();
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry getEntries(int index) {
      return entries_.get(index);
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.EntryOrBuilder getEntriesOrBuilder(
        int index) {
      return entries_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasKeys()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getKeys().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getEntriesCount(); i++) {
        if (!getEntries(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getKeys());
      }
      for (int i = 0; i < entries_.size(); i++) {
        output.writeMessage(2, entries_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getKeys());
      }
      for (int i = 0; i < entries_.size(); i++) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, entries_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap)) {
        return super.equals(obj);
      }
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap) obj;

      if (hasKeys() != other.hasKeys()) return false;
      if (hasKeys()) {
        if (!getKeys()
            .equals(other.getKeys())) return false;
      }
      if (!getEntriesList()
          .equals(other.getEntriesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKeys()) {
        hash = (37 * hash) + KEYS_FIELD_NUMBER;
        hash = (53 * hash) + getKeys().hashCode();
      }
      if (getEntriesCount() > 0) {
        hash = (37 * hash) + ENTRIES_FIELD_NUMBER;
        hash = (53 * hash) + getEntriesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.ORMap}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.ORMap)
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMap_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMap_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Builder.class);
      }

      // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getKeysFieldBuilder();
          getEntriesFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        keys_ = null;
        if (keysBuilder_ != null) {
          keysBuilder_.dispose();
          keysBuilder_ = null;
        }
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
        } else {
          entries_ = null;
          entriesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMap_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap getDefaultInstanceForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap build() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap buildPartial() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap result) {
        if (entriesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            entries_ = java.util.Collections.unmodifiableList(entries_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.entries_ = entries_;
        } else {
          result.entries_ = entriesBuilder_.build();
        }
      }

      private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.keys_ = keysBuilder_ == null
              ? keys_
              : keysBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap) {
          return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap other) {
        if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.getDefaultInstance()) return this;
        if (other.hasKeys()) {
          mergeKeys(other.getKeys());
        }
        if (entriesBuilder_ == null) {
          if (!other.entries_.isEmpty()) {
            if (entries_.isEmpty()) {
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureEntriesIsMutable();
              entries_.addAll(other.entries_);
            }
            onChanged();
          }
        } else {
          if (!other.entries_.isEmpty()) {
            if (entriesBuilder_.isEmpty()) {
              entriesBuilder_.dispose();
              entriesBuilder_ = null;
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000002);
              entriesBuilder_ = 
                org.apache.pekko.protobufv3.internal.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getEntriesFieldBuilder() : null;
            } else {
              entriesBuilder_.addAllMessages(other.entries_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasKeys()) {
          return false;
        }
        if (!getKeys().isInitialized()) {
          return false;
        }
        for (int i = 0; i < getEntriesCount(); i++) {
          if (!getEntries(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getKeysFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry m =
                    input.readMessage(
                        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.PARSER,
                        extensionRegistry);
                if (entriesBuilder_ == null) {
                  ensureEntriesIsMutable();
                  entries_.add(m);
                } else {
                  entriesBuilder_.addMessage(m);
                }
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet keys_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder> keysBuilder_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       * @return Whether the keys field is set.
       */
      public boolean hasKeys() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       * @return The keys.
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getKeys() {
        if (keysBuilder_ == null) {
          return keys_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
        } else {
          return keysBuilder_.getMessage();
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder setKeys(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value) {
        if (keysBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          keys_ = value;
        } else {
          keysBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder setKeys(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder builderForValue) {
        if (keysBuilder_ == null) {
          keys_ = builderForValue.build();
        } else {
          keysBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder mergeKeys(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value) {
        if (keysBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            keys_ != null &&
            keys_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance()) {
            getKeysBuilder().mergeFrom(value);
          } else {
            keys_ = value;
          }
        } else {
          keysBuilder_.mergeFrom(value);
        }
        if (keys_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder clearKeys() {
        bitField0_ = (bitField0_ & ~0x00000001);
        keys_ = null;
        if (keysBuilder_ != null) {
          keysBuilder_.dispose();
          keysBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder getKeysBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getKeysFieldBuilder().getBuilder();
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getKeysOrBuilder() {
        if (keysBuilder_ != null) {
          return keysBuilder_.getMessageOrBuilder();
        } else {
          return keys_ == null ?
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder> 
          getKeysFieldBuilder() {
        if (keysBuilder_ == null) {
          keysBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder>(
                  getKeys(),
                  getParentForChildren(),
                  isClean());
          keys_ = null;
        }
        return keysBuilder_;
      }

      private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry> entries_ =
        java.util.Collections.emptyList();
      private void ensureEntriesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          entries_ = new java.util.ArrayList<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry>(entries_);
          bitField0_ |= 0x00000002;
         }
      }

      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.EntryOrBuilder> entriesBuilder_;

      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry> getEntriesList() {
        if (entriesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(entries_);
        } else {
          return entriesBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public int getEntriesCount() {
        if (entriesBuilder_ == null) {
          return entries_.size();
        } else {
          return entriesBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry getEntries(int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);
        } else {
          return entriesBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public Builder setEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.set(index, value);
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public Builder setEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.set(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public Builder addEntries(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public Builder addEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(index, value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public Builder addEntries(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public Builder addEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public Builder addAllEntries(
          java.lang.Iterable<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry> values) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
              values, entries_);
          onChanged();
        } else {
          entriesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public Builder clearEntries() {
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          entriesBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public Builder removeEntries(int index) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.remove(index);
          onChanged();
        } else {
          entriesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.Builder getEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.EntryOrBuilder getEntriesOrBuilder(
          int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);  } else {
          return entriesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.EntryOrBuilder> 
           getEntriesOrBuilderList() {
        if (entriesBuilder_ != null) {
          return entriesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(entries_);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.Builder addEntriesBuilder() {
        return getEntriesFieldBuilder().addBuilder(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.Builder addEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder().addBuilder(
            index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMap.Entry entries = 2;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.Builder> 
           getEntriesBuilderList() {
        return getEntriesFieldBuilder().getBuilderList();
      }
      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.EntryOrBuilder> 
          getEntriesFieldBuilder() {
        if (entriesBuilder_ == null) {
          entriesBuilder_ = new org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap.EntryOrBuilder>(
                  entries_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          entries_ = null;
        }
        return entriesBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.ORMap)
    }

    // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.ORMap)
    private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap();
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<ORMap>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<ORMap>() {
      @java.lang.Override
      public ORMap parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<ORMap> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<ORMap> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMap getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ORMapDeltaGroupOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.ORMapDeltaGroup)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
     */
    java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry> 
        getEntriesList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry getEntries(int index);
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
     */
    int getEntriesCount();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
     */
    java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.EntryOrBuilder> 
        getEntriesOrBuilderList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.EntryOrBuilder getEntriesOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code org.apache.pekko.cluster.ddata.ORMapDeltaGroup}
   */
  public static final class ORMapDeltaGroup extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.ORMapDeltaGroup)
      ORMapDeltaGroupOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ORMapDeltaGroup.newBuilder() to construct.
    private ORMapDeltaGroup(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ORMapDeltaGroup() {
      entries_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new ORMapDeltaGroup();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Builder.class);
    }

    public interface MapEntryOrBuilder extends
        // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry)
        org.apache.pekko.protobufv3.internal.MessageOrBuilder {

      /**
       * <code>optional string stringKey = 1;</code>
       * @return Whether the stringKey field is set.
       */
      boolean hasStringKey();
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The stringKey.
       */
      java.lang.String getStringKey();
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The bytes for stringKey.
       */
      org.apache.pekko.protobufv3.internal.ByteString
          getStringKeyBytes();

      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
       * @return The value.
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getValue();
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getValueOrBuilder();

      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return Whether the intKey field is set.
       */
      boolean hasIntKey();
      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return The intKey.
       */
      int getIntKey();

      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return Whether the longKey field is set.
       */
      boolean hasLongKey();
      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return The longKey.
       */
      long getLongKey();

      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return Whether the otherKey field is set.
       */
      boolean hasOtherKey();
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return The otherKey.
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherKey();
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherKeyOrBuilder();
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry}
     */
    public static final class MapEntry extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry)
        MapEntryOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use MapEntry.newBuilder() to construct.
      private MapEntry(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private MapEntry() {
        stringKey_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new MapEntry();
      }

      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_MapEntry_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_MapEntry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.Builder.class);
      }

      private int bitField0_;
      public static final int STRINGKEY_FIELD_NUMBER = 1;
      @SuppressWarnings("serial")
      private volatile java.lang.Object stringKey_ = "";
      /**
       * <code>optional string stringKey = 1;</code>
       * @return Whether the stringKey field is set.
       */
      @java.lang.Override
      public boolean hasStringKey() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The stringKey.
       */
      @java.lang.Override
      public java.lang.String getStringKey() {
        java.lang.Object ref = stringKey_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          org.apache.pekko.protobufv3.internal.ByteString bs = 
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            stringKey_ = s;
          }
          return s;
        }
      }
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The bytes for stringKey.
       */
      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.ByteString
          getStringKeyBytes() {
        java.lang.Object ref = stringKey_;
        if (ref instanceof java.lang.String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          stringKey_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value_;
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
       * @return The value.
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getValue() {
        return value_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : value_;
      }
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getValueOrBuilder() {
        return value_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : value_;
      }

      public static final int INTKEY_FIELD_NUMBER = 3;
      private int intKey_ = 0;
      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return Whether the intKey field is set.
       */
      @java.lang.Override
      public boolean hasIntKey() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return The intKey.
       */
      @java.lang.Override
      public int getIntKey() {
        return intKey_;
      }

      public static final int LONGKEY_FIELD_NUMBER = 4;
      private long longKey_ = 0L;
      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return Whether the longKey field is set.
       */
      @java.lang.Override
      public boolean hasLongKey() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return The longKey.
       */
      @java.lang.Override
      public long getLongKey() {
        return longKey_;
      }

      public static final int OTHERKEY_FIELD_NUMBER = 5;
      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage otherKey_;
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return Whether the otherKey field is set.
       */
      @java.lang.Override
      public boolean hasOtherKey() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return The otherKey.
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherKey() {
        return otherKey_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
      }
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherKeyOrBuilder() {
        return otherKey_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (hasValue()) {
          if (!getValue().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        if (hasOtherKey()) {
          if (!getOtherKey().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 1, stringKey_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getValue());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeSInt32(3, intKey_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          output.writeSInt64(4, longKey_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          output.writeMessage(5, getOtherKey());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += org.apache.pekko.protobufv3.internal.GeneratedMessageV3.computeStringSize(1, stringKey_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeMessageSize(2, getValue());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeSInt32Size(3, intKey_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeSInt64Size(4, longKey_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeMessageSize(5, getOtherKey());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry)) {
          return super.equals(obj);
        }
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry) obj;

        if (hasStringKey() != other.hasStringKey()) return false;
        if (hasStringKey()) {
          if (!getStringKey()
              .equals(other.getStringKey())) return false;
        }
        if (hasValue() != other.hasValue()) return false;
        if (hasValue()) {
          if (!getValue()
              .equals(other.getValue())) return false;
        }
        if (hasIntKey() != other.hasIntKey()) return false;
        if (hasIntKey()) {
          if (getIntKey()
              != other.getIntKey()) return false;
        }
        if (hasLongKey() != other.hasLongKey()) return false;
        if (hasLongKey()) {
          if (getLongKey()
              != other.getLongKey()) return false;
        }
        if (hasOtherKey() != other.hasOtherKey()) return false;
        if (hasOtherKey()) {
          if (!getOtherKey()
              .equals(other.getOtherKey())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasStringKey()) {
          hash = (37 * hash) + STRINGKEY_FIELD_NUMBER;
          hash = (53 * hash) + getStringKey().hashCode();
        }
        if (hasValue()) {
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getValue().hashCode();
        }
        if (hasIntKey()) {
          hash = (37 * hash) + INTKEY_FIELD_NUMBER;
          hash = (53 * hash) + getIntKey();
        }
        if (hasLongKey()) {
          hash = (37 * hash) + LONGKEY_FIELD_NUMBER;
          hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
              getLongKey());
        }
        if (hasOtherKey()) {
          hash = (37 * hash) + OTHERKEY_FIELD_NUMBER;
          hash = (53 * hash) + getOtherKey().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry parseFrom(
          java.nio.ByteBuffer data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry parseFrom(
          java.nio.ByteBuffer data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry parseFrom(byte[] data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry parseFrom(
          byte[] data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry parseFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry parseDelimitedFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry}
       */
      public static final class Builder extends
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry)
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntryOrBuilder {
        public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_MapEntry_descriptor;
        }

        @java.lang.Override
        protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_MapEntry_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.Builder.class);
        }

        // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getValueFieldBuilder();
            getOtherKeyFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          stringKey_ = "";
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          intKey_ = 0;
          longKey_ = 0L;
          otherKey_ = null;
          if (otherKeyBuilder_ != null) {
            otherKeyBuilder_.dispose();
            otherKeyBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_MapEntry_descriptor;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry getDefaultInstanceForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry build() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry buildPartial() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry(this);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.stringKey_ = stringKey_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.value_ = valueBuilder_ == null
                ? value_
                : valueBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.intKey_ = intKey_;
            to_bitField0_ |= 0x00000004;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.longKey_ = longKey_;
            to_bitField0_ |= 0x00000008;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.otherKey_ = otherKeyBuilder_ == null
                ? otherKey_
                : otherKeyBuilder_.build();
            to_bitField0_ |= 0x00000010;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
          if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry) {
            return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry other) {
          if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.getDefaultInstance()) return this;
          if (other.hasStringKey()) {
            stringKey_ = other.stringKey_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasValue()) {
            mergeValue(other.getValue());
          }
          if (other.hasIntKey()) {
            setIntKey(other.getIntKey());
          }
          if (other.hasLongKey()) {
            setLongKey(other.getLongKey());
          }
          if (other.hasOtherKey()) {
            mergeOtherKey(other.getOtherKey());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (hasValue()) {
            if (!getValue().isInitialized()) {
              return false;
            }
          }
          if (hasOtherKey()) {
            if (!getOtherKey().isInitialized()) {
              return false;
            }
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  stringKey_ = input.readBytes();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
                case 18: {
                  input.readMessage(
                      getValueFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
                case 24: {
                  intKey_ = input.readSInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
                case 32: {
                  longKey_ = input.readSInt64();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
                case 42: {
                  input.readMessage(
                      getOtherKeyFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private java.lang.Object stringKey_ = "";
        /**
         * <code>optional string stringKey = 1;</code>
         * @return Whether the stringKey field is set.
         */
        public boolean hasStringKey() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @return The stringKey.
         */
        public java.lang.String getStringKey() {
          java.lang.Object ref = stringKey_;
          if (!(ref instanceof java.lang.String)) {
            org.apache.pekko.protobufv3.internal.ByteString bs =
                (org.apache.pekko.protobufv3.internal.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              stringKey_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @return The bytes for stringKey.
         */
        public org.apache.pekko.protobufv3.internal.ByteString
            getStringKeyBytes() {
          java.lang.Object ref = stringKey_;
          if (ref instanceof String) {
            org.apache.pekko.protobufv3.internal.ByteString b = 
                org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            stringKey_ = b;
            return b;
          } else {
            return (org.apache.pekko.protobufv3.internal.ByteString) ref;
          }
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @param value The stringKey to set.
         * @return This builder for chaining.
         */
        public Builder setStringKey(
            java.lang.String value) {
          if (value == null) { throw new NullPointerException(); }
          stringKey_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearStringKey() {
          stringKey_ = getDefaultInstance().getStringKey();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @param value The bytes for stringKey to set.
         * @return This builder for chaining.
         */
        public Builder setStringKeyBytes(
            org.apache.pekko.protobufv3.internal.ByteString value) {
          if (value == null) { throw new NullPointerException(); }
          stringKey_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value_;
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> valueBuilder_;
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         * @return Whether the value field is set.
         */
        public boolean hasValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         * @return The value.
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getValue() {
          if (valueBuilder_ == null) {
            return value_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : value_;
          } else {
            return valueBuilder_.getMessage();
          }
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         */
        public Builder setValue(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
          if (valueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            value_ = value;
          } else {
            valueBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         */
        public Builder setValue(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder builderForValue) {
          if (valueBuilder_ == null) {
            value_ = builderForValue.build();
          } else {
            valueBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         */
        public Builder mergeValue(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
          if (valueBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0) &&
              value_ != null &&
              value_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance()) {
              getValueBuilder().mergeFrom(value);
            } else {
              value_ = value;
            }
          } else {
            valueBuilder_.mergeFrom(value);
          }
          if (value_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder getValueBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getValueFieldBuilder().getBuilder();
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getValueOrBuilder() {
          if (valueBuilder_ != null) {
            return valueBuilder_.getMessageOrBuilder();
          } else {
            return value_ == null ?
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : value_;
          }
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage value = 2;</code>
         */
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
            getValueFieldBuilder() {
          if (valueBuilder_ == null) {
            valueBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder>(
                    getValue(),
                    getParentForChildren(),
                    isClean());
            value_ = null;
          }
          return valueBuilder_;
        }

        private int intKey_ ;
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @return Whether the intKey field is set.
         */
        @java.lang.Override
        public boolean hasIntKey() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @return The intKey.
         */
        @java.lang.Override
        public int getIntKey() {
          return intKey_;
        }
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @param value The intKey to set.
         * @return This builder for chaining.
         */
        public Builder setIntKey(int value) {

          intKey_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @return This builder for chaining.
         */
        public Builder clearIntKey() {
          bitField0_ = (bitField0_ & ~0x00000004);
          intKey_ = 0;
          onChanged();
          return this;
        }

        private long longKey_ ;
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @return Whether the longKey field is set.
         */
        @java.lang.Override
        public boolean hasLongKey() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @return The longKey.
         */
        @java.lang.Override
        public long getLongKey() {
          return longKey_;
        }
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @param value The longKey to set.
         * @return This builder for chaining.
         */
        public Builder setLongKey(long value) {

          longKey_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @return This builder for chaining.
         */
        public Builder clearLongKey() {
          bitField0_ = (bitField0_ & ~0x00000008);
          longKey_ = 0L;
          onChanged();
          return this;
        }

        private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage otherKey_;
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> otherKeyBuilder_;
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         * @return Whether the otherKey field is set.
         */
        public boolean hasOtherKey() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         * @return The otherKey.
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherKey() {
          if (otherKeyBuilder_ == null) {
            return otherKey_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
          } else {
            return otherKeyBuilder_.getMessage();
          }
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder setOtherKey(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
          if (otherKeyBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            otherKey_ = value;
          } else {
            otherKeyBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder setOtherKey(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder builderForValue) {
          if (otherKeyBuilder_ == null) {
            otherKey_ = builderForValue.build();
          } else {
            otherKeyBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder mergeOtherKey(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
          if (otherKeyBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0) &&
              otherKey_ != null &&
              otherKey_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance()) {
              getOtherKeyBuilder().mergeFrom(value);
            } else {
              otherKey_ = value;
            }
          } else {
            otherKeyBuilder_.mergeFrom(value);
          }
          if (otherKey_ != null) {
            bitField0_ |= 0x00000010;
            onChanged();
          }
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder clearOtherKey() {
          bitField0_ = (bitField0_ & ~0x00000010);
          otherKey_ = null;
          if (otherKeyBuilder_ != null) {
            otherKeyBuilder_.dispose();
            otherKeyBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder getOtherKeyBuilder() {
          bitField0_ |= 0x00000010;
          onChanged();
          return getOtherKeyFieldBuilder().getBuilder();
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherKeyOrBuilder() {
          if (otherKeyBuilder_ != null) {
            return otherKeyBuilder_.getMessageOrBuilder();
          } else {
            return otherKey_ == null ?
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
          }
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
            getOtherKeyFieldBuilder() {
          if (otherKeyBuilder_ == null) {
            otherKeyBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder>(
                    getOtherKey(),
                    getParentForChildren(),
                    isClean());
            otherKey_ = null;
          }
          return otherKeyBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry)
      }

      // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry)
      private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry();
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<MapEntry>
          PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<MapEntry>() {
        @java.lang.Override
        public MapEntry parsePartialFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static org.apache.pekko.protobufv3.internal.Parser<MapEntry> parser() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Parser<MapEntry> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface EntryOrBuilder extends
        // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry)
        org.apache.pekko.protobufv3.internal.MessageOrBuilder {

      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORMapDeltaOp operation = 1;</code>
       * @return Whether the operation field is set.
       */
      boolean hasOperation();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORMapDeltaOp operation = 1;</code>
       * @return The operation.
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaOp getOperation();

      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
       * @return Whether the underlying field is set.
       */
      boolean hasUnderlying();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
       * @return The underlying.
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getUnderlying();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getUnderlyingOrBuilder();

      /**
       * <code>required sint32 zeroTag = 3;</code>
       * @return Whether the zeroTag field is set.
       */
      boolean hasZeroTag();
      /**
       * <code>required sint32 zeroTag = 3;</code>
       * @return The zeroTag.
       */
      int getZeroTag();

      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
       */
      java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry> 
          getEntryDataList();
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry getEntryData(int index);
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
       */
      int getEntryDataCount();
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
       */
      java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntryOrBuilder> 
          getEntryDataOrBuilderList();
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntryOrBuilder getEntryDataOrBuilder(
          int index);
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry}
     */
    public static final class Entry extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry)
        EntryOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Entry.newBuilder() to construct.
      private Entry(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Entry() {
        operation_ = 0;
        entryData_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Entry();
      }

      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_Entry_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_Entry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.Builder.class);
      }

      private int bitField0_;
      public static final int OPERATION_FIELD_NUMBER = 1;
      private int operation_ = 0;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORMapDeltaOp operation = 1;</code>
       * @return Whether the operation field is set.
       */
      @java.lang.Override public boolean hasOperation() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORMapDeltaOp operation = 1;</code>
       * @return The operation.
       */
      @java.lang.Override public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaOp getOperation() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaOp result = org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaOp.forNumber(operation_);
        return result == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaOp.ORMapPut : result;
      }

      public static final int UNDERLYING_FIELD_NUMBER = 2;
      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet underlying_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
       * @return Whether the underlying field is set.
       */
      @java.lang.Override
      public boolean hasUnderlying() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
       * @return The underlying.
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getUnderlying() {
        return underlying_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : underlying_;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getUnderlyingOrBuilder() {
        return underlying_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : underlying_;
      }

      public static final int ZEROTAG_FIELD_NUMBER = 3;
      private int zeroTag_ = 0;
      /**
       * <code>required sint32 zeroTag = 3;</code>
       * @return Whether the zeroTag field is set.
       */
      @java.lang.Override
      public boolean hasZeroTag() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>required sint32 zeroTag = 3;</code>
       * @return The zeroTag.
       */
      @java.lang.Override
      public int getZeroTag() {
        return zeroTag_;
      }

      public static final int ENTRYDATA_FIELD_NUMBER = 4;
      @SuppressWarnings("serial")
      private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry> entryData_;
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
       */
      @java.lang.Override
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry> getEntryDataList() {
        return entryData_;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
       */
      @java.lang.Override
      public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntryOrBuilder> 
          getEntryDataOrBuilderList() {
        return entryData_;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
       */
      @java.lang.Override
      public int getEntryDataCount() {
        return entryData_.size();
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry getEntryData(int index) {
        return entryData_.get(index);
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntryOrBuilder getEntryDataOrBuilder(
          int index) {
        return entryData_.get(index);
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasOperation()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!hasUnderlying()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!hasZeroTag()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!getUnderlying().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        for (int i = 0; i < getEntryDataCount(); i++) {
          if (!getEntryData(i).isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeEnum(1, operation_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getUnderlying());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeSInt32(3, zeroTag_);
        }
        for (int i = 0; i < entryData_.size(); i++) {
          output.writeMessage(4, entryData_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeEnumSize(1, operation_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeMessageSize(2, getUnderlying());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeSInt32Size(3, zeroTag_);
        }
        for (int i = 0; i < entryData_.size(); i++) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeMessageSize(4, entryData_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry)) {
          return super.equals(obj);
        }
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry) obj;

        if (hasOperation() != other.hasOperation()) return false;
        if (hasOperation()) {
          if (operation_ != other.operation_) return false;
        }
        if (hasUnderlying() != other.hasUnderlying()) return false;
        if (hasUnderlying()) {
          if (!getUnderlying()
              .equals(other.getUnderlying())) return false;
        }
        if (hasZeroTag() != other.hasZeroTag()) return false;
        if (hasZeroTag()) {
          if (getZeroTag()
              != other.getZeroTag()) return false;
        }
        if (!getEntryDataList()
            .equals(other.getEntryDataList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasOperation()) {
          hash = (37 * hash) + OPERATION_FIELD_NUMBER;
          hash = (53 * hash) + operation_;
        }
        if (hasUnderlying()) {
          hash = (37 * hash) + UNDERLYING_FIELD_NUMBER;
          hash = (53 * hash) + getUnderlying().hashCode();
        }
        if (hasZeroTag()) {
          hash = (37 * hash) + ZEROTAG_FIELD_NUMBER;
          hash = (53 * hash) + getZeroTag();
        }
        if (getEntryDataCount() > 0) {
          hash = (37 * hash) + ENTRYDATA_FIELD_NUMBER;
          hash = (53 * hash) + getEntryDataList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry parseFrom(
          java.nio.ByteBuffer data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry parseFrom(
          java.nio.ByteBuffer data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry parseFrom(byte[] data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry parseFrom(
          byte[] data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry parseFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry parseDelimitedFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry}
       */
      public static final class Builder extends
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry)
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.EntryOrBuilder {
        public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_Entry_descriptor;
        }

        @java.lang.Override
        protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_Entry_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.Builder.class);
        }

        // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getUnderlyingFieldBuilder();
            getEntryDataFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          operation_ = 0;
          underlying_ = null;
          if (underlyingBuilder_ != null) {
            underlyingBuilder_.dispose();
            underlyingBuilder_ = null;
          }
          zeroTag_ = 0;
          if (entryDataBuilder_ == null) {
            entryData_ = java.util.Collections.emptyList();
          } else {
            entryData_ = null;
            entryDataBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000008);
          return this;
        }

        @java.lang.Override
        public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_Entry_descriptor;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry getDefaultInstanceForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry build() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry buildPartial() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry result) {
          if (entryDataBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)) {
              entryData_ = java.util.Collections.unmodifiableList(entryData_);
              bitField0_ = (bitField0_ & ~0x00000008);
            }
            result.entryData_ = entryData_;
          } else {
            result.entryData_ = entryDataBuilder_.build();
          }
        }

        private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.operation_ = operation_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.underlying_ = underlyingBuilder_ == null
                ? underlying_
                : underlyingBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.zeroTag_ = zeroTag_;
            to_bitField0_ |= 0x00000004;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
          if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry) {
            return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry other) {
          if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.getDefaultInstance()) return this;
          if (other.hasOperation()) {
            setOperation(other.getOperation());
          }
          if (other.hasUnderlying()) {
            mergeUnderlying(other.getUnderlying());
          }
          if (other.hasZeroTag()) {
            setZeroTag(other.getZeroTag());
          }
          if (entryDataBuilder_ == null) {
            if (!other.entryData_.isEmpty()) {
              if (entryData_.isEmpty()) {
                entryData_ = other.entryData_;
                bitField0_ = (bitField0_ & ~0x00000008);
              } else {
                ensureEntryDataIsMutable();
                entryData_.addAll(other.entryData_);
              }
              onChanged();
            }
          } else {
            if (!other.entryData_.isEmpty()) {
              if (entryDataBuilder_.isEmpty()) {
                entryDataBuilder_.dispose();
                entryDataBuilder_ = null;
                entryData_ = other.entryData_;
                bitField0_ = (bitField0_ & ~0x00000008);
                entryDataBuilder_ = 
                  org.apache.pekko.protobufv3.internal.GeneratedMessageV3.alwaysUseFieldBuilders ?
                     getEntryDataFieldBuilder() : null;
              } else {
                entryDataBuilder_.addAllMessages(other.entryData_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!hasOperation()) {
            return false;
          }
          if (!hasUnderlying()) {
            return false;
          }
          if (!hasZeroTag()) {
            return false;
          }
          if (!getUnderlying().isInitialized()) {
            return false;
          }
          for (int i = 0; i < getEntryDataCount(); i++) {
            if (!getEntryData(i).isInitialized()) {
              return false;
            }
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8: {
                  int tmpRaw = input.readEnum();
                  org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaOp tmpValue =
                      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaOp.forNumber(tmpRaw);
                  if (tmpValue == null) {
                    mergeUnknownVarintField(1, tmpRaw);
                  } else {
                    operation_ = tmpRaw;
                    bitField0_ |= 0x00000001;
                  }
                  break;
                } // case 8
                case 18: {
                  input.readMessage(
                      getUnderlyingFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
                case 24: {
                  zeroTag_ = input.readSInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
                case 34: {
                  org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry m =
                      input.readMessage(
                          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.PARSER,
                          extensionRegistry);
                  if (entryDataBuilder_ == null) {
                    ensureEntryDataIsMutable();
                    entryData_.add(m);
                  } else {
                    entryDataBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private int operation_ = 0;
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORMapDeltaOp operation = 1;</code>
         * @return Whether the operation field is set.
         */
        @java.lang.Override public boolean hasOperation() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORMapDeltaOp operation = 1;</code>
         * @return The operation.
         */
        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaOp getOperation() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaOp result = org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaOp.forNumber(operation_);
          return result == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaOp.ORMapPut : result;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORMapDeltaOp operation = 1;</code>
         * @param value The operation to set.
         * @return This builder for chaining.
         */
        public Builder setOperation(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaOp value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000001;
          operation_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORMapDeltaOp operation = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearOperation() {
          bitField0_ = (bitField0_ & ~0x00000001);
          operation_ = 0;
          onChanged();
          return this;
        }

        private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet underlying_;
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder> underlyingBuilder_;
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         * @return Whether the underlying field is set.
         */
        public boolean hasUnderlying() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         * @return The underlying.
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getUnderlying() {
          if (underlyingBuilder_ == null) {
            return underlying_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : underlying_;
          } else {
            return underlyingBuilder_.getMessage();
          }
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         */
        public Builder setUnderlying(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value) {
          if (underlyingBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            underlying_ = value;
          } else {
            underlyingBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         */
        public Builder setUnderlying(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder builderForValue) {
          if (underlyingBuilder_ == null) {
            underlying_ = builderForValue.build();
          } else {
            underlyingBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         */
        public Builder mergeUnderlying(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value) {
          if (underlyingBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0) &&
              underlying_ != null &&
              underlying_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance()) {
              getUnderlyingBuilder().mergeFrom(value);
            } else {
              underlying_ = value;
            }
          } else {
            underlyingBuilder_.mergeFrom(value);
          }
          if (underlying_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         */
        public Builder clearUnderlying() {
          bitField0_ = (bitField0_ & ~0x00000002);
          underlying_ = null;
          if (underlyingBuilder_ != null) {
            underlyingBuilder_.dispose();
            underlyingBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder getUnderlyingBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getUnderlyingFieldBuilder().getBuilder();
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getUnderlyingOrBuilder() {
          if (underlyingBuilder_ != null) {
            return underlyingBuilder_.getMessageOrBuilder();
          } else {
            return underlying_ == null ?
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : underlying_;
          }
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet underlying = 2;</code>
         */
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder> 
            getUnderlyingFieldBuilder() {
          if (underlyingBuilder_ == null) {
            underlyingBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder>(
                    getUnderlying(),
                    getParentForChildren(),
                    isClean());
            underlying_ = null;
          }
          return underlyingBuilder_;
        }

        private int zeroTag_ ;
        /**
         * <code>required sint32 zeroTag = 3;</code>
         * @return Whether the zeroTag field is set.
         */
        @java.lang.Override
        public boolean hasZeroTag() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <code>required sint32 zeroTag = 3;</code>
         * @return The zeroTag.
         */
        @java.lang.Override
        public int getZeroTag() {
          return zeroTag_;
        }
        /**
         * <code>required sint32 zeroTag = 3;</code>
         * @param value The zeroTag to set.
         * @return This builder for chaining.
         */
        public Builder setZeroTag(int value) {

          zeroTag_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         * <code>required sint32 zeroTag = 3;</code>
         * @return This builder for chaining.
         */
        public Builder clearZeroTag() {
          bitField0_ = (bitField0_ & ~0x00000004);
          zeroTag_ = 0;
          onChanged();
          return this;
        }

        private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry> entryData_ =
          java.util.Collections.emptyList();
        private void ensureEntryDataIsMutable() {
          if (!((bitField0_ & 0x00000008) != 0)) {
            entryData_ = new java.util.ArrayList<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry>(entryData_);
            bitField0_ |= 0x00000008;
           }
        }

        private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntryOrBuilder> entryDataBuilder_;

        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry> getEntryDataList() {
          if (entryDataBuilder_ == null) {
            return java.util.Collections.unmodifiableList(entryData_);
          } else {
            return entryDataBuilder_.getMessageList();
          }
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public int getEntryDataCount() {
          if (entryDataBuilder_ == null) {
            return entryData_.size();
          } else {
            return entryDataBuilder_.getCount();
          }
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry getEntryData(int index) {
          if (entryDataBuilder_ == null) {
            return entryData_.get(index);
          } else {
            return entryDataBuilder_.getMessage(index);
          }
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public Builder setEntryData(
            int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry value) {
          if (entryDataBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureEntryDataIsMutable();
            entryData_.set(index, value);
            onChanged();
          } else {
            entryDataBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public Builder setEntryData(
            int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.Builder builderForValue) {
          if (entryDataBuilder_ == null) {
            ensureEntryDataIsMutable();
            entryData_.set(index, builderForValue.build());
            onChanged();
          } else {
            entryDataBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public Builder addEntryData(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry value) {
          if (entryDataBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureEntryDataIsMutable();
            entryData_.add(value);
            onChanged();
          } else {
            entryDataBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public Builder addEntryData(
            int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry value) {
          if (entryDataBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureEntryDataIsMutable();
            entryData_.add(index, value);
            onChanged();
          } else {
            entryDataBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public Builder addEntryData(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.Builder builderForValue) {
          if (entryDataBuilder_ == null) {
            ensureEntryDataIsMutable();
            entryData_.add(builderForValue.build());
            onChanged();
          } else {
            entryDataBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public Builder addEntryData(
            int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.Builder builderForValue) {
          if (entryDataBuilder_ == null) {
            ensureEntryDataIsMutable();
            entryData_.add(index, builderForValue.build());
            onChanged();
          } else {
            entryDataBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public Builder addAllEntryData(
            java.lang.Iterable<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry> values) {
          if (entryDataBuilder_ == null) {
            ensureEntryDataIsMutable();
            org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
                values, entryData_);
            onChanged();
          } else {
            entryDataBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public Builder clearEntryData() {
          if (entryDataBuilder_ == null) {
            entryData_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
          } else {
            entryDataBuilder_.clear();
          }
          return this;
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public Builder removeEntryData(int index) {
          if (entryDataBuilder_ == null) {
            ensureEntryDataIsMutable();
            entryData_.remove(index);
            onChanged();
          } else {
            entryDataBuilder_.remove(index);
          }
          return this;
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.Builder getEntryDataBuilder(
            int index) {
          return getEntryDataFieldBuilder().getBuilder(index);
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntryOrBuilder getEntryDataOrBuilder(
            int index) {
          if (entryDataBuilder_ == null) {
            return entryData_.get(index);  } else {
            return entryDataBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntryOrBuilder> 
             getEntryDataOrBuilderList() {
          if (entryDataBuilder_ != null) {
            return entryDataBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(entryData_);
          }
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.Builder addEntryDataBuilder() {
          return getEntryDataFieldBuilder().addBuilder(
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.getDefaultInstance());
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.Builder addEntryDataBuilder(
            int index) {
          return getEntryDataFieldBuilder().addBuilder(
              index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.getDefaultInstance());
        }
        /**
         * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.MapEntry entryData = 4;</code>
         */
        public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.Builder> 
             getEntryDataBuilderList() {
          return getEntryDataFieldBuilder().getBuilderList();
        }
        private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntryOrBuilder> 
            getEntryDataFieldBuilder() {
          if (entryDataBuilder_ == null) {
            entryDataBuilder_ = new org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.MapEntryOrBuilder>(
                    entryData_,
                    ((bitField0_ & 0x00000008) != 0),
                    getParentForChildren(),
                    isClean());
            entryData_ = null;
          }
          return entryDataBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry)
      }

      // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry)
      private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry();
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<Entry>
          PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<Entry>() {
        @java.lang.Override
        public Entry parsePartialFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static org.apache.pekko.protobufv3.internal.Parser<Entry> parser() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Parser<Entry> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public static final int ENTRIES_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry> entries_;
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry> getEntriesList() {
      return entries_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.EntryOrBuilder> 
        getEntriesOrBuilderList() {
      return entries_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
     */
    @java.lang.Override
    public int getEntriesCount() {
      return entries_.size();
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry getEntries(int index) {
      return entries_.get(index);
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.EntryOrBuilder getEntriesOrBuilder(
        int index) {
      return entries_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getEntriesCount(); i++) {
        if (!getEntries(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < entries_.size(); i++) {
        output.writeMessage(1, entries_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < entries_.size(); i++) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, entries_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup)) {
        return super.equals(obj);
      }
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup) obj;

      if (!getEntriesList()
          .equals(other.getEntriesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getEntriesCount() > 0) {
        hash = (37 * hash) + ENTRIES_FIELD_NUMBER;
        hash = (53 * hash) + getEntriesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.ORMapDeltaGroup}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.ORMapDeltaGroup)
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroupOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Builder.class);
      }

      // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.newBuilder()
      private Builder() {

      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
        } else {
          entries_ = null;
          entriesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup getDefaultInstanceForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup build() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup buildPartial() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup result) {
        if (entriesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            entries_ = java.util.Collections.unmodifiableList(entries_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.entries_ = entries_;
        } else {
          result.entries_ = entriesBuilder_.build();
        }
      }

      private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup) {
          return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup other) {
        if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.getDefaultInstance()) return this;
        if (entriesBuilder_ == null) {
          if (!other.entries_.isEmpty()) {
            if (entries_.isEmpty()) {
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureEntriesIsMutable();
              entries_.addAll(other.entries_);
            }
            onChanged();
          }
        } else {
          if (!other.entries_.isEmpty()) {
            if (entriesBuilder_.isEmpty()) {
              entriesBuilder_.dispose();
              entriesBuilder_ = null;
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000001);
              entriesBuilder_ = 
                org.apache.pekko.protobufv3.internal.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getEntriesFieldBuilder() : null;
            } else {
              entriesBuilder_.addAllMessages(other.entries_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        for (int i = 0; i < getEntriesCount(); i++) {
          if (!getEntries(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry m =
                    input.readMessage(
                        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.PARSER,
                        extensionRegistry);
                if (entriesBuilder_ == null) {
                  ensureEntriesIsMutable();
                  entries_.add(m);
                } else {
                  entriesBuilder_.addMessage(m);
                }
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry> entries_ =
        java.util.Collections.emptyList();
      private void ensureEntriesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          entries_ = new java.util.ArrayList<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry>(entries_);
          bitField0_ |= 0x00000001;
         }
      }

      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.EntryOrBuilder> entriesBuilder_;

      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry> getEntriesList() {
        if (entriesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(entries_);
        } else {
          return entriesBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public int getEntriesCount() {
        if (entriesBuilder_ == null) {
          return entries_.size();
        } else {
          return entriesBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry getEntries(int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);
        } else {
          return entriesBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public Builder setEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.set(index, value);
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public Builder setEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.set(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public Builder addEntries(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public Builder addEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(index, value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public Builder addEntries(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public Builder addEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public Builder addAllEntries(
          java.lang.Iterable<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry> values) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
              values, entries_);
          onChanged();
        } else {
          entriesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public Builder clearEntries() {
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          entriesBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public Builder removeEntries(int index) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.remove(index);
          onChanged();
        } else {
          entriesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.Builder getEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.EntryOrBuilder getEntriesOrBuilder(
          int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);  } else {
          return entriesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.EntryOrBuilder> 
           getEntriesOrBuilderList() {
        if (entriesBuilder_ != null) {
          return entriesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(entries_);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.Builder addEntriesBuilder() {
        return getEntriesFieldBuilder().addBuilder(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.Builder addEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder().addBuilder(
            index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMapDeltaGroup.Entry entries = 1;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.Builder> 
           getEntriesBuilderList() {
        return getEntriesFieldBuilder().getBuilderList();
      }
      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.EntryOrBuilder> 
          getEntriesFieldBuilder() {
        if (entriesBuilder_ == null) {
          entriesBuilder_ = new org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup.EntryOrBuilder>(
                  entries_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          entries_ = null;
        }
        return entriesBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.ORMapDeltaGroup)
    }

    // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.ORMapDeltaGroup)
    private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup();
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<ORMapDeltaGroup>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<ORMapDeltaGroup>() {
      @java.lang.Override
      public ORMapDeltaGroup parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<ORMapDeltaGroup> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<ORMapDeltaGroup> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMapDeltaGroup getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface LWWMapOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.LWWMap)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return Whether the keys field is set.
     */
    boolean hasKeys();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return The keys.
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getKeys();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getKeysOrBuilder();

    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
     */
    java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry> 
        getEntriesList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry getEntries(int index);
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
     */
    int getEntriesCount();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
     */
    java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.EntryOrBuilder> 
        getEntriesOrBuilderList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.EntryOrBuilder getEntriesOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code org.apache.pekko.cluster.ddata.LWWMap}
   */
  public static final class LWWMap extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.LWWMap)
      LWWMapOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use LWWMap.newBuilder() to construct.
    private LWWMap(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private LWWMap() {
      entries_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new LWWMap();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_LWWMap_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_LWWMap_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Builder.class);
    }

    public interface EntryOrBuilder extends
        // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.LWWMap.Entry)
        org.apache.pekko.protobufv3.internal.MessageOrBuilder {

      /**
       * <code>optional string stringKey = 1;</code>
       * @return Whether the stringKey field is set.
       */
      boolean hasStringKey();
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The stringKey.
       */
      java.lang.String getStringKey();
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The bytes for stringKey.
       */
      org.apache.pekko.protobufv3.internal.ByteString
          getStringKeyBytes();

      /**
       * <code>required .org.apache.pekko.cluster.ddata.LWWRegister value = 2;</code>
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.LWWRegister value = 2;</code>
       * @return The value.
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister getValue();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.LWWRegister value = 2;</code>
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegisterOrBuilder getValueOrBuilder();

      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return Whether the intKey field is set.
       */
      boolean hasIntKey();
      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return The intKey.
       */
      int getIntKey();

      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return Whether the longKey field is set.
       */
      boolean hasLongKey();
      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return The longKey.
       */
      long getLongKey();

      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return Whether the otherKey field is set.
       */
      boolean hasOtherKey();
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return The otherKey.
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherKey();
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherKeyOrBuilder();
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.LWWMap.Entry}
     */
    public static final class Entry extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.LWWMap.Entry)
        EntryOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Entry.newBuilder() to construct.
      private Entry(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Entry() {
        stringKey_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Entry();
      }

      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_LWWMap_Entry_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_LWWMap_Entry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.Builder.class);
      }

      private int bitField0_;
      public static final int STRINGKEY_FIELD_NUMBER = 1;
      @SuppressWarnings("serial")
      private volatile java.lang.Object stringKey_ = "";
      /**
       * <code>optional string stringKey = 1;</code>
       * @return Whether the stringKey field is set.
       */
      @java.lang.Override
      public boolean hasStringKey() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The stringKey.
       */
      @java.lang.Override
      public java.lang.String getStringKey() {
        java.lang.Object ref = stringKey_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          org.apache.pekko.protobufv3.internal.ByteString bs = 
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            stringKey_ = s;
          }
          return s;
        }
      }
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The bytes for stringKey.
       */
      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.ByteString
          getStringKeyBytes() {
        java.lang.Object ref = stringKey_;
        if (ref instanceof java.lang.String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          stringKey_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister value_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.LWWRegister value = 2;</code>
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.LWWRegister value = 2;</code>
       * @return The value.
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister getValue() {
        return value_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.getDefaultInstance() : value_;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.LWWRegister value = 2;</code>
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegisterOrBuilder getValueOrBuilder() {
        return value_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.getDefaultInstance() : value_;
      }

      public static final int INTKEY_FIELD_NUMBER = 3;
      private int intKey_ = 0;
      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return Whether the intKey field is set.
       */
      @java.lang.Override
      public boolean hasIntKey() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return The intKey.
       */
      @java.lang.Override
      public int getIntKey() {
        return intKey_;
      }

      public static final int LONGKEY_FIELD_NUMBER = 4;
      private long longKey_ = 0L;
      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return Whether the longKey field is set.
       */
      @java.lang.Override
      public boolean hasLongKey() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return The longKey.
       */
      @java.lang.Override
      public long getLongKey() {
        return longKey_;
      }

      public static final int OTHERKEY_FIELD_NUMBER = 5;
      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage otherKey_;
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return Whether the otherKey field is set.
       */
      @java.lang.Override
      public boolean hasOtherKey() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return The otherKey.
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherKey() {
        return otherKey_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
      }
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherKeyOrBuilder() {
        return otherKey_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasValue()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!getValue().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (hasOtherKey()) {
          if (!getOtherKey().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 1, stringKey_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getValue());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeSInt32(3, intKey_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          output.writeSInt64(4, longKey_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          output.writeMessage(5, getOtherKey());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += org.apache.pekko.protobufv3.internal.GeneratedMessageV3.computeStringSize(1, stringKey_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeMessageSize(2, getValue());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeSInt32Size(3, intKey_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeSInt64Size(4, longKey_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeMessageSize(5, getOtherKey());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry)) {
          return super.equals(obj);
        }
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry) obj;

        if (hasStringKey() != other.hasStringKey()) return false;
        if (hasStringKey()) {
          if (!getStringKey()
              .equals(other.getStringKey())) return false;
        }
        if (hasValue() != other.hasValue()) return false;
        if (hasValue()) {
          if (!getValue()
              .equals(other.getValue())) return false;
        }
        if (hasIntKey() != other.hasIntKey()) return false;
        if (hasIntKey()) {
          if (getIntKey()
              != other.getIntKey()) return false;
        }
        if (hasLongKey() != other.hasLongKey()) return false;
        if (hasLongKey()) {
          if (getLongKey()
              != other.getLongKey()) return false;
        }
        if (hasOtherKey() != other.hasOtherKey()) return false;
        if (hasOtherKey()) {
          if (!getOtherKey()
              .equals(other.getOtherKey())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasStringKey()) {
          hash = (37 * hash) + STRINGKEY_FIELD_NUMBER;
          hash = (53 * hash) + getStringKey().hashCode();
        }
        if (hasValue()) {
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getValue().hashCode();
        }
        if (hasIntKey()) {
          hash = (37 * hash) + INTKEY_FIELD_NUMBER;
          hash = (53 * hash) + getIntKey();
        }
        if (hasLongKey()) {
          hash = (37 * hash) + LONGKEY_FIELD_NUMBER;
          hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
              getLongKey());
        }
        if (hasOtherKey()) {
          hash = (37 * hash) + OTHERKEY_FIELD_NUMBER;
          hash = (53 * hash) + getOtherKey().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry parseFrom(
          java.nio.ByteBuffer data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry parseFrom(
          java.nio.ByteBuffer data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry parseFrom(byte[] data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry parseFrom(
          byte[] data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry parseFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry parseDelimitedFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code org.apache.pekko.cluster.ddata.LWWMap.Entry}
       */
      public static final class Builder extends
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.LWWMap.Entry)
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.EntryOrBuilder {
        public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_LWWMap_Entry_descriptor;
        }

        @java.lang.Override
        protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_LWWMap_Entry_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.Builder.class);
        }

        // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getValueFieldBuilder();
            getOtherKeyFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          stringKey_ = "";
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          intKey_ = 0;
          longKey_ = 0L;
          otherKey_ = null;
          if (otherKeyBuilder_ != null) {
            otherKeyBuilder_.dispose();
            otherKeyBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_LWWMap_Entry_descriptor;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry getDefaultInstanceForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry build() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry buildPartial() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry(this);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.stringKey_ = stringKey_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.value_ = valueBuilder_ == null
                ? value_
                : valueBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.intKey_ = intKey_;
            to_bitField0_ |= 0x00000004;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.longKey_ = longKey_;
            to_bitField0_ |= 0x00000008;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.otherKey_ = otherKeyBuilder_ == null
                ? otherKey_
                : otherKeyBuilder_.build();
            to_bitField0_ |= 0x00000010;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
          if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry) {
            return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry other) {
          if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.getDefaultInstance()) return this;
          if (other.hasStringKey()) {
            stringKey_ = other.stringKey_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasValue()) {
            mergeValue(other.getValue());
          }
          if (other.hasIntKey()) {
            setIntKey(other.getIntKey());
          }
          if (other.hasLongKey()) {
            setLongKey(other.getLongKey());
          }
          if (other.hasOtherKey()) {
            mergeOtherKey(other.getOtherKey());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!hasValue()) {
            return false;
          }
          if (!getValue().isInitialized()) {
            return false;
          }
          if (hasOtherKey()) {
            if (!getOtherKey().isInitialized()) {
              return false;
            }
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  stringKey_ = input.readBytes();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
                case 18: {
                  input.readMessage(
                      getValueFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
                case 24: {
                  intKey_ = input.readSInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
                case 32: {
                  longKey_ = input.readSInt64();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
                case 42: {
                  input.readMessage(
                      getOtherKeyFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private java.lang.Object stringKey_ = "";
        /**
         * <code>optional string stringKey = 1;</code>
         * @return Whether the stringKey field is set.
         */
        public boolean hasStringKey() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @return The stringKey.
         */
        public java.lang.String getStringKey() {
          java.lang.Object ref = stringKey_;
          if (!(ref instanceof java.lang.String)) {
            org.apache.pekko.protobufv3.internal.ByteString bs =
                (org.apache.pekko.protobufv3.internal.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              stringKey_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @return The bytes for stringKey.
         */
        public org.apache.pekko.protobufv3.internal.ByteString
            getStringKeyBytes() {
          java.lang.Object ref = stringKey_;
          if (ref instanceof String) {
            org.apache.pekko.protobufv3.internal.ByteString b = 
                org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            stringKey_ = b;
            return b;
          } else {
            return (org.apache.pekko.protobufv3.internal.ByteString) ref;
          }
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @param value The stringKey to set.
         * @return This builder for chaining.
         */
        public Builder setStringKey(
            java.lang.String value) {
          if (value == null) { throw new NullPointerException(); }
          stringKey_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearStringKey() {
          stringKey_ = getDefaultInstance().getStringKey();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @param value The bytes for stringKey to set.
         * @return This builder for chaining.
         */
        public Builder setStringKeyBytes(
            org.apache.pekko.protobufv3.internal.ByteString value) {
          if (value == null) { throw new NullPointerException(); }
          stringKey_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister value_;
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegisterOrBuilder> valueBuilder_;
        /**
         * <code>required .org.apache.pekko.cluster.ddata.LWWRegister value = 2;</code>
         * @return Whether the value field is set.
         */
        public boolean hasValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.LWWRegister value = 2;</code>
         * @return The value.
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister getValue() {
          if (valueBuilder_ == null) {
            return value_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.getDefaultInstance() : value_;
          } else {
            return valueBuilder_.getMessage();
          }
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.LWWRegister value = 2;</code>
         */
        public Builder setValue(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister value) {
          if (valueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            value_ = value;
          } else {
            valueBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.LWWRegister value = 2;</code>
         */
        public Builder setValue(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.Builder builderForValue) {
          if (valueBuilder_ == null) {
            value_ = builderForValue.build();
          } else {
            valueBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.LWWRegister value = 2;</code>
         */
        public Builder mergeValue(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister value) {
          if (valueBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0) &&
              value_ != null &&
              value_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.getDefaultInstance()) {
              getValueBuilder().mergeFrom(value);
            } else {
              value_ = value;
            }
          } else {
            valueBuilder_.mergeFrom(value);
          }
          if (value_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.LWWRegister value = 2;</code>
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.LWWRegister value = 2;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.Builder getValueBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getValueFieldBuilder().getBuilder();
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.LWWRegister value = 2;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegisterOrBuilder getValueOrBuilder() {
          if (valueBuilder_ != null) {
            return valueBuilder_.getMessageOrBuilder();
          } else {
            return value_ == null ?
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.getDefaultInstance() : value_;
          }
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.LWWRegister value = 2;</code>
         */
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegisterOrBuilder> 
            getValueFieldBuilder() {
          if (valueBuilder_ == null) {
            valueBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegister.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWRegisterOrBuilder>(
                    getValue(),
                    getParentForChildren(),
                    isClean());
            value_ = null;
          }
          return valueBuilder_;
        }

        private int intKey_ ;
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @return Whether the intKey field is set.
         */
        @java.lang.Override
        public boolean hasIntKey() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @return The intKey.
         */
        @java.lang.Override
        public int getIntKey() {
          return intKey_;
        }
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @param value The intKey to set.
         * @return This builder for chaining.
         */
        public Builder setIntKey(int value) {

          intKey_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @return This builder for chaining.
         */
        public Builder clearIntKey() {
          bitField0_ = (bitField0_ & ~0x00000004);
          intKey_ = 0;
          onChanged();
          return this;
        }

        private long longKey_ ;
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @return Whether the longKey field is set.
         */
        @java.lang.Override
        public boolean hasLongKey() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @return The longKey.
         */
        @java.lang.Override
        public long getLongKey() {
          return longKey_;
        }
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @param value The longKey to set.
         * @return This builder for chaining.
         */
        public Builder setLongKey(long value) {

          longKey_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @return This builder for chaining.
         */
        public Builder clearLongKey() {
          bitField0_ = (bitField0_ & ~0x00000008);
          longKey_ = 0L;
          onChanged();
          return this;
        }

        private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage otherKey_;
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> otherKeyBuilder_;
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         * @return Whether the otherKey field is set.
         */
        public boolean hasOtherKey() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         * @return The otherKey.
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherKey() {
          if (otherKeyBuilder_ == null) {
            return otherKey_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
          } else {
            return otherKeyBuilder_.getMessage();
          }
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder setOtherKey(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
          if (otherKeyBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            otherKey_ = value;
          } else {
            otherKeyBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder setOtherKey(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder builderForValue) {
          if (otherKeyBuilder_ == null) {
            otherKey_ = builderForValue.build();
          } else {
            otherKeyBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder mergeOtherKey(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
          if (otherKeyBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0) &&
              otherKey_ != null &&
              otherKey_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance()) {
              getOtherKeyBuilder().mergeFrom(value);
            } else {
              otherKey_ = value;
            }
          } else {
            otherKeyBuilder_.mergeFrom(value);
          }
          if (otherKey_ != null) {
            bitField0_ |= 0x00000010;
            onChanged();
          }
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder clearOtherKey() {
          bitField0_ = (bitField0_ & ~0x00000010);
          otherKey_ = null;
          if (otherKeyBuilder_ != null) {
            otherKeyBuilder_.dispose();
            otherKeyBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder getOtherKeyBuilder() {
          bitField0_ |= 0x00000010;
          onChanged();
          return getOtherKeyFieldBuilder().getBuilder();
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherKeyOrBuilder() {
          if (otherKeyBuilder_ != null) {
            return otherKeyBuilder_.getMessageOrBuilder();
          } else {
            return otherKey_ == null ?
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
          }
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
            getOtherKeyFieldBuilder() {
          if (otherKeyBuilder_ == null) {
            otherKeyBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder>(
                    getOtherKey(),
                    getParentForChildren(),
                    isClean());
            otherKey_ = null;
          }
          return otherKeyBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.LWWMap.Entry)
      }

      // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.LWWMap.Entry)
      private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry();
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<Entry>
          PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<Entry>() {
        @java.lang.Override
        public Entry parsePartialFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static org.apache.pekko.protobufv3.internal.Parser<Entry> parser() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Parser<Entry> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int KEYS_FIELD_NUMBER = 1;
    private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet keys_;
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return Whether the keys field is set.
     */
    @java.lang.Override
    public boolean hasKeys() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return The keys.
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getKeys() {
      return keys_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getKeysOrBuilder() {
      return keys_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
    }

    public static final int ENTRIES_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry> entries_;
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry> getEntriesList() {
      return entries_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.EntryOrBuilder> 
        getEntriesOrBuilderList() {
      return entries_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public int getEntriesCount() {
      return entries_.size();
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry getEntries(int index) {
      return entries_.get(index);
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.EntryOrBuilder getEntriesOrBuilder(
        int index) {
      return entries_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasKeys()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getKeys().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getEntriesCount(); i++) {
        if (!getEntries(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getKeys());
      }
      for (int i = 0; i < entries_.size(); i++) {
        output.writeMessage(2, entries_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getKeys());
      }
      for (int i = 0; i < entries_.size(); i++) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, entries_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap)) {
        return super.equals(obj);
      }
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap) obj;

      if (hasKeys() != other.hasKeys()) return false;
      if (hasKeys()) {
        if (!getKeys()
            .equals(other.getKeys())) return false;
      }
      if (!getEntriesList()
          .equals(other.getEntriesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKeys()) {
        hash = (37 * hash) + KEYS_FIELD_NUMBER;
        hash = (53 * hash) + getKeys().hashCode();
      }
      if (getEntriesCount() > 0) {
        hash = (37 * hash) + ENTRIES_FIELD_NUMBER;
        hash = (53 * hash) + getEntriesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.LWWMap}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.LWWMap)
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMapOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_LWWMap_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_LWWMap_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Builder.class);
      }

      // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getKeysFieldBuilder();
          getEntriesFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        keys_ = null;
        if (keysBuilder_ != null) {
          keysBuilder_.dispose();
          keysBuilder_ = null;
        }
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
        } else {
          entries_ = null;
          entriesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_LWWMap_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap getDefaultInstanceForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap build() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap buildPartial() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap result) {
        if (entriesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            entries_ = java.util.Collections.unmodifiableList(entries_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.entries_ = entries_;
        } else {
          result.entries_ = entriesBuilder_.build();
        }
      }

      private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.keys_ = keysBuilder_ == null
              ? keys_
              : keysBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap) {
          return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap other) {
        if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.getDefaultInstance()) return this;
        if (other.hasKeys()) {
          mergeKeys(other.getKeys());
        }
        if (entriesBuilder_ == null) {
          if (!other.entries_.isEmpty()) {
            if (entries_.isEmpty()) {
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureEntriesIsMutable();
              entries_.addAll(other.entries_);
            }
            onChanged();
          }
        } else {
          if (!other.entries_.isEmpty()) {
            if (entriesBuilder_.isEmpty()) {
              entriesBuilder_.dispose();
              entriesBuilder_ = null;
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000002);
              entriesBuilder_ = 
                org.apache.pekko.protobufv3.internal.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getEntriesFieldBuilder() : null;
            } else {
              entriesBuilder_.addAllMessages(other.entries_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasKeys()) {
          return false;
        }
        if (!getKeys().isInitialized()) {
          return false;
        }
        for (int i = 0; i < getEntriesCount(); i++) {
          if (!getEntries(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getKeysFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry m =
                    input.readMessage(
                        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.PARSER,
                        extensionRegistry);
                if (entriesBuilder_ == null) {
                  ensureEntriesIsMutable();
                  entries_.add(m);
                } else {
                  entriesBuilder_.addMessage(m);
                }
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet keys_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder> keysBuilder_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       * @return Whether the keys field is set.
       */
      public boolean hasKeys() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       * @return The keys.
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getKeys() {
        if (keysBuilder_ == null) {
          return keys_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
        } else {
          return keysBuilder_.getMessage();
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder setKeys(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value) {
        if (keysBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          keys_ = value;
        } else {
          keysBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder setKeys(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder builderForValue) {
        if (keysBuilder_ == null) {
          keys_ = builderForValue.build();
        } else {
          keysBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder mergeKeys(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value) {
        if (keysBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            keys_ != null &&
            keys_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance()) {
            getKeysBuilder().mergeFrom(value);
          } else {
            keys_ = value;
          }
        } else {
          keysBuilder_.mergeFrom(value);
        }
        if (keys_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder clearKeys() {
        bitField0_ = (bitField0_ & ~0x00000001);
        keys_ = null;
        if (keysBuilder_ != null) {
          keysBuilder_.dispose();
          keysBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder getKeysBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getKeysFieldBuilder().getBuilder();
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getKeysOrBuilder() {
        if (keysBuilder_ != null) {
          return keysBuilder_.getMessageOrBuilder();
        } else {
          return keys_ == null ?
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder> 
          getKeysFieldBuilder() {
        if (keysBuilder_ == null) {
          keysBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder>(
                  getKeys(),
                  getParentForChildren(),
                  isClean());
          keys_ = null;
        }
        return keysBuilder_;
      }

      private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry> entries_ =
        java.util.Collections.emptyList();
      private void ensureEntriesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          entries_ = new java.util.ArrayList<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry>(entries_);
          bitField0_ |= 0x00000002;
         }
      }

      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.EntryOrBuilder> entriesBuilder_;

      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry> getEntriesList() {
        if (entriesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(entries_);
        } else {
          return entriesBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public int getEntriesCount() {
        if (entriesBuilder_ == null) {
          return entries_.size();
        } else {
          return entriesBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry getEntries(int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);
        } else {
          return entriesBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public Builder setEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.set(index, value);
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public Builder setEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.set(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public Builder addEntries(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public Builder addEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(index, value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public Builder addEntries(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public Builder addEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public Builder addAllEntries(
          java.lang.Iterable<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry> values) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
              values, entries_);
          onChanged();
        } else {
          entriesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public Builder clearEntries() {
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          entriesBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public Builder removeEntries(int index) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.remove(index);
          onChanged();
        } else {
          entriesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.Builder getEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.EntryOrBuilder getEntriesOrBuilder(
          int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);  } else {
          return entriesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.EntryOrBuilder> 
           getEntriesOrBuilderList() {
        if (entriesBuilder_ != null) {
          return entriesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(entries_);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.Builder addEntriesBuilder() {
        return getEntriesFieldBuilder().addBuilder(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.Builder addEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder().addBuilder(
            index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.LWWMap.Entry entries = 2;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.Builder> 
           getEntriesBuilderList() {
        return getEntriesFieldBuilder().getBuilderList();
      }
      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.EntryOrBuilder> 
          getEntriesFieldBuilder() {
        if (entriesBuilder_ == null) {
          entriesBuilder_ = new org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap.EntryOrBuilder>(
                  entries_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          entries_ = null;
        }
        return entriesBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.LWWMap)
    }

    // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.LWWMap)
    private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap();
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<LWWMap>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<LWWMap>() {
      @java.lang.Override
      public LWWMap parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<LWWMap> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<LWWMap> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.LWWMap getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PNCounterMapOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.PNCounterMap)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return Whether the keys field is set.
     */
    boolean hasKeys();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return The keys.
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getKeys();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getKeysOrBuilder();

    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
     */
    java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry> 
        getEntriesList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry getEntries(int index);
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
     */
    int getEntriesCount();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
     */
    java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.EntryOrBuilder> 
        getEntriesOrBuilderList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.EntryOrBuilder getEntriesOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code org.apache.pekko.cluster.ddata.PNCounterMap}
   */
  public static final class PNCounterMap extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.PNCounterMap)
      PNCounterMapOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use PNCounterMap.newBuilder() to construct.
    private PNCounterMap(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private PNCounterMap() {
      entries_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new PNCounterMap();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Builder.class);
    }

    public interface EntryOrBuilder extends
        // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.PNCounterMap.Entry)
        org.apache.pekko.protobufv3.internal.MessageOrBuilder {

      /**
       * <code>optional string stringKey = 1;</code>
       * @return Whether the stringKey field is set.
       */
      boolean hasStringKey();
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The stringKey.
       */
      java.lang.String getStringKey();
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The bytes for stringKey.
       */
      org.apache.pekko.protobufv3.internal.ByteString
          getStringKeyBytes();

      /**
       * <code>required .org.apache.pekko.cluster.ddata.PNCounter value = 2;</code>
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.PNCounter value = 2;</code>
       * @return The value.
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter getValue();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.PNCounter value = 2;</code>
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterOrBuilder getValueOrBuilder();

      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return Whether the intKey field is set.
       */
      boolean hasIntKey();
      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return The intKey.
       */
      int getIntKey();

      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return Whether the longKey field is set.
       */
      boolean hasLongKey();
      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return The longKey.
       */
      long getLongKey();

      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return Whether the otherKey field is set.
       */
      boolean hasOtherKey();
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return The otherKey.
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherKey();
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherKeyOrBuilder();
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.PNCounterMap.Entry}
     */
    public static final class Entry extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.PNCounterMap.Entry)
        EntryOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Entry.newBuilder() to construct.
      private Entry(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Entry() {
        stringKey_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Entry();
      }

      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_Entry_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_Entry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.Builder.class);
      }

      private int bitField0_;
      public static final int STRINGKEY_FIELD_NUMBER = 1;
      @SuppressWarnings("serial")
      private volatile java.lang.Object stringKey_ = "";
      /**
       * <code>optional string stringKey = 1;</code>
       * @return Whether the stringKey field is set.
       */
      @java.lang.Override
      public boolean hasStringKey() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The stringKey.
       */
      @java.lang.Override
      public java.lang.String getStringKey() {
        java.lang.Object ref = stringKey_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          org.apache.pekko.protobufv3.internal.ByteString bs = 
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            stringKey_ = s;
          }
          return s;
        }
      }
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The bytes for stringKey.
       */
      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.ByteString
          getStringKeyBytes() {
        java.lang.Object ref = stringKey_;
        if (ref instanceof java.lang.String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          stringKey_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter value_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.PNCounter value = 2;</code>
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.PNCounter value = 2;</code>
       * @return The value.
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter getValue() {
        return value_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.getDefaultInstance() : value_;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.PNCounter value = 2;</code>
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterOrBuilder getValueOrBuilder() {
        return value_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.getDefaultInstance() : value_;
      }

      public static final int INTKEY_FIELD_NUMBER = 3;
      private int intKey_ = 0;
      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return Whether the intKey field is set.
       */
      @java.lang.Override
      public boolean hasIntKey() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return The intKey.
       */
      @java.lang.Override
      public int getIntKey() {
        return intKey_;
      }

      public static final int LONGKEY_FIELD_NUMBER = 4;
      private long longKey_ = 0L;
      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return Whether the longKey field is set.
       */
      @java.lang.Override
      public boolean hasLongKey() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return The longKey.
       */
      @java.lang.Override
      public long getLongKey() {
        return longKey_;
      }

      public static final int OTHERKEY_FIELD_NUMBER = 5;
      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage otherKey_;
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return Whether the otherKey field is set.
       */
      @java.lang.Override
      public boolean hasOtherKey() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return The otherKey.
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherKey() {
        return otherKey_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
      }
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherKeyOrBuilder() {
        return otherKey_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasValue()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!getValue().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (hasOtherKey()) {
          if (!getOtherKey().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 1, stringKey_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getValue());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeSInt32(3, intKey_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          output.writeSInt64(4, longKey_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          output.writeMessage(5, getOtherKey());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += org.apache.pekko.protobufv3.internal.GeneratedMessageV3.computeStringSize(1, stringKey_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeMessageSize(2, getValue());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeSInt32Size(3, intKey_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeSInt64Size(4, longKey_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeMessageSize(5, getOtherKey());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry)) {
          return super.equals(obj);
        }
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry) obj;

        if (hasStringKey() != other.hasStringKey()) return false;
        if (hasStringKey()) {
          if (!getStringKey()
              .equals(other.getStringKey())) return false;
        }
        if (hasValue() != other.hasValue()) return false;
        if (hasValue()) {
          if (!getValue()
              .equals(other.getValue())) return false;
        }
        if (hasIntKey() != other.hasIntKey()) return false;
        if (hasIntKey()) {
          if (getIntKey()
              != other.getIntKey()) return false;
        }
        if (hasLongKey() != other.hasLongKey()) return false;
        if (hasLongKey()) {
          if (getLongKey()
              != other.getLongKey()) return false;
        }
        if (hasOtherKey() != other.hasOtherKey()) return false;
        if (hasOtherKey()) {
          if (!getOtherKey()
              .equals(other.getOtherKey())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasStringKey()) {
          hash = (37 * hash) + STRINGKEY_FIELD_NUMBER;
          hash = (53 * hash) + getStringKey().hashCode();
        }
        if (hasValue()) {
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getValue().hashCode();
        }
        if (hasIntKey()) {
          hash = (37 * hash) + INTKEY_FIELD_NUMBER;
          hash = (53 * hash) + getIntKey();
        }
        if (hasLongKey()) {
          hash = (37 * hash) + LONGKEY_FIELD_NUMBER;
          hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
              getLongKey());
        }
        if (hasOtherKey()) {
          hash = (37 * hash) + OTHERKEY_FIELD_NUMBER;
          hash = (53 * hash) + getOtherKey().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry parseFrom(
          java.nio.ByteBuffer data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry parseFrom(
          java.nio.ByteBuffer data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry parseFrom(byte[] data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry parseFrom(
          byte[] data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry parseFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry parseDelimitedFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code org.apache.pekko.cluster.ddata.PNCounterMap.Entry}
       */
      public static final class Builder extends
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.PNCounterMap.Entry)
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.EntryOrBuilder {
        public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_Entry_descriptor;
        }

        @java.lang.Override
        protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_Entry_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.Builder.class);
        }

        // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getValueFieldBuilder();
            getOtherKeyFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          stringKey_ = "";
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          intKey_ = 0;
          longKey_ = 0L;
          otherKey_ = null;
          if (otherKeyBuilder_ != null) {
            otherKeyBuilder_.dispose();
            otherKeyBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_Entry_descriptor;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry getDefaultInstanceForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry build() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry buildPartial() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry(this);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.stringKey_ = stringKey_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.value_ = valueBuilder_ == null
                ? value_
                : valueBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.intKey_ = intKey_;
            to_bitField0_ |= 0x00000004;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.longKey_ = longKey_;
            to_bitField0_ |= 0x00000008;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.otherKey_ = otherKeyBuilder_ == null
                ? otherKey_
                : otherKeyBuilder_.build();
            to_bitField0_ |= 0x00000010;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
          if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry) {
            return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry other) {
          if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.getDefaultInstance()) return this;
          if (other.hasStringKey()) {
            stringKey_ = other.stringKey_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasValue()) {
            mergeValue(other.getValue());
          }
          if (other.hasIntKey()) {
            setIntKey(other.getIntKey());
          }
          if (other.hasLongKey()) {
            setLongKey(other.getLongKey());
          }
          if (other.hasOtherKey()) {
            mergeOtherKey(other.getOtherKey());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!hasValue()) {
            return false;
          }
          if (!getValue().isInitialized()) {
            return false;
          }
          if (hasOtherKey()) {
            if (!getOtherKey().isInitialized()) {
              return false;
            }
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  stringKey_ = input.readBytes();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
                case 18: {
                  input.readMessage(
                      getValueFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
                case 24: {
                  intKey_ = input.readSInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
                case 32: {
                  longKey_ = input.readSInt64();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
                case 42: {
                  input.readMessage(
                      getOtherKeyFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private java.lang.Object stringKey_ = "";
        /**
         * <code>optional string stringKey = 1;</code>
         * @return Whether the stringKey field is set.
         */
        public boolean hasStringKey() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @return The stringKey.
         */
        public java.lang.String getStringKey() {
          java.lang.Object ref = stringKey_;
          if (!(ref instanceof java.lang.String)) {
            org.apache.pekko.protobufv3.internal.ByteString bs =
                (org.apache.pekko.protobufv3.internal.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              stringKey_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @return The bytes for stringKey.
         */
        public org.apache.pekko.protobufv3.internal.ByteString
            getStringKeyBytes() {
          java.lang.Object ref = stringKey_;
          if (ref instanceof String) {
            org.apache.pekko.protobufv3.internal.ByteString b = 
                org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            stringKey_ = b;
            return b;
          } else {
            return (org.apache.pekko.protobufv3.internal.ByteString) ref;
          }
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @param value The stringKey to set.
         * @return This builder for chaining.
         */
        public Builder setStringKey(
            java.lang.String value) {
          if (value == null) { throw new NullPointerException(); }
          stringKey_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearStringKey() {
          stringKey_ = getDefaultInstance().getStringKey();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @param value The bytes for stringKey to set.
         * @return This builder for chaining.
         */
        public Builder setStringKeyBytes(
            org.apache.pekko.protobufv3.internal.ByteString value) {
          if (value == null) { throw new NullPointerException(); }
          stringKey_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter value_;
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterOrBuilder> valueBuilder_;
        /**
         * <code>required .org.apache.pekko.cluster.ddata.PNCounter value = 2;</code>
         * @return Whether the value field is set.
         */
        public boolean hasValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.PNCounter value = 2;</code>
         * @return The value.
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter getValue() {
          if (valueBuilder_ == null) {
            return value_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.getDefaultInstance() : value_;
          } else {
            return valueBuilder_.getMessage();
          }
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.PNCounter value = 2;</code>
         */
        public Builder setValue(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter value) {
          if (valueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            value_ = value;
          } else {
            valueBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.PNCounter value = 2;</code>
         */
        public Builder setValue(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.Builder builderForValue) {
          if (valueBuilder_ == null) {
            value_ = builderForValue.build();
          } else {
            valueBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.PNCounter value = 2;</code>
         */
        public Builder mergeValue(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter value) {
          if (valueBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0) &&
              value_ != null &&
              value_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.getDefaultInstance()) {
              getValueBuilder().mergeFrom(value);
            } else {
              value_ = value;
            }
          } else {
            valueBuilder_.mergeFrom(value);
          }
          if (value_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.PNCounter value = 2;</code>
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.PNCounter value = 2;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.Builder getValueBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getValueFieldBuilder().getBuilder();
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.PNCounter value = 2;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterOrBuilder getValueOrBuilder() {
          if (valueBuilder_ != null) {
            return valueBuilder_.getMessageOrBuilder();
          } else {
            return value_ == null ?
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.getDefaultInstance() : value_;
          }
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.PNCounter value = 2;</code>
         */
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterOrBuilder> 
            getValueFieldBuilder() {
          if (valueBuilder_ == null) {
            valueBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounter.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterOrBuilder>(
                    getValue(),
                    getParentForChildren(),
                    isClean());
            value_ = null;
          }
          return valueBuilder_;
        }

        private int intKey_ ;
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @return Whether the intKey field is set.
         */
        @java.lang.Override
        public boolean hasIntKey() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @return The intKey.
         */
        @java.lang.Override
        public int getIntKey() {
          return intKey_;
        }
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @param value The intKey to set.
         * @return This builder for chaining.
         */
        public Builder setIntKey(int value) {

          intKey_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @return This builder for chaining.
         */
        public Builder clearIntKey() {
          bitField0_ = (bitField0_ & ~0x00000004);
          intKey_ = 0;
          onChanged();
          return this;
        }

        private long longKey_ ;
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @return Whether the longKey field is set.
         */
        @java.lang.Override
        public boolean hasLongKey() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @return The longKey.
         */
        @java.lang.Override
        public long getLongKey() {
          return longKey_;
        }
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @param value The longKey to set.
         * @return This builder for chaining.
         */
        public Builder setLongKey(long value) {

          longKey_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @return This builder for chaining.
         */
        public Builder clearLongKey() {
          bitField0_ = (bitField0_ & ~0x00000008);
          longKey_ = 0L;
          onChanged();
          return this;
        }

        private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage otherKey_;
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> otherKeyBuilder_;
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         * @return Whether the otherKey field is set.
         */
        public boolean hasOtherKey() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         * @return The otherKey.
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherKey() {
          if (otherKeyBuilder_ == null) {
            return otherKey_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
          } else {
            return otherKeyBuilder_.getMessage();
          }
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder setOtherKey(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
          if (otherKeyBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            otherKey_ = value;
          } else {
            otherKeyBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder setOtherKey(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder builderForValue) {
          if (otherKeyBuilder_ == null) {
            otherKey_ = builderForValue.build();
          } else {
            otherKeyBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder mergeOtherKey(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
          if (otherKeyBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0) &&
              otherKey_ != null &&
              otherKey_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance()) {
              getOtherKeyBuilder().mergeFrom(value);
            } else {
              otherKey_ = value;
            }
          } else {
            otherKeyBuilder_.mergeFrom(value);
          }
          if (otherKey_ != null) {
            bitField0_ |= 0x00000010;
            onChanged();
          }
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder clearOtherKey() {
          bitField0_ = (bitField0_ & ~0x00000010);
          otherKey_ = null;
          if (otherKeyBuilder_ != null) {
            otherKeyBuilder_.dispose();
            otherKeyBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder getOtherKeyBuilder() {
          bitField0_ |= 0x00000010;
          onChanged();
          return getOtherKeyFieldBuilder().getBuilder();
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherKeyOrBuilder() {
          if (otherKeyBuilder_ != null) {
            return otherKeyBuilder_.getMessageOrBuilder();
          } else {
            return otherKey_ == null ?
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
          }
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
            getOtherKeyFieldBuilder() {
          if (otherKeyBuilder_ == null) {
            otherKeyBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder>(
                    getOtherKey(),
                    getParentForChildren(),
                    isClean());
            otherKey_ = null;
          }
          return otherKeyBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.PNCounterMap.Entry)
      }

      // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.PNCounterMap.Entry)
      private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry();
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<Entry>
          PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<Entry>() {
        @java.lang.Override
        public Entry parsePartialFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static org.apache.pekko.protobufv3.internal.Parser<Entry> parser() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Parser<Entry> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int KEYS_FIELD_NUMBER = 1;
    private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet keys_;
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return Whether the keys field is set.
     */
    @java.lang.Override
    public boolean hasKeys() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return The keys.
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getKeys() {
      return keys_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getKeysOrBuilder() {
      return keys_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
    }

    public static final int ENTRIES_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry> entries_;
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry> getEntriesList() {
      return entries_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.EntryOrBuilder> 
        getEntriesOrBuilderList() {
      return entries_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public int getEntriesCount() {
      return entries_.size();
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry getEntries(int index) {
      return entries_.get(index);
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.EntryOrBuilder getEntriesOrBuilder(
        int index) {
      return entries_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasKeys()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getKeys().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getEntriesCount(); i++) {
        if (!getEntries(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getKeys());
      }
      for (int i = 0; i < entries_.size(); i++) {
        output.writeMessage(2, entries_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getKeys());
      }
      for (int i = 0; i < entries_.size(); i++) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, entries_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap)) {
        return super.equals(obj);
      }
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap) obj;

      if (hasKeys() != other.hasKeys()) return false;
      if (hasKeys()) {
        if (!getKeys()
            .equals(other.getKeys())) return false;
      }
      if (!getEntriesList()
          .equals(other.getEntriesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKeys()) {
        hash = (37 * hash) + KEYS_FIELD_NUMBER;
        hash = (53 * hash) + getKeys().hashCode();
      }
      if (getEntriesCount() > 0) {
        hash = (37 * hash) + ENTRIES_FIELD_NUMBER;
        hash = (53 * hash) + getEntriesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.PNCounterMap}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.PNCounterMap)
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMapOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Builder.class);
      }

      // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getKeysFieldBuilder();
          getEntriesFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        keys_ = null;
        if (keysBuilder_ != null) {
          keysBuilder_.dispose();
          keysBuilder_ = null;
        }
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
        } else {
          entries_ = null;
          entriesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap getDefaultInstanceForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap build() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap buildPartial() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap result) {
        if (entriesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            entries_ = java.util.Collections.unmodifiableList(entries_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.entries_ = entries_;
        } else {
          result.entries_ = entriesBuilder_.build();
        }
      }

      private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.keys_ = keysBuilder_ == null
              ? keys_
              : keysBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap) {
          return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap other) {
        if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.getDefaultInstance()) return this;
        if (other.hasKeys()) {
          mergeKeys(other.getKeys());
        }
        if (entriesBuilder_ == null) {
          if (!other.entries_.isEmpty()) {
            if (entries_.isEmpty()) {
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureEntriesIsMutable();
              entries_.addAll(other.entries_);
            }
            onChanged();
          }
        } else {
          if (!other.entries_.isEmpty()) {
            if (entriesBuilder_.isEmpty()) {
              entriesBuilder_.dispose();
              entriesBuilder_ = null;
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000002);
              entriesBuilder_ = 
                org.apache.pekko.protobufv3.internal.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getEntriesFieldBuilder() : null;
            } else {
              entriesBuilder_.addAllMessages(other.entries_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasKeys()) {
          return false;
        }
        if (!getKeys().isInitialized()) {
          return false;
        }
        for (int i = 0; i < getEntriesCount(); i++) {
          if (!getEntries(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getKeysFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry m =
                    input.readMessage(
                        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.PARSER,
                        extensionRegistry);
                if (entriesBuilder_ == null) {
                  ensureEntriesIsMutable();
                  entries_.add(m);
                } else {
                  entriesBuilder_.addMessage(m);
                }
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet keys_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder> keysBuilder_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       * @return Whether the keys field is set.
       */
      public boolean hasKeys() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       * @return The keys.
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getKeys() {
        if (keysBuilder_ == null) {
          return keys_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
        } else {
          return keysBuilder_.getMessage();
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder setKeys(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value) {
        if (keysBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          keys_ = value;
        } else {
          keysBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder setKeys(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder builderForValue) {
        if (keysBuilder_ == null) {
          keys_ = builderForValue.build();
        } else {
          keysBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder mergeKeys(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value) {
        if (keysBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            keys_ != null &&
            keys_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance()) {
            getKeysBuilder().mergeFrom(value);
          } else {
            keys_ = value;
          }
        } else {
          keysBuilder_.mergeFrom(value);
        }
        if (keys_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder clearKeys() {
        bitField0_ = (bitField0_ & ~0x00000001);
        keys_ = null;
        if (keysBuilder_ != null) {
          keysBuilder_.dispose();
          keysBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder getKeysBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getKeysFieldBuilder().getBuilder();
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getKeysOrBuilder() {
        if (keysBuilder_ != null) {
          return keysBuilder_.getMessageOrBuilder();
        } else {
          return keys_ == null ?
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder> 
          getKeysFieldBuilder() {
        if (keysBuilder_ == null) {
          keysBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder>(
                  getKeys(),
                  getParentForChildren(),
                  isClean());
          keys_ = null;
        }
        return keysBuilder_;
      }

      private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry> entries_ =
        java.util.Collections.emptyList();
      private void ensureEntriesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          entries_ = new java.util.ArrayList<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry>(entries_);
          bitField0_ |= 0x00000002;
         }
      }

      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.EntryOrBuilder> entriesBuilder_;

      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry> getEntriesList() {
        if (entriesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(entries_);
        } else {
          return entriesBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public int getEntriesCount() {
        if (entriesBuilder_ == null) {
          return entries_.size();
        } else {
          return entriesBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry getEntries(int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);
        } else {
          return entriesBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public Builder setEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.set(index, value);
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public Builder setEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.set(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public Builder addEntries(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public Builder addEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(index, value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public Builder addEntries(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public Builder addEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public Builder addAllEntries(
          java.lang.Iterable<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry> values) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
              values, entries_);
          onChanged();
        } else {
          entriesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public Builder clearEntries() {
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          entriesBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public Builder removeEntries(int index) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.remove(index);
          onChanged();
        } else {
          entriesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.Builder getEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.EntryOrBuilder getEntriesOrBuilder(
          int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);  } else {
          return entriesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.EntryOrBuilder> 
           getEntriesOrBuilderList() {
        if (entriesBuilder_ != null) {
          return entriesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(entries_);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.Builder addEntriesBuilder() {
        return getEntriesFieldBuilder().addBuilder(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.Builder addEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder().addBuilder(
            index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.PNCounterMap.Entry entries = 2;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.Builder> 
           getEntriesBuilderList() {
        return getEntriesFieldBuilder().getBuilderList();
      }
      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.EntryOrBuilder> 
          getEntriesFieldBuilder() {
        if (entriesBuilder_ == null) {
          entriesBuilder_ = new org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap.EntryOrBuilder>(
                  entries_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          entries_ = null;
        }
        return entriesBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.PNCounterMap)
    }

    // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.PNCounterMap)
    private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap();
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<PNCounterMap>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<PNCounterMap>() {
      @java.lang.Override
      public PNCounterMap parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<PNCounterMap> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<PNCounterMap> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.PNCounterMap getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ORMultiMapOrBuilder extends
      // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.ORMultiMap)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return Whether the keys field is set.
     */
    boolean hasKeys();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return The keys.
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getKeys();
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getKeysOrBuilder();

    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
     */
    java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry> 
        getEntriesList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry getEntries(int index);
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
     */
    int getEntriesCount();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
     */
    java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.EntryOrBuilder> 
        getEntriesOrBuilderList();
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
     */
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.EntryOrBuilder getEntriesOrBuilder(
        int index);

    /**
     * <code>optional bool withValueDeltas = 3;</code>
     * @return Whether the withValueDeltas field is set.
     */
    boolean hasWithValueDeltas();
    /**
     * <code>optional bool withValueDeltas = 3;</code>
     * @return The withValueDeltas.
     */
    boolean getWithValueDeltas();
  }
  /**
   * Protobuf type {@code org.apache.pekko.cluster.ddata.ORMultiMap}
   */
  public static final class ORMultiMap extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.ORMultiMap)
      ORMultiMapOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ORMultiMap.newBuilder() to construct.
    private ORMultiMap(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ORMultiMap() {
      entries_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new ORMultiMap();
    }

    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Builder.class);
    }

    public interface EntryOrBuilder extends
        // @@protoc_insertion_point(interface_extends:org.apache.pekko.cluster.ddata.ORMultiMap.Entry)
        org.apache.pekko.protobufv3.internal.MessageOrBuilder {

      /**
       * <code>optional string stringKey = 1;</code>
       * @return Whether the stringKey field is set.
       */
      boolean hasStringKey();
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The stringKey.
       */
      java.lang.String getStringKey();
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The bytes for stringKey.
       */
      org.apache.pekko.protobufv3.internal.ByteString
          getStringKeyBytes();

      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet value = 2;</code>
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet value = 2;</code>
       * @return The value.
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getValue();
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet value = 2;</code>
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getValueOrBuilder();

      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return Whether the intKey field is set.
       */
      boolean hasIntKey();
      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return The intKey.
       */
      int getIntKey();

      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return Whether the longKey field is set.
       */
      boolean hasLongKey();
      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return The longKey.
       */
      long getLongKey();

      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return Whether the otherKey field is set.
       */
      boolean hasOtherKey();
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return The otherKey.
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherKey();
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       */
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherKeyOrBuilder();
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.ORMultiMap.Entry}
     */
    public static final class Entry extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:org.apache.pekko.cluster.ddata.ORMultiMap.Entry)
        EntryOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Entry.newBuilder() to construct.
      private Entry(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Entry() {
        stringKey_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Entry();
      }

      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_Entry_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_Entry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.Builder.class);
      }

      private int bitField0_;
      public static final int STRINGKEY_FIELD_NUMBER = 1;
      @SuppressWarnings("serial")
      private volatile java.lang.Object stringKey_ = "";
      /**
       * <code>optional string stringKey = 1;</code>
       * @return Whether the stringKey field is set.
       */
      @java.lang.Override
      public boolean hasStringKey() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The stringKey.
       */
      @java.lang.Override
      public java.lang.String getStringKey() {
        java.lang.Object ref = stringKey_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          org.apache.pekko.protobufv3.internal.ByteString bs = 
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            stringKey_ = s;
          }
          return s;
        }
      }
      /**
       * <code>optional string stringKey = 1;</code>
       * @return The bytes for stringKey.
       */
      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.ByteString
          getStringKeyBytes() {
        java.lang.Object ref = stringKey_;
        if (ref instanceof java.lang.String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          stringKey_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet value = 2;</code>
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet value = 2;</code>
       * @return The value.
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getValue() {
        return value_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : value_;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet value = 2;</code>
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getValueOrBuilder() {
        return value_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : value_;
      }

      public static final int INTKEY_FIELD_NUMBER = 3;
      private int intKey_ = 0;
      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return Whether the intKey field is set.
       */
      @java.lang.Override
      public boolean hasIntKey() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional sint32 intKey = 3;</code>
       * @return The intKey.
       */
      @java.lang.Override
      public int getIntKey() {
        return intKey_;
      }

      public static final int LONGKEY_FIELD_NUMBER = 4;
      private long longKey_ = 0L;
      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return Whether the longKey field is set.
       */
      @java.lang.Override
      public boolean hasLongKey() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional sint64 longKey = 4;</code>
       * @return The longKey.
       */
      @java.lang.Override
      public long getLongKey() {
        return longKey_;
      }

      public static final int OTHERKEY_FIELD_NUMBER = 5;
      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage otherKey_;
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return Whether the otherKey field is set.
       */
      @java.lang.Override
      public boolean hasOtherKey() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       * @return The otherKey.
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherKey() {
        return otherKey_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
      }
      /**
       * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
       */
      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherKeyOrBuilder() {
        return otherKey_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasValue()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!getValue().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (hasOtherKey()) {
          if (!getOtherKey().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 1, stringKey_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getValue());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeSInt32(3, intKey_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          output.writeSInt64(4, longKey_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          output.writeMessage(5, getOtherKey());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += org.apache.pekko.protobufv3.internal.GeneratedMessageV3.computeStringSize(1, stringKey_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeMessageSize(2, getValue());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeSInt32Size(3, intKey_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeSInt64Size(4, longKey_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeMessageSize(5, getOtherKey());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry)) {
          return super.equals(obj);
        }
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry) obj;

        if (hasStringKey() != other.hasStringKey()) return false;
        if (hasStringKey()) {
          if (!getStringKey()
              .equals(other.getStringKey())) return false;
        }
        if (hasValue() != other.hasValue()) return false;
        if (hasValue()) {
          if (!getValue()
              .equals(other.getValue())) return false;
        }
        if (hasIntKey() != other.hasIntKey()) return false;
        if (hasIntKey()) {
          if (getIntKey()
              != other.getIntKey()) return false;
        }
        if (hasLongKey() != other.hasLongKey()) return false;
        if (hasLongKey()) {
          if (getLongKey()
              != other.getLongKey()) return false;
        }
        if (hasOtherKey() != other.hasOtherKey()) return false;
        if (hasOtherKey()) {
          if (!getOtherKey()
              .equals(other.getOtherKey())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasStringKey()) {
          hash = (37 * hash) + STRINGKEY_FIELD_NUMBER;
          hash = (53 * hash) + getStringKey().hashCode();
        }
        if (hasValue()) {
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getValue().hashCode();
        }
        if (hasIntKey()) {
          hash = (37 * hash) + INTKEY_FIELD_NUMBER;
          hash = (53 * hash) + getIntKey();
        }
        if (hasLongKey()) {
          hash = (37 * hash) + LONGKEY_FIELD_NUMBER;
          hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
              getLongKey());
        }
        if (hasOtherKey()) {
          hash = (37 * hash) + OTHERKEY_FIELD_NUMBER;
          hash = (53 * hash) + getOtherKey().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry parseFrom(
          java.nio.ByteBuffer data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry parseFrom(
          java.nio.ByteBuffer data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry parseFrom(byte[] data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry parseFrom(
          byte[] data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry parseFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry parseDelimitedFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code org.apache.pekko.cluster.ddata.ORMultiMap.Entry}
       */
      public static final class Builder extends
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.ORMultiMap.Entry)
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.EntryOrBuilder {
        public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_Entry_descriptor;
        }

        @java.lang.Override
        protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_Entry_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.Builder.class);
        }

        // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getValueFieldBuilder();
            getOtherKeyFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          stringKey_ = "";
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          intKey_ = 0;
          longKey_ = 0L;
          otherKey_ = null;
          if (otherKeyBuilder_ != null) {
            otherKeyBuilder_.dispose();
            otherKeyBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_Entry_descriptor;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry getDefaultInstanceForType() {
          return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry build() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry buildPartial() {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry(this);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.stringKey_ = stringKey_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.value_ = valueBuilder_ == null
                ? value_
                : valueBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.intKey_ = intKey_;
            to_bitField0_ |= 0x00000004;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.longKey_ = longKey_;
            to_bitField0_ |= 0x00000008;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.otherKey_ = otherKeyBuilder_ == null
                ? otherKey_
                : otherKeyBuilder_.build();
            to_bitField0_ |= 0x00000010;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
          if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry) {
            return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry other) {
          if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.getDefaultInstance()) return this;
          if (other.hasStringKey()) {
            stringKey_ = other.stringKey_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasValue()) {
            mergeValue(other.getValue());
          }
          if (other.hasIntKey()) {
            setIntKey(other.getIntKey());
          }
          if (other.hasLongKey()) {
            setLongKey(other.getLongKey());
          }
          if (other.hasOtherKey()) {
            mergeOtherKey(other.getOtherKey());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!hasValue()) {
            return false;
          }
          if (!getValue().isInitialized()) {
            return false;
          }
          if (hasOtherKey()) {
            if (!getOtherKey().isInitialized()) {
              return false;
            }
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  stringKey_ = input.readBytes();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
                case 18: {
                  input.readMessage(
                      getValueFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
                case 24: {
                  intKey_ = input.readSInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
                case 32: {
                  longKey_ = input.readSInt64();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
                case 42: {
                  input.readMessage(
                      getOtherKeyFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private java.lang.Object stringKey_ = "";
        /**
         * <code>optional string stringKey = 1;</code>
         * @return Whether the stringKey field is set.
         */
        public boolean hasStringKey() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @return The stringKey.
         */
        public java.lang.String getStringKey() {
          java.lang.Object ref = stringKey_;
          if (!(ref instanceof java.lang.String)) {
            org.apache.pekko.protobufv3.internal.ByteString bs =
                (org.apache.pekko.protobufv3.internal.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              stringKey_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @return The bytes for stringKey.
         */
        public org.apache.pekko.protobufv3.internal.ByteString
            getStringKeyBytes() {
          java.lang.Object ref = stringKey_;
          if (ref instanceof String) {
            org.apache.pekko.protobufv3.internal.ByteString b = 
                org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            stringKey_ = b;
            return b;
          } else {
            return (org.apache.pekko.protobufv3.internal.ByteString) ref;
          }
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @param value The stringKey to set.
         * @return This builder for chaining.
         */
        public Builder setStringKey(
            java.lang.String value) {
          if (value == null) { throw new NullPointerException(); }
          stringKey_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearStringKey() {
          stringKey_ = getDefaultInstance().getStringKey();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         * <code>optional string stringKey = 1;</code>
         * @param value The bytes for stringKey to set.
         * @return This builder for chaining.
         */
        public Builder setStringKeyBytes(
            org.apache.pekko.protobufv3.internal.ByteString value) {
          if (value == null) { throw new NullPointerException(); }
          stringKey_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value_;
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder> valueBuilder_;
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet value = 2;</code>
         * @return Whether the value field is set.
         */
        public boolean hasValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet value = 2;</code>
         * @return The value.
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getValue() {
          if (valueBuilder_ == null) {
            return value_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : value_;
          } else {
            return valueBuilder_.getMessage();
          }
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet value = 2;</code>
         */
        public Builder setValue(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value) {
          if (valueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            value_ = value;
          } else {
            valueBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet value = 2;</code>
         */
        public Builder setValue(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder builderForValue) {
          if (valueBuilder_ == null) {
            value_ = builderForValue.build();
          } else {
            valueBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet value = 2;</code>
         */
        public Builder mergeValue(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value) {
          if (valueBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0) &&
              value_ != null &&
              value_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance()) {
              getValueBuilder().mergeFrom(value);
            } else {
              value_ = value;
            }
          } else {
            valueBuilder_.mergeFrom(value);
          }
          if (value_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet value = 2;</code>
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet value = 2;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder getValueBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getValueFieldBuilder().getBuilder();
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet value = 2;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getValueOrBuilder() {
          if (valueBuilder_ != null) {
            return valueBuilder_.getMessageOrBuilder();
          } else {
            return value_ == null ?
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : value_;
          }
        }
        /**
         * <code>required .org.apache.pekko.cluster.ddata.ORSet value = 2;</code>
         */
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder> 
            getValueFieldBuilder() {
          if (valueBuilder_ == null) {
            valueBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder>(
                    getValue(),
                    getParentForChildren(),
                    isClean());
            value_ = null;
          }
          return valueBuilder_;
        }

        private int intKey_ ;
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @return Whether the intKey field is set.
         */
        @java.lang.Override
        public boolean hasIntKey() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @return The intKey.
         */
        @java.lang.Override
        public int getIntKey() {
          return intKey_;
        }
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @param value The intKey to set.
         * @return This builder for chaining.
         */
        public Builder setIntKey(int value) {

          intKey_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         * <code>optional sint32 intKey = 3;</code>
         * @return This builder for chaining.
         */
        public Builder clearIntKey() {
          bitField0_ = (bitField0_ & ~0x00000004);
          intKey_ = 0;
          onChanged();
          return this;
        }

        private long longKey_ ;
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @return Whether the longKey field is set.
         */
        @java.lang.Override
        public boolean hasLongKey() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @return The longKey.
         */
        @java.lang.Override
        public long getLongKey() {
          return longKey_;
        }
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @param value The longKey to set.
         * @return This builder for chaining.
         */
        public Builder setLongKey(long value) {

          longKey_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         * <code>optional sint64 longKey = 4;</code>
         * @return This builder for chaining.
         */
        public Builder clearLongKey() {
          bitField0_ = (bitField0_ & ~0x00000008);
          longKey_ = 0L;
          onChanged();
          return this;
        }

        private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage otherKey_;
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> otherKeyBuilder_;
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         * @return Whether the otherKey field is set.
         */
        public boolean hasOtherKey() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         * @return The otherKey.
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage getOtherKey() {
          if (otherKeyBuilder_ == null) {
            return otherKey_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
          } else {
            return otherKeyBuilder_.getMessage();
          }
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder setOtherKey(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
          if (otherKeyBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            otherKey_ = value;
          } else {
            otherKeyBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder setOtherKey(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder builderForValue) {
          if (otherKeyBuilder_ == null) {
            otherKey_ = builderForValue.build();
          } else {
            otherKeyBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder mergeOtherKey(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage value) {
          if (otherKeyBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0) &&
              otherKey_ != null &&
              otherKey_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance()) {
              getOtherKeyBuilder().mergeFrom(value);
            } else {
              otherKey_ = value;
            }
          } else {
            otherKeyBuilder_.mergeFrom(value);
          }
          if (otherKey_ != null) {
            bitField0_ |= 0x00000010;
            onChanged();
          }
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public Builder clearOtherKey() {
          bitField0_ = (bitField0_ & ~0x00000010);
          otherKey_ = null;
          if (otherKeyBuilder_ != null) {
            otherKeyBuilder_.dispose();
            otherKeyBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder getOtherKeyBuilder() {
          bitField0_ |= 0x00000010;
          onChanged();
          return getOtherKeyFieldBuilder().getBuilder();
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder getOtherKeyOrBuilder() {
          if (otherKeyBuilder_ != null) {
            return otherKeyBuilder_.getMessageOrBuilder();
          } else {
            return otherKey_ == null ?
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.getDefaultInstance() : otherKey_;
          }
        }
        /**
         * <code>optional .org.apache.pekko.cluster.ddata.OtherMessage otherKey = 5;</code>
         */
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder> 
            getOtherKeyFieldBuilder() {
          if (otherKeyBuilder_ == null) {
            otherKeyBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessage.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.OtherMessageOrBuilder>(
                    getOtherKey(),
                    getParentForChildren(),
                    isClean());
            otherKey_ = null;
          }
          return otherKeyBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.ORMultiMap.Entry)
      }

      // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.ORMultiMap.Entry)
      private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry();
      }

      public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<Entry>
          PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<Entry>() {
        @java.lang.Override
        public Entry parsePartialFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static org.apache.pekko.protobufv3.internal.Parser<Entry> parser() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Parser<Entry> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int KEYS_FIELD_NUMBER = 1;
    private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet keys_;
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return Whether the keys field is set.
     */
    @java.lang.Override
    public boolean hasKeys() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     * @return The keys.
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getKeys() {
      return keys_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
    }
    /**
     * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getKeysOrBuilder() {
      return keys_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
    }

    public static final int ENTRIES_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry> entries_;
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry> getEntriesList() {
      return entries_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.EntryOrBuilder> 
        getEntriesOrBuilderList() {
      return entries_;
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public int getEntriesCount() {
      return entries_.size();
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry getEntries(int index) {
      return entries_.get(index);
    }
    /**
     * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
     */
    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.EntryOrBuilder getEntriesOrBuilder(
        int index) {
      return entries_.get(index);
    }

    public static final int WITHVALUEDELTAS_FIELD_NUMBER = 3;
    private boolean withValueDeltas_ = false;
    /**
     * <code>optional bool withValueDeltas = 3;</code>
     * @return Whether the withValueDeltas field is set.
     */
    @java.lang.Override
    public boolean hasWithValueDeltas() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional bool withValueDeltas = 3;</code>
     * @return The withValueDeltas.
     */
    @java.lang.Override
    public boolean getWithValueDeltas() {
      return withValueDeltas_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasKeys()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getKeys().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getEntriesCount(); i++) {
        if (!getEntries(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getKeys());
      }
      for (int i = 0; i < entries_.size(); i++) {
        output.writeMessage(2, entries_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeBool(3, withValueDeltas_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getKeys());
      }
      for (int i = 0; i < entries_.size(); i++) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, entries_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeBoolSize(3, withValueDeltas_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap)) {
        return super.equals(obj);
      }
      org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap other = (org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap) obj;

      if (hasKeys() != other.hasKeys()) return false;
      if (hasKeys()) {
        if (!getKeys()
            .equals(other.getKeys())) return false;
      }
      if (!getEntriesList()
          .equals(other.getEntriesList())) return false;
      if (hasWithValueDeltas() != other.hasWithValueDeltas()) return false;
      if (hasWithValueDeltas()) {
        if (getWithValueDeltas()
            != other.getWithValueDeltas()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKeys()) {
        hash = (37 * hash) + KEYS_FIELD_NUMBER;
        hash = (53 * hash) + getKeys().hashCode();
      }
      if (getEntriesCount() > 0) {
        hash = (37 * hash) + ENTRIES_FIELD_NUMBER;
        hash = (53 * hash) + getEntriesList().hashCode();
      }
      if (hasWithValueDeltas()) {
        hash = (37 * hash) + WITHVALUEDELTAS_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashBoolean(
            getWithValueDeltas());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code org.apache.pekko.cluster.ddata.ORMultiMap}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:org.apache.pekko.cluster.ddata.ORMultiMap)
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMapOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.class, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Builder.class);
      }

      // Construct using org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getKeysFieldBuilder();
          getEntriesFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        keys_ = null;
        if (keysBuilder_ != null) {
          keysBuilder_.dispose();
          keysBuilder_ = null;
        }
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
        } else {
          entries_ = null;
          entriesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        withValueDeltas_ = false;
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap getDefaultInstanceForType() {
        return org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap build() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap buildPartial() {
        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap result = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap result) {
        if (entriesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            entries_ = java.util.Collections.unmodifiableList(entries_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.entries_ = entries_;
        } else {
          result.entries_ = entriesBuilder_.build();
        }
      }

      private void buildPartial0(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.keys_ = keysBuilder_ == null
              ? keys_
              : keysBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.withValueDeltas_ = withValueDeltas_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap) {
          return mergeFrom((org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap other) {
        if (other == org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.getDefaultInstance()) return this;
        if (other.hasKeys()) {
          mergeKeys(other.getKeys());
        }
        if (entriesBuilder_ == null) {
          if (!other.entries_.isEmpty()) {
            if (entries_.isEmpty()) {
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureEntriesIsMutable();
              entries_.addAll(other.entries_);
            }
            onChanged();
          }
        } else {
          if (!other.entries_.isEmpty()) {
            if (entriesBuilder_.isEmpty()) {
              entriesBuilder_.dispose();
              entriesBuilder_ = null;
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000002);
              entriesBuilder_ = 
                org.apache.pekko.protobufv3.internal.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getEntriesFieldBuilder() : null;
            } else {
              entriesBuilder_.addAllMessages(other.entries_);
            }
          }
        }
        if (other.hasWithValueDeltas()) {
          setWithValueDeltas(other.getWithValueDeltas());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasKeys()) {
          return false;
        }
        if (!getKeys().isInitialized()) {
          return false;
        }
        for (int i = 0; i < getEntriesCount(); i++) {
          if (!getEntries(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getKeysFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry m =
                    input.readMessage(
                        org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.PARSER,
                        extensionRegistry);
                if (entriesBuilder_ == null) {
                  ensureEntriesIsMutable();
                  entries_.add(m);
                } else {
                  entriesBuilder_.addMessage(m);
                }
                break;
              } // case 18
              case 24: {
                withValueDeltas_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet keys_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder> keysBuilder_;
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       * @return Whether the keys field is set.
       */
      public boolean hasKeys() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       * @return The keys.
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet getKeys() {
        if (keysBuilder_ == null) {
          return keys_ == null ? org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
        } else {
          return keysBuilder_.getMessage();
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder setKeys(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value) {
        if (keysBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          keys_ = value;
        } else {
          keysBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder setKeys(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder builderForValue) {
        if (keysBuilder_ == null) {
          keys_ = builderForValue.build();
        } else {
          keysBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder mergeKeys(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet value) {
        if (keysBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            keys_ != null &&
            keys_ != org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance()) {
            getKeysBuilder().mergeFrom(value);
          } else {
            keys_ = value;
          }
        } else {
          keysBuilder_.mergeFrom(value);
        }
        if (keys_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public Builder clearKeys() {
        bitField0_ = (bitField0_ & ~0x00000001);
        keys_ = null;
        if (keysBuilder_ != null) {
          keysBuilder_.dispose();
          keysBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder getKeysBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getKeysFieldBuilder().getBuilder();
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder getKeysOrBuilder() {
        if (keysBuilder_ != null) {
          return keysBuilder_.getMessageOrBuilder();
        } else {
          return keys_ == null ?
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.getDefaultInstance() : keys_;
        }
      }
      /**
       * <code>required .org.apache.pekko.cluster.ddata.ORSet keys = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder> 
          getKeysFieldBuilder() {
        if (keysBuilder_ == null) {
          keysBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSet.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORSetOrBuilder>(
                  getKeys(),
                  getParentForChildren(),
                  isClean());
          keys_ = null;
        }
        return keysBuilder_;
      }

      private java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry> entries_ =
        java.util.Collections.emptyList();
      private void ensureEntriesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          entries_ = new java.util.ArrayList<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry>(entries_);
          bitField0_ |= 0x00000002;
         }
      }

      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.EntryOrBuilder> entriesBuilder_;

      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry> getEntriesList() {
        if (entriesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(entries_);
        } else {
          return entriesBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public int getEntriesCount() {
        if (entriesBuilder_ == null) {
          return entries_.size();
        } else {
          return entriesBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry getEntries(int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);
        } else {
          return entriesBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public Builder setEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.set(index, value);
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public Builder setEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.set(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public Builder addEntries(org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public Builder addEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(index, value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public Builder addEntries(
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public Builder addEntries(
          int index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public Builder addAllEntries(
          java.lang.Iterable<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry> values) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
              values, entries_);
          onChanged();
        } else {
          entriesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public Builder clearEntries() {
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          entriesBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public Builder removeEntries(int index) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.remove(index);
          onChanged();
        } else {
          entriesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.Builder getEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.EntryOrBuilder getEntriesOrBuilder(
          int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);  } else {
          return entriesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public java.util.List<? extends org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.EntryOrBuilder> 
           getEntriesOrBuilderList() {
        if (entriesBuilder_ != null) {
          return entriesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(entries_);
        }
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.Builder addEntriesBuilder() {
        return getEntriesFieldBuilder().addBuilder(
            org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.Builder addEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder().addBuilder(
            index, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.getDefaultInstance());
      }
      /**
       * <code>repeated .org.apache.pekko.cluster.ddata.ORMultiMap.Entry entries = 2;</code>
       */
      public java.util.List<org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.Builder> 
           getEntriesBuilderList() {
        return getEntriesFieldBuilder().getBuilderList();
      }
      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.EntryOrBuilder> 
          getEntriesFieldBuilder() {
        if (entriesBuilder_ == null) {
          entriesBuilder_ = new org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
              org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.Entry.Builder, org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap.EntryOrBuilder>(
                  entries_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          entries_ = null;
        }
        return entriesBuilder_;
      }

      private boolean withValueDeltas_ ;
      /**
       * <code>optional bool withValueDeltas = 3;</code>
       * @return Whether the withValueDeltas field is set.
       */
      @java.lang.Override
      public boolean hasWithValueDeltas() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional bool withValueDeltas = 3;</code>
       * @return The withValueDeltas.
       */
      @java.lang.Override
      public boolean getWithValueDeltas() {
        return withValueDeltas_;
      }
      /**
       * <code>optional bool withValueDeltas = 3;</code>
       * @param value The withValueDeltas to set.
       * @return This builder for chaining.
       */
      public Builder setWithValueDeltas(boolean value) {

        withValueDeltas_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool withValueDeltas = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearWithValueDeltas() {
        bitField0_ = (bitField0_ & ~0x00000004);
        withValueDeltas_ = false;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:org.apache.pekko.cluster.ddata.ORMultiMap)
    }

    // @@protoc_insertion_point(class_scope:org.apache.pekko.cluster.ddata.ORMultiMap)
    private static final org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap();
    }

    public static org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<ORMultiMap>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<ORMultiMap>() {
      @java.lang.Override
      public ORMultiMap parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (org.apache.pekko.protobufv3.internal.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<ORMultiMap> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<ORMultiMap> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatedDataMessages.ORMultiMap getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_GSet_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_GSet_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_ORSet_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_ORSet_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_Entry_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_Entry_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_Flag_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_Flag_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_LWWRegister_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_LWWRegister_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_GCounter_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_GCounter_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_GCounter_Entry_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_GCounter_Entry_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_PNCounter_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_PNCounter_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_ORMap_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_ORMap_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_ORMap_Entry_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_ORMap_Entry_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_MapEntry_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_MapEntry_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_Entry_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_Entry_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_LWWMap_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_LWWMap_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_LWWMap_Entry_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_LWWMap_Entry_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_Entry_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_Entry_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_Entry_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_Entry_fieldAccessorTable;

  public static org.apache.pekko.protobufv3.internal.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  org.apache.pekko.protobufv3.internal.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\034ReplicatedDataMessages.proto\022\036org.apac" +
      "he.pekko.cluster.ddata\032\030ReplicatorMessag" +
      "es.proto\"\260\001\n\004GSet\022\026\n\016stringElements\030\001 \003(" +
      "\t\022\027\n\013intElements\030\002 \003(\021B\002\020\001\022\030\n\014longElemen" +
      "ts\030\003 \003(\022B\002\020\001\022C\n\rotherElements\030\004 \003(\0132,.or" +
      "g.apache.pekko.cluster.ddata.OtherMessag" +
      "e\022\030\n\020actorRefElements\030\005 \003(\t\"\256\002\n\005ORSet\022>\n" +
      "\007vvector\030\001 \002(\0132-.org.apache.pekko.cluste" +
      "r.ddata.VersionVector\022;\n\004dots\030\002 \003(\0132-.or" +
      "g.apache.pekko.cluster.ddata.VersionVect" +
      "or\022\026\n\016stringElements\030\003 \003(\t\022\027\n\013intElement" +
      "s\030\004 \003(\021B\002\020\001\022\030\n\014longElements\030\005 \003(\022B\002\020\001\022C\n" +
      "\rotherElements\030\006 \003(\0132,.org.apache.pekko." +
      "cluster.ddata.OtherMessage\022\030\n\020actorRefEl" +
      "ements\030\007 \003(\t\"\337\001\n\017ORSetDeltaGroup\022F\n\007entr" +
      "ies\030\001 \003(\01325.org.apache.pekko.cluster.dda" +
      "ta.ORSetDeltaGroup.Entry\032\203\001\n\005Entry\022?\n\top" +
      "eration\030\001 \002(\0162,.org.apache.pekko.cluster" +
      ".ddata.ORSetDeltaOp\0229\n\nunderlying\030\002 \002(\0132" +
      "%.org.apache.pekko.cluster.ddata.ORSet\"\027" +
      "\n\004Flag\022\017\n\007enabled\030\001 \002(\010\"\232\001\n\013LWWRegister\022" +
      "\021\n\ttimestamp\030\001 \002(\022\022;\n\004node\030\002 \002(\0132-.org.a" +
      "pache.pekko.cluster.ddata.UniqueAddress\022" +
      ";\n\005state\030\003 \002(\0132,.org.apache.pekko.cluste" +
      "r.ddata.OtherMessage\"\240\001\n\010GCounter\022?\n\007ent" +
      "ries\030\001 \003(\0132..org.apache.pekko.cluster.dd" +
      "ata.GCounter.Entry\032S\n\005Entry\022;\n\004node\030\001 \002(" +
      "\0132-.org.apache.pekko.cluster.ddata.Uniqu" +
      "eAddress\022\r\n\005value\030\002 \002(\014\"\207\001\n\tPNCounter\022<\n" +
      "\nincrements\030\001 \002(\0132(.org.apache.pekko.clu" +
      "ster.ddata.GCounter\022<\n\ndecrements\030\002 \002(\0132" +
      "(.org.apache.pekko.cluster.ddata.GCounte" +
      "r\"\265\002\n\005ORMap\0223\n\004keys\030\001 \002(\0132%.org.apache.p" +
      "ekko.cluster.ddata.ORSet\022<\n\007entries\030\002 \003(" +
      "\0132+.org.apache.pekko.cluster.ddata.ORMap" +
      ".Entry\032\270\001\n\005Entry\022\021\n\tstringKey\030\001 \001(\t\022;\n\005v" +
      "alue\030\002 \002(\0132,.org.apache.pekko.cluster.dd" +
      "ata.OtherMessage\022\016\n\006intKey\030\003 \001(\021\022\017\n\007long" +
      "Key\030\004 \001(\022\022>\n\010otherKey\030\005 \001(\0132,.org.apache" +
      ".pekko.cluster.ddata.OtherMessage\"\373\003\n\017OR" +
      "MapDeltaGroup\022F\n\007entries\030\001 \003(\01325.org.apa" +
      "che.pekko.cluster.ddata.ORMapDeltaGroup." +
      "Entry\032\273\001\n\010MapEntry\022\021\n\tstringKey\030\001 \001(\t\022;\n" +
      "\005value\030\002 \001(\0132,.org.apache.pekko.cluster." +
      "ddata.OtherMessage\022\016\n\006intKey\030\003 \001(\021\022\017\n\007lo" +
      "ngKey\030\004 \001(\022\022>\n\010otherKey\030\005 \001(\0132,.org.apac" +
      "he.pekko.cluster.ddata.OtherMessage\032\341\001\n\005" +
      "Entry\022?\n\toperation\030\001 \002(\0162,.org.apache.pe" +
      "kko.cluster.ddata.ORMapDeltaOp\0229\n\nunderl" +
      "ying\030\002 \002(\0132%.org.apache.pekko.cluster.dd" +
      "ata.ORSet\022\017\n\007zeroTag\030\003 \002(\021\022K\n\tentryData\030" +
      "\004 \003(\01328.org.apache.pekko.cluster.ddata.O" +
      "RMapDeltaGroup.MapEntry\"\266\002\n\006LWWMap\0223\n\004ke" +
      "ys\030\001 \002(\0132%.org.apache.pekko.cluster.ddat" +
      "a.ORSet\022=\n\007entries\030\002 \003(\0132,.org.apache.pe" +
      "kko.cluster.ddata.LWWMap.Entry\032\267\001\n\005Entry" +
      "\022\021\n\tstringKey\030\001 \001(\t\022:\n\005value\030\002 \002(\0132+.org" +
      ".apache.pekko.cluster.ddata.LWWRegister\022" +
      "\016\n\006intKey\030\003 \001(\021\022\017\n\007longKey\030\004 \001(\022\022>\n\010othe" +
      "rKey\030\005 \001(\0132,.org.apache.pekko.cluster.dd" +
      "ata.OtherMessage\"\300\002\n\014PNCounterMap\0223\n\004key" +
      "s\030\001 \002(\0132%.org.apache.pekko.cluster.ddata" +
      ".ORSet\022C\n\007entries\030\002 \003(\01322.org.apache.pek" +
      "ko.cluster.ddata.PNCounterMap.Entry\032\265\001\n\005" +
      "Entry\022\021\n\tstringKey\030\001 \001(\t\0228\n\005value\030\002 \002(\0132" +
      ").org.apache.pekko.cluster.ddata.PNCount" +
      "er\022\016\n\006intKey\030\003 \001(\021\022\017\n\007longKey\030\004 \001(\022\022>\n\010o" +
      "therKey\030\005 \001(\0132,.org.apache.pekko.cluster" +
      ".ddata.OtherMessage\"\321\002\n\nORMultiMap\0223\n\004ke" +
      "ys\030\001 \002(\0132%.org.apache.pekko.cluster.ddat" +
      "a.ORSet\022A\n\007entries\030\002 \003(\01320.org.apache.pe" +
      "kko.cluster.ddata.ORMultiMap.Entry\022\027\n\017wi" +
      "thValueDeltas\030\003 \001(\010\032\261\001\n\005Entry\022\021\n\tstringK" +
      "ey\030\001 \001(\t\0224\n\005value\030\002 \002(\0132%.org.apache.pek" +
      "ko.cluster.ddata.ORSet\022\016\n\006intKey\030\003 \001(\021\022\017" +
      "\n\007longKey\030\004 \001(\022\022>\n\010otherKey\030\005 \001(\0132,.org." +
      "apache.pekko.cluster.ddata.OtherMessage*" +
      "-\n\014ORSetDeltaOp\022\007\n\003Add\020\000\022\n\n\006Remove\020\001\022\010\n\004" +
      "Full\020\002*R\n\014ORMapDeltaOp\022\014\n\010ORMapPut\020\000\022\017\n\013" +
      "ORMapRemove\020\001\022\022\n\016ORMapRemoveKey\020\002\022\017\n\013ORM" +
      "apUpdate\020\003B/\n+org.apache.pekko.cluster.d" +
      "data.protobuf.msgH\001"
    };
    descriptor = org.apache.pekko.protobufv3.internal.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new org.apache.pekko.protobufv3.internal.Descriptors.FileDescriptor[] {
          org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.getDescriptor(),
        });
    internal_static_org_apache_pekko_cluster_ddata_GSet_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_org_apache_pekko_cluster_ddata_GSet_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_GSet_descriptor,
        new java.lang.String[] { "StringElements", "IntElements", "LongElements", "OtherElements", "ActorRefElements", });
    internal_static_org_apache_pekko_cluster_ddata_ORSet_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_org_apache_pekko_cluster_ddata_ORSet_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_ORSet_descriptor,
        new java.lang.String[] { "Vvector", "Dots", "StringElements", "IntElements", "LongElements", "OtherElements", "ActorRefElements", });
    internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_descriptor,
        new java.lang.String[] { "Entries", });
    internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_Entry_descriptor =
      internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_descriptor.getNestedTypes().get(0);
    internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_Entry_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_ORSetDeltaGroup_Entry_descriptor,
        new java.lang.String[] { "Operation", "Underlying", });
    internal_static_org_apache_pekko_cluster_ddata_Flag_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_org_apache_pekko_cluster_ddata_Flag_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_Flag_descriptor,
        new java.lang.String[] { "Enabled", });
    internal_static_org_apache_pekko_cluster_ddata_LWWRegister_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_org_apache_pekko_cluster_ddata_LWWRegister_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_LWWRegister_descriptor,
        new java.lang.String[] { "Timestamp", "Node", "State", });
    internal_static_org_apache_pekko_cluster_ddata_GCounter_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_org_apache_pekko_cluster_ddata_GCounter_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_GCounter_descriptor,
        new java.lang.String[] { "Entries", });
    internal_static_org_apache_pekko_cluster_ddata_GCounter_Entry_descriptor =
      internal_static_org_apache_pekko_cluster_ddata_GCounter_descriptor.getNestedTypes().get(0);
    internal_static_org_apache_pekko_cluster_ddata_GCounter_Entry_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_GCounter_Entry_descriptor,
        new java.lang.String[] { "Node", "Value", });
    internal_static_org_apache_pekko_cluster_ddata_PNCounter_descriptor =
      getDescriptor().getMessageTypes().get(6);
    internal_static_org_apache_pekko_cluster_ddata_PNCounter_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_PNCounter_descriptor,
        new java.lang.String[] { "Increments", "Decrements", });
    internal_static_org_apache_pekko_cluster_ddata_ORMap_descriptor =
      getDescriptor().getMessageTypes().get(7);
    internal_static_org_apache_pekko_cluster_ddata_ORMap_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_ORMap_descriptor,
        new java.lang.String[] { "Keys", "Entries", });
    internal_static_org_apache_pekko_cluster_ddata_ORMap_Entry_descriptor =
      internal_static_org_apache_pekko_cluster_ddata_ORMap_descriptor.getNestedTypes().get(0);
    internal_static_org_apache_pekko_cluster_ddata_ORMap_Entry_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_ORMap_Entry_descriptor,
        new java.lang.String[] { "StringKey", "Value", "IntKey", "LongKey", "OtherKey", });
    internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_descriptor =
      getDescriptor().getMessageTypes().get(8);
    internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_descriptor,
        new java.lang.String[] { "Entries", });
    internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_MapEntry_descriptor =
      internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_descriptor.getNestedTypes().get(0);
    internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_MapEntry_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_MapEntry_descriptor,
        new java.lang.String[] { "StringKey", "Value", "IntKey", "LongKey", "OtherKey", });
    internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_Entry_descriptor =
      internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_descriptor.getNestedTypes().get(1);
    internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_Entry_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_ORMapDeltaGroup_Entry_descriptor,
        new java.lang.String[] { "Operation", "Underlying", "ZeroTag", "EntryData", });
    internal_static_org_apache_pekko_cluster_ddata_LWWMap_descriptor =
      getDescriptor().getMessageTypes().get(9);
    internal_static_org_apache_pekko_cluster_ddata_LWWMap_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_LWWMap_descriptor,
        new java.lang.String[] { "Keys", "Entries", });
    internal_static_org_apache_pekko_cluster_ddata_LWWMap_Entry_descriptor =
      internal_static_org_apache_pekko_cluster_ddata_LWWMap_descriptor.getNestedTypes().get(0);
    internal_static_org_apache_pekko_cluster_ddata_LWWMap_Entry_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_LWWMap_Entry_descriptor,
        new java.lang.String[] { "StringKey", "Value", "IntKey", "LongKey", "OtherKey", });
    internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_descriptor =
      getDescriptor().getMessageTypes().get(10);
    internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_descriptor,
        new java.lang.String[] { "Keys", "Entries", });
    internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_Entry_descriptor =
      internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_descriptor.getNestedTypes().get(0);
    internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_Entry_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_PNCounterMap_Entry_descriptor,
        new java.lang.String[] { "StringKey", "Value", "IntKey", "LongKey", "OtherKey", });
    internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_descriptor =
      getDescriptor().getMessageTypes().get(11);
    internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_descriptor,
        new java.lang.String[] { "Keys", "Entries", "WithValueDeltas", });
    internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_Entry_descriptor =
      internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_descriptor.getNestedTypes().get(0);
    internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_Entry_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_org_apache_pekko_cluster_ddata_ORMultiMap_Entry_descriptor,
        new java.lang.String[] { "StringKey", "Value", "IntKey", "LongKey", "OtherKey", });
    org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
