/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.descriptor;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.container.Type1Container;
import org.apache.pdfbox.preflight.font.descriptor.FontDescriptorHelper;

public class Type1DescriptorHelper
extends FontDescriptorHelper<Type1Container> {
    public Type1DescriptorHelper(PreflightContext context, PDSimpleFont font, Type1Container fontContainer) {
        super(context, (PDFontLike)font, fontContainer);
    }

    @Override
    protected boolean checkMandatoryFields(COSDictionary fDescriptor) {
        String charsetStr;
        boolean result = super.checkMandatoryFields(fDescriptor);
        if (Type1DescriptorHelper.isSubSet(this.fontDescriptor.getFontName()) && ((charsetStr = this.fontDescriptor.getCharSet()) == null || charsetStr.isEmpty())) {
            ((Type1Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.4", this.fontDescriptor.getFontName() + ": The Charset entry is missing for the Type1 Subset"));
            result = false;
        }
        return result;
    }

    @Override
    public PDStream extractFontFile(PDFontDescriptor fontDescriptor) {
        PDStream ff1 = fontDescriptor.getFontFile();
        PDStream ff3 = fontDescriptor.getFontFile3();
        if (ff1 != null) {
            boolean hasLength3;
            COSStream stream = ff1.getCOSObject();
            if (stream == null) {
                ((Type1Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", fontDescriptor.getFontName() + ": The FontFile is missing"));
                ((Type1Container)this.fContainer).notEmbedded();
                return null;
            }
            boolean hasLength1 = stream.getInt(COSName.LENGTH1) > 0;
            boolean hasLength2 = stream.getInt(COSName.LENGTH2) > 0;
            boolean bl = hasLength3 = stream.getInt(COSName.LENGTH3) >= 0;
            if (!(hasLength1 && hasLength2 && hasLength3)) {
                ((Type1Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", fontDescriptor.getFontName() + ": The FontFile is invalid"));
                return null;
            }
            return ff1;
        }
        return ff3;
    }

    @Override
    protected void processFontFile(PDFontDescriptor fontDescriptor, PDStream fontFile) {
        if (this.font.isDamaged()) {
            ((Type1Container)this.fContainer).push(new ValidationResult.ValidationError("3.2.1", this.font.getName() + ": The FontFile can't be read"));
        }
    }
}

