/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="texttopdf", header={"Creates a PDF document from text"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public class TextToPDF
implements Callable<Integer> {
    private static final int FONTSCALE = 1000;
    private static final int DEFAULT_FONT_SIZE = 10;
    private static final float LINE_HEIGHT_FACTOR = 1.05f;
    private PDRectangle mediaBox = PDRectangle.LETTER;
    private PDFont font = null;
    private final PrintStream SYSERR;
    @CommandLine.Option(names={"-fontSize"}, description={"the size of the font to use (default: ${DEFAULT-VALUE}"})
    private int fontSize = 10;
    @CommandLine.Option(names={"-landscape"}, description={"set orientation to landscape"})
    private boolean landscape = false;
    @CommandLine.Option(names={"-pageSize"}, description={"the page size to use. \nCandidates: ${COMPLETION-CANDIDATES} (default: ${DEFAULT-VALUE})"})
    private PageSizes pageSize = PageSizes.LETTER;
    @CommandLine.Option(names={"-charset"}, description={"the charset to use. \n(default: ${DEFAULT-VALUE})"})
    private Charset charset = Charset.defaultCharset();
    @CommandLine.Option(names={"-standardFont"}, description={"the font to use for the text. Either this or -ttf should be specified but not both.\nCandidates: ${COMPLETION-CANDIDATES} (default: ${DEFAULT-VALUE})"})
    private Standard14Fonts.FontName standardFont = Standard14Fonts.FontName.HELVETICA;
    @CommandLine.Option(names={"-ttf"}, paramLabel="<ttf file>", description={"the TTF font to use for the text. Either this or -standardFont should be specified but not both."})
    private File ttf;
    @CommandLine.Option(names={"-i", "--input"}, description={"the text file to convert"}, required=true)
    private File infile;
    @CommandLine.Option(names={"-o", "--output"}, description={"the generated PDF file"}, required=true)
    private File outfile;

    public TextToPDF() {
        this.SYSERR = System.err;
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine(new TextToPDF()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() {
        try (PDDocument doc = new PDDocument();){
            Throwable throwable;
            FileInputStream is;
            this.font = this.ttf != null ? PDType0Font.load(doc, this.ttf) : new PDType1Font(this.standardFont);
            this.setFont(this.font);
            this.setFontSize(this.fontSize);
            this.setMediaBox(this.pageSize.getPageSize());
            this.setLandscape(this.landscape);
            boolean hasUtf8BOM = false;
            if (this.charset.equals(StandardCharsets.UTF_8)) {
                is = new FileInputStream(this.infile);
                throwable = null;
                try {
                    if (((InputStream)is).read() == 239 && ((InputStream)is).read() == 187 && ((InputStream)is).read() == 191) {
                        hasUtf8BOM = true;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((InputStream)is).close();
                        }
                    }
                }
            }
            is = new FileInputStream(this.infile);
            throwable = null;
            try {
                long skipped;
                if (hasUtf8BOM && (skipped = ((InputStream)is).skip(3L)) != 3L) {
                    throw new IOException("Could not skip 3 bytes, size changed?!");
                }
                try (InputStreamReader reader = new InputStreamReader((InputStream)is, this.charset);){
                    this.createPDFFromText(doc, reader);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((InputStream)is).close();
                    }
                }
            }
            doc.save(this.outfile);
        }
        catch (IOException ioe) {
            this.SYSERR.println("Error converting text to PDF [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
            return 4;
        }
        return 0;
    }

    public PDDocument createPDFFromText(Reader text) throws IOException {
        PDDocument doc = new PDDocument();
        this.createPDFFromText(doc, text);
        return doc;
    }

    public void createPDFFromText(PDDocument doc, Reader text) throws IOException {
        String nextLine;
        if (this.font == null) {
            this.font = new PDType1Font(this.standardFont);
        }
        int margin = 40;
        float height = this.font.getBoundingBox().getHeight() / 1000.0f;
        PDRectangle actualMediaBox = this.landscape ? new PDRectangle(this.mediaBox.getHeight(), this.mediaBox.getWidth()) : this.mediaBox;
        height = height * (float)this.fontSize * 1.05f;
        BufferedReader data = new BufferedReader(text);
        PDPage page = new PDPage(actualMediaBox);
        PDPageContentStream contentStream = null;
        float y = -1.0f;
        float maxStringLength = page.getMediaBox().getWidth() - 80.0f;
        boolean textIsEmpty = true;
        StringBuilder nextLineToDraw = new StringBuilder();
        while ((nextLine = data.readLine()) != null) {
            textIsEmpty = false;
            String[] lineWords = nextLine.replaceAll("[\\n\\r]+$", "").split(" ", -1);
            int lineIndex = 0;
            while (lineIndex < lineWords.length) {
                nextLineToDraw.setLength(0);
                boolean addSpace = false;
                float lengthIfUsingNextWord = 0.0f;
                boolean ff = false;
                do {
                    String word1;
                    String word2 = "";
                    String word = lineWords[lineIndex];
                    int indexFF = word.indexOf(12);
                    if (indexFF == -1) {
                        word1 = word;
                    } else {
                        ff = true;
                        word1 = word.substring(0, indexFF);
                        if (indexFF < word.length()) {
                            word2 = word.substring(indexFF + 1);
                        }
                    }
                    if (word1.length() > 0 || !ff) {
                        if (addSpace) {
                            nextLineToDraw.append(' ');
                        } else {
                            addSpace = true;
                        }
                        nextLineToDraw.append(word1);
                    }
                    if (!ff || word2.length() == 0) {
                        ++lineIndex;
                    } else {
                        lineWords[lineIndex] = word2;
                    }
                    if (ff) break;
                    if (lineIndex >= lineWords.length) continue;
                    String nextWord = lineWords[lineIndex];
                    indexFF = nextWord.indexOf(12);
                    if (indexFF != -1) {
                        nextWord = nextWord.substring(0, indexFF);
                    }
                    String lineWithNextWord = nextLineToDraw + " " + nextWord;
                    lengthIfUsingNextWord = this.font.getStringWidth(lineWithNextWord) / 1000.0f * (float)this.fontSize;
                } while (lineIndex < lineWords.length && lengthIfUsingNextWord < maxStringLength);
                if (y < 40.0f) {
                    page = new PDPage(actualMediaBox);
                    doc.addPage(page);
                    if (contentStream != null) {
                        contentStream.endText();
                        contentStream.close();
                    }
                    contentStream = new PDPageContentStream(doc, page);
                    contentStream.setFont(this.font, this.fontSize);
                    contentStream.beginText();
                    y = page.getMediaBox().getHeight() - 40.0f + height;
                    contentStream.newLineAtOffset(40.0f, y);
                }
                if (contentStream == null) {
                    throw new IOException("Error:Expected non-null content stream.");
                }
                contentStream.newLineAtOffset(0.0f, -height);
                y -= height;
                contentStream.showText(nextLineToDraw.toString());
                if (!ff) continue;
                page = new PDPage(actualMediaBox);
                doc.addPage(page);
                contentStream.endText();
                contentStream.close();
                contentStream = new PDPageContentStream(doc, page);
                contentStream.setFont(this.font, this.fontSize);
                contentStream.beginText();
                y = page.getMediaBox().getHeight() - 40.0f + height;
                contentStream.newLineAtOffset(40.0f, y);
            }
        }
        if (textIsEmpty) {
            doc.addPage(page);
        }
        if (contentStream != null) {
            contentStream.endText();
            contentStream.close();
        }
    }

    public PDFont getFont() {
        return this.font;
    }

    public void setFont(PDFont aFont) {
        this.font = aFont;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int aFontSize) {
        this.fontSize = aFontSize;
    }

    public PDRectangle getMediaBox() {
        return this.mediaBox;
    }

    public void setMediaBox(PDRectangle mediaBox) {
        this.mediaBox = mediaBox;
    }

    public boolean isLandscape() {
        return this.landscape;
    }

    public void setLandscape(boolean landscape) {
        this.landscape = landscape;
    }

    private static enum PageSizes {
        LETTER(PDRectangle.LETTER),
        LEGAL(PDRectangle.LEGAL),
        A0(PDRectangle.A0),
        A1(PDRectangle.A1),
        A2(PDRectangle.A2),
        A3(PDRectangle.A3),
        A4(PDRectangle.A4),
        A5(PDRectangle.A5),
        A6(PDRectangle.A6);

        final PDRectangle pageSize;

        private PageSizes(PDRectangle pageSize) {
            this.pageSize = pageSize;
        }

        public PDRectangle getPageSize() {
            return this.pageSize;
        }
    }
}

