/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfwriter.compress.CompressParameters;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="writedecodeddoc", header={"Writes a PDF document with all streams decoded"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public class WriteDecodedDoc
implements Callable<Integer> {
    private final PrintStream SYSERR = System.err;
    @CommandLine.Option(names={"-password"}, description={"the password to decrypt the document"}, arity="0..1", interactive=true)
    private String password;
    @CommandLine.Option(names={"-skipImages"}, description={"don't uncompress images"})
    private boolean skipImages;
    @CommandLine.Parameters(paramLabel="inputfile", index="0", description={"the PDF document to be decompressed"})
    private File infile;
    @CommandLine.Parameters(paramLabel="outputfile", arity="0..1", description={"the PDF file to save to."})
    private File outfile;

    public void doIt(String in, String out, String password, boolean skipImages) throws IOException {
        try (PDDocument doc = Loader.loadPDF(new File(in), password);){
            doc.setAllSecurityToBeRemoved(true);
            COSDocument cosDocument = doc.getDocument();
            cosDocument.getXrefTable().keySet().stream().forEach(o -> this.processObject(cosDocument.getObjectFromPool((COSObjectKey)o), skipImages));
            doc.getDocumentCatalog();
            doc.getDocument().setIsXRefStream(false);
            doc.save(out, CompressParameters.NO_COMPRESSION);
        }
    }

    private void processObject(COSObject cosObject, boolean skipImages) {
        COSBase base = cosObject.getObject();
        if (base instanceof COSStream) {
            COSStream stream = (COSStream)base;
            if (skipImages && COSName.XOBJECT.equals(stream.getItem(COSName.TYPE)) && COSName.IMAGE.equals(stream.getItem(COSName.SUBTYPE))) {
                return;
            }
            try {
                byte[] bytes = new PDStream(stream).toByteArray();
                stream.removeItem(COSName.FILTER);
                try (OutputStream streamOut = stream.createOutputStream();){
                    streamOut.write(bytes);
                }
            }
            catch (IOException ex) {
                this.SYSERR.println("skip " + cosObject.getObjectNumber() + " " + cosObject.getGenerationNumber() + " obj: " + ex.getMessage());
            }
        }
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine(new WriteDecodedDoc()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() {
        String outputFilename = this.outfile == null ? WriteDecodedDoc.calculateOutputFilename(this.infile.getAbsolutePath()) : this.outfile.getAbsolutePath();
        try {
            this.doIt(this.infile.getAbsolutePath(), outputFilename, this.password, this.skipImages);
        }
        catch (IOException ioe) {
            this.SYSERR.println("Error writing decoded PDF [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
            return 4;
        }
        return 0;
    }

    private static String calculateOutputFilename(String filename) {
        String outputFilename = filename.toLowerCase().endsWith(".pdf") ? filename.substring(0, filename.length() - 4) : filename;
        outputFilename = outputFilename + "_unc.pdf";
        return outputFilename;
    }
}

