/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;

public class TrailerValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext ctx) throws ValidationException {
        PreflightDocument pdfDoc = ctx.getDocument();
        COSDictionary linearizedDict = pdfDoc.getDocument().getLinearizedDictionary();
        if (linearizedDict != null && ctx.getXrefTrailerResolver().getTrailerCount() == 2 && ctx.getFileLen() == linearizedDict.getLong(COSName.L)) {
            this.checkLinearizedDictionary(ctx, linearizedDict);
            float pdfVersion = pdfDoc.getVersion();
            if (pdfVersion <= 1.4f) {
                this.checkTrailersForLinearizedPDF14(ctx);
            } else {
                this.checkTrailersForLinearizedPDF15(ctx);
            }
        } else {
            this.checkMainTrailer(ctx, pdfDoc.getDocument().getTrailer());
        }
    }

    protected void checkTrailersForLinearizedPDF14(PreflightContext ctx) {
        COSDictionary first = ctx.getXrefTrailerResolver().getFirstTrailer();
        if (first == null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4", "There are no trailer in the PDF file"));
        } else {
            COSDictionary last = ctx.getXrefTrailerResolver().getLastTrailer();
            this.checkMainTrailer(ctx, first);
            if (!this.compareIds(first, last)) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.6", "ID is different in the first and the last trailer"));
            }
        }
    }

    protected void checkTrailersForLinearizedPDF15(PreflightContext ctx) {
        COSDocument cosDocument = ctx.getDocument().getDocument();
        List<COSObject> xrefs = cosDocument.getObjectsByType(COSName.XREF);
        if (xrefs.isEmpty()) {
            this.checkTrailersForLinearizedPDF14(ctx);
        } else {
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            COSDictionary firstTrailer = null;
            COSDictionary lastTrailer = null;
            for (COSObject co : xrefs) {
                long offset = cosDocument.getXrefTable().get(new COSObjectKey(co.getObjectNumber(), co.getGenerationNumber()));
                if (offset < min) {
                    min = offset;
                    firstTrailer = (COSDictionary)co.getObject();
                }
                if (offset <= max) continue;
                max = offset;
                lastTrailer = (COSDictionary)co.getObject();
            }
            this.checkMainTrailer(ctx, firstTrailer);
            if (!this.compareIds(firstTrailer, lastTrailer)) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.6", "ID is different in the first and the last trailer"));
            }
        }
    }

    protected boolean compareIds(COSDictionary first, COSDictionary last) {
        COSBase idFirst = first.getDictionaryObject(COSName.ID);
        COSBase idLast = last.getDictionaryObject(COSName.ID);
        if (idFirst != null && idLast != null) {
            if (!(idFirst instanceof COSArray) || !(idLast instanceof COSArray)) {
                return false;
            }
            boolean isEqual = true;
            for (COSBase of : (COSArray)idFirst) {
                boolean oneIsEquals = false;
                String ofString = ((COSString)of).getString();
                for (COSBase ol : (COSArray)idLast) {
                    if (oneIsEquals) break;
                    oneIsEquals = ((COSString)ol).getString().equals(ofString);
                }
                if (isEqual &= oneIsEquals) continue;
                break;
            }
            return isEqual;
        }
        return true;
    }

    protected void checkMainTrailer(PreflightContext ctx, COSDictionary trailer) {
        if (!trailer.containsKey(COSName.ID)) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.1", "The trailer dictionary doesn't contain ID"));
        } else if (trailer.getCOSArray(COSName.ID) == null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.3", "The trailer dictionary contains an id but it isn't an array"));
        }
        if (trailer.containsKey(COSName.ENCRYPT)) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.2", "The trailer dictionary contains Encrypt"));
        }
        if (!trailer.containsKey(COSName.SIZE)) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.4", "The trailer dictionary doesn't contain Size"));
        } else if (!(trailer.getDictionaryObject(COSName.SIZE) instanceof COSInteger)) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.3", "The trailer dictionary contains a size but it isn't an integer"));
        }
        if (!trailer.containsKey(COSName.ROOT)) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.5", "The trailer dictionary doesn't contain Root"));
        } else if (trailer.getCOSDictionary(COSName.ROOT) == null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.3", "The trailer dictionary contains a root but it isn't a dictionary"));
        }
        if (trailer.containsKey(COSName.PREV) && !(trailer.getDictionaryObject(COSName.PREV) instanceof COSInteger)) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.3", "The trailer dictionary contains a prev but it isn't an integer"));
        }
        if (trailer.containsKey(COSName.INFO) && trailer.getCOSDictionary(COSName.INFO) == null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.3", "The trailer dictionary contains an info but it isn't a dictionary"));
        }
    }

    protected void checkLinearizedDictionary(PreflightContext ctx, COSDictionary linearizedDict) {
        boolean t;
        boolean l = linearizedDict.getItem(COSName.L) != null;
        boolean h = linearizedDict.getItem(COSName.H) != null;
        boolean o = linearizedDict.getItem(COSName.O) != null;
        boolean e = linearizedDict.getItem(COSName.E) != null;
        boolean n = linearizedDict.getItem(COSName.N) != null;
        boolean bl = t = linearizedDict.getItem(COSName.T) != null;
        if (!(l && h && o && e && t && n)) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.2.3", "Invalid key in The Linearized dictionary"));
        }
    }
}

