/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.CharStringHandler;
import org.apache.fontbox.cff.Type1CharString;
import org.apache.fontbox.type1.Type1CharStringReader;

public class Type2CharString
extends Type1CharString {
    private float defWidthX = 0.0f;
    private float nominalWidthX = 0.0f;
    private int pathCount = 0;
    private final int gid;

    public Type2CharString(Type1CharStringReader font, String fontName, String glyphName, int gid, List<Object> sequence, int defaultWidthX, int nomWidthX) {
        super(font, fontName, glyphName);
        this.gid = gid;
        this.defWidthX = defaultWidthX;
        this.nominalWidthX = nomWidthX;
        this.convertType1ToType2(sequence);
    }

    public int getGID() {
        return this.gid;
    }

    private void convertType1ToType2(List<Object> sequence) {
        this.type1Sequence = new ArrayList();
        this.pathCount = 0;
        CharStringHandler handler = this::handleType2Command;
        handler.handleSequence(sequence);
    }

    private List<Number> handleType2Command(List<Number> numbers, CharStringCommand command) {
        ++this.commandCount;
        CharStringCommand.Type2KeyWord type2KeyWord = command.getType2KeyWord();
        if (type2KeyWord == null) {
            this.addCommand(numbers, command);
            return Collections.emptyList();
        }
        switch (type2KeyWord) {
            case HSTEM: 
            case HSTEMHM: {
                numbers = this.clearStack(numbers, numbers.size() % 2 != 0);
                this.expandStemHints(numbers, true);
                break;
            }
            case VSTEM: 
            case VSTEMHM: {
                numbers = this.clearStack(numbers, numbers.size() % 2 != 0);
                this.expandStemHints(numbers, false);
                break;
            }
            case VMOVETO: 
            case HMOVETO: {
                numbers = this.clearStack(numbers, numbers.size() > 1);
                this.markPath();
                this.addCommand(numbers, command);
                break;
            }
            case RLINETO: {
                this.addCommandList(Type2CharString.split(numbers, 2), command);
                break;
            }
            case HLINETO: {
                this.drawAlternatingLine(numbers, true);
                break;
            }
            case VLINETO: {
                this.drawAlternatingLine(numbers, false);
                break;
            }
            case RRCURVETO: {
                this.addCommandList(Type2CharString.split(numbers, 6), command);
                break;
            }
            case ENDCHAR: {
                numbers = this.clearStack(numbers, numbers.size() == 5 || numbers.size() == 1);
                this.closeCharString2Path();
                if (numbers.size() == 4) {
                    numbers.add(0, 0);
                    this.addCommand(numbers, new CharStringCommand(12, 6));
                    break;
                }
                this.addCommand(numbers, command);
                break;
            }
            case RMOVETO: {
                numbers = this.clearStack(numbers, numbers.size() > 2);
                this.markPath();
                this.addCommand(numbers, command);
                break;
            }
            case VHCURVETO: {
                this.drawAlternatingCurve(numbers, false);
                break;
            }
            case HVCURVETO: {
                this.drawAlternatingCurve(numbers, true);
                break;
            }
            case HFLEX: {
                List<Number> first = Arrays.asList(numbers.get(0), 0, numbers.get(1), numbers.get(2), numbers.get(3), 0);
                List<Number> second = Arrays.asList(numbers.get(4), 0, numbers.get(5), Float.valueOf(-numbers.get(2).floatValue()), numbers.get(6), 0);
                this.addCommandList(Arrays.asList(first, second), new CharStringCommand(8));
                break;
            }
            case FLEX: {
                List<Number> first = numbers.subList(0, 6);
                List<Number> second = numbers.subList(6, 12);
                this.addCommandList(Arrays.asList(first, second), new CharStringCommand(8));
                break;
            }
            case HFLEX1: {
                List<Number> first = Arrays.asList(numbers.get(0), numbers.get(1), numbers.get(2), numbers.get(3), numbers.get(4), 0);
                List<Number> second = Arrays.asList(numbers.get(5), 0, numbers.get(6), numbers.get(7), numbers.get(8), 0);
                this.addCommandList(Arrays.asList(first, second), new CharStringCommand(8));
                break;
            }
            case FLEX1: {
                int dx = 0;
                int dy = 0;
                for (int i = 0; i < 5; ++i) {
                    dx += numbers.get(i * 2).intValue();
                    dy += numbers.get(i * 2 + 1).intValue();
                }
                List<Number> first = numbers.subList(0, 6);
                List<Number> second = Arrays.asList(numbers.get(6), numbers.get(7), numbers.get(8), numbers.get(9), Math.abs(dx) > Math.abs(dy) ? (Number)numbers.get(10) : (Number)(-dx), Math.abs(dx) > Math.abs(dy) ? (Number)(-dy) : (Number)numbers.get(10));
                this.addCommandList(Arrays.asList(first, second), new CharStringCommand(8));
                break;
            }
            case HINTMASK: 
            case CNTRMASK: {
                numbers = this.clearStack(numbers, numbers.size() % 2 != 0);
                if (numbers.isEmpty()) break;
                this.expandStemHints(numbers, false);
                break;
            }
            case RCURVELINE: {
                if (numbers.size() < 2) break;
                this.addCommandList(Type2CharString.split(numbers.subList(0, numbers.size() - 2), 6), new CharStringCommand(8));
                this.addCommand(numbers.subList(numbers.size() - 2, numbers.size()), new CharStringCommand(5));
                break;
            }
            case RLINECURVE: {
                if (numbers.size() < 6) break;
                this.addCommandList(Type2CharString.split(numbers.subList(0, numbers.size() - 6), 2), new CharStringCommand(5));
                this.addCommand(numbers.subList(numbers.size() - 6, numbers.size()), new CharStringCommand(8));
                break;
            }
            case VVCURVETO: {
                this.drawCurve(numbers, false);
                break;
            }
            case HHCURVETO: {
                this.drawCurve(numbers, true);
                break;
            }
            default: {
                this.addCommand(numbers, command);
            }
        }
        return Collections.emptyList();
    }

    private List<Number> clearStack(List<Number> numbers, boolean flag) {
        if (this.type1Sequence.isEmpty()) {
            if (flag) {
                this.addCommand(Arrays.asList(0, Float.valueOf(numbers.get(0).floatValue() + this.nominalWidthX)), new CharStringCommand(13));
                numbers = numbers.subList(1, numbers.size());
            } else {
                this.addCommand(Arrays.asList(0, Float.valueOf(this.defWidthX)), new CharStringCommand(13));
            }
        }
        return numbers;
    }

    private void expandStemHints(List<Number> numbers, boolean horizontal) {
    }

    private void markPath() {
        if (this.pathCount > 0) {
            this.closeCharString2Path();
        }
        ++this.pathCount;
    }

    private void closeCharString2Path() {
        CharStringCommand command = this.pathCount > 0 ? (CharStringCommand)this.type1Sequence.get(this.type1Sequence.size() - 1) : null;
        CharStringCommand closepathCommand = new CharStringCommand(9);
        if (command != null && !closepathCommand.equals(command)) {
            this.addCommand(Collections.emptyList(), closepathCommand);
        }
    }

    private void drawAlternatingLine(List<Number> numbers, boolean horizontal) {
        while (!numbers.isEmpty()) {
            this.addCommand(numbers.subList(0, 1), new CharStringCommand(horizontal ? 6 : 7));
            numbers = numbers.subList(1, numbers.size());
            horizontal = !horizontal;
        }
    }

    private void drawAlternatingCurve(List<Number> numbers, boolean horizontal) {
        while (numbers.size() >= 4) {
            boolean last;
            boolean bl = last = numbers.size() == 5;
            if (horizontal) {
                this.addCommand(Arrays.asList(numbers.get(0), 0, numbers.get(1), numbers.get(2), last ? (Number)numbers.get(4) : (Number)0, numbers.get(3)), new CharStringCommand(8));
            } else {
                this.addCommand(Arrays.asList(0, numbers.get(0), numbers.get(1), numbers.get(2), numbers.get(3), last ? (Number)numbers.get(4) : (Number)0), new CharStringCommand(8));
            }
            numbers = numbers.subList(last ? 5 : 4, numbers.size());
            horizontal = !horizontal;
        }
    }

    private void drawCurve(List<Number> numbers, boolean horizontal) {
        while (numbers.size() >= 4) {
            boolean first;
            boolean bl = first = numbers.size() % 4 == 1;
            if (horizontal) {
                this.addCommand(Arrays.asList(numbers.get(first ? 1 : 0), first ? (Number)numbers.get(0) : (Number)0, numbers.get(first ? 2 : 1), numbers.get(first ? 3 : 2), numbers.get(first ? 4 : 3), 0), new CharStringCommand(8));
            } else {
                this.addCommand(Arrays.asList(first ? (Number)numbers.get(0) : (Number)0, numbers.get(first ? 1 : 0), numbers.get(first ? 2 : 1), numbers.get(first ? 3 : 2), 0, numbers.get(first ? 4 : 3)), new CharStringCommand(8));
            }
            numbers = numbers.subList(first ? 5 : 4, numbers.size());
        }
    }

    private void addCommandList(List<List<Number>> numbers, CharStringCommand command) {
        numbers.forEach(ns -> this.addCommand((List<Number>)ns, command));
    }

    private void addCommand(List<Number> numbers, CharStringCommand command) {
        this.type1Sequence.addAll(numbers);
        this.type1Sequence.add(command);
    }

    private static <E> List<List<E>> split(List<E> list, int size) {
        int listSize = list.size() / size;
        ArrayList<List<List<E>>> result = new ArrayList<List<List<E>>>(listSize);
        for (int i = 0; i < listSize; ++i) {
            result.add(list.subList(i * size, (i + 1) * size));
        }
        return result;
    }
}

