/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.HashMap;
import java.util.Map;
import org.apache.fontbox.cff.CFFCharset;

class CFFCharsetType1
implements CFFCharset {
    private static final String EXCEPTION_MESSAGE = "Not a CIDFont";
    private final Map<Integer, Integer> sidOrCidToGid = new HashMap<Integer, Integer>(250);
    private final Map<Integer, Integer> gidToSid = new HashMap<Integer, Integer>(250);
    private final Map<String, Integer> nameToSid = new HashMap<String, Integer>(250);
    private final Map<Integer, String> gidToName = new HashMap<Integer, String>(250);

    CFFCharsetType1() {
    }

    @Override
    public boolean isCIDFont() {
        return false;
    }

    @Override
    public void addSID(int gid, int sid, String name) {
        this.sidOrCidToGid.put(sid, gid);
        this.gidToSid.put(gid, sid);
        this.nameToSid.put(name, sid);
        this.gidToName.put(gid, name);
    }

    @Override
    public void addCID(int gid, int cid) {
        throw new IllegalStateException(EXCEPTION_MESSAGE);
    }

    @Override
    public int getSIDForGID(int sid) {
        Integer gid = this.gidToSid.get(sid);
        if (gid == null) {
            return 0;
        }
        return gid;
    }

    @Override
    public int getGIDForSID(int sid) {
        Integer gid = this.sidOrCidToGid.get(sid);
        if (gid == null) {
            return 0;
        }
        return gid;
    }

    @Override
    public int getGIDForCID(int cid) {
        throw new IllegalStateException(EXCEPTION_MESSAGE);
    }

    @Override
    public int getSID(String name) {
        Integer sid = this.nameToSid.get(name);
        if (sid == null) {
            return 0;
        }
        return sid;
    }

    @Override
    public String getNameForGID(int gid) {
        return this.gidToName.get(gid);
    }

    @Override
    public int getCIDForGID(int gid) {
        throw new IllegalStateException(EXCEPTION_MESSAGE);
    }
}

