/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FileOpenSaveDialog {
    private static final JFileChooser fileChooser = new JFileChooser(){

        @Override
        public void approveSelection() {
            int result;
            File selectedFile = this.getSelectedFile();
            if (selectedFile.exists() && this.getDialogType() == 1 && (result = JOptionPane.showConfirmDialog(this, "Do you want to overwrite?", "File already exists", 0)) != 0) {
                this.cancelSelection();
                return;
            }
            super.approveSelection();
        }
    };
    private final Component mainUI;

    public FileOpenSaveDialog(Component parentUI, FileFilter fileFilter) {
        this.mainUI = parentUI;
        fileChooser.resetChoosableFileFilters();
        fileChooser.setFileFilter(fileFilter);
    }

    public boolean saveFile(byte[] bytes, String extension) throws IOException {
        int result = fileChooser.showSaveDialog(this.mainUI);
        if (result == 0) {
            String filename = fileChooser.getSelectedFile().getAbsolutePath();
            if (extension != null && !filename.endsWith(extension)) {
                filename = filename + "." + extension;
            }
            try (FileOutputStream outputStream = new FileOutputStream(filename);){
                outputStream.write(bytes);
            }
            return true;
        }
        return false;
    }

    public File openFile() throws IOException {
        int result = fileChooser.showOpenDialog(this.mainUI);
        if (result == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }
}

