/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class PeekInputStream
extends InputStream {
    private byte[] content = new byte[0];
    private int position = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeekInputStream(InputStream source) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            IOUtils.copyLarge(source, bos);
            this.content = bos.toByteArray();
        }
        finally {
            IOUtils.closeQuietly(source);
            IOUtils.closeQuietly(bos);
        }
    }

    public int read() throws IOException {
        if (this.position >= this.content.length) {
            throw new IOException("No more content in this stream");
        }
        int currentByte = this.content[this.position] & 0xFF;
        ++this.position;
        return currentByte;
    }

    public int peek() throws IOException {
        if (this.position >= this.content.length) {
            throw new IOException("No more content in this stream");
        }
        return this.content[this.position] & 0xFF;
    }

    public byte[] peek(int numberOfBytes) throws IOException {
        if (numberOfBytes < 0 || this.position + numberOfBytes >= this.content.length) {
            throw new IOException("No more content in this stream, can't return the next " + numberOfBytes + " bytes");
        }
        byte[] nextBytes = new byte[numberOfBytes];
        System.arraycopy(this.content, this.position, nextBytes, 0, numberOfBytes);
        return nextBytes;
    }
}

