/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.apache.hadoop.ozone.shell.s3;

import java.io.IOException;

import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.Handler;

import picocli.CommandLine;

/**
 * Common interface for S3 command handling.
 */
public abstract class S3Handler extends Handler {

  @CommandLine.Option(names = {"--om-service-id"},
      required = false,
      description = "OM Service ID for OM HA, " +
          "required when cluster has multiple OM services")
  private String omServiceID;

  public String getOmServiceID() {
    return omServiceID;
  }

  @Override
  protected OzoneAddress getAddress() throws OzoneClientException {
    return new OzoneAddress();
  }

  @Override
  protected OzoneClient createClient(OzoneAddress address)
      throws IOException, OzoneClientException {
    return address.createClientForS3Commands(getConf(), omServiceID);
  }

}
