/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.update.server;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hdds.protocol.scm.proto.SCMUpdateServiceProtos;
import org.apache.hadoop.hdds.scm.update.client.CRLStore;
import org.apache.hadoop.hdds.scm.update.client.UpdateServiceConfig;
import org.apache.hadoop.hdds.scm.update.server.SCMUpdateServiceImpl;
import org.apache.ratis.thirdparty.io.grpc.BindableService;
import org.apache.ratis.thirdparty.io.grpc.Server;
import org.apache.ratis.thirdparty.io.grpc.ServerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMUpdateServiceGrpcServer {
    private static final Logger LOG = LoggerFactory.getLogger(SCMUpdateServiceGrpcServer.class);
    private static final String SERVICE_NAME = "SCMUpdateService";
    private CRLStore crlStore;
    private int port;
    private Server server;
    private SCMUpdateServiceImpl scmUpdateService;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    public SCMUpdateServiceGrpcServer(UpdateServiceConfig updateConf, CRLStore crlStore) {
        this.crlStore = crlStore;
        this.port = updateConf.getPort();
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws IOException {
        LOG.info("{} starting", (Object)SERVICE_NAME);
        this.scmUpdateService = new SCMUpdateServiceImpl(this.crlStore);
        this.server = ServerBuilder.forPort((int)this.port).addService((BindableService)this.scmUpdateService).build();
        if (!this.isStarted.compareAndSet(false, true)) {
            LOG.info("Ignoring start() since {} has already started.", (Object)SERVICE_NAME);
            return;
        }
        this.server.start();
    }

    public void stop() {
        LOG.info("{} stopping", (Object)SERVICE_NAME);
        if (this.isStarted.get()) {
            this.scmUpdateService = null;
            this.server.shutdown();
            try {
                this.server.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.error("failed to shutdown SCMClientGrpcServer", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            finally {
                this.server.shutdownNow();
            }
            LOG.info("{} stopped!", (Object)SERVICE_NAME);
            this.isStarted.set(false);
        }
    }

    public void join() throws InterruptedException {
        while (this.isStarted.get()) {
            this.wait();
        }
    }

    public void notifyCrlUpdate() {
        this.scmUpdateService.notifyUpdate(SCMUpdateServiceProtos.Type.CRLUpdate);
    }
}

