/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.update.server;

import java.security.cert.X509CRL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.protocol.scm.proto.SCMUpdateServiceProtos;
import org.apache.hadoop.hdds.scm.update.client.CRLStore;
import org.apache.hadoop.hdds.scm.update.server.CRLClientInfo;
import org.apache.hadoop.hdds.scm.update.server.SCMUpdateClientInfo;
import org.apache.hadoop.hdds.scm.update.server.SCMUpdateHandler;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.crl.CRLCodec;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfo;
import org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMCRLUpdateHandler
implements SCMUpdateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SCMCRLUpdateHandler.class);
    private final CRLStore crlStore;
    private static final SCMUpdateServiceProtos.Type TYPE = SCMUpdateServiceProtos.Type.CRLUpdate;
    private final Map<UUID, CRLClientInfo> clients;

    SCMCRLUpdateHandler(CRLStore crlStore) {
        this.crlStore = crlStore;
        this.clients = new ConcurrentHashMap<UUID, CRLClientInfo>();
    }

    @Override
    public SCMUpdateServiceProtos.Type getType() {
        return TYPE;
    }

    @Override
    public void handleClientRequest(SCMUpdateServiceProtos.UpdateRequest request, SCMUpdateClientInfo clientInfo) {
        CRLClientInfo crlClientInfo;
        SCMUpdateServiceProtos.CRLUpdateRequest updateStatusRequest = request.getCrlUpdateRequest();
        long clientCrlId = updateStatusRequest.getReceivedCrlId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Client {} updateStatus \nclientCrlId {}  \npendingCrls {}", new Object[]{clientInfo.getClientId(), clientCrlId, updateStatusRequest.getPendingCrlIdsList().toString()});
        }
        if (!this.clients.containsKey(clientInfo.getClientId())) {
            crlClientInfo = new CRLClientInfo(clientInfo);
            this.clients.put(clientInfo.getClientId(), crlClientInfo);
        } else {
            crlClientInfo = this.clients.get(clientInfo.getClientId());
        }
        crlClientInfo.setPendingCrlIds(request.getCrlUpdateRequest().getPendingCrlIdsList());
        crlClientInfo.setReceivedCrlId(request.getCrlUpdateRequest().getReceivedCrlId());
        this.sendCrlUpdateToClient(crlClientInfo);
    }

    @Override
    public void onUpdate() {
        LOG.debug("Update due to certificate revocation");
        this.clients.values().forEach(client -> this.sendCrlUpdateToClient((CRLClientInfo)client));
    }

    @Override
    public void onRemoveClient(SCMUpdateClientInfo clientInfo) {
        this.clients.remove(clientInfo.getClientId());
    }

    private void sendCrlUpdateToClient(CRLClientInfo client) {
        long nextCrlId;
        long serverCrlId;
        long clientCrlId = client.getReceivedCrlId();
        if (clientCrlId >= (serverCrlId = this.crlStore.getLatestCrlId())) {
            return;
        }
        LOG.debug("## Server: clientCrlId {} serverCrlId {}", (Object)clientCrlId, (Object)serverCrlId);
        try {
            CRLInfo crlInfo = null;
            for (nextCrlId = clientCrlId + 1L; crlInfo == null && nextCrlId <= serverCrlId; ++nextCrlId) {
                crlInfo = this.crlStore.getCRL(nextCrlId);
            }
            if (crlInfo == null) {
                LOG.debug("Nothing to send to client");
                return;
            }
            this.sendCrlToClient(crlInfo, client.getUpdateClientInfo());
        }
        catch (Exception e) {
            LOG.error("Failed to handle client update.", (Throwable)e);
            client.getUpdateClientInfo().getResponseObserver().onError((Throwable)Status.INTERNAL.withDescription("Failed to send crl" + nextCrlId + " to client " + client.getUpdateClientInfo().getClientId()).asException());
        }
    }

    private void sendCrlToClient(CRLInfo crl, SCMUpdateClientInfo clientInfo) throws SCMSecurityException {
        LOG.debug("Sending client# {} with crl: {} ", (Object)clientInfo.getClientId(), (Object)crl.getCrlSequenceID());
        StreamObserver responseObserver = clientInfo.getResponseObserver();
        SCMUpdateServiceProtos.CRLInfoProto crlInfoProto = SCMUpdateServiceProtos.CRLInfoProto.newBuilder().setCrlSequenceID(crl.getCrlSequenceID()).setX509CRL(CRLCodec.getPEMEncodedString((X509CRL)crl.getX509CRL())).setCreationTimestamp(crl.getCreationTimestamp()).build();
        responseObserver.onNext((Object)SCMUpdateServiceProtos.UpdateResponse.newBuilder().setUpdateType(SCMUpdateServiceProtos.Type.CRLUpdate).setCrlUpdateResponse(SCMUpdateServiceProtos.CRLUpdateResponse.newBuilder().setCrlInfo(crlInfoProto).build()).build());
    }
}

