/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server.upgrade;

import java.io.IOException;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.upgrade.AbstractLayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.BasicUpgradeFinalizer;
import org.apache.hadoop.ozone.upgrade.UpgradeException;

public class SCMUpgradeFinalizer
extends BasicUpgradeFinalizer<StorageContainerManager, HDDSLayoutVersionManager> {
    public SCMUpgradeFinalizer(HDDSLayoutVersionManager versionManager) {
        super((AbstractLayoutVersionManager)versionManager);
    }

    public void preFinalizeUpgrade(StorageContainerManager scm) throws IOException {
        String msg = "  Existing pipelines and containers will be closed during Upgrade.";
        msg = msg + "\n  New pipelines creation will remain frozen until Upgrade is finalized.";
        PipelineManager pipelineManager = scm.getPipelineManager();
        pipelineManager.freezePipelineCreation();
        this.waitForAllPipelinesToDestroy(pipelineManager);
        this.logAndEmit(msg);
    }

    public void finalizeUpgrade(StorageContainerManager scm) throws UpgradeException {
        super.finalizeUpgrade(lf -> arg_0 -> ((HDDSLayoutFeature)((HDDSLayoutFeature)lf)).scmAction(arg_0), (Storage)scm.getScmStorageConfig());
    }

    public void postFinalizeUpgrade(StorageContainerManager scm) throws IOException {
        scm.getScmNodeManager().forceNodesToHealthyReadOnly();
        PipelineManager pipelineManager = scm.getPipelineManager();
        pipelineManager.resumePipelineCreation();
        boolean hasPipeline = false;
        while (!hasPipeline) {
            ReplicationConfig ratisThree = ReplicationConfig.fromTypeAndFactor((HddsProtos.ReplicationType)HddsProtos.ReplicationType.RATIS, (HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE);
            int pipelineCount = pipelineManager.getPipelines(ratisThree, Pipeline.PipelineState.OPEN).size();
            boolean bl = hasPipeline = pipelineCount >= 1;
            if (!hasPipeline) {
                LOG.info("Waiting for at least one open pipeline after SCM finalization.");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            LOG.info("Open pipeline found after SCM finalization");
        }
        this.emitFinishedMsg();
    }

    public void runPrefinalizeStateActions(Storage storage, StorageContainerManager scm) throws IOException {
        this.runPrefinalizeStateActions(lf -> arg_0 -> ((HDDSLayoutFeature)((HDDSLayoutFeature)lf)).scmAction(arg_0), storage, scm);
    }

    private void waitForAllPipelinesToDestroy(PipelineManager pipelineManager) throws IOException {
        boolean pipelineFound = true;
        while (pipelineFound) {
            pipelineFound = false;
            for (Pipeline pipeline : pipelineManager.getPipelines()) {
                if (pipeline.getPipelineState() == Pipeline.PipelineState.CLOSED) continue;
                pipelineFound = true;
                pipelineManager.closePipeline(pipeline, true);
            }
            try {
                if (!pipelineFound) continue;
                LOG.info("Waiting for all pipelines to close.");
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

