/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.protobuf.BlockingService;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.PipelineChoosePolicy;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.ScmConfig;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.block.BlockManager;
import org.apache.hadoop.hdds.scm.block.BlockManagerImpl;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLogImpl;
import org.apache.hadoop.hdds.scm.command.CommandStatusReportHandler;
import org.apache.hadoop.hdds.scm.container.CloseContainerEventHandler;
import org.apache.hadoop.hdds.scm.container.ContainerActionsHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerManagerImpl;
import org.apache.hadoop.hdds.scm.container.ContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.IncrementalContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerBalancer;
import org.apache.hadoop.hdds.scm.container.common.helpers.MoveDataNodePair;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementPolicyFactory;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementMetrics;
import org.apache.hadoop.hdds.scm.container.placement.metrics.ContainerStat;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMMetrics;
import org.apache.hadoop.hdds.scm.crl.CRLStatusReportHandler;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.ha.HASecurityUtils;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.ha.SCMHAManager;
import org.apache.hadoop.hdds.scm.ha.SCMHAManagerImpl;
import org.apache.hadoop.hdds.scm.ha.SCMHANodeDetails;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.apache.hadoop.hdds.scm.ha.SCMNodeDetails;
import org.apache.hadoop.hdds.scm.ha.SCMNodeInfo;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServerImpl;
import org.apache.hadoop.hdds.scm.ha.SCMServiceManager;
import org.apache.hadoop.hdds.scm.ha.SequenceIdGenerator;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStoreImpl;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.NetworkTopologyImpl;
import org.apache.hadoop.hdds.scm.node.DeadNodeHandler;
import org.apache.hadoop.hdds.scm.node.HealthyReadOnlyNodeHandler;
import org.apache.hadoop.hdds.scm.node.NewNodeHandler;
import org.apache.hadoop.hdds.scm.node.NodeDecommissionManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeReportHandler;
import org.apache.hadoop.hdds.scm.node.ReadOnlyHealthyToHealthyNodeHandler;
import org.apache.hadoop.hdds.scm.node.SCMNodeManager;
import org.apache.hadoop.hdds.scm.node.StaleNodeHandler;
import org.apache.hadoop.hdds.scm.node.StartDatanodeAdminHandler;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineActionHandler;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManagerImpl;
import org.apache.hadoop.hdds.scm.pipeline.PipelineReportHandler;
import org.apache.hadoop.hdds.scm.pipeline.WritableContainerFactory;
import org.apache.hadoop.hdds.scm.pipeline.choose.algorithms.PipelineChoosePolicyFactory;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.hdds.scm.server.SCMBlockProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMCertStore;
import org.apache.hadoop.hdds.scm.server.SCMClientProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMConfigurator;
import org.apache.hadoop.hdds.scm.server.SCMContainerMetrics;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMMXBean;
import org.apache.hadoop.hdds.scm.server.SCMSecurityProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.scm.server.StorageContainerManagerHttpServer;
import org.apache.hadoop.hdds.scm.server.upgrade.SCMUpgradeFinalizer;
import org.apache.hadoop.hdds.scm.server.upgrade.ScmHAUnfinalizedStateValidationAction;
import org.apache.hadoop.hdds.security.OzoneSecurityException;
import org.apache.hadoop.hdds.security.token.ContainerTokenGenerator;
import org.apache.hadoop.hdds.security.token.ContainerTokenSecretManager;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateServer;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateStore;
import org.apache.hadoop.hdds.security.x509.certificate.authority.DefaultCAServer;
import org.apache.hadoop.hdds.security.x509.certificate.authority.PKIProfiles.DefaultCAProfile;
import org.apache.hadoop.hdds.security.x509.certificate.authority.PKIProfiles.DefaultProfile;
import org.apache.hadoop.hdds.security.x509.certificate.authority.PKIProfiles.PKIProfile;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.SCMCertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.hdds.server.ServiceRuntimeInfoImpl;
import org.apache.hadoop.hdds.server.events.EventExecutor;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.FixedThreadPoolExecutor;
import org.apache.hadoop.hdds.server.http.RatisDropwizardExports;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.HddsVersionInfo;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.common.MonotonicClock;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.lease.LeaseManager;
import org.apache.hadoop.ozone.upgrade.LayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "CBLOCK", "OZONE", "HBASE"})
public final class StorageContainerManager
extends ServiceRuntimeInfoImpl
implements SCMMXBean,
OzoneStorageContainerManager {
    private static final Logger LOG = LoggerFactory.getLogger(StorageContainerManager.class);
    private static SCMMetrics metrics;
    private final SCMDatanodeProtocolServer datanodeProtocolServer;
    private final SCMBlockProtocolServer blockProtocolServer;
    private final SCMClientProtocolServer clientProtocolServer;
    private SCMSecurityProtocolServer securityProtocolServer;
    private NodeManager scmNodeManager;
    private PipelineManager pipelineManager;
    private ContainerManager containerManager;
    private BlockManager scmBlockManager;
    private final SCMStorageConfig scmStorageConfig;
    private NodeDecommissionManager scmDecommissionManager;
    private WritableContainerFactory writableContainerFactory;
    private SCMMetadataStore scmMetadataStore;
    private CertificateStore certificateStore;
    private SCMHAManager scmHAManager;
    private SCMContext scmContext;
    private SequenceIdGenerator sequenceIdGen;
    private final EventQueue eventQueue;
    private final SCMServiceManager serviceManager;
    private StorageContainerManagerHttpServer httpServer;
    private final Collection<String> scmAdminUsernames;
    private ObjectName scmInfoBeanName;
    private final Cache<String, ContainerStat> containerReportCache;
    private ReplicationManager replicationManager;
    private final LeaseManager<Long> commandWatcherLeaseManager;
    private SCMSafeModeManager scmSafeModeManager;
    private SCMCertificateClient scmCertificateClient;
    private ContainerTokenSecretManager containerTokenMgr;
    private JvmPauseMonitor jvmPauseMonitor;
    private final OzoneConfiguration configuration;
    private SCMContainerMetrics scmContainerMetrics;
    private SCMContainerPlacementMetrics placementMetrics;
    private MetricsSystem ms;
    private final Map<String, RatisDropwizardExports> ratisMetricsMap = new ConcurrentHashMap<String, RatisDropwizardExports>();
    private String primaryScmNodeId;
    private NetworkTopology clusterMap;
    private PipelineChoosePolicy pipelineChoosePolicy;
    private SecurityConfig securityConfig;
    private HDDSLayoutVersionManager scmLayoutVersionManager;
    private UpgradeFinalizer<StorageContainerManager> upgradeFinalizer;
    private final SCMHANodeDetails scmHANodeDetails;
    private ContainerBalancer containerBalancer;

    @VisibleForTesting
    public StorageContainerManager(OzoneConfiguration conf) throws IOException, AuthenticationException {
        this(conf, new SCMConfigurator());
    }

    private StorageContainerManager(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException, AuthenticationException {
        super(HddsVersionInfo.HDDS_VERSION_INFO);
        Objects.requireNonNull(configurator, "configurator cannot not be null");
        Objects.requireNonNull(conf, "configuration cannot not be null");
        this.scmHANodeDetails = SCMHANodeDetails.loadSCMHAConfig(conf);
        this.configuration = conf;
        StorageContainerManager.initMetrics();
        this.containerReportCache = this.buildContainerReportCache();
        this.scmStorageConfig = new SCMStorageConfig(conf);
        if (this.scmStorageConfig.getState() != Storage.StorageState.INITIALIZED) {
            String errMsg = "Please make sure you have run 'ozone scm --init' command to generate all the required metadata to " + this.scmStorageConfig.getStorageDir();
            if (SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf) && !this.scmStorageConfig.isSCMHAEnabled()) {
                errMsg = errMsg + " or make sure you have run 'ozone scm --bootstrap' cmd to add the SCM to existing SCM HA group";
            }
            LOG.error(errMsg + ".");
            throw new SCMException("SCM not initialized due to storage config failure.", SCMException.ResultCodes.SCM_NOT_INITIALIZED);
        }
        this.scmLayoutVersionManager = new HDDSLayoutVersionManager(this.scmStorageConfig.getLayoutVersion());
        this.upgradeFinalizer = new SCMUpgradeFinalizer(this.scmLayoutVersionManager);
        this.primaryScmNodeId = this.scmStorageConfig.getPrimaryScmNodeId();
        this.initializeCertificateClient();
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
            StorageContainerManager.loginAsSCMUserIfSecurityEnabled(this.scmHANodeDetails, (ConfigurationSource)conf);
        }
        this.initalizeMetadataStore(conf, configurator);
        this.eventQueue = new EventQueue();
        this.serviceManager = new SCMServiceManager();
        long watcherTimeout = conf.getTimeDuration("hdds.scm.watcher.timeout", "10m", TimeUnit.MILLISECONDS);
        this.commandWatcherLeaseManager = new LeaseManager("CommandWatcher", watcherTimeout);
        this.initializeSystemManagers(conf, configurator);
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
            this.initializeCAnSecurityProtocol(conf, configurator);
        } else {
            this.securityProtocolServer = null;
        }
        this.scmAdminUsernames = conf.getTrimmedStringCollection("ozone.administrators");
        String scmShortUsername = UserGroupInformation.getCurrentUser().getShortUserName();
        if (!this.scmAdminUsernames.contains(scmShortUsername)) {
            this.scmAdminUsernames.add(scmShortUsername);
        }
        this.datanodeProtocolServer = new SCMDatanodeProtocolServer(conf, this, (EventPublisher)this.eventQueue);
        this.blockProtocolServer = new SCMBlockProtocolServer(conf, this);
        this.clientProtocolServer = new SCMClientProtocolServer(conf, this);
        this.initializeEventHandlers();
        this.containerBalancer = new ContainerBalancer(this.scmNodeManager, this.containerManager, this.replicationManager, this.configuration, this.scmContext, ContainerPlacementPolicyFactory.getPolicy((ConfigurationSource)conf, this.scmNodeManager, this.clusterMap, true, this.placementMetrics));
        LOG.info(this.containerBalancer.toString());
        this.scmSafeModeManager.emitSafeModeStatus();
        this.registerMXBean();
        this.registerMetricsSource(this);
    }

    private void initializeEventHandlers() {
        CloseContainerEventHandler closeContainerHandler = new CloseContainerEventHandler(this.pipelineManager, this.containerManager, this.scmContext);
        NodeReportHandler nodeReportHandler = new NodeReportHandler(this.scmNodeManager);
        PipelineReportHandler pipelineReportHandler = new PipelineReportHandler(this.scmSafeModeManager, this.pipelineManager, this.scmContext, (ConfigurationSource)this.configuration);
        CommandStatusReportHandler cmdStatusReportHandler = new CommandStatusReportHandler();
        NewNodeHandler newNodeHandler = new NewNodeHandler(this.pipelineManager, this.scmDecommissionManager, (ConfigurationSource)this.configuration, this.serviceManager);
        StaleNodeHandler staleNodeHandler = new StaleNodeHandler(this.scmNodeManager, this.pipelineManager, this.configuration);
        DeadNodeHandler deadNodeHandler = new DeadNodeHandler(this.scmNodeManager, this.pipelineManager, this.containerManager);
        StartDatanodeAdminHandler datanodeStartAdminHandler = new StartDatanodeAdminHandler(this.scmNodeManager, this.pipelineManager);
        ReadOnlyHealthyToHealthyNodeHandler readOnlyHealthyToHealthyNodeHandler = new ReadOnlyHealthyToHealthyNodeHandler(this.configuration, this.serviceManager);
        HealthyReadOnlyNodeHandler healthyReadOnlyNodeHandler = new HealthyReadOnlyNodeHandler(this.scmNodeManager, this.pipelineManager, this.configuration);
        ContainerActionsHandler actionsHandler = new ContainerActionsHandler();
        ContainerReportHandler containerReportHandler = new ContainerReportHandler(this.scmNodeManager, this.containerManager, this.scmContext, this.configuration);
        IncrementalContainerReportHandler incrementalContainerReportHandler = new IncrementalContainerReportHandler(this.scmNodeManager, this.containerManager, this.scmContext);
        PipelineActionHandler pipelineActionHandler = new PipelineActionHandler(this.pipelineManager, this.scmContext, this.configuration);
        CRLStatusReportHandler crlStatusReportHandler = new CRLStatusReportHandler(this.certificateStore, this.configuration);
        this.eventQueue.addHandler(SCMEvents.DATANODE_COMMAND, (EventHandler)this.scmNodeManager);
        this.eventQueue.addHandler(SCMEvents.RETRIABLE_DATANODE_COMMAND, (EventHandler)this.scmNodeManager);
        this.eventQueue.addHandler(SCMEvents.NODE_REPORT, (EventHandler)nodeReportHandler);
        this.eventQueue.addHandler(SCMEvents.CONTAINER_REPORT, (EventExecutor)new FixedThreadPoolExecutor(SCMEvents.CONTAINER_REPORT.getName(), EventQueue.getExecutorName(SCMEvents.CONTAINER_REPORT, (EventHandler)containerReportHandler)), (EventHandler)containerReportHandler);
        this.eventQueue.addHandler(SCMEvents.INCREMENTAL_CONTAINER_REPORT, (EventHandler)incrementalContainerReportHandler);
        this.eventQueue.addHandler(SCMEvents.CONTAINER_ACTIONS, (EventHandler)actionsHandler);
        this.eventQueue.addHandler(SCMEvents.CLOSE_CONTAINER, (EventHandler)closeContainerHandler);
        this.eventQueue.addHandler(SCMEvents.NEW_NODE, (EventHandler)newNodeHandler);
        this.eventQueue.addHandler(SCMEvents.STALE_NODE, (EventHandler)staleNodeHandler);
        this.eventQueue.addHandler(SCMEvents.HEALTHY_READONLY_TO_HEALTHY_NODE, (EventHandler)readOnlyHealthyToHealthyNodeHandler);
        this.eventQueue.addHandler(SCMEvents.HEALTHY_READONLY_NODE, (EventHandler)healthyReadOnlyNodeHandler);
        this.eventQueue.addHandler(SCMEvents.DEAD_NODE, (EventHandler)deadNodeHandler);
        this.eventQueue.addHandler(SCMEvents.START_ADMIN_ON_NODE, (EventHandler)datanodeStartAdminHandler);
        this.eventQueue.addHandler(SCMEvents.CMD_STATUS_REPORT, (EventHandler)cmdStatusReportHandler);
        this.eventQueue.addHandler(SCMEvents.DELETE_BLOCK_STATUS, (EventHandler)((DeletedBlockLogImpl)this.scmBlockManager.getDeletedBlockLog()));
        this.eventQueue.addHandler(SCMEvents.PIPELINE_ACTIONS, (EventHandler)pipelineActionHandler);
        this.eventQueue.addHandler(SCMEvents.PIPELINE_REPORT, (EventHandler)pipelineReportHandler);
        this.eventQueue.addHandler(SCMEvents.CRL_STATUS_REPORT, (EventHandler)crlStatusReportHandler);
    }

    private void initializeCertificateClient() {
        this.securityConfig = new SecurityConfig((ConfigurationSource)this.configuration);
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)this.configuration) && this.scmStorageConfig.checkPrimarySCMIdInitialized()) {
            this.scmCertificateClient = new SCMCertificateClient(this.securityConfig, this.scmStorageConfig.getScmCertSerialId());
        }
    }

    public OzoneConfiguration getConfiguration() {
        return this.configuration;
    }

    public static StorageContainerManager createSCM(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException, AuthenticationException {
        return new StorageContainerManager(conf, configurator);
    }

    public static StorageContainerManager createSCM(OzoneConfiguration conf) throws IOException, AuthenticationException {
        return StorageContainerManager.createSCM(conf, new SCMConfigurator());
    }

    private void initializeSystemManagers(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException {
        this.clusterMap = configurator.getNetworkTopology() != null ? configurator.getNetworkTopology() : new NetworkTopologyImpl((ConfigurationSource)conf);
        RatisDropwizardExports.registerRatisMetricReporters(this.ratisMetricsMap);
        this.scmHAManager = configurator.getSCMHAManager() != null ? configurator.getSCMHAManager() : new SCMHAManagerImpl((ConfigurationSource)conf, this);
        SequenceIdGenerator.upgradeToSequenceId(this.scmMetadataStore);
        this.sequenceIdGen = new SequenceIdGenerator((ConfigurationSource)conf, this.scmHAManager, (Table<String, Long>)this.scmMetadataStore.getSequenceIdTable());
        if (configurator.getScmContext() != null) {
            this.scmContext = configurator.getScmContext();
        } else {
            long term = SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf) ? 0L : -1L;
            this.scmContext = new SCMContext.Builder().setLeader(false).setTerm(term).setIsInSafeMode(true).setIsPreCheckComplete(false).setSCM(this).build();
        }
        this.scmNodeManager = configurator.getScmNodeManager() != null ? configurator.getScmNodeManager() : new SCMNodeManager(conf, this.scmStorageConfig, (EventPublisher)this.eventQueue, this.clusterMap, this.scmContext, this.scmLayoutVersionManager);
        this.placementMetrics = SCMContainerPlacementMetrics.create();
        PlacementPolicy containerPlacementPolicy = ContainerPlacementPolicyFactory.getPolicy((ConfigurationSource)conf, this.scmNodeManager, this.clusterMap, true, this.placementMetrics);
        this.pipelineManager = configurator.getPipelineManager() != null ? configurator.getPipelineManager() : PipelineManagerImpl.newPipelineManager((ConfigurationSource)conf, this.scmHAManager, this.scmNodeManager, (Table<PipelineID, Pipeline>)this.scmMetadataStore.getPipelineTable(), (EventPublisher)this.eventQueue, this.scmContext, this.serviceManager);
        this.containerManager = configurator.getContainerManager() != null ? configurator.getContainerManager() : new ContainerManagerImpl((Configuration)conf, this.scmHAManager, this.sequenceIdGen, this.pipelineManager, (Table<ContainerID, ContainerInfo>)this.scmMetadataStore.getContainerTable());
        this.pipelineChoosePolicy = PipelineChoosePolicyFactory.getPolicy((ConfigurationSource)conf);
        this.writableContainerFactory = configurator.getWritableContainerFactory() != null ? configurator.getWritableContainerFactory() : new WritableContainerFactory(this);
        this.scmBlockManager = configurator.getScmBlockManager() != null ? configurator.getScmBlockManager() : new BlockManagerImpl((ConfigurationSource)conf, this);
        this.replicationManager = configurator.getReplicationManager() != null ? configurator.getReplicationManager() : new ReplicationManager((ConfigurationSource)conf, this.containerManager, containerPlacementPolicy, (EventPublisher)this.eventQueue, this.scmContext, this.serviceManager, this.scmNodeManager, (Clock)new MonotonicClock((ZoneId)ZoneOffset.UTC), this.scmHAManager, (Table<ContainerID, MoveDataNodePair>)this.getScmMetadataStore().getMoveTable());
        this.scmSafeModeManager = configurator.getScmSafeModeManager() != null ? configurator.getScmSafeModeManager() : new SCMSafeModeManager((ConfigurationSource)conf, this.containerManager.getContainers(), this.containerManager, this.pipelineManager, this.eventQueue, this.serviceManager, this.scmContext);
        this.scmDecommissionManager = new NodeDecommissionManager(conf, this.scmNodeManager, this.containerManager, this.scmContext, (EventPublisher)this.eventQueue, this.replicationManager);
    }

    private void initializeCAnSecurityProtocol(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException {
        CertificateServer rootCertificateServer;
        CertificateServer scmCertificateServer;
        if (this.scmMetadataStore == null) {
            LOG.error("Cannot initialize Certificate Server without a valid meta data layer.");
            throw new SCMException("Cannot initialize CA without a valid metadata store", SCMException.ResultCodes.SCM_NOT_INITIALIZED);
        }
        this.certificateStore = new SCMCertStore.Builder().setMetadaStore(this.scmMetadataStore).setRatisServer(this.scmHAManager.getRatisServer()).setCRLSequenceId(this.getLastSequenceIdForCRL()).build();
        if (this.scmStorageConfig.checkPrimarySCMIdInitialized()) {
            String subject = "scm-sub@" + InetAddress.getLocalHost().getHostName();
            if (configurator.getCertificateServer() != null) {
                scmCertificateServer = configurator.getCertificateServer();
            } else {
                scmCertificateServer = new DefaultCAServer(subject, this.scmStorageConfig.getClusterID(), this.scmStorageConfig.getScmId(), this.certificateStore, (PKIProfile)new DefaultProfile(), this.scmCertificateClient.getComponentName());
                scmCertificateServer.init(new SecurityConfig((ConfigurationSource)this.configuration), CertificateServer.CAType.INTERMEDIARY_CA);
            }
            if (this.primaryScmNodeId.equals(this.scmStorageConfig.getScmId())) {
                rootCertificateServer = configurator.getCertificateServer() != null ? configurator.getCertificateServer() : HASecurityUtils.initializeRootCertificateServer(conf, this.certificateStore, this.scmStorageConfig, (PKIProfile)new DefaultCAProfile());
                this.persistPrimarySCMCerts();
            } else {
                rootCertificateServer = null;
            }
        } else {
            scmCertificateServer = rootCertificateServer = HASecurityUtils.initializeRootCertificateServer(conf, this.certificateStore, this.scmStorageConfig, (PKIProfile)new DefaultProfile());
        }
        this.securityProtocolServer = new SCMSecurityProtocolServer(conf, rootCertificateServer, scmCertificateServer, this.scmCertificateClient != null ? this.scmCertificateClient.getCACertificate() : null, this);
        if (this.securityConfig.isContainerTokenEnabled()) {
            this.containerTokenMgr = this.createContainerTokenSecretManager(this.configuration);
        }
    }

    private void persistPrimarySCMCerts() throws IOException {
        X509Certificate rootCACert;
        BigInteger certSerial = this.scmCertificateClient.getCertificate().getSerialNumber();
        if (this.certificateStore.getCertificateByID(certSerial, CertificateStore.CertType.VALID_CERTS) == null) {
            LOG.info("Storing sub-ca certificate serialId {} on primary SCM", (Object)certSerial);
            this.certificateStore.storeValidScmCertificate(certSerial, this.scmCertificateClient.getCertificate());
        }
        if (this.certificateStore.getCertificateByID((rootCACert = this.scmCertificateClient.getCACertificate()).getSerialNumber(), CertificateStore.CertType.VALID_CERTS) == null) {
            LOG.info("Storing root certificate serialId {}", (Object)rootCACert.getSerialNumber());
            this.certificateStore.storeValidScmCertificate(rootCACert.getSerialNumber(), rootCACert);
        }
    }

    public CertificateServer getRootCertificateServer() {
        return this.getSecurityProtocolServer().getRootCertificateServer();
    }

    public CertificateServer getScmCertificateServer() {
        return this.getSecurityProtocolServer().getScmCertificateServer();
    }

    public SCMCertificateClient getScmCertificateClient() {
        return this.scmCertificateClient;
    }

    private ContainerTokenSecretManager createContainerTokenSecretManager(OzoneConfiguration conf) throws IOException {
        long expiryTime = conf.getTimeDuration("hdds.block.token.expiry.time", "1d", TimeUnit.MILLISECONDS);
        if (this.scmCertificateClient == null) {
            String certSerialNumber;
            Preconditions.checkState((!this.scmStorageConfig.checkPrimarySCMIdInitialized() ? 1 : 0) != 0);
            try {
                certSerialNumber = this.getScmCertificateServer().getCACertificate().getSerialNumber().toString();
            }
            catch (CertificateException ex) {
                LOG.error("Get CA Certificate failed", (Throwable)ex);
                throw new IOException(ex);
            }
            catch (IOException ex) {
                LOG.error("Get CA Certificate failed", (Throwable)ex);
                throw ex;
            }
            this.scmCertificateClient = new SCMCertificateClient(this.securityConfig, certSerialNumber, OzoneConsts.SCM_ROOT_CA_COMPONENT_NAME);
        }
        String certId = this.scmCertificateClient.getCertificate().getSerialNumber().toString();
        return new ContainerTokenSecretManager(this.securityConfig, expiryTime, certId);
    }

    private void initalizeMetadataStore(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException {
        this.scmMetadataStore = configurator.getMetadataStore() != null ? configurator.getMetadataStore() : new SCMMetadataStoreImpl(conf);
    }

    private static void loginAsSCMUserIfSecurityEnabled(SCMHANodeDetails scmhaNodeDetails, ConfigurationSource conf) throws IOException, AuthenticationException {
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
            Configuration hadoopConf;
            if (LOG.isDebugEnabled()) {
                ScmConfig scmConfig = (ScmConfig)conf.getObject(ScmConfig.class);
                LOG.debug("Ozone security is enabled. Attempting login for SCM user. Principal: {}, keytab: {}", (Object)scmConfig.getKerberosPrincipal(), (Object)scmConfig.getKerberosKeytab());
            }
            if (!SecurityUtil.getAuthenticationMethod((Configuration)(hadoopConf = LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)conf))).equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
                throw new AuthenticationException(SecurityUtil.getAuthenticationMethod((Configuration)hadoopConf) + " authentication method not support. SCM user login failed.");
            }
            UserGroupInformation.setConfiguration((Configuration)hadoopConf);
            InetSocketAddress socketAddress = StorageContainerManager.getScmAddress(scmhaNodeDetails, conf);
            SecurityUtil.login((Configuration)hadoopConf, (String)"hdds.scm.kerberos.keytab.file", (String)"hdds.scm.kerberos.principal", (String)socketAddress.getHostName());
            LOG.info("SCM login successful.");
        }
    }

    long getLastSequenceIdForCRL() throws IOException {
        Long sequenceId = (Long)this.scmMetadataStore.getCRLSequenceIdTable().get((Object)"CRL_SEQUENCE_ID");
        if (sequenceId == null) {
            return 0L;
        }
        return sequenceId;
    }

    public static String buildRpcServerStartMessage(String description, InetSocketAddress addr) {
        return addr != null ? String.format("%s is listening at %s", description, addr.toString()) : String.format("%s not started", description);
    }

    public static RPC.Server startRpcServer(OzoneConfiguration conf, InetSocketAddress addr, Class<?> protocol, BlockingService instance, int handlerCount) throws IOException {
        RPC.Server rpcServer = new RPC.Builder((Configuration)conf).setProtocol(protocol).setInstance((Object)instance).setBindAddress(addr.getHostString()).setPort(addr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager(null).build();
        HddsServerUtil.addPBProtocol((Configuration)conf, protocol, (BlockingService)instance, (RPC.Server)rpcServer);
        return rpcServer;
    }

    public static boolean scmBootstrap(OzoneConfiguration conf) throws AuthenticationException, IOException {
        if (!SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf)) {
            LOG.error("Bootstrap is not supported without SCM HA.");
            return false;
        }
        String primordialSCM = SCMHAUtils.getPrimordialSCM((ConfigurationSource)conf);
        SCMHANodeDetails scmhaNodeDetails = SCMHANodeDetails.loadSCMHAConfig(conf);
        String selfNodeId = scmhaNodeDetails.getLocalNodeDetails().getNodeId();
        String selfHostName = scmhaNodeDetails.getLocalNodeDetails().getHostName();
        if (primordialSCM != null && SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf) && SCMHAUtils.isPrimordialSCM((ConfigurationSource)conf, (String)selfNodeId, (String)selfHostName)) {
            LOG.info("SCM bootstrap command can only be executed in non-Primordial SCM {}, self id {} Ignoring it.", (Object)primordialSCM, (Object)selfNodeId);
            return true;
        }
        SCMStorageConfig scmStorageConfig = new SCMStorageConfig(conf);
        String persistedClusterId = scmStorageConfig.getClusterID();
        Storage.StorageState state = scmStorageConfig.getState();
        if (state == Storage.StorageState.INITIALIZED && conf.getBoolean("ozone.scm.skip.bootstrap.validation", false)) {
            LOG.info("Skipping clusterId validation during bootstrap command.  ClusterId id {}, SCM id {}", (Object)persistedClusterId, (Object)scmStorageConfig.getScmId());
            StorageContainerManager.initializeSecurityIfNeeded(conf, scmhaNodeDetails, scmStorageConfig);
            return true;
        }
        StorageContainerManager.loginAsSCMUserIfSecurityEnabled(scmhaNodeDetails, (ConfigurationSource)conf);
        OzoneConfiguration config = SCMHAUtils.removeSelfId((OzoneConfiguration)conf, (String)scmhaNodeDetails.getLocalNodeDetails().getNodeId());
        ScmInfo scmInfo = HAUtils.getScmInfo((OzoneConfiguration)config);
        String fetchedId = scmInfo.getClusterId();
        Preconditions.checkNotNull((Object)fetchedId);
        if (state == Storage.StorageState.INITIALIZED) {
            Preconditions.checkNotNull((Object)scmStorageConfig.getScmId());
            if (!fetchedId.equals(persistedClusterId)) {
                LOG.error("Could not bootstrap as SCM is already initialized with cluster id {} but cluster id for existing leader SCM instance is {}", (Object)persistedClusterId, (Object)fetchedId);
                return false;
            }
            StorageContainerManager.initializeSecurityIfNeeded(conf, scmhaNodeDetails, scmStorageConfig);
        } else {
            try {
                scmStorageConfig.setClusterId(fetchedId);
                if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
                    HASecurityUtils.initializeSecurity(scmStorageConfig, config, StorageContainerManager.getScmAddress(scmhaNodeDetails, (ConfigurationSource)conf), false);
                }
                scmStorageConfig.setPrimaryScmNodeId(scmInfo.getScmId());
                scmStorageConfig.setSCMHAFlag(true);
                scmStorageConfig.initialize();
                LOG.info("SCM BootStrap  is successful for ClusterID {}, SCMID {}", (Object)scmInfo.getClusterId(), (Object)scmStorageConfig.getScmId());
                LOG.info("Primary SCM Node ID {}", (Object)scmStorageConfig.getPrimaryScmNodeId());
            }
            catch (IOException ioe) {
                LOG.error("Could not initialize SCM version file", (Throwable)ioe);
                return false;
            }
        }
        return true;
    }

    private static void initializeSecurityIfNeeded(OzoneConfiguration conf, SCMHANodeDetails scmhaNodeDetails, SCMStorageConfig scmStorageConfig) throws IOException {
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf) && scmStorageConfig.getScmCertSerialId() == null) {
            HASecurityUtils.initializeSecurity(scmStorageConfig, conf, StorageContainerManager.getScmAddress(scmhaNodeDetails, (ConfigurationSource)conf), true);
            scmStorageConfig.forceInitialize();
            LOG.info("SCM unsecure cluster is converted to secure cluster. Persisted SCM Certificate SerialID {}", (Object)scmStorageConfig.getScmCertSerialId());
        }
    }

    public static boolean scmInit(OzoneConfiguration conf, String clusterId) throws IOException {
        SCMStorageConfig scmStorageConfig = new SCMStorageConfig(conf);
        Storage.StorageState state = scmStorageConfig.getState();
        SCMHANodeDetails haDetails = SCMHANodeDetails.loadSCMHAConfig(conf);
        String primordialSCM = SCMHAUtils.getPrimordialSCM((ConfigurationSource)conf);
        String selfNodeId = haDetails.getLocalNodeDetails().getNodeId();
        String selfHostName = haDetails.getLocalNodeDetails().getHostName();
        if (primordialSCM != null && SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf) && !SCMHAUtils.isPrimordialSCM((ConfigurationSource)conf, (String)selfNodeId, (String)selfHostName)) {
            LOG.info("SCM init command can only be executed in Primordial SCM {}, self id {} Ignoring it.", (Object)primordialSCM, (Object)selfNodeId);
            return true;
        }
        if (state != Storage.StorageState.INITIALIZED) {
            try {
                if (clusterId != null && !clusterId.isEmpty()) {
                    Preconditions.checkNotNull((Object)UUID.fromString(clusterId));
                    scmStorageConfig.setClusterId(clusterId);
                }
                if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
                    HASecurityUtils.initializeSecurity(scmStorageConfig, conf, StorageContainerManager.getScmAddress(haDetails, (ConfigurationSource)conf), true);
                }
                scmStorageConfig.setPrimaryScmNodeId(scmStorageConfig.getScmId());
                scmStorageConfig.initialize();
                if (SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf)) {
                    SCMRatisServerImpl.initialize(scmStorageConfig.getClusterID(), scmStorageConfig.getScmId(), haDetails.getLocalNodeDetails(), conf);
                    scmStorageConfig = new SCMStorageConfig(conf);
                    scmStorageConfig.setSCMHAFlag(true);
                    scmStorageConfig.forceInitialize();
                }
                LOG.info("SCM initialization succeeded. Current cluster id for sd={}; cid={}; layoutVersion={}; scmId={}", new Object[]{scmStorageConfig.getStorageDir(), scmStorageConfig.getClusterID(), scmStorageConfig.getLayoutVersion(), scmStorageConfig.getScmId()});
                return true;
            }
            catch (IOException ioe) {
                LOG.error("Could not initialize SCM version file", (Throwable)ioe);
                return false;
            }
        }
        ScmHAUnfinalizedStateValidationAction.checkScmHA(conf, scmStorageConfig, (LayoutVersionManager)new HDDSLayoutVersionManager(scmStorageConfig.getLayoutVersion()));
        clusterId = scmStorageConfig.getClusterID();
        boolean isSCMHAEnabled = scmStorageConfig.isSCMHAEnabled();
        StorageContainerManager.initializeSecurityIfNeeded(conf, haDetails, scmStorageConfig);
        if (SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf) && !isSCMHAEnabled) {
            SCMRatisServerImpl.initialize(scmStorageConfig.getClusterID(), scmStorageConfig.getScmId(), haDetails.getLocalNodeDetails(), conf);
            scmStorageConfig.setSCMHAFlag(true);
            scmStorageConfig.setPrimaryScmNodeId(scmStorageConfig.getScmId());
            scmStorageConfig.forceInitialize();
            LOG.debug("Enabled SCM HA");
        }
        LOG.info("SCM already initialized. Reusing existing cluster id for sd={};cid={}; layoutVersion={}; HAEnabled={}", new Object[]{scmStorageConfig.getStorageDir(), clusterId, scmStorageConfig.getLayoutVersion(), scmStorageConfig.isSCMHAEnabled()});
        return true;
    }

    private static InetSocketAddress getScmAddress(SCMHANodeDetails haDetails, ConfigurationSource conf) throws IOException {
        List scmNodeInfoList = SCMNodeInfo.buildNodeInfo((ConfigurationSource)conf);
        Preconditions.checkNotNull((Object)scmNodeInfoList, (Object)"scmNodeInfoList is null");
        InetSocketAddress scmAddress = null;
        if (SCMHAUtils.getScmServiceId((ConfigurationSource)conf) != null) {
            for (SCMNodeInfo scmNodeInfo : scmNodeInfoList) {
                if (haDetails.getLocalNodeDetails().getNodeId() == null || !haDetails.getLocalNodeDetails().getNodeId().equals(scmNodeInfo.getNodeId())) continue;
                scmAddress = NetUtils.createSocketAddr((String)scmNodeInfo.getBlockClientAddress());
            }
        } else if (((SCMNodeInfo)scmNodeInfoList.get(0)).getBlockClientAddress() == null) {
            LOG.error("SCM Address not able to figure out from config, finding hostname from InetAddress.");
            scmAddress = NetUtils.createSocketAddr((String)InetAddress.getLocalHost().getHostName(), (int)9863);
        } else {
            scmAddress = NetUtils.createSocketAddr((String)((SCMNodeInfo)scmNodeInfoList.get(0)).getBlockClientAddress());
        }
        return scmAddress;
    }

    public static void initMetrics() {
        metrics = SCMMetrics.create();
    }

    public static SCMMetrics getMetrics() {
        return metrics == null ? SCMMetrics.create() : metrics;
    }

    public SCMStorageConfig getScmStorageConfig() {
        return this.scmStorageConfig;
    }

    public SCMDatanodeProtocolServer getDatanodeProtocolServer() {
        return this.datanodeProtocolServer;
    }

    public SCMBlockProtocolServer getBlockProtocolServer() {
        return this.blockProtocolServer;
    }

    public SCMClientProtocolServer getClientProtocolServer() {
        return this.clientProtocolServer;
    }

    public SCMSecurityProtocolServer getSecurityProtocolServer() {
        return this.securityProtocolServer;
    }

    private Cache<String, ContainerStat> buildContainerReportCache() {
        return CacheBuilder.newBuilder().expireAfterAccess(Long.MAX_VALUE, TimeUnit.MILLISECONDS).maximumSize(Integer.MAX_VALUE).removalListener(removalNotification -> {
            Cache<String, ContainerStat> cache = this.containerReportCache;
            synchronized (cache) {
                ContainerStat stat = (ContainerStat)removalNotification.getValue();
                if (stat != null) {
                    metrics.decrContainerStat(stat);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Remove expired container stat entry for datanode: {}.", removalNotification.getKey());
                }
            }
        }).build();
    }

    private void registerMXBean() {
        HashMap<String, String> jmxProperties = new HashMap<String, String>();
        jmxProperties.put("component", "ServerRuntime");
        this.scmInfoBeanName = HddsUtils.registerWithJmxProperties((String)"StorageContainerManager", (String)"StorageContainerManagerInfo", jmxProperties, (Object)this);
    }

    private void registerMetricsSource(SCMMXBean scmMBean) {
        this.scmContainerMetrics = SCMContainerMetrics.create(scmMBean);
    }

    private void unregisterMXBean() {
        if (this.scmInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.scmInfoBeanName);
            this.scmInfoBeanName = null;
        }
    }

    @VisibleForTesting
    public ContainerInfo getContainerInfo(long containerID) throws IOException {
        return this.containerManager.getContainer(ContainerID.valueOf((long)containerID));
    }

    @VisibleForTesting
    public InetSocketAddress getClientRpcAddress() {
        return this.getClientProtocolServer().getClientRpcAddress();
    }

    @Override
    public String getClientRpcPort() {
        InetSocketAddress addr = this.getClientRpcAddress();
        return addr == null ? "0" : Integer.toString(addr.getPort());
    }

    public String getBlockProtocolRpcPort() {
        InetSocketAddress addr = this.getBlockProtocolServer().getBlockRpcAddress();
        return addr == null ? "0" : Integer.toString(addr.getPort());
    }

    public String getSecurityProtocolRpcPort() {
        InetSocketAddress addr = this.getSecurityProtocolServer().getRpcAddress();
        return addr == null ? "0" : Integer.toString(addr.getPort());
    }

    @Override
    public InetSocketAddress getDatanodeRpcAddress() {
        return this.getDatanodeProtocolServer().getDatanodeRpcAddress();
    }

    @Override
    public SCMNodeDetails getScmNodeDetails() {
        return this.scmHANodeDetails.getLocalNodeDetails();
    }

    public SCMHANodeDetails getSCMHANodeDetails() {
        return this.scmHANodeDetails;
    }

    @Override
    public String getDatanodeRpcPort() {
        InetSocketAddress addr = this.getDatanodeRpcAddress();
        return addr == null ? "0" : Integer.toString(addr.getPort());
    }

    @Override
    public void start() throws IOException {
        this.upgradeFinalizer.runPrefinalizeStateActions((Storage)this.scmStorageConfig, (Object)this);
        if (LOG.isInfoEnabled()) {
            LOG.info(StorageContainerManager.buildRpcServerStartMessage("StorageContainerLocationProtocol RPC server", this.getClientRpcAddress()));
        }
        this.scmHAManager.start();
        this.startSecretManagerIfNecessary();
        this.ms = HddsServerUtil.initializeMetrics((OzoneConfiguration)this.configuration, (String)"StorageContainerManager");
        this.commandWatcherLeaseManager.start();
        this.getClientProtocolServer().start();
        if (LOG.isInfoEnabled()) {
            LOG.info(StorageContainerManager.buildRpcServerStartMessage("ScmBlockLocationProtocol RPC server", this.getBlockProtocolServer().getBlockRpcAddress()));
        }
        this.getBlockProtocolServer().start();
        if (LOG.isInfoEnabled()) {
            LOG.info(StorageContainerManager.buildRpcServerStartMessage("ScmDatanodeProtocl RPC server", this.getDatanodeProtocolServer().getDatanodeRpcAddress()));
        }
        if (!this.scmStorageConfig.isSCMHAEnabled()) {
            this.getDatanodeProtocolServer().start();
        }
        if (this.getSecurityProtocolServer() != null) {
            this.getSecurityProtocolServer().start();
            this.persistSCMCertificates();
        }
        this.scmBlockManager.start();
        this.jvmPauseMonitor = new JvmPauseMonitor();
        this.jvmPauseMonitor.init((Configuration)this.configuration);
        this.jvmPauseMonitor.start();
        try {
            this.httpServer = new StorageContainerManagerHttpServer((MutableConfigurationSource)this.configuration, this);
            this.httpServer.start();
        }
        catch (Exception ex) {
            LOG.error("SCM HttpServer failed to start.", (Throwable)ex);
        }
        this.setStartTime();
    }

    private void persistSCMCertificates() throws IOException {
        if (this.primaryScmNodeId != null && !this.primaryScmNodeId.equals(this.scmStorageConfig.getScmId())) {
            List pemEncodedCerts = this.scmCertificateClient.listCA();
            for (String cert : pemEncodedCerts) {
                try {
                    X509Certificate x509Certificate = CertificateCodec.getX509Certificate((String)cert);
                    if (this.certificateStore.getCertificateByID(x509Certificate.getSerialNumber(), CertificateStore.CertType.VALID_CERTS) != null) continue;
                    LOG.info("Persist certificate serialId {} on Scm Bootstrap Node {}", (Object)x509Certificate.getSerialNumber(), (Object)this.scmStorageConfig.getScmId());
                    this.certificateStore.storeValidScmCertificate(x509Certificate.getSerialNumber(), x509Certificate);
                }
                catch (CertificateException ex) {
                    LOG.error("Error while decoding CA Certificate", (Throwable)ex);
                    throw new IOException(ex);
                }
            }
        }
    }

    @Override
    public void stop() {
        try {
            LOG.info("Stopping Container Balancer service.");
            this.containerBalancer.stop();
        }
        catch (Exception e) {
            LOG.error("Failed to stop Container Balancer service.");
        }
        try {
            LOG.info("Stopping Replication Manager Service.");
            this.replicationManager.stop();
        }
        catch (Exception ex) {
            LOG.error("Replication manager service stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping the Datanode Admin Monitor.");
            this.scmDecommissionManager.stop();
        }
        catch (Exception ex) {
            LOG.error("The Datanode Admin Monitor failed to stop", (Throwable)ex);
        }
        try {
            LOG.info("Stopping Lease Manager of the command watchers");
            this.commandWatcherLeaseManager.shutdown();
        }
        catch (Exception ex) {
            LOG.error("Lease Manager of the command watchers stop failed");
        }
        try {
            LOG.info("Stopping datanode service RPC server");
            this.getDatanodeProtocolServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager datanode RPC stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping block service RPC server");
            this.getBlockProtocolServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager blockRpcServer stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping the StorageContainerLocationProtocol RPC server");
            this.getClientProtocolServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager clientRpcServer stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping Storage Container Manager HTTP server.");
            this.httpServer.stop();
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager HTTP server stop failed.", (Throwable)ex);
        }
        if (this.getSecurityProtocolServer() != null) {
            this.getSecurityProtocolServer().stop();
        }
        try {
            LOG.info("Stopping Block Manager Service.");
            this.scmBlockManager.stop();
        }
        catch (Exception ex) {
            LOG.error("SCM block manager service stop failed.", (Throwable)ex);
        }
        if (this.containerReportCache != null) {
            this.containerReportCache.invalidateAll();
            this.containerReportCache.cleanUp();
        }
        this.stopSecretManager();
        if (metrics != null) {
            metrics.unRegister();
        }
        this.unregisterMXBean();
        if (this.scmContainerMetrics != null) {
            this.scmContainerMetrics.unRegister();
        }
        if (this.placementMetrics != null) {
            this.placementMetrics.unRegister();
        }
        try {
            LOG.info("Stopping SCM Event Queue.");
            this.eventQueue.close();
        }
        catch (Exception ex) {
            LOG.error("SCM Event Queue stop failed", (Throwable)ex);
        }
        if (this.jvmPauseMonitor != null) {
            this.jvmPauseMonitor.stop();
        }
        try {
            LOG.info("Stopping SCM HA services.");
            this.scmHAManager.shutdown();
        }
        catch (Exception ex) {
            LOG.error("SCM HA Manager stop failed", (Throwable)ex);
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.containerManager});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.pipelineManager});
        try {
            LOG.info("Stopping SCM MetadataStore.");
            this.scmMetadataStore.stop();
        }
        catch (Exception ex) {
            LOG.error("SCM Metadata store stop failed", (Throwable)ex);
        }
        if (this.ms != null) {
            this.ms.stop();
        }
        this.scmSafeModeManager.stop();
    }

    @Override
    public void join() {
        try {
            this.getBlockProtocolServer().join();
            this.getClientProtocolServer().join();
            this.getDatanodeProtocolServer().join();
            if (this.getSecurityProtocolServer() != null) {
                this.getSecurityProtocolServer().join();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("Interrupted during StorageContainerManager join.");
        }
    }

    public int getNodeCount(HddsProtos.NodeState nodestate) {
        return this.scmNodeManager.getNodeCount(null, nodestate);
    }

    public NodeDecommissionManager getScmDecommissionManager() {
        return this.scmDecommissionManager;
    }

    public SCMHAManager getScmHAManager() {
        return this.scmHAManager;
    }

    public WritableContainerFactory getWritableContainerFactory() {
        return this.writableContainerFactory;
    }

    @Override
    @VisibleForTesting
    public ContainerManager getContainerManager() {
        return this.containerManager;
    }

    @Override
    @VisibleForTesting
    public NodeManager getScmNodeManager() {
        return this.scmNodeManager;
    }

    @Override
    @VisibleForTesting
    public PipelineManager getPipelineManager() {
        return this.pipelineManager;
    }

    @Override
    @VisibleForTesting
    public BlockManager getScmBlockManager() {
        return this.scmBlockManager;
    }

    @VisibleForTesting
    public SCMSafeModeManager getScmSafeModeManager() {
        return this.scmSafeModeManager;
    }

    @Override
    @VisibleForTesting
    public ReplicationManager getReplicationManager() {
        return this.replicationManager;
    }

    @Override
    @VisibleForTesting
    public ContainerBalancer getContainerBalancer() {
        return this.containerBalancer;
    }

    public boolean checkLeader() {
        if (!SCMHAUtils.isSCMHAEnabled((ConfigurationSource)this.configuration)) {
            return true;
        }
        return this.getScmHAManager().getRatisServer().getDivision().getInfo().isLeaderReady();
    }

    public void checkAdminAccess(UserGroupInformation remoteUser) throws IOException {
        if (!(remoteUser == null || this.scmAdminUsernames.contains(remoteUser.getUserName()) || this.scmAdminUsernames.contains(remoteUser.getShortUserName()) || this.scmAdminUsernames.contains("*"))) {
            throw new AccessControlException("Access denied for user " + remoteUser.getUserName() + ". Superuser privilege is required.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContainerReport(String datanodeUuid) {
        Cache<String, ContainerStat> cache = this.containerReportCache;
        synchronized (cache) {
            this.containerReportCache.invalidate((Object)datanodeUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerStat getContainerReport(String datanodeUuid) {
        ContainerStat stat = null;
        Cache<String, ContainerStat> cache = this.containerReportCache;
        synchronized (cache) {
            stat = (ContainerStat)this.containerReportCache.getIfPresent((Object)datanodeUuid);
        }
        return stat;
    }

    public ConcurrentMap<String, ContainerStat> getContainerReportCache() {
        return this.containerReportCache.asMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getContainerReport() {
        HashMap<String, String> id2StatMap = new HashMap<String, String>();
        Cache<String, ContainerStat> cache = this.containerReportCache;
        synchronized (cache) {
            ConcurrentMap map = this.containerReportCache.asMap();
            for (Map.Entry entry : map.entrySet()) {
                id2StatMap.put((String)entry.getKey(), ((ContainerStat)entry.getValue()).toJsonString());
            }
        }
        return id2StatMap;
    }

    @Override
    public double getSafeModeCurrentContainerThreshold() {
        return this.getCurrentContainerThreshold();
    }

    @Override
    public boolean isInSafeMode() {
        return this.scmSafeModeManager.getInSafeMode();
    }

    public EventPublisher getEventQueue() {
        return this.eventQueue;
    }

    public SCMContext getScmContext() {
        return this.scmContext;
    }

    public SequenceIdGenerator getSequenceIdGen() {
        return this.sequenceIdGen;
    }

    public SCMServiceManager getSCMServiceManager() {
        return this.serviceManager;
    }

    public boolean exitSafeMode() {
        this.scmSafeModeManager.exitSafeMode((EventPublisher)this.eventQueue);
        return true;
    }

    @VisibleForTesting
    public double getCurrentContainerThreshold() {
        return this.scmSafeModeManager.getCurrentContainerThreshold();
    }

    @Override
    public Map<String, Integer> getContainerStateCount() {
        HashMap<String, Integer> nodeStateCount = new HashMap<String, Integer>();
        for (HddsProtos.LifeCycleState state : HddsProtos.LifeCycleState.values()) {
            nodeStateCount.put(state.toString(), this.containerManager.getContainers(state).size());
        }
        return nodeStateCount;
    }

    public SCMMetadataStore getScmMetadataStore() {
        return this.scmMetadataStore;
    }

    public NetworkTopology getClusterMap() {
        return this.clusterMap;
    }

    public Map<String, Pair<Boolean, String>> getRuleStatus() {
        return this.scmSafeModeManager.getRuleStatus();
    }

    @Override
    public Map<String, String[]> getSafeModeRuleStatus() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (Map.Entry<String, Pair<Boolean, String>> entry : this.scmSafeModeManager.getRuleStatus().entrySet()) {
            String[] status = new String[]{(String)entry.getValue().getRight(), ((Boolean)entry.getValue().getLeft()).toString()};
            map.put(entry.getKey(), status);
        }
        return map;
    }

    public PipelineChoosePolicy getPipelineChoosePolicy() {
        return this.pipelineChoosePolicy;
    }

    @Override
    public String getScmId() {
        return this.getScmStorageConfig().getScmId();
    }

    @Override
    public String getClusterId() {
        return this.getScmStorageConfig().getClusterID();
    }

    public HDDSLayoutVersionManager getLayoutVersionManager() {
        return this.scmLayoutVersionManager;
    }

    public String getSCMNodeId() {
        return this.scmHANodeDetails.getLocalNodeDetails().getNodeId();
    }

    public UpgradeFinalizer.StatusAndMessages finalizeUpgrade(String upgradeClientID) throws IOException {
        return this.upgradeFinalizer.finalize(upgradeClientID, (Object)this);
    }

    public UpgradeFinalizer.StatusAndMessages queryUpgradeFinalizationProgress(String upgradeClientID, boolean takeover, boolean readonly) throws IOException {
        if (readonly) {
            return new UpgradeFinalizer.StatusAndMessages(this.upgradeFinalizer.getStatus(), Collections.emptyList());
        }
        return this.upgradeFinalizer.reportStatus(upgradeClientID, takeover);
    }

    public UpgradeFinalizer<StorageContainerManager> getUpgradeFinalizer() {
        return this.upgradeFinalizer;
    }

    private void startSecretManagerIfNecessary() {
        boolean running;
        boolean shouldRun;
        boolean bl = shouldRun = this.securityConfig.isSecurityEnabled() && this.securityConfig.isContainerTokenEnabled() && this.containerTokenMgr != null;
        if (shouldRun && !(running = this.containerTokenMgr.isRunning())) {
            this.startSecretManager();
        }
    }

    private void startSecretManager() {
        try {
            this.scmCertificateClient.assertValidKeysAndCertificate();
        }
        catch (OzoneSecurityException e) {
            LOG.error("Unable to read key pair.", (Throwable)e);
            throw new UncheckedIOException((IOException)((Object)e));
        }
        try {
            LOG.info("Starting token manager");
            this.containerTokenMgr.start((CertificateClient)this.scmCertificateClient);
        }
        catch (IOException e) {
            LOG.error("Error starting block token secret manager.", (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    private void stopSecretManager() {
        if (this.containerTokenMgr != null) {
            LOG.info("Stopping block token manager.");
            try {
                this.containerTokenMgr.stop();
            }
            catch (IOException e) {
                LOG.error("Failed to stop block token manager", (Throwable)e);
            }
        }
    }

    public ContainerTokenGenerator getContainerTokenGenerator() {
        return this.containerTokenMgr != null ? this.containerTokenMgr : ContainerTokenGenerator.DISABLED;
    }

    @Override
    public String getScmRatisRoles() throws IOException {
        SCMRatisServer server = this.getScmHAManager().getRatisServer();
        return server != null ? HddsUtils.format(server.getRatisRoles()) : "STANDALONE";
    }

    @Override
    public String getPrimordialNode() {
        if (SCMHAUtils.isSCMHAEnabled((ConfigurationSource)this.configuration)) {
            String primordialNode = SCMHAUtils.getPrimordialSCM((ConfigurationSource)this.configuration);
            if (SCMHAUtils.getSCMNodeIds((ConfigurationSource)this.configuration).contains(primordialNode)) {
                ArrayList<SCMNodeDetails> localAndPeerNodes = new ArrayList<SCMNodeDetails>(this.scmHANodeDetails.getPeerNodeDetails());
                localAndPeerNodes.add(this.getSCMHANodeDetails().getLocalNodeDetails());
                for (SCMNodeDetails nodes : localAndPeerNodes) {
                    if (!nodes.getNodeId().equals(primordialNode)) continue;
                    return nodes.getHostName();
                }
            }
            return primordialNode;
        }
        return null;
    }
}

